/* ====================================================================
 * Copyright (c) 2003-2006, 2008  Martin Hauner
 *                                http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "PropSetCmd.h"
#include "PropSetParam.h"
#include "CmdResultCallback.h"
#include "CmdProgressCallback.h"
#include "svn/Client.h"


PropSetCmd::PropSetCmd( PropSetParam* param, CmdResultCallback* cb )
: ScCmd(param->getId()), _param(param), _cb(cb)
{
}

PropSetCmd::~PropSetCmd()
{
}

void PropSetCmd::run()
{
  sc::Error* err;

  _prgscb->started( _param, getCancel() );

  err = _client->propset( _param->getPropName(), _param->getPropVal(), _param->getPath(),
    _param->getRecurse() );

  _param->setError( err );
  _prgscb->finished( _param );

  _cb->handleResult( _param, err );
}
