/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SVN_VISUALMERGE_H
#define _SVN_VISUALMERGE_H

// util
#include "util/String.h"

// apr
struct apr_pool_t;

// svn
#include "WcStatusTypes.h"
struct svn_error_t;
struct svn_client_ctx_t;


namespace svn
{

/**
 * prepare and run visual merge
 */
class VisualMerge
{
public:
  VisualMerge( svn_client_ctx_t* context, const sc::String& diffCmd,
    apr_pool_t* pool );
  ~VisualMerge();

  svn_error_t* run( WcStatusPtr file );

private:
  svn_client_ctx_t* _context;
  apr_pool_t*       _pool;
  sc::String        _mergeCmd;
};

} // namespace

#endif // _SVN_VISUALMERGE_H
