/*
 *	subtitle editor
 *
 *	http://kitone.free.fr/subtitleeditor/
 *
 *	Copyright @ 2005-2006, kitone
 *
 *	Contact: kitone at free dot fr
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public
 *	License as published by the Free Software Foundation; either
 *	version 2 of the License, or (at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU
 *	General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public
 *	License along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA	02111-1307	USA
 *
 *	See gpl.txt for more information regarding the GNU General Public License.
 *
 *
 *	\file
 *	\brief 
 *	\author kitone (kitone at free dot fr)
 */

#include "DialogAbout.h"
#include "utility.h"
#include "ISubtitleEditor.h"
#include <iostream>

DialogAbout::DialogAbout()
{
	set_transient_for(*dynamic_cast<Gtk::Window*>(SE::getInstance()));

	// name
	set_name("Subtitle Editor");
	// version
	set_version(VERSION);
	// copyright
	set_copyright("kitone (IDJAAD djamel)");
	// comments
	set_comments(_("a tool for subtitles edition"));

	// authors
	std::list<Glib::ustring>	authors;
	authors.push_back("kitone (IDJAAD djamel)");
	set_authors(authors);

	// translator-credits
	//std::list<Glib::ustring>	translators;
	set_translator_credits(_("translator-credits"));
	//translators.push_back("toto");

	// website
	set_website("http://kitone.free.fr/subtitleeditor/");
	set_website_label("http://kitone.free.fr/subtitleeditor/");
	
	// license
	Glib::ustring license=
		"This program is free software; you can redistribute it and/or modify  \n"
		"it under the terms of the GNU General Public License as published by  \n"
		"the Free Software Foundation; either version 2 of the License, or	\n"
		"(at your option) any later version.	\n\n"
		"This program is distributed in the hope that it will be useful,	\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of  \n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the	\n"
		"GNU General Public License for more details.  \n\n"
		"You should have received a copy of the GNU General Public License	\n"
		"along with this program; if not, write to the Free Software	\n"
		"Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111 USA	\n\n"
		"See gpl.txt for more information regarding the GNU General Public License. \n";
	set_license(license);

	try
	{
		Glib::ustring filename = get_share_dir("subtitleeditor.png");
		set_logo(Gdk::Pixbuf::create_from_file(filename));
	}
	catch(Glib::Error &ex)
	{
		std::cerr << ex.what() << std::endl;
	}
}

