/*
 *	subtitle editor
 *
 *	http://kitone.free.fr/subtitleeditor/
 *
 *	Copyright @ 2005-2006, kitone
 *
 *	Contact: kitone at free dot fr
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public
 *	License as published by the Free Software Foundation; either
 *	version 2 of the License, or (at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU
 *	General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public
 *	License along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA	02111-1307	USA
 *
 *	See gpl.txt for more information regarding the GNU General Public License.
 *
 *
 *	\file
 *	\brief 
 *	\author kitone (kitone at free dot fr)
 */

#include "Waveform.h"
#include <iostream>
#include <math.h>
#include <fstream>
#include <iostream>
#include <glibmm.h>



Waveform::Waveform()
{
	n_channels = 0;
	len = 0;
}

guint Waveform::get_size()
{
	return channels[0].size();
}

gint64 Waveform::get_len()
{
	return len;
}


double Waveform::get_channel(unsigned int ch, guint64 pos)
{
	CLAMP(pos, 0, get_size());
	CLAMP(ch, 0, n_channels);

	return channels[ch][pos];
}

bool Waveform::open(const Glib::ustring &file_uri)
{
	Glib::ustring filename = Glib::filename_from_uri(file_uri);

	std::ifstream file(filename.c_str(), std::ios_base::binary);

	if(!file)
	{
		return false;
	}

	std::string line;

	if(!std::getline(file, line))
	{
		file.close();
		return false;
	}
	
	if(line != "waveform")
	{
		file.close();
		return false;
	}
	
	if(!std::getline(file, line))
	{
		file.close();
		return false;
	}

	uri = line;
	
	file.read((char*)&n_channels, sizeof(n_channels));
	file.read((char*)&len, sizeof(len));

	for(unsigned int n=0; n< n_channels; ++n)
	{
		std::vector<double>::size_type size=0;
		
		file.read((char*)&size, sizeof(size));
		
		channels[n].resize(size);

		for(unsigned int i=0; i<size; ++i)
		{
			file.read((char*)&channels[n][i], sizeof(double));
		}
	}
	
	file.close();
	return true;
}

/*
 *
 */
bool Waveform::save(const Glib::ustring &file_uri)
{
	Glib::ustring filename = Glib::filename_from_uri(file_uri);

	std::ofstream file(filename.c_str(), std::ios_base::binary);

	if(!file)
		return false;
	
	file << "waveform" << std::endl;
	
	file << uri << std::endl;

	file.write((const char*)&n_channels, sizeof(n_channels));
	file.write((const char*)&len, sizeof(len));

	
	for(unsigned int n = 0; n < n_channels; ++n)
	{
		std::vector<double>::size_type size = channels[n].size();
		
		file.write((const char*)&size, sizeof(size));
		
		for(unsigned int i=0; i < size; ++i)
		{
			file.write((const char*)&channels[n][i], sizeof(double));
		}
	}
	
	file.close();
	
	return true;
}


