%define ruby_libdir %(ruby -rrbconfig -e 'puts Config::CONFIG["rubylibdir"]')

%define name		suikyo
%define version		2.1.0
%define release		1
%define	e_sitedir 	%{_datadir}/emacs/site-lisp
%define e_startdir	%{e_sitedir}/site-start.d
%define	xe_sitedir	%{_datadir}/xemacs/site-lisp
%define xe_startdir	%{_datadir}/xemacs/site-packages/lisp/site-start.d
%define	sitepdir	%{_datadir}/xemacs/xemacs-packages

Summary: Romaji Hiragana conversion library
Name: %{name}
Version: %{version}
Release: %{release}
License: GPL
URL: http://taiyaki.org/suikyo/
Source: http://taiyaki.org/suikyo/src/%{name}-%{version}.tar.gz
Group: Development/Libraries
BuildArch: noarch
BuildRoot: %{_tmppath}/%{name}-%{version}-root
BuildRequires: ruby, xemacs
BuildRequires: emacs

%package emacs
Summary: emacs binding of suikyo
Group: Applications/Editors
Requires: suikyo
Requires: emacs

%package xemacs
Summary: xemacs binding of suikyo
Group: Applications/Editors
Requires: xemacs, %{name} = %{version}

%package ruby
Summary: ruby binding of suikyo
Group: Development/Libraries
Requires: ruby, %{name} = %{version}

%description
Suikyo is a Romaji Hiragana conversion library based on
DFA (Deterministic finate state) automaton.

%description emacs
suikyo-emacs is a emacs binding of suikyo.

%description xemacs
suikyo-xemacs is a xemacs binding of suikyo.

%description ruby
suikyo-ruby is a ruby binding of suikyo.

%prep
rm -rf %{buildroot}

%setup -q

%build
%configure rubydir=%{ruby_libdir}
make

cd elisp/src

emacs -no-site-file -q -batch -f batch-byte-compile *.el
for i in *.el; do
  cp $i $i.emacs
done
for i in *.elc; do
  mv $i $i.emacs
done

xemacs -no-site-file -q -batch -f batch-byte-compile *.el
for i in *.elc; do
  mv $i $i.xemacs
done

cd ../..

%install
(cd conv-table && make SUIKYO_TABLE_DIR=%{buildroot}%{_datadir}/suikyo/conv-table install)
(cd ruby && echo "install:" > doc/Makefile && make prefix=%{buildroot}%{_prefix} rubydir=%{buildroot}%{ruby_libdir} install)

cd elisp/src

mkdir -p %{buildroot}%{e_sitedir}/suikyo

for i in *.el*.emacs; do
  install -c -m 0644 $i %{buildroot}%{e_sitedir}/suikyo/${i%%.emacs}
done

mkdir -p %{buildroot}%{e_startdir}
install -c -m 0644 ../etc/init-suikyo.el %{buildroot}%{e_startdir}

mkdir -p %{buildroot}%{sitepdir}/lisp/suikyo

cd ../..
%configure --with-emacs-sitelispdir=%{sitepdir}/lisp/suikyo \
  --with-emacs-initdir=%{xe_startdir}
make
cd elisp/src

install -c -m 0644 *.el %{buildroot}%{sitepdir}/lisp/suikyo
for i in *.elc.xemacs; do
  install -c -m 0644 $i %{buildroot}%{sitepdir}/lisp/suikyo/${i%%.xemacs}
done

mkdir -p %{buildroot}%{xe_startdir}
install -c -m 0644 ../etc/init-suikyo.el %{buildroot}%{xe_startdir}

cd ../..

%clean
rm -rf %{buildroot}

%files
%defattr(-,root,root)
%{_datadir}/suikyo
%doc ChangeLog
%doc contrib/uniq.rb
%doc doc/index.html

%files emacs
%{e_sitedir}/suikyo
%{e_startdir}/init-suikyo.el
%doc elisp/ChangeLog

%files xemacs
%{sitepdir}/lisp/suikyo
%{xe_startdir}/init-suikyo.el
%doc elisp/ChangeLog

%files ruby
%{_libdir}/ruby/*/*
%doc ruby/ChangeLog
%doc ruby/doc/index.html

%changelog
* Tue Dec 16 2003 Masaki Yatsu <yatsu@digital-genes.com>
- (1.2.0-1)
- version up.

* Wed May 28 2003 Masaki Yatsu <yatsu@borogrammers.net>
- (1.1.2-2 / 1.1.2-0pa2)
- make suikyo sub directory in Emacs-Lisp directory

* Sun May 18 2003 Masaki Yatsu <yatsu@borogrammers.net>
- (1.1.2-1 / 1.1.2-0pa1)
- version up

* Tue May 13 2003 Masaki Yatsu <yatsu@borogrammers.net>
- (1.1.1-0pa2)
- correct suikyo-table-path

* Tue May 13 2003 Masaki Yatsu <yatsu@borogrammers.net>
- (1.1.1-0pa1)
- first build
