/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.map.proj;

import com.jhlabs.map.proj.PseudoCylindricalProjection;
import java.awt.geom.Point2D;

public class Wagner3Projection
extends PseudoCylindricalProjection {
    private static final double TWOTHIRD = 0.6666666666666666;
    private double C_x;

    public Point2D.Double project(double lplam, double lpphi, Point2D.Double xy) {
        xy.x = this.C_x * lplam * Math.cos(0.6666666666666666 * lpphi);
        xy.y = lpphi;
        return xy;
    }

    public Point2D.Double projectInverse(double x, double y, Point2D.Double lp) {
        lp.y = y;
        lp.x = x / (this.C_x * Math.cos(0.6666666666666666 * lp.y));
        return lp;
    }

    public void initialize() {
        super.initialize();
        this.C_x = Math.cos(this.trueScaleLatitude) / Math.cos(2.0 * this.trueScaleLatitude / 3.0);
        this.es = 0.0;
    }

    public boolean hasInverse() {
        return true;
    }

    public String toString() {
        return "Wagner III";
    }
}

