/*
 * Decompiled with CFR 0.152.
 */
package bioroute.analysis;

import cadyts.supply.network.Network;
import cadyts.supply.network.Node;
import cadyts.utilities.io.tabularFileParser.TabularFileHandler;
import cadyts.utilities.io.tabularFileParser.TabularFileParser;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

public class CorrelationAnalyzer
implements TabularFileHandler {
    private final Network network;
    private final LinkedList<List<Node>> routeBuffer = new LinkedList();
    private final int sampleInterval;
    private final double[] binCnt;
    private long totalCnt;

    public CorrelationAnalyzer(int maxDist, int sampleInterval, Network network) {
        if (maxDist < 0) {
            throw new IllegalArgumentException("max. dist < 0");
        }
        if (network == null) {
            throw new IllegalArgumentException("network is null");
        }
        this.sampleInterval = sampleInterval;
        this.binCnt = new double[maxDist / sampleInterval + 1];
        this.network = network;
    }

    public void run(String fromFile, String toFile) throws IOException {
        if (fromFile == null) {
            throw new IllegalArgumentException("from file is null");
        }
        TabularFileParser parser = new TabularFileParser();
        parser.setDelimiterRegex("\\s");
        parser.parse(fromFile, this);
        if (toFile != null) {
            double[] binFreq = this.getResult();
            PrintWriter writer = new PrintWriter(toFile);
            int i = 0;
            while (i < binFreq.length) {
                writer.print(i * this.sampleInterval);
                writer.print(" ");
                writer.println(binFreq[i]);
                ++i;
            }
            writer.flush();
            writer.close();
        }
    }

    public double[] getResult() {
        double[] result = new double[this.binCnt.length];
        System.arraycopy(this.binCnt, 0, result, 0, this.binCnt.length);
        int i = 0;
        while (i < result.length) {
            int n = i++;
            result[n] = result[n] / (double)this.totalCnt;
        }
        return result;
    }

    public int getSampleInterval() {
        return this.sampleInterval;
    }

    @Override
    public void startDocument() {
        this.totalCnt = 0L;
    }

    @Override
    public String preprocess(String line) {
        int semicolonIndex = line.indexOf(";");
        return line.substring(0, semicolonIndex);
    }

    @Override
    public void startRow(String[] row) {
        LinkedList<Node> route = new LinkedList<Node>();
        String[] stringArray = row;
        int n = row.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            route.add(this.network.getNode(element));
            ++n2;
        }
        this.routeBuffer.addFirst(route);
        while (this.routeBuffer.size() > this.binCnt.length) {
            this.routeBuffer.removeLast();
        }
        if (this.routeBuffer.size() == this.binCnt.length) {
            this.binCnt[0] = this.binCnt[0] + 1.0;
            HashSet nodes1 = new HashSet(this.routeBuffer.getFirst());
            int bin = 1;
            while (bin < this.binCnt.length) {
                HashSet nodes2 = new HashSet(this.routeBuffer.get(bin));
                double denom = 0.5 * (double)(nodes1.size() + nodes2.size());
                nodes2.retainAll(nodes1);
                int n3 = bin++;
                this.binCnt[n3] = this.binCnt[n3] + (double)nodes2.size() / denom;
            }
            ++this.totalCnt;
        }
    }

    @Override
    public void endDocument() {
    }
}

