/*
 * Decompiled with CFR 0.152.
 */
package cadyts.calibrators.analytical;

import cadyts.calibrators.analytical.AnalyticalCalibrator;
import cadyts.demand.Plan;
import cadyts.supply.SimResults;
import cadyts.utilities.math.Cholesky;
import cadyts.utilities.math.CholeskyModified;
import cadyts.utilities.math.Matrix;
import cadyts.utilities.math.Vector;
import java.util.List;
import java.util.logging.Logger;

public class ChoiceParameterCalibrator<L>
extends AnalyticalCalibrator<L> {
    private static final long serialVersionUID = 1L;
    public static final double DEFAULT_INITIAL_STEP_SIZE = 1.0;
    public static final double DEFAULT_MSA_EXPONENT = 1.0;
    public static final boolean DEFAULT_USE_APPROXIMATE_NEWTON = true;
    public static final Vector DEFAULT_INITIAL_PARAMETERS = null;
    public static final Matrix DEFAULT_INITIAL_PARAMETER_COVARIANCE = null;
    public static final Matrix DEFAULT_INITIAL_PARAMETER_HESSIAN = null;
    private final int parameterDimension;
    protected double initialStepSize = 1.0;
    protected double msaExponent = 1.0;
    protected boolean useApproximateNewton = true;
    protected Vector initialParameters = DEFAULT_INITIAL_PARAMETERS;
    private Matrix initialParameterCovariance = DEFAULT_INITIAL_PARAMETER_COVARIANCE;
    protected Matrix initialParameterHessian = DEFAULT_INITIAL_PARAMETER_HESSIAN;
    protected Vector parameters;
    protected Vector dLL_dParameters;
    protected Matrix paramCov;
    private final Matrix d2W_dbdb;

    public ChoiceParameterCalibrator(String logFile, Long randomSeed, int timeBinSize_s, int parameterDimension) {
        super(logFile, randomSeed, timeBinSize_s);
        if (parameterDimension <= 0) {
            throw new IllegalArgumentException("parameterDimension must be strictly positive");
        }
        this.parameterDimension = parameterDimension;
        Logger.getLogger(this.myName).info("parameterDimension is " + this.parameterDimension);
        Logger.getLogger(this.myName).info("default initialStepSize is " + this.initialStepSize);
        Logger.getLogger(this.myName).info("default msaExponent is " + this.msaExponent);
        Logger.getLogger(this.myName).info("default useApproximateNetwon is " + this.useApproximateNewton);
        Logger.getLogger(this.myName).info("default initialParameters are " + this.initialParameters);
        Logger.getLogger(this.myName).info("default initialParameterCovariance is " + this.initialParameterCovariance);
        this.parameters = new Vector(parameterDimension);
        this.dLL_dParameters = new Vector(parameterDimension);
        this.paramCov = null;
        this.d2W_dbdb = new Matrix(parameterDimension, parameterDimension);
    }

    public void setInitialStepSize(double initialStepSize) {
        if (initialStepSize < 0.0) {
            throw new IllegalArgumentException("initialStepSize must not be negative");
        }
        if (initialStepSize == 0.0) {
            Logger.getLogger(this.myName).warning("initialStepSize of zero means that initialParameters will be maintained");
        }
        this.initialStepSize = initialStepSize;
        Logger.getLogger(this.myName).info("set initialStepSize to " + this.initialStepSize);
    }

    public double getInitialStepSize() {
        return this.initialStepSize;
    }

    public void setMsaExponent(double msaExponent) {
        if (msaExponent < 0.0) {
            throw new IllegalArgumentException("msaExponent must be non-negative");
        }
        if (msaExponent != 0.0 && (msaExponent <= 0.5 || msaExponent > 1.0)) {
            Logger.getLogger(this.myName).warning("nonzero msaExponent values outside of (0.5, 1.0] are not recommended");
        }
        this.msaExponent = msaExponent;
        Logger.getLogger(this.myName).info("set msaExponent to " + this.msaExponent);
    }

    public double getMsaExponent() {
        return this.msaExponent;
    }

    public void setUseApproximateNetwton(boolean useApproximateNewton) {
        this.useApproximateNewton = useApproximateNewton;
        Logger.getLogger(this.myName).info("set useApproximateNewton to " + this.useApproximateNewton);
    }

    public boolean getUseApproximateNewton() {
        return this.useApproximateNewton;
    }

    public void setInitialParameters(Vector initialParameters) {
        if (initialParameters != null && initialParameters.size() != this.parameterDimension) {
            throw new IllegalArgumentException("dimension of " + initialParameters + " is not " + this.parameterDimension);
        }
        this.initialParameters = initialParameters;
        Logger.getLogger(this.myName).info("set initialParameters to " + this.initialParameters);
        if (initialParameters == null) {
            this.parameters.clear();
        } else {
            this.parameters.copy(initialParameters);
        }
        Logger.getLogger(this.myName).info("set current parameter estimate to " + this.parameters);
    }

    public Vector getInitialParameters() {
        return this.initialParameters;
    }

    public void setInitialParameterCovariance(Matrix initialParameterCovariance) {
        if (initialParameterCovariance != null && (initialParameterCovariance.rowSize() != this.parameterDimension || initialParameterCovariance.columnSize() != this.parameterDimension)) {
            throw new IllegalArgumentException("dimension of " + initialParameterCovariance.toSingleLineString() + " is not " + this.parameterDimension + " x " + this.parameterDimension);
        }
        this.initialParameterCovariance = initialParameterCovariance;
        Logger.getLogger(this.myName).info("set initialParameterCovariance to " + (this.initialParameterCovariance == null ? null : this.initialParameterCovariance.toSingleLineString()));
        if (initialParameterCovariance == null) {
            this.initialParameterHessian = null;
        } else {
            Cholesky c = new Cholesky();
            if (!c.invert(this.initialParameterCovariance)) {
                throw new IllegalArgumentException("could not invert initialParameterCovariance");
            }
            this.initialParameterHessian = c.getResult();
            this.initialParameterHessian.mult(-1.0);
        }
    }

    public Matrix getInitialParameterCovariance() {
        return this.initialParameterCovariance.newImmutableView();
    }

    public void setInitialParameterVariances(Vector initialParameterVariances) {
        if (initialParameterVariances != null) {
            this.setInitialParameterCovariance(Matrix.newDiagonal(initialParameterVariances));
        } else {
            this.setInitialParameterCovariance(null);
        }
    }

    public Vector getParameters() {
        return this.parameters.newImmutableView();
    }

    public Vector get_dLL_dParam() {
        return this.dLL_dParameters.newImmutableView();
    }

    public Matrix getParameterCovariance() {
        return this.paramCov == null ? null : this.paramCov.newImmutableView();
    }

    @Override
    public int selectPlan(List<? extends Plan<L>> plans, Vector choiceProbs) {
        throw new UnsupportedOperationException("for parameter calibration, use selectPlan(Integer, List, Vector, Matrix, List<? extends Matrix>) instead");
    }

    public int selectPlan(Integer overrideChoice, List<? extends Plan<L>> plans, Vector choiceProbs, Matrix dChoiceProb_dParam, List<? extends Matrix> d2ChoiceProb_dParam2) {
        this.selectPlan(overrideChoice, plans, choiceProbs);
        if (this.getIteration() >= this.getPreparatoryIterations() && choiceProbs != null && dChoiceProb_dParam != null) {
            int i = 0;
            while (i < plans.size()) {
                double priorP = Math.max(choiceProbs.get(i), 1.0E-6);
                double postP = Math.max(this.getLastChoiceProb(i), 1.0E-6);
                this.dLL_dParameters.add(dChoiceProb_dParam.getRow(i), postP / priorP);
                if (d2ChoiceProb_dParam2 != null) {
                    this.d2W_dbdb.add(d2ChoiceProb_dParam2.get(i), postP / priorP);
                    this.d2W_dbdb.addOuterProduct(dChoiceProb_dParam.getRow(i), dChoiceProb_dParam.getRow(i), -1.0 * postP / priorP / priorP);
                }
                ++i;
            }
        }
        return this.getLastChoiceIndex();
    }

    public int selectPlan(List<? extends Plan<L>> plans, Vector choiceProbs, Matrix dChoiceProb_dParam, List<? extends Matrix> d2ChoiceProb_dParam2) {
        return this.selectPlan(null, plans, choiceProbs, dChoiceProb_dParam, d2ChoiceProb_dParam2);
    }

    @Override
    public void afterNetworkLoading(SimResults<L> simResults) {
        Vector dir;
        super.afterNetworkLoading(simResults);
        if (this.getIteration() <= this.getPreparatoryIterations()) {
            return;
        }
        if (this.initialParameterHessian != null) {
            this.d2W_dbdb.add(this.initialParameterHessian, 1.0);
        }
        this.d2W_dbdb.mult(-1.0);
        CholeskyModified c = new CholeskyModified(16);
        if (c.invert(this.d2W_dbdb)) {
            this.paramCov = c.getResult();
            Logger.getLogger(this.getClass().getName()).info("modified Cholesky factorization succeeded after " + c.getTrials() + " trials");
        } else {
            this.paramCov = null;
            Logger.getLogger(this.getClass().getName()).warning("modified Cholesky factorization failed after " + c.getTrials() + " trials");
        }
        this.d2W_dbdb.clear();
        Vector grad = this.get_dLL_dParam();
        if (this.useApproximateNewton && this.paramCov != null) {
            dir = this.paramCov.timesVectorFromRight(grad);
            if (dir.innerProd(grad) <= 0.0) {
                Logger.getLogger(this.getClass().getName()).warning("approximate Newton step is no ascent direction");
            }
        } else {
            dir = grad;
        }
        this.parameters.add(dir, this.initialStepSize * Math.pow(this.getIteration() - this.getPreparatoryIterations(), -this.msaExponent));
        if (this.initialParameters != null && this.initialParameterHessian != null) {
            Vector deviation = this.parameters.copy();
            deviation.add(this.initialParameters, -1.0);
            this.dLL_dParameters = this.initialParameterHessian.timesVectorFromRight(deviation);
        } else {
            this.dLL_dParameters.clear();
        }
    }
}

