/*
 * Decompiled with CFR 0.152.
 */
package cadyts.utilities.math.networks;

import cadyts.supply.network.Link;
import cadyts.supply.network.Node;
import cadyts.utilities.math.networks.LinkCost;
import java.util.Collection;

public class LinkCostExcludingNodes
implements LinkCost {
    private final LinkCost linkCost;
    private final Collection<Node> excludedNodes;

    public LinkCostExcludingNodes(LinkCost linkCost, Collection<Node> excludedNodes) {
        if (linkCost == null) {
            throw new IllegalArgumentException("linkCost is null");
        }
        if (excludedNodes == null) {
            throw new IllegalArgumentException("excludedNodes is null");
        }
        this.linkCost = linkCost;
        this.excludedNodes = excludedNodes;
    }

    @Override
    public double getCost(Link link) {
        if (this.excludedNodes.contains(link.getFromNode()) || this.excludedNodes.contains(link.getToNode())) {
            return Double.POSITIVE_INFINITY;
        }
        return this.linkCost.getCost(link);
    }
}

