/*
 * Decompiled with CFR 0.152.
 */
package cadyts.utilities.visualization.network;

import java.awt.Color;
import java.util.logging.Logger;

public class ValueColorizer {
    private double[] values;
    private Color[] colors;

    private void init(double[] values, Color[] colors) {
        this.values = values;
        this.colors = colors;
    }

    public ValueColorizer(String colordef) {
        try {
            String[] colordefs = colordef.trim().split("\\s");
            double[] values = new double[colordefs.length / 2];
            Color[] colors = new Color[colordefs.length / 2];
            int i = 0;
            while (i < colordefs.length / 2) {
                colors[i] = (Color)Color.class.getField(colordefs[2 * i]).get(null);
                values[i] = Double.parseDouble(colordefs[1 + 2 * i]);
                ++i;
            }
            this.init(values, colors);
        }
        catch (NoSuchFieldException e) {
            Logger.getLogger(this.getClass().getName()).warning("Illegal color definition\"" + colordef + "\", using defaul values.");
            this.init(new double[]{-1.0, 0.0, 0.1, 0.3, 1.0}, new Color[]{Color.BLUE, Color.WHITE, Color.GREEN, Color.YELLOW, Color.RED});
        }
        catch (IllegalAccessException e) {
            Logger.getLogger(this.getClass().getName()).warning("Illegal color definition\"" + colordef + "\", using defaul values.");
            this.init(new double[]{-1.0, 0.0, 0.1, 0.3, 1.0}, new Color[]{Color.BLUE, Color.WHITE, Color.GREEN, Color.YELLOW, Color.RED});
        }
    }

    public ValueColorizer() {
        this(new double[]{-1.0, 0.0, 0.1, 0.3, 1.0}, new Color[]{Color.BLUE, Color.WHITE, Color.GREEN, Color.YELLOW, Color.RED});
    }

    public ValueColorizer(double[] values, Color[] colors) {
        this.init(values, colors);
    }

    private int upperIndex(double val) {
        int result = 0;
        while (this.values[result] < val && result < this.values.length - 1) {
            ++result;
        }
        return result;
    }

    private int bound(double x) {
        return (int)Math.max(0L, Math.min(Math.round(x), 255L));
    }

    public Color getColor(double value) {
        int u = this.upperIndex(value);
        if (u == 0) {
            return this.colors[0];
        }
        double w = (value - this.values[u - 1]) / (this.values[u] - this.values[u - 1]);
        int r = this.bound(w * (double)this.colors[u].getRed() + (1.0 - w) * (double)this.colors[u - 1].getRed());
        int g = this.bound(w * (double)this.colors[u].getGreen() + (1.0 - w) * (double)this.colors[u - 1].getGreen());
        int b = this.bound(w * (double)this.colors[u].getBlue() + (1.0 - w) * (double)this.colors[u - 1].getBlue());
        return new Color(r, g, b);
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < this.values.length) {
            result.append(String.valueOf(this.colors[i].toString()) + " " + this.values[i] + " ");
            ++i;
        }
        return result.toString();
    }
}

