.TH SUNCLOCK 1 "July 3, 2001"
.SH NAME
sunclock \- a fancy clock for the X Window system, providing local time
(legal time and solar time), sunrise, sunset and various geographical 
data through a point and click interface.
.SH SYNOPSIS
.B sunclock
[
.I options
]
.PP
where the list of licit options is the following long list 
(starting from (**) the options are configurable at runtime):
.PP
[-help] [-listmenu] [-version] [-citycheck] \
[-display name] [-sharedir directory] [-citycategories value] \
[-clock] [-map] [-dock] [-undock] \
[-menu] [-nomenu] [-selector] [-noselector] \
[-zoom] [-nozoom] [-option] [-nooption] [-urban] [-nourban]
.PP
(**)  [-language name] [-dateformat string1|string2|...] \
[-rcfile file] [-command string] [-helpcommand string] \
[-clockimage file] [-mapimage file] [-mapmode * <L,C,S,D,E>] \
[-clockgeom <geom>] [-mapgeom <geom>] \
[-auxilgeom <geom>] [-menugeom <geom>] [-selgeom <geom>] \
[-zoomgeom <geom>] [-optiongeom <geom>] [-urbangeom <geom>] \
[-title name] [-clockclassname name] [-mapclassname name] \
[-auxilclassname name] [-classname name] \
[-menufont fontname] [-coordfont fontname] [-cityfont fontname] \
[-mapstripfont fontname] [-clockstripfont fontname] \
[-verbose] [-silent] [-synchro] [-nosynchro] [-zoomsync] [-nozoomsync] \
[-placement (random, fixed, center, NW, NE, SW, SE)] \
[-placementshift x y] [-extrawidth value] \
[-decimal] [-dms] [-city name] [-position latitude|longitude] \
[-addcity size|name|lat|lon|tz] [-removecity name (name|lat|lon)] \
[-rootdx value] [-rootdy value] [-fixedrootpos] [-randomrootpos] \
[-screensaver] [-noscreensaver] [-rootperiod value (in seconds)] \
[-animation] [-noanimation] [-animateperiod value (in seconds)] \
[-progress number[s,m,h,d,M,Y]] [-jump number[s,m,h,d,M,Y]] \
[-aspect mode] [-colorlevel level=0,1,2,3] \
[-fillmode number=0,1,2] [-coastlines] [-contour] [-landfill] \
[-shading mode=0,1,2,3,4,5] [-diffusion value] [-refraction value] \
[-night] [-terminator] [-twilight] [-luminosity] [-lightgradient] \
[-nonight] [-darkness value<=1.0] [-colorscale number>=1] \
[-mag value] [-magx value] [-magy value] [-dx value ] [-dy value] \
[-spotsizes s1|s2|s3|... (0<=si<=4, 1<=i<=citycategories)] \
[-sizelimits w1|w2|w3|... (wi = zoom width values, 1<=i<=citycategories)] \
[-citymode mode=0,1,2,3] [-objectmode mode=0,1,2] \
[-sun] [-nosun] [-moon] [-nomoon] [-tropics] [-notropics] \
[-meridianmode mode=0,1,2,3] [-parallelmode mode=0,1,2,3] \
[-meridianspacing value] [-parallelspacing value] \
[-dottedlines] [-plainlines] [-bottomline] [-nobottomline] \
[-vmfcolors color1|color2|color3...] [-setcolor field|color]

.SH DESCRIPTION
.I sunclock
is an X11 application that displays a map of the Earth and shows
the illuminated portion of the globe.  In addition to providing local
time for the default timezone, it also displays GMT time, legal and
solar time of major cities, their latitude and longitude, the
mutual distances of arbitrary locations on Earth, the position at
zenith of Sun and Moon. Sunclock can display meridians, parallels, 
tropics and arctic circles. It has builtin functions that accelerate 
the speed of time and show the evolution of seasons. Sunclock can be 
internationalized for various western languages. It is possible to 
customize the app-default file and enter additional city entries.

Sunclock can commute between two states, the "clock window" and
the "map window". The clock window displays a small map of the Earth
and therefore occupies little space on the screen, while the "map window" 
displays a large map and offers more advanced functions. The Sunclock
package includes a resizable and zoomable vector map . External
Earth maps can also be loaded (as to version 3.30, formats .jpg, 
.xpm or .xpm.gz, .vmf can be read [.vmf is the specific vector map 
format of  sunclock]). Some additional formats could be added in the 
future.

The map window can work in five different modes:
.PP
- "Legal time" mode: legal time of default time zone and GMT time are 
displayed.
.PP
- "Coordinate" mode: by clicking on a city, users get coordinates 
(latitude, longitude) of that city, legal time and sunrise/sunset.
.PP
- "Solar" mode: by clicking on a point of the map (either a city or 
another point), solar time and day length are shown.
.PP
- "Hour Extension" mode: displays solar times from 00:00 to 23:00 in bottom
strip, according to the Sun position.
.PP
- "Distance" mode: shows distances in km and miles between two arbitrary
locations.
.PP
Depending on the mode chosen, the bottom line shows a short text
displaying the requested information. The bottom line can be scrolled to
the right or to the left by pressing the PageUp/PageDown and Home/End 
key arrows.
.PP
A further functionality is the "Progress" feature, which allows to
accelerate the evolution of time, so as to observe the evolution of
day/night periods and seasons. By default, the Sun and Moon are also
shown on the map (rather, the positions of Earth where Sun and Moon
are at zenith are shown).  Coordinates of meridians, parallels,
cities, the names of cities can be displayed on the map.

All functionalities can be accessed though GUI actions on the main
window or the auxiliary windows. The main window is resizable by
pulling the window edges - as the current window manager permits it. 
There are 5 auxiliary windows:
.PP
- Menu Window. This is the main menu, which offers a wide list of actions. 
The menu window is launched by typing 'H' or clicking on the bottom 
strip with the left mouse button once. Each action can be obtained by using 
the indicated keyboard shortcut or by clicking with the mouse on the 
corresponding entry. Upper/lower case is irrelevant, except for options or 
actions which have more than 2 switches. Lower case then rotates the switches 
in one direction, upper case in the other direction. For those switches, 
the left mouse button will have the same effect as lower case, and the 
right mouse button the same effect as upper case.
.PP
- File Selector window. It can be accessed by clicking on the upper part 
of the main window with the middle mouse button. It allows to select
the Earth image file (in formats *.vmf *.xpm, *.xpm.gz, *.jpg) to be 
loaded.
.PP
- Zoom window. It can be accessed by clicking on the upper part
of the main window with the right mouse button. The zoom window
allows to select a specific area on the Earth, to translate or zoom 
it up to 100 times. High resolutions (larger than 10) are only recommended 
with the "huge" Earthmap of 11 Mbytes, which offers clean images up to
20 times magnification at least.
.PP
- Urban selector window. Allows to modify interactively the list of 
shown cities and locations.
.PP
- Option window. Allows to reconfigure pretty much everything on the fly
(colors, fonts, etc), exactly as with the command line options.
.SH OPTIONS
The program does not use the Xt nor any other more advanced toolkit,
and hence only (!) those options explicitly enumerated below may be used.
The only needed resource is the list of coordinates and timezones of
cities to be displayed. The system administrator can possibly customize 
the system-wide prepackaged config file Sunclockrc before installing the
package, while users can tweak their individual configuration file 
~/.sunclockrc at any time. The individual config file ~/.sunclockrc is 
read *after* the system wide config file Sunclockrc, and therefore its
settings override those of the system wide config. The command line
options can be used to override ~/.sunclockrc itself.
.TP
.BI "\-help "
Show brief help and exit.
.TP
.BI "\-listmenu "
Explanations on the actions available from the builtin menu.
.TP
.BI "\-version "
Show program version and exit.
.TP
.BI "\-verbose "
Make Sunclock verbose. The program then sends to stderr some information 
on the internal operations performed. This is disabled by default.
.TP
.BI "\-silent "
Make Sunclock silent about internal operations performed. This is the default.
.TP
.BI "\-citycheck "
At start-up, check that there are no repetitions in the list of cities
(a city is considered to be repeated if it appears twice under the same
name, with coordinates differing by at most 0.5 degree).
By default no check is performed on Sunclockrc - which is supposedly
correctly set up...
.TP
.B "\-display " dispname
Give the name of the X server to contact.
.TP
.B "\-language " name
Select language to be used in the sunclock menu and help.
.TP
.B "\-title name"
Change the specification of the string which should appear in the title bar
of the main and auxiliary windows. Default is the application name, 
i.e., sunclock.
.TP
.B "\-classname name"
Change the specification of class application name. Default is
Sunclock. Other specifications can be passed so that aware window
managers might use it for configuration purposes. You might e.g.
pass -classname NoTitle-Sticky, and configure properly your WM so
that it removes the title bar, and make the window sticky with respect 
to the Desktop Pager. With fvwm, you could use for instance
.PP
Style "*NoTitle*"    NoTitle, WindowListHit, Sticky
.PP
Style "*ShowTitle*"  Title, WindowListHit, Slippery
.PP
Style "*Sticky*"     Sticky
.PP
to get specify such a behaviour.
.TP
.B "\-menufont " name
Select the menu font, used in the bottom line of the map window, in the 
menu, file selection, zoom and option windows. Default is 6x13
.TP
.B "\-coordfont " name 
Select the coordinates font, used when writing coordinates on the map 
window. Default is 6x13.
.TP
.B "\-cityfont " name 
Select the city font, used when writing city names on the map window. 
Default is 6x10.
.TP
.B "\-mapstripfont " name 
Select the map strip font, used in the bottom line of the map window. 
Default is 6x13.
.TP
.B "\-clockstripfont " name 
Select the (normally smaller) clock strip font, used in the bottom line of 
the clock window. Default is 6x10.
.TP
.B "\-rcfile " filename
Read a configuration file that is different from the user default 
~/.sunclockrc (if this option is not set, the user config file defaults to
~/.sunclockrc). Notice that the app-default config file Sunclockrc is 
read first, and the file set by the -rcfile option is read afterwards;
therefore its settings override those set by the system wide config file. 
Reading further config files is possible at runtime, using the option 
window. Set -rcfile with a void string "" if you wish to bypass the
user config file step.
.TP
.B "\-sharedir " directory
Set the directory where system wide shared Earthmaps are located.
Default is /usr/share/sunclock/earthmaps.
.TP
.B "\-mapimage " file.jpg (or file.vmf, file.xpm, file.xpm.gz)
Start sunclock with an Earth map image loaded in the map window.
.TP
.B "\-clockimage " file.jpg (or file.vmf, file.xpm, file.xpm.gz)
Start sunclock with an Earth map image loaded in the clock window. 
The same maps can be used used for the map and clock windows, but
in the latter case they will tend to be scaled down.
.TP
.B "\-colorlevel " level=0,1,2,3
Sets the color level (0=monochrome, 1=few colors, 2=many colors,
3=full colors). With the "monochrome" setting, day and night appear 
respectively as mapbgcolor (white by default) and mapfgcolor (black 
by default), and no shading is available; all other features
(city names, coordinates) appear also as monochrome. 
With the "few colors" setting, the menus and city spots can be 
represented with dedicated colors, but the meridians/parallels/tropics
are still monochrome. With the "many colors" oprions, 
meridians/parallels/tropics can also be drawn in color. 
In these first 3 modes, only .vmf vector maps can be loaded.
These modes save a lot of CPU power - since a simple algorithm of 
inversion of colors is used to set colors of all points in the map. 
Monochrome mode can be useful for very slow CPUs, such as those 
in use in PDAs with black and white screen. The full color mode (level=3)
allows to load jpeg or other colorful images; day and night can be drawn 
with various shading parameters. This is the default and recommended mode 
if you have a reasonably recent machine with enough video RAM.
.TP
.B "\-dock "
This option is meant to give sunclock the ability to be docked in the
window manager buttons or menu bar, providing that the WM offers this
possibility without requiring special hints (fvwm2 or windowmaker or
afterstep will work perfectly well for that purpose, KDE or Gnome
won't...) Under the -dock option, sunclock locks the size of the first
launched window, which is necessarily a small clock. Also, that
initial window can no longer be closed by typing 'K' or 'Q'. (The only
way to exit the application, then, is to kill it with xkill, or to
undock it first with the -undock option from the Option window).
The user might want to customize the size and suitable options so
that sunclock fits with the size of the dockable applets. As an example,
sunclock could be invoked as follows:
.TP
.B " "
sunclock -language fr -nobottomline -dock -clockgeom 63x42+2+190
-dateformat "%H:%M:%S|%a%_%d%_%b|%b%_%Y|%j%_%U/52" -command "xdiary"
.TP
.B "\-undock "
Undocks sunclock. This option has no other effect than reallowing the
use of options that were "frozen" under -dock. It can be used e.g. to 
exit the application when sunclock has been started in dock mode.
.TP
.B "\-synchro "
With this option, sunclock updates all windows simultaneously. This, of 
course, requires more CPU time and may slow down sunclock's operation 
if too many windows have been opened. The default is to update only the 
active window. 
.TP
.B "\-nosynchro "
With this option, sunclock only updates the active window. This is the
default.
.TP
.B \-clock
Start in the clock state. This is the default and thus need not be
specified.
.TP
.BI "\-dateformat string1|string2|..."
Set the format(s) used in the text output in the bottom strip of the clock. 
The default date format consists of 3 strings:
.PP
  %H:%M%_%a%_%d%_%b%_%y|%H:%M:%S%_%Z|%a%_%j/%t%_%U/52
.PP
Here %H,%M,%S stand for hour, minutes, seconds, %a for dayname, 
%b for monthname, %d for monthday number, %j for yearday number,
%m for month number, %y for year last two digits, %Y for year number,
%t for number of days in year (365 or 366), %Z for timezone, %U for week
number (week #1 is the week with the first thursday of the year); all
other characters are reproduced as such, except %_ which stands for a 
blank space, %% which stands for % and %| which stands for |. The vertical 
bar | is used as a delimiter to indicate successive time formats. There 
can be as many formats as desired, and the actual selection cycles through
all these formats by clicking on the bottom strip with the mouse. The 
first string (i.e. the one preceding the first bar) is taken as the 
default format.
.TP
.BI "\-map "
Start in the map state.  Useful to start right away with advanced 
functionalities.
.TP
.BI "\-decimal "
Initializes coordinate values of geographical data in decimal degrees.
However, this can still be switched at runtime.
.TP
.BI "\-dms "
Initializes coordinate values of geographical data in degrees, minutes
and seconds. However, this can still be switched at runtime.
.TP
.B "\-menu "
Raise the menu window along with the main (map, clock) window.
.TP
.B "\-nomenu "
Don't raise the menu window along with the main (map, clock) window.
This is the default.
.TP
.B "\-selector "
Raise the selector window along with the main (map, clock) window.
.TP
.B "\-noselector "
Don't raise the selector window along with the main (map, clock) window.
This is the default.
.TP
.B "\-zoom "
Raise the zoom window along with the main (map, clock) window.
.TP
.B "\-nozoom "
Don't raise the zoom window along with the main (map, clock) window.
This is the default.
.TP
.B "\-option "
Raise the option window along with the main (map, clock) window.
.TP
.B "\-nooption "
Don't raise the option window along with the main (map, clock) window.
This is the default.
.TP
.B "\-urban "
Raise the urban window along with the main (map, clock) window.
.TP
.B "\-nourban "
Don't raise the urban window along with the main (map, clock) window.
This is the default.
.TP
.B "\-aspect " mode
Sets the aspect mode, i.e. the way by which zooming behaves with 
respect to horizontal and vertical directions. Mode = 0 means that no 
synchronizations are made, mode = 1 means that the zoom factors are
always made to be equal, mode = 2 (the more subtle one) means that 
the horizontal and vertical zoom factors are adjusted so that the
region located near the central point of the zoomed area will be
conformal to its actual geometry on Earth, i.e. will not appear to be
distorted horizontally or vertically.  This won't be true elsewhere,
though, especially if the zoomed area is large.
.TP
.B "\-zoomsync "
When the option is set, the zoom window will open in synchronization mode:
any zooming action made from the main map or from the zoom window will 
take place as the mouse button is released (or as a key is pressed).
This is the default when the zoom window has not been opened 
(synchronization is automatically set).
.TP
.B "\-nozoomsync "
When set, the zoom window will open in non-synchro mode. Synchronizing
the zoom will still be possible, though, by clicking on the "Synchro"
button. By default, synchronization does not occur when the zoom window
is opened, unless option -zoomsync has been set.
.TP
.BI "\-mapmode * (single character = C, D, E, L or S)"
Start the map functions in mode (C)oordinates, (D)istances, hour (E)xtension,
(L)egal time or (S)olar time respectively. Any other specification is 
ignored. Default is legal time mode.
.TP
.BI "\-placement " <choice>\ (random, fixed, center, NW, NE, SW, SE)
Specify whether commuting between clock and map windows should proceed
with letting the the window centers, respectively, the NW, NE, SW, SE 
corners fixed, or rather whether it should operate randomly, or through 
user defined placement. Default is NW placement.
.TP
.BI "\-placementshift " x\ y
Relative displacement <clock window> --> <map window>, to apply with
respect to the -placement specification. If placement is NW, then
the NW window corner will move by (x,y) pixels. Defaut is (0,0), i.e.
no modification to apply to the -placement specification.
.TP
.BI "\-extrawidth " value
When using the 'enlarge window' command specified by key '>', the width
of the full X display is used, minus some default width equal to 10 pixels.
This is enough the accomodate the width of window borders of most window
managers. In case it is not, -extrawidth <value> can be used to change
this setting.
.TP
.BI "\-clockgeom " (width)x(height)+(x coord)+(y coord)
Specify the geometry of the clock window, i.e. its size and position
(absolute position with respect to the left upper corner of the screen).
.TP
.BI "\-mapgeom " (width)x(height)+(x coord)+(y coord)
Specify the geometry of the map window, i.e. its size and position
(absolute position with respect to the left upper corner of the screen).
.TP
.BI "\-menugeom " +(x coord)+(y coord)
Specify the relative position (x = horizontal shift, y = vertical shift)
of the menu window with respect to the main window, starting from the 
bottom edge of the main window (from its top edge in case of SW or 
SE placements, see above). The y value may need an adjustment, according 
to the height of the title bar allocated by the window manager, if any. 
In the case of the menu window, width and height solely depend on the 
menufont, and therefore any given specification of width and height is 
ignored. The default relative position is x = 0, y = 30. 
.TP
.BI "\-selgeom " (width)x(height)+(x coord)+(y coord)
Specify the geometry of the selector window. The position specification 
is relative to the main window (or to the menu, when the menu is raised).
See above option -menugeom for further explanations. The default geometry
of the selector window is 600x180+0+30.
.TP
.BI "\-zoomgeom " (width)x(height)+(x coord)+(y coord)
Specify the geometry of the zoom window. The position specification 
is relative to the main window (or to the menu, when the menu is raised).
See above option -menugeom for further explanations. The default geometry
of the zoom window is 500x320+0+30.
.TP
.BI "\-optiongeom " (width)x(height)+(x coord)+(y coord)
Specify the geometry of the option window. The position specification 
is relative to the main window (or to the menu, when the menu is raised).
See above option -menugeom for further explanations. The height
specification depends solely on the selected menufont and is therefore
ignored. The default geometry of the option window is 630x80+0+30. 
.TP
.BI "\-urbangeom " +(x coord)+(y coord)
Specify the relative position (x = horizontal shift, y = vertical shift)
of the urban window with respect to the main window (or to the menu, when 
the menu is raised). See above option -menugeom for further explanations. 
.TP
.BI "\-auxilgeom " +(x coord)+(y coord)
Specify the relative position (x = horizontal shift, y = vertical shift)
of the auxiliary windows (menu, zoom, selector, option). All relative 
displacements are set to (x,y).
.TP
.BI "\-mag " value
Rescale the image by a magnification factor equal to <value>, which must 
be at least equal to 1.0. This means that the window only shows a fraction 
of the entire map namely, 1/<value> x 1/<value>. Default value is 1.0.
.TP
.BI "\-magx " value
Same as for the -mag option, but only the x direction (width) is rescaled. 
Default value for magx is 1.0.
.TP
.BI "\-magy " value
Same as for the -mag option, but only the y direction (height) is rescaled. 
Default value for magy is 1.0.
.TP
.BI "\-dx " "value (degrees)"
Options -dx and -dy allow to set the longitude, respectively the latitude,
of the city or location at which the zoom area should be centered.
The values should be given in degrees. Default (dx,dy) is (0.0,0.0). 
.TP
.BI "\-dy " "value (degrees)"
See -dx above.
.TP
.BI "\-coastlines "
In the builtin vector map, generate coast lines without filling the
land areas.
.TP
.BI "\-contour "
As before, but use a smart algorithm which eliminates \"redundant\" coast
lines, especially at lower resolutions (in case the coasts are very
irregular, some parts may disappear but the overall picture looks sharper).
.TP
.BI "\-landfill "
In the builtin vector map, fill the land areas without generating coast 
lines.
.TP
.BI "\-fillmode " 0,1,2
Fillmode=0 is equivalent to -coastlines, fillmode=1 is equivalent to 
-contour, and fillmode=2 is equivalent to -landfill.
.TP
.BI "\-dottedlines "
Use dotted lines to represent meridians and parallels.
.TP
.BI "\-plainlines "
Use plain lines to represent meridians and parallels.
.TP
.BI "\-bottomline "
Draw a line at the bottom of the map, to separate the map from the text 
strip showing time and coordinates. 
.TP
.BI "\-nobottomline "
Don't draw the bottom line. This is the default.
.TP
.BI "\-command " string
Specify an external action or program that will be called through keyboard 
shortcut 'x'. Default is empty command.
.TP
.BI "\-helpcommand " string
Specify an external action or program that will be called through keyboard 
shortcut double 'h' (call help). Default is 
"xterm -fn 9x15 -cr green -ms red -e man sunclock &".
.TP
.BI "\-jump " "number[unit] (where unit=s,m,h,d,M,Y)"
Number of seconds (respectively minutes, hour, days, Months, Years) 
by which the current date and time should be shifted. No blank space
should separate the number and its unit. If the unit is absent, the 
number is understood to be expressed by default in seconds. Useful to get 
sunclock display information on earlier or later epochs.
.TP
.BI "\-progress " "number[unit] (where unit=s,m,h,d,M,Y)"
Number of seconds (respectively minutes, hour, days, Months, Years) 
by which the time progression should operate. No blank space
should separate the number and its unit. If the unit is absent, the number
is understood to be expressed by default in seconds. Useful to get sunclock 
progress by other steps than the predefined ones (by default the steps 
cycle between the values 1 mn, 1 hour, 1 day, 7 days, 30 days).
.TP
.BI "\-rootdx " "value (between 0.0 and 1.0)"
Options -rootdx and -rootdy allow to set the position where the sunclock
map is copied on the root window in rootwindow or screensaver modes.
'-rootdx 0.0' means on the left side, '-rootdx 1.0' on the right side,
'-rootdy 0.0' means at the top, '-rootdy 1.0' at the bottom of the root
window. Default is 0.5 for both values, i.e. a centered map.
.TP
.BI "\-rootdy " "value (degrees)"
See -rootdx above.
.TP
.BI "\-fixedrootpos "
Use the above rootdx and rootdy values to fix the position of the map on 
the root window. This is the default unless -screensaver has been
specified.
.TP
.BI "\-randomrootpos "
Instead of using the above rootdx and rootdy values to fix the position 
of the map on the root window, just use a random position instead.
This is the default in case the -screensaver option has been set.
.TP
.BI "\-screensaver "
Start sunclock in screensaver mode (no window nor any GUI controls
are available in that case, and the only way to terminate the program
is to kill it explicitly).
.TP
.BI "\-noscreensaver "
Do not start sunclock in screensaver mode. This is the default.
.TP
.BI "\-rootperiod " "value (in seconds, between 1 and 120 sec)"
Set the period for refreshing the root window. Default is 30 seconds.
This takes effect only when writing the map onto the root window is active
(strike twice on '[' or hit the relevant box in the Option window).
Writing onto the root window is disabled by using the ']' key.
.TP
.BI "\-animation "
Start the animation mode right away when sunclock is launched.
.TP
.BI "\-noanimation "
Don't start the animation mode when sunclock is launched - this is the
default. Sunclock can anyway switch between the animation/noanimation
modes by typing key ' (apostrophe) at runtime.
.TP
.BI "\-animateperiod " "value (in seconds, between 0 and 5 sec)"
Set the period for animating the map. Default is 0 seconds, which means that
images are switched as fast as sunclock can compute them. Otherwise time
is shifted by the current progress value (as set by the -progess option)
after waiting the number of seconds prescribed by the animateperiod value.
This takes effect only when the animation is active (strike on the ' key 
or hit the relevant box in the Option window).
.TP
.BI "\-addcity " size|name|latitude|longitude|timezone
.PP
where name is the ascii name of the place to be shown on the map.
The first argument "size" is an nonnegative integer meant to indicate the
size of the city (1: major city, 2: important city, 3: less important
city, ...). The argument "size" can also be set to 0, with the effect
of hiding the corresponding city, while keeping in memory all of its
other parameters. The city can then be shown again with
Latitude and longitude are floating point numbers representing the
geographical location of the place. Western longitudes and southern latitudes
should be entered as negative numbers. timezone is the name of the timezone
that the place is in. This should be the name of a file under
/usr/share/zoneinfo (or whatever directory is used on your system),
incorrect timezones cause the clock to display GMT. It is also possible to
reference a file in a directory relative to /usr/share/zoneinfo for example
Canada/Eastern instead of EST5EDT.
.TP
.BI "\-city " "name (name|lat|lon)"
Initialize program so as to display data of city 'name', respectively
(name, with latitude and longitude specified). This becomes effective only 
if the above mentioned city is listed in the systemwide RC file Sunclockrc
or in the user's private ~/.sunclockrc. The operating mode is set to 
Coordinates mode.
.TP
.BI "\-position " "latitude|longitude"
Initialize program so as to display data of the position specified by 
two coordinates (in degrees). The operating mode is set to Solar time mode.
Notice that \"latitude|longitude\" should be given as a single parameter
with a vertical bar | (a blank space is also admitted instead of a |).
.TP
.BI "\-addcity " "size|name|lat|lon|tz"
Adds a city in the list of cities to be displayed on the map. They must be
defined by exactly 5 parameters: size, name, latitude, longitude, timezone,
in this order, with parameters being separated by a vertical bar |. Blank
characters may appear in the name if double quotes are used to mark
the group of parameters (but there shouldn't be any blank characters
in the other parameters). In the RC config file, blank characters should
be replaced by the octal character 037 (i.e. Ctrl-Q Ctrl-_ within emacs).
.TP
.BI "\-removecity " "name (name|lat|lon)"
Removes name (respectively name|lat|lon) from the list of cities to be
displayed. Same remarks as above for blank characters.
.TP
.BI "\-citycategories " value
Specifies the maximal number of city categories: categories range from 1 
(highest catgory, i.e. major city) to some maximum number. The option
-citycategories specifies that maximum number. It can only be used
at start-up, not at runtime. The default value is 5.
.TP
.BI "\-spotsizes " "s1|s2|s3|... (0<=si<=5, 1<=i<=citycategories)"
With this setting, major cities (category 1) will be represented by the 
symbol of size s1, category 2 cities by the symbol off size s2, etc. 
The default setting is -spotsize 1|2|3|4|5. Assigning size si=0 means that 
the corresponding category of cities (rank i) will not be displayed. 
If there are less data than the number of city categories (5 by default), 
the last given data is repeated as many times as needed, e.g.
-spotsizes 2 is equivalent to -spotsizes 2|2|2|2|2.
Example: specifying -spotsizes 0|2|0|3|0 will let appear only city
categories 2 and 4, but those of category 4 will appear with the symbol
normally allocated to cities of category 3. This is useful in combination
with the option -sizelimits (see below).
.TP
.BI "\-sizelimits " w1|w2|w3|... 
(wi = zoom width values, 1<=i<=citycategories)
With this setting, cities of rank i=1,2,3,... will appear if (and only if) 
the width of the zoomed map is at least equal to wi (as it would appear 
if the Earth would be entirely displayed...) . The default is
0|580|2500|6000|12000 (no constraint for major cities, rank 4 cities appear
only if the width is at least 6000 pixels, e.g. if an original window
of width 800, say, has been applied a zoom at least equal to 7.5).
Thus -sizelimits 0 is equivalent to -sizelimits 0|0|0|0|0, -sizelimits 0|400
is equivalent to -sizelimits 0|400|400|400|400.
.TP
.BI "\-shading " mode=0,1,2,3,4,5
Start sunclock with the specified shading mode. Mode 0 means that the night
area is not displayed. In higher modes, the night area is displayed, with
increasingly sophisticated shading algorithms. Mode 1 stands for no shading
(i.e. just bright and dark colors are shown). Mode 2 shades the 
terminator area -- the area in which the sun is partially hidden by the 
horizon. Mode 3 shades the region in which there is still substantial 
luminosity left after sunset (depending on the diffusion parameter below). 
Default is 3 below horizon. Mode 4 additionally represents the luminosity 
values in all parts of the illuminated area. Mode 5 represents the gradient
of luminosity from the brightest area (facing the sun) to the darkest area
(opposite to the sun); this has nothing to do, though, with the actual
luminosity values.
.TP
.BI "\-nonight "
Start sunclock with the night region not drawn. This is
equivalent to \-shading 0.
.TP
.BI "\-night "
Start sunclock with the night region in plain shading mode. This is
equivalent to \-shading 1.
.TP 
.BI "\-terminator " 
Equivalent to \-shading 2 
.TP 
.BI "\-twilight "
Equivalent to \-shading 3 
.TP 
.BI "\-luminosity "
Equivalent to \-shading 4
.TP 
.BI "\-lightgradient "
Equivalent to \-shading 5
.TP
.BI "\-diffusion " "value\ (degrees)"
Sets the amplitude of the area in which diffusion of light in the
atmosphere is still sufficient to keep some luminosity after sunset.
Default is 3 degrees.
.TP
.BI "\-refraction " "value\ (degrees)"
Sets the value of the refraction angle for tangential sun rays at sunset.
This is related to the fact that the sun sometimes looks bigger at sunset.
Changing the refraction degree slightly affects the computation of sunrise
and sunset times. Default is 0.1 degree.
.TP
.BI "\-darkness " "value\ (in the range 0.0 ... 1.0)"
Sets the constrast between day and night areas. A 0.0 value means that 
the night area will not be distinguishable from day, while 1.0 means that 
it will be completely black. Default is 0.5.
.TP
.BI "\-colorscale " "value\ (integer in the range 1 ... 256)"
Sets the number of color subdvisions which will be in use for producing
shading, that is, the number of colors ranging from bright colors (day)
to dark colors (night). Default is 16.
.TP
.BI "\-meridianmode mode=0,1,2,3"
Start sunclock with meridians displayed or not, according to the mode,
mode=0 : no meridians, mode=1 : meridians drawn, mode=2 : meridians drawn
with labels at the bottom, mode=3 : meridians drawn with labels at the top.
The default mode is 0 (no meridians).
.TP
.BI "\-parallelmode mode=0,1,2,3"
Start sunclock with parallels displayed or not, according to the mode,
mode=0 : no parallels, mode=1 : parallels drawn, mode=2 : parallels drawn
with labels at the left hand side, mode=3 : parallels drawn with labels 
at the right hand side. The default mode is 0 (no parallels).
.TP
.BI "\-meridianspacing value\ (degree)"
Specify how many degrees (or fractions of degree) should separate
meridians drawn on the map.
.TP
.BI "\-parallelspacing value\ (degree)"
Specify how many degrees (or fractions of degree) should separate
parallels drawn on the map.
.TP
.BI "\-citymode mode=0,1,2,3"
Start sunclock with cities displayed or not, according to the mode,
mode=0 : no cities, mode=1 : cities drawn, mode=2 : cities drawn
with their names, mode=3 : cities drawn with their coordinates. 
The default mode is 1 (cities shown without names or coordinates).
.TP
.BI "\-tropics "
Start sunclock with tropics and arctic circles displayed (by default, 
they aren't).
.TP
.BI "\-sun "
Start sunclock with the Sun position displayed (by default, it is).
.TP
.BI "\-moon "
Start sunclock with the Moon position displayed (by default, it is).
.TP
.BI "\-notropics \-nosun \-nomoon"
These options just negate the above ones.
.TP
.BI "\-objectmode " mode=0,1,2
Mode=0 stands for no objects (Sun, Moon) at all, mode=1 for objects just
drawn by their symbol, mode=2 for objects drawn with their symbol
and coordinates in decimal degrees (or degrees, minutes, seconds, using
the  key switch).
.TP 
.BI "\-vmfcolors " "color1|color2|color3..."
Redefine the list of colors to be used in the .vmf file. This option has
no effect when loading files with other formats. Default is NULL string
(so that the default colors are loaded). The string "|" is also considered
to be a void string and can be used in the option widget to enforce
default colors back.
.TP 
.BI "\-setcolor " "field|color"
Sets the color of a specified field in the sunclock widgets. 
The color can be specified as any litteral value (red, yellow, etc...,
as defined in the resource file rgb.txt), or as a 6 digit hexadecimal 
value #ijklmn, or even 12 digits (for 48 bits displays!) The field can 
take any of the following values (between parentheses, the meaning and
default value):
.PP
clockbg (clock background color; White)
.PP
clockfg (clock foreground color; Black)
.PP
mapbg (map background color; White)
.PP
mapfg (map foreground color; Black)
.PP
menubg (menu text background color; Grey92)
.PP
menufg (menu text foreground color; Black)
.PP
weak (color for disabled menu commands; Red)
.PP
clockstripbg (background color of bottom strip in clock window; Grey92)
.PP
clockstripfg (foreground color of bottom strip in clock window; Black)
.PP
mapstripbg (background color of bottom strip in map window; Grey92)
.PP
mapstripfg (foreground color of bottom strip in map window; Black)
.PP
zoombg (background color of the small monochrome map used in the 
zoom widget; White)
.PP
zoomfg (foreground color of the small monochrome map used in the 
zoom widget; Black)
.PP
optionbg (background color of option text entry; White)
.PP
optionfg (foreground color of option text entry; Black)
.PP
caret (color of text caret; SkyBlue2)
.PP
change (color for temporary changes; Brown)
.PP
choice (color for selected changes and choices; SkyBlue2)
.PP
directory (color of text indicating directory entries; Blue)
.PP
image (color of text indicating image files; Magenta)
.PP
cityname (color of text indicating city names; Red)
.PP
city0 (color of unmarked cities; Orange)
.PP
city1 (color of marked cities, main selection; Red)
.PP
city2 (color of marked cities, secondary selection; Red3)
.PP
mark1 (color of first mark; Pink1)
.PP
mark2 (color of secondary mark; Pink2)
.PP
line (color of geodesic lines; White).
.PP
meridian (color of meridians; White).
.PP
parallel (color of parallels; White).
.PP
tropic (color of Equator/Tropics/Arctic circles; White)
.PP
sun (color of Sun; Yellow)
.PP
moon (color of Moon; Khaki)
.PP
star (color of Stars; White)
.PP
root (color of Root window on which stars will be drawn; Black)
.PP
.SH PRIVATE CONFIGURATION FILE
Users may keep a file in their home directory called ~/.sunclockrc. This
file can contain specify any number of options which are also available
as command line options:
.PP
mapmode: L
.PP
language: en
.PP
city: Washington
.PP
map
.PP
mapimage: /usr/share/sunclock/earthmaps/jpeg/caida.jpg
.PP
tropics
.PP
twilight

.SH "HOW IT WORKS"
.I sunclock
calculates the position of the Sun using the algorithm in chapter 18 of:
.PP
.I "Astronomical Formulae for Calculators"
by Jean Meeus, Third Edition, Richmond: Willmann-Bell, 1985.
.PP
and Mercator projects the illuminated area onto map image.  The
Sun's position is calculated to better than one arc-second
in accuracy.
.SH BUGS
Sunclock makes intensive use of pointers and memory allocation/deallocation,
so memory leaks might still be possible under some circumstances. 
However, the program has been thoroughly debugged, and crashes seem 
to be rather rare. As new features are introduced, older ones may become 
broken during the phase of development :-(
.PP
The illuminated area shown is the area which would be sunlit
if the Earth atmosphere would be absolutely uniform.  The actual 
illuminated area may depend on weather, temperature, atmospheric 
refraction and diffusion, etc.
.SH AUTHORS
John Walker, Autodesk, Inc., <kelvin@acad.uu.NET>, wrote the original
Suntools program from which sunclock is derived.
.PP
John Mackin, Basser Department of Computer Science, University of Sydney,
Sydney, Australia, <john@cs.su.oz.AU>, wrote the X11 version out of Suntools.
.PP
Stephen Martin, Fujitsu Systems Business of Canada, smartin@fujitsu.ca,
added support for interactive map.
.PP
Jean-Pierre Demailly, Universit de Grenoble I, 
demailly@fourier.ujf-grenoble.fr worked out versions 3.xx, which add many 
new major features (loading maps, shading, zoom functionalities, 
configuration of options on the fly at runtime, through a point and click
GUI interface).
