#!/usr/bin/php
<?
/*
 *  Copyright (C) 2008 Nicolas Vion <nico@picapo.net>
 *
 *   This file is part of swac-explore.
 *
 *   Foobar is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   Foobar is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with swac-explore; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */


$struct_sound_info = array(
	"Word" => array(
		array("title" => "Text", "field" => "SWAC_TEXT", "var" => "TEXT"),
		array("title" => "Language", "field" => "SWAC_LANG", "var" => "LANG")
	),
	"Speaker" => array(
		array("title" => "Name", "field" => "SWAC_SPEAK_NAME", "var" => "SPEAK_NAME"),
		array("title" => "Gender", "field" => "SWAC_SPEAK_GENDER", "var" => "SPEAK_GENDER"),
		array("title" => "Native Language", "field" => "SWAC_SPEAK_LANG", "var" => "SPEAK_LANG"),
		array("title" => "Native Region", "field" => "SWAC_SPEAK_LANG_REGION", "var" => "SPEAK_LANG_REGION"),
		array("title" => "Living Country", "field" => "SWAC_SPEAK_LIV_COUNTRY", "var" => "SPEAK_LIV_COUNTRY"),
		array("title" => "Living Town",	"field" => "SWAC_SPEAK_LIV_TOWN", "var" =>  "SPEAK_LIV_TOWN")
	),
	"Collection" => array(
		array("title" => "Name", "field" => "SWAC_COLL_NAME", "var" => "COLL_NAME"),
		array("title" => "Homepage", "field" => "SWAC_COLL_URL", "var" => "COLL_URL"),
		array("title" => "Section", "field" => "SWAC_COLL_SECTION", "var" => "COLL_SECTION"),
		array("title" => "Description",	"field" => "SWAC_COLL_DESC", "var" => "COLL_DESC"),
		array("title" => "Authors", "field" => "SWAC_COLL_AUTHORS", "var" => "COLL_AUTHORS"),
		array("title" => "Organisation", "field" => "SWAC_COLL_ORG", "var" => "COLL_ORG"),
		array("title" => "Organisation Homepage", "field" => "SWAC_COLL_ORG_URL", "var" => "COLL_ORG_URL"),
		array("title" => "License", "field" => "SWAC_COLL_LICENSE", "var" => "COLL_LICENSE"),
		array("title" => "Copyright", "field" => "SWAC_COLL_COPYRIGHT", "var" => "COLL_COPYRIGHT")
	),
	"Classification" => array(
		array("title" => "Alphabetical Keys", "field" => "SWAC_ALPHAIDX", "var" => "ALPHAIDX"),
		array("title" => "Base From", "field" => "SWAC_BASEFORM", "var" => "BASEFORM"),
		array("title" => "Form Name", "field" => "SWAC_FORM_NAME", "var" => "FORM_NAME"),
		array("title" => "Homograph Id.", "field" => "SWAC_HOMOGRAPHIDX", "var" => "HOMOGRAPHIDX")
	),
	"Technical Information" => array(
		array("title" => "Recording Date", "field" => "SWAC_TECH_DATE", "var" => "TECH_DATE"),
		array("title" => "Audio Quality", "field" => "SWAC_TECH_QLT", "var" => "TECH_QLT"),
		array("title" => "Software", "field" => "SWAC_TECH_SOFT", "var" => "TECH_SOFT")
	),
	"File" => array(
		array("title" => "Package", "field" => "packages.path", "var" => "path"),
		array("title" => "Filename", "field" => "filename", "var" => "filename"),
		array("title" => "Index", "field" => "sounds.idx", "var" => "idx")
	)
);

$struct_sounds_list = array(
	array("field" => "SWAC_TEXT", "var" => "TEXT", "title" => "Pronunced"),
	array("field" => "SWAC_LANG", "var" => "LANG", "title" => "Lang.", "visible" => false),
	array("field" => "SWAC_HOMOGRAPHIDX", "var" => "HOMOGRAPH", "title" => "Homograph"),
	array("field" => "SWAC_BASEFORM", "var" => "BASEFORM", "title" => "Baseform", "visible" => false),
	array("field" => "SWAC_FORM_NAME", "var" => "FORM_NAME", "title" => "Form Name", "visible" => false),
	array("field" => "SWAC_SPEAK_NAME", "var" => "SPEAK_NAME", "title" => "Speaker Name"),
	array("field" => "SWAC_SPEAK_LANG_REGION", "var" => "SPEAK_LANG_REGION", "title" => "Native Region", "visible" => false),
	array("field" => "sounds.idx", "var" => "idx", "title" => "Idx", "visible" => false),
	array("field" => "filename", "var" => "filename", "title" => "Filename"),
	array("field" => "packages.path", "var" => "path", "title" => "Package", "visible" => false)
);

$struct_select_field = array(
	array("field" => "SWAC_TEXT", "title" => "Pronunced"),
	array("field" => "SWAC_ALPHAIDX", "title" => "Alphabetical Keys", "default" => "true"),
	array("field" => "SWAC_TECH_DATE", "title" => "Recording Date"),
	array("field" => "SWAC_BASEFORM", "title" => "Baseform"),
	array("field" => "filename", "title" => "Filename")
);





define("TAB", "	");
define("RET", "\n");
define("SL", " \\");

echo "//This file was automaticaly generated by /php/make.php don't modify!".RET.RET;


//--------- Sound info -----------
echo "#define SOUND_INFO_INIT ".SL.RET;
echo TAB."Gtk::TreeRow parent;".SL.RET;
foreach ($struct_sound_info as $title => $items) {
	echo SL.RET;
	echo TAB.'parent = *(store_info->append());'.SL.RET;
	echo TAB.'parent[ListSoundInfo.caption] = "'.$title.'";'.SL.RET;
	echo TAB.'parent[ListSoundInfo.weight] = Pango::WEIGHT_BOLD;'.SL.RET;;

	foreach($items as $item) {
		echo SL.RET;
		echo TAB.'if (Gtk::TreeRow row = *(store_info->append(parent->children()))) {'.SL.RET;
		echo TAB.TAB.'row[ListSoundInfo.caption] = "'.$item["title"].' :";'.SL.RET;
		echo TAB.TAB.'view_'.$item["var"].' = row;'.SL.RET;
		echo TAB.'}'.SL.RET;

	}
}
echo RET.RET;



echo "#define SOUND_INFO_VARS".SL.RET;
foreach ($struct_sound_info as $title => $items)
	foreach($items as $item)
		echo TAB.'Gtk::TreeModel::Row view_'.$item["var"].";".SL.RET;
echo RET.RET;



$fields = array();
foreach ($struct_sound_info as $title => $items)
	foreach($items as $item)
		$fields[$item["var"]] = $item["field"]; 

echo "#define SOUND_INFO_SET".SL.RET;
echo TAB."if (argc == ".count($fields).") {".SL.RET;
$i = 0;
foreach($fields as $var => $field)
	echo TAB.TAB.'Window1->view_'.$var.'[Window1->ListSoundInfo.value] = argv['.($i++).'];'.SL.RET;
echo TAB."}".RET;
echo RET.RET;


echo '#define SOUND_INFO_FIELDS "'.implode(", ", array_values($fields)).'"';
echo RET.RET;



//--------- Sound List -----------
echo "#define SOUNDS_LIST_INIT".SL.RET;
echo TAB."int count;".SL.RET;
echo TAB."Gtk::TreeViewColumn *new_column;".SL.RET;
foreach($struct_sounds_list as $i => $col) {
	echo TAB.'count = treeview1->append_column("'.$col["title"].'", ListView.'.$col["var"].');'.SL.RET;
	echo TAB.'if (new_column = treeview1->get_column(count - 1)) {'.SL.RET;
	echo TAB.TAB.'new_column->set_sort_column(ListView.'.$col["var"].');'.SL.RET;
	echo TAB.TAB.'new_column->set_resizable(true);'.SL.RET;
	if (isset($col["visible"]) and !$col["visible"])
		echo TAB.TAB.'new_column->set_visible(false);'.SL.RET;
	echo TAB."}".SL.RET.SL.RET;
}
echo RET.RET;


echo "#define SOUNDS_LIST_VARS".SL.RET;
echo TAB.'TModelListView() { '.SL.RET;
foreach($struct_sounds_list as $i => $col)
	echo TAB.TAB.'add('.$col["var"].');'.SL.RET;
echo TAB.'}'.SL.RET;
foreach($struct_sounds_list as $i => $col)
	echo TAB.'Gtk::TreeModelColumn<Glib::ustring> '.$col["var"].";".SL.RET;
echo RET.RET;



echo "#define SOUNDS_LIST_SET".SL.RET;
echo TAB."if (argc == ".count($struct_sounds_list).") {".SL.RET;
echo TAB.TAB."Gtk::TreeRow row = *(Window1->store_sounds->append());".SL.RET;
foreach ($struct_sounds_list as $i => $col)
	echo TAB.TAB.'row[Window1->ListView.'.$col["var"].'] = argv['.$i.'];'.SL.RET;
echo TAB."}".RET;
echo RET.RET;



$fields = array();
foreach($struct_sounds_list as $i => $col)
	$fields[] = $col["field"];

echo '#define SOUNDS_LIST_FIELDS "'.implode(", ", $fields).'"';
echo RET.RET;


//--------- Select field -----------
echo '#define SELECT_FIELD_INIT'.SL.RET;
foreach($struct_select_field as $i => $field) {
	echo TAB.'if (Gtk::TreeRow row = *(store_fields->append())) {'.SL.RET;
	echo TAB.TAB.'row[ListExt.value] = "'.$field["field"].'";'.SL.RET;
	echo TAB.TAB.'row[ListExt.caption] = "'.$field["title"].'";'.SL.RET;
	if (isset($field["default"]) and $field["default"]) { 
		echo TAB.TAB.'user_index_field = "'.$field["field"].'";'.SL.RET;
		echo TAB.TAB.'combobox2->set_active(row);'.SL.RET;	
	}
	echo TAB.'}'.SL.RET;
	echo SL.RET;

}
echo RET.RET;



