/*==================================================================
 * popdog.h - Popup dialog routines
 *
 * Swami
 * Copyright (C) 1999-2003 Josh Green <jgreen@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA or point your web browser to http://www.gnu.org.
 *
 * To contact the author of this program:
 * Email: Josh Green <jgreen@users.sourceforge.net>
 * Swami homepage: http://swami.sourceforge.net
 *==================================================================*/
#include "popdog.h"
#include <gtk/gtkframe.h>
#include <gtk/gtkbutton.h>
#include <gtk/gtkhbox.h>
#include <gtk/gtkvbox.h>

static void gtk_popdog_class_init (GtkPopDogClass * klass);
static void gtk_popdog_init (GtkPopDog * popdog);

GtkType
gtk_popdog_get_type (void)
{
  static GtkType popdog_type = 0;

  if (!popdog_type)
    {
      static const GtkTypeInfo popdog_info = {
	"GtkPopDog",
	sizeof (GtkPopDog),
	sizeof (GtkPopDogClass),
	(GtkClassInitFunc) gtk_popdog_class_init,
	(GtkObjectInitFunc) gtk_popdog_init,
	/* reserved_1 */ NULL,
	/* reserved_2 */ NULL,
	(GtkClassInitFunc) NULL,
      };
      popdog_type = gtk_type_unique (GTK_TYPE_WINDOW, &popdog_info);
    }

  return (popdog_type);
}

static void
gtk_popdog_class_init (GtkPopDogClass * class)
{
}

static void
gtk_popdog_init (GtkPopDog * popdog)
{
  GtkWidget *frame;
  GtkWidget *box;

  box = gtk_vbox_new (FALSE, 4);
  gtk_container_set_border_width (GTK_CONTAINER (box), 10);
  gtk_container_add (GTK_CONTAINER (popdog), box);
  gtk_widget_show (box);

  frame = gtk_frame_new (NULL);
  gtk_box_pack_start (GTK_BOX (box), frame, TRUE, TRUE, 0);
  gtk_widget_show (frame);

  popdog->vbox = gtk_vbox_new (FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (popdog->vbox), 5);
  gtk_container_add (GTK_CONTAINER (frame), popdog->vbox);
  gtk_widget_show (popdog->vbox);

  popdog->action_area = gtk_hbox_new (TRUE, 5);
  gtk_container_set_border_width (GTK_CONTAINER (popdog->action_area), 0);
  gtk_box_pack_start (GTK_BOX (box), popdog->action_area, FALSE, FALSE, 0);
  gtk_widget_show (popdog->action_area);
}

GtkWidget *
gtk_popdog_new (gchar * title)
{
  GtkWidget *popdog;

  popdog = GTK_WIDGET (gtk_type_new (GTK_TYPE_POPDOG));
  gtk_window_set_title (GTK_WINDOW (popdog), title);
  gtk_window_set_position (GTK_WINDOW (popdog), GTK_WIN_POS_MOUSE);
  return (popdog);
}
