/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.internal.ViewPane;
import org.eclipse.ui.internal.WorkbenchPartReference;
import org.eclipse.ui.presentations.IPartMenu;
import org.eclipse.ui.presentations.IPresentablePart;

public class PresentableViewPart
implements IPresentablePart {
    private final List listeners = new ArrayList();
    private ViewPane pane;
    private IPartMenu viewMenu = new IPartMenu(){

        public void showMenu(Point location) {
            PresentableViewPart.this.pane.showViewMenu(location);
        }
    };
    private final IPropertyListener propertyListenerProxy = new IPropertyListener(){

        public void propertyChanged(Object source, int propId) {
            int i = 0;
            while (i < PresentableViewPart.this.listeners.size()) {
                ((IPropertyListener)PresentableViewPart.this.listeners.get(i)).propertyChanged(PresentableViewPart.this, propId);
                ++i;
            }
        }
    };

    public PresentableViewPart(ViewPane pane) {
        this.pane = pane;
    }

    public void firePropertyChange(int propertyId) {
        int i = 0;
        while (i < this.listeners.size()) {
            ((IPropertyListener)this.listeners.get(i)).propertyChanged(this, propertyId);
            ++i;
        }
    }

    public void addPropertyListener(IPropertyListener listener) {
        if (this.listeners.isEmpty()) {
            this.getViewReference().addPropertyListener(this.propertyListenerProxy);
        }
        this.listeners.add(listener);
    }

    public String getName() {
        WorkbenchPartReference ref = (WorkbenchPartReference)this.pane.getPartReference();
        return ref.getRegisteredName();
    }

    public String getTitle() {
        return this.getViewReference().getTitle();
    }

    public Image getTitleImage() {
        return this.getViewReference().getTitleImage();
    }

    public String getTitleToolTip() {
        return this.getViewReference().getTitleToolTip();
    }

    private IViewReference getViewReference() {
        return this.pane.getViewReference();
    }

    public boolean isDirty() {
        return false;
    }

    public void removePropertyListener(IPropertyListener listener) {
        this.listeners.remove(listener);
        if (this.listeners.isEmpty()) {
            this.getViewReference().removePropertyListener(this.propertyListenerProxy);
        }
    }

    public void setBounds(Rectangle bounds) {
        this.pane.setBounds(bounds);
    }

    public void setFocus() {
        this.pane.setFocus();
    }

    public void setVisible(boolean isVisible) {
        this.pane.setVisible(isVisible);
    }

    public boolean isBusy() {
        return this.pane.isBusy();
    }

    public Control getToolBar() {
        if (!this.pane.toolbarIsVisible()) {
            return null;
        }
        ToolBarManager toolbarManager = this.pane.getToolBarManager();
        if (toolbarManager == null) {
            return null;
        }
        ToolBar control = toolbarManager.getControl();
        if (control == null || control.isDisposed()) {
            return null;
        }
        return control;
    }

    public IPartMenu getMenu() {
        if (this.pane.hasViewMenu()) {
            return this.viewMenu;
        }
        return null;
    }

    public Control getControl() {
        return this.pane.getControl();
    }
}

