/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.ui.commands.ActionHandler;
import org.eclipse.ui.commands.CommandEvent;
import org.eclipse.ui.commands.ExecutionException;
import org.eclipse.ui.commands.ICommand;
import org.eclipse.ui.commands.ICommandListener;
import org.eclipse.ui.commands.IContextBinding;
import org.eclipse.ui.commands.IHandler;
import org.eclipse.ui.commands.IImageBinding;
import org.eclipse.ui.commands.IKeySequenceBinding;
import org.eclipse.ui.commands.NoSuchAttributeException;
import org.eclipse.ui.commands.NotDefinedException;
import org.eclipse.ui.commands.NotHandledException;
import org.eclipse.ui.internal.misc.Policy;
import org.eclipse.ui.internal.util.Util;

final class Command
implements ICommand {
    private static final boolean DEBUG_HANDLERS = Policy.DEBUG_HANDLERS && Policy.DEBUG_HANDLERS_VERBOSE;
    private static final String DEBUG_HANDLERS_COMMAND_ID = Policy.DEBUG_HANDLERS_VERBOSE_COMMAND_ID;
    private static final int HASH_FACTOR = 89;
    private static final int HASH_INITIAL;
    private List contextBindings;
    private transient IContextBinding[] contextBindingsAsArray;
    private String categoryId;
    private List commandListeners;
    private Set commandsWithListeners;
    private boolean defined;
    private String description;
    private IHandler handler;
    private transient int hashCode;
    private transient boolean hashCodeComputed;
    private String id;
    private List imageBindings;
    private transient IImageBinding[] imageBindingsAsArray;
    private List keySequenceBindings;
    private transient IKeySequenceBinding[] keySequenceBindingsAsArray;
    private String name;
    private transient String string;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.internal.commands.Command");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        HASH_INITIAL = clazz.getName().hashCode();
    }

    Command(Set commandsWithListeners, String id) {
        if (commandsWithListeners == null || id == null) {
            throw new NullPointerException();
        }
        this.commandsWithListeners = commandsWithListeners;
        this.id = id;
    }

    public void addCommandListener(ICommandListener commandListener) {
        if (commandListener == null) {
            throw new NullPointerException();
        }
        if (this.commandListeners == null) {
            this.commandListeners = new ArrayList();
        }
        if (!this.commandListeners.contains(commandListener)) {
            this.commandListeners.add(commandListener);
        }
        this.commandsWithListeners.add(this);
    }

    public int compareTo(Object object) {
        Command castedObject = (Command)object;
        int compareTo = Util.compare(this.contextBindingsAsArray, castedObject.contextBindingsAsArray);
        if (compareTo == 0 && (compareTo = Util.compare((Comparable)((Object)this.categoryId), (Comparable)((Object)castedObject.categoryId))) == 0 && (compareTo = Util.compare(this.defined, castedObject.defined)) == 0 && (compareTo = Util.compare((Comparable)((Object)this.description), (Comparable)((Object)castedObject.description))) == 0 && (compareTo = Util.compare(this.handler, castedObject.handler)) == 0 && (compareTo = Util.compare((Comparable)((Object)this.id), (Comparable)((Object)castedObject.id))) == 0 && (compareTo = Util.compare(this.imageBindingsAsArray, castedObject.imageBindingsAsArray)) == 0 && (compareTo = Util.compare(this.keySequenceBindingsAsArray, castedObject.keySequenceBindingsAsArray)) == 0) {
            compareTo = Util.compare((Comparable)((Object)this.name), (Comparable)((Object)castedObject.name));
        }
        return compareTo;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Command)) {
            return false;
        }
        Command castedObject = (Command)object;
        boolean equals = true;
        equals &= Util.equals(this.contextBindings, castedObject.contextBindings);
        equals &= Util.equals(this.categoryId, castedObject.categoryId);
        equals &= Util.equals(this.defined, castedObject.defined);
        equals &= Util.equals(this.description, castedObject.description);
        equals &= Util.equals(this.handler, castedObject.handler);
        equals &= Util.equals(this.id, castedObject.id);
        equals &= Util.equals(this.imageBindings, castedObject.imageBindings);
        equals &= Util.equals(this.keySequenceBindings, castedObject.keySequenceBindings);
        return equals &= Util.equals(this.name, castedObject.name);
    }

    public void execute(Object parameter) throws ExecutionException, NotHandledException {
        IHandler handler = this.handler;
        if (handler == null) {
            throw new NotHandledException();
        }
        handler.execute(parameter);
    }

    void fireCommandChanged(CommandEvent commandEvent) {
        if (commandEvent == null) {
            throw new NullPointerException();
        }
        if (this.commandListeners != null) {
            int i = 0;
            while (i < this.commandListeners.size()) {
                ((ICommandListener)this.commandListeners.get(i)).commandChanged(commandEvent);
                ++i;
            }
        }
    }

    public Object getAttributeValue(String attributeName) throws NoSuchAttributeException, NotHandledException {
        IHandler handler = this.handler;
        if (handler != null) {
            return handler.getAttributeValue(attributeName);
        }
        throw new NotHandledException();
    }

    public String getCategoryId() throws NotDefinedException {
        if (!this.defined) {
            throw new NotDefinedException();
        }
        return this.categoryId;
    }

    public List getContextBindings() {
        return this.contextBindings;
    }

    public Set getDefinedAttributeNames() throws NotHandledException {
        IHandler handler = this.handler;
        if (handler != null) {
            return handler.getDefinedAttributeNames();
        }
        throw new NotHandledException();
    }

    public String getDescription() throws NotDefinedException {
        if (!this.defined) {
            throw new NotDefinedException();
        }
        return this.description;
    }

    public String getId() {
        return this.id;
    }

    public List getImageBindings() {
        return this.imageBindings;
    }

    public List getKeySequenceBindings() {
        return this.keySequenceBindings;
    }

    public String getName() throws NotDefinedException {
        if (!this.defined) {
            throw new NotDefinedException();
        }
        return this.name;
    }

    public int hashCode() {
        if (!this.hashCodeComputed) {
            this.hashCode = HASH_INITIAL;
            this.hashCode = this.hashCode * 89 + Util.hashCode(this.contextBindings);
            this.hashCode = this.hashCode * 89 + Util.hashCode(this.categoryId);
            this.hashCode = this.hashCode * 89 + Util.hashCode(this.defined);
            this.hashCode = this.hashCode * 89 + Util.hashCode(this.description);
            this.hashCode = this.hashCode * 89 + Util.hashCode(this.handler);
            this.hashCode = this.hashCode * 89 + Util.hashCode(this.id);
            this.hashCode = this.hashCode * 89 + Util.hashCode(this.imageBindings);
            this.hashCode = this.hashCode * 89 + Util.hashCode(this.keySequenceBindings);
            this.hashCode = this.hashCode * 89 + Util.hashCode(this.name);
            this.hashCodeComputed = true;
        }
        return this.hashCode;
    }

    public boolean isDefined() {
        return this.defined;
    }

    public boolean isHandled() {
        return this.handler != null;
    }

    public void removeCommandListener(ICommandListener commandListener) {
        if (commandListener == null) {
            throw new NullPointerException();
        }
        if (this.commandListeners != null) {
            this.commandListeners.remove(commandListener);
        }
        if (this.commandListeners.isEmpty()) {
            this.commandsWithListeners.remove(this);
        }
    }

    boolean setContextBindings(List contextBindings) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ui.commands.IContextBinding");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!Util.equals(contextBindings = Util.safeCopy(contextBindings, (Class)clazz), this.contextBindings)) {
            this.contextBindings = contextBindings;
            this.contextBindingsAsArray = this.contextBindings.toArray(new IContextBinding[this.contextBindings.size()]);
            this.hashCodeComputed = false;
            this.hashCode = 0;
            this.string = null;
            return true;
        }
        return false;
    }

    boolean setCategoryId(String categoryId) {
        if (!Util.equals(categoryId, this.categoryId)) {
            this.categoryId = categoryId;
            this.hashCodeComputed = false;
            this.hashCode = 0;
            this.string = null;
            return true;
        }
        return false;
    }

    boolean setDefined(boolean defined) {
        if (defined != this.defined) {
            this.defined = defined;
            this.hashCodeComputed = false;
            this.hashCode = 0;
            this.string = null;
            return true;
        }
        return false;
    }

    boolean setDescription(String description) {
        if (!Util.equals(description, this.description)) {
            this.description = description;
            this.hashCodeComputed = false;
            this.hashCode = 0;
            this.string = null;
            return true;
        }
        return false;
    }

    boolean setHandler(IHandler handler) {
        if (handler != this.handler) {
            this.handler = handler;
            this.hashCodeComputed = false;
            this.hashCode = 0;
            this.string = null;
            if (DEBUG_HANDLERS && (DEBUG_HANDLERS_COMMAND_ID == null || DEBUG_HANDLERS_COMMAND_ID.equals(this.id))) {
                System.out.print("HANDLERS >> Command('" + this.id + "' has changed to ");
                if (handler == null) {
                    System.out.println("no handler");
                } else {
                    System.out.print("'");
                    if (handler instanceof ActionHandler) {
                        ActionHandler actionHandler = (ActionHandler)handler;
                        System.out.print(actionHandler.getAction().getClass().getName());
                    } else {
                        System.out.print(handler.getClass().getName());
                    }
                    System.out.println("' as its handler");
                }
            }
            return true;
        }
        return false;
    }

    boolean setImageBindings(List imageBindings) {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.ui.commands.IImageBinding");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!Util.equals(imageBindings = Util.safeCopy(imageBindings, (Class)clazz), this.imageBindings)) {
            this.imageBindings = imageBindings;
            this.imageBindingsAsArray = this.imageBindings.toArray(new IImageBinding[this.imageBindings.size()]);
            this.hashCodeComputed = false;
            this.hashCode = 0;
            this.string = null;
            return true;
        }
        return false;
    }

    boolean setKeySequenceBindings(List keySequenceBindings) {
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.ui.commands.IKeySequenceBinding");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!Util.equals(keySequenceBindings = Util.safeCopy(keySequenceBindings, (Class)clazz), this.keySequenceBindings)) {
            this.keySequenceBindings = keySequenceBindings;
            this.keySequenceBindingsAsArray = this.keySequenceBindings.toArray(new IKeySequenceBinding[this.keySequenceBindings.size()]);
            this.hashCodeComputed = false;
            this.hashCode = 0;
            this.string = null;
            return true;
        }
        return false;
    }

    boolean setName(String name) {
        if (!Util.equals(name, this.name)) {
            this.name = name;
            this.hashCodeComputed = false;
            this.hashCode = 0;
            this.string = null;
            return true;
        }
        return false;
    }

    public String toString() {
        if (this.string == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('[');
            stringBuffer.append(this.contextBindings);
            stringBuffer.append(',');
            stringBuffer.append(this.categoryId);
            stringBuffer.append(',');
            stringBuffer.append(this.defined);
            stringBuffer.append(',');
            stringBuffer.append(this.description);
            stringBuffer.append(',');
            stringBuffer.append(this.handler);
            stringBuffer.append(',');
            stringBuffer.append(this.id);
            stringBuffer.append(',');
            stringBuffer.append(this.imageBindings);
            stringBuffer.append(',');
            stringBuffer.append(this.keySequenceBindings);
            stringBuffer.append(',');
            stringBuffer.append(this.name);
            stringBuffer.append(']');
            this.string = stringBuffer.toString();
        }
        return this.string;
    }
}

