/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.commands;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.ui.internal.commands.KeySequenceBinding;
import org.eclipse.ui.internal.commands.KeySequenceBindingDefinition;
import org.eclipse.ui.internal.commands.Match;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.keys.KeySequence;
import org.eclipse.ui.keys.KeyStroke;

final class KeySequenceBindingNode {
    private Map contextMap = new HashMap();
    private Map assignmentsByContextId = new HashMap();
    private Map childKeyStrokeNodeByKeyStrokeMap = new HashMap();
    private Match match = null;

    static void add(Map keyStrokeNodeByKeyStrokeMap, KeySequence keySequence, String contextId, String keyConfigurationId, int rank, String platform, String locale, String commandId) {
        List keyStrokes = keySequence.getKeyStrokes();
        Map root = keyStrokeNodeByKeyStrokeMap;
        KeySequenceBindingNode keySequenceBindingNode = null;
        int i = 0;
        while (i < keyStrokes.size()) {
            KeyStroke keyStroke = (KeyStroke)keyStrokes.get(i);
            keySequenceBindingNode = (KeySequenceBindingNode)root.get(keyStroke);
            if (keySequenceBindingNode == null) {
                keySequenceBindingNode = new KeySequenceBindingNode();
                root.put(keyStroke, keySequenceBindingNode);
            }
            root = keySequenceBindingNode.childKeyStrokeNodeByKeyStrokeMap;
            ++i;
        }
        if (keySequenceBindingNode != null) {
            super.add(contextId, keyConfigurationId, rank, platform, locale, commandId);
        }
    }

    static Map find(Map keyStrokeNodeByKeyStrokeMap, KeySequence keySequence) {
        Iterator iterator = keySequence.getKeyStrokes().iterator();
        KeySequenceBindingNode keySequenceBindingNode = null;
        while (iterator.hasNext()) {
            keySequenceBindingNode = (KeySequenceBindingNode)keyStrokeNodeByKeyStrokeMap.get(iterator.next());
            if (keySequenceBindingNode == null) {
                return null;
            }
            keyStrokeNodeByKeyStrokeMap = keySequenceBindingNode.childKeyStrokeNodeByKeyStrokeMap;
        }
        return keyStrokeNodeByKeyStrokeMap;
    }

    static Map getAssignmentsByContextIdKeySequence(Map keyStrokeNodeByKeyStrokeMap, KeySequence prefix) {
        HashMap<KeySequence, Map> assignmentsByContextIdByKeySequence = new HashMap<KeySequence, Map>();
        Iterator iterator = keyStrokeNodeByKeyStrokeMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            KeyStroke keyStroke = (KeyStroke)entry.getKey();
            KeySequenceBindingNode keySequenceBindingNode = (KeySequenceBindingNode)entry.getValue();
            ArrayList<KeyStroke> keyStrokes = new ArrayList<KeyStroke>(prefix.getKeyStrokes());
            keyStrokes.add(keyStroke);
            KeySequence keySequence = KeySequence.getInstance(keyStrokes);
            Map childAssignmentsByContextIdByKeySequence = KeySequenceBindingNode.getAssignmentsByContextIdKeySequence(keySequenceBindingNode.childKeyStrokeNodeByKeyStrokeMap, keySequence);
            if (childAssignmentsByContextIdByKeySequence.size() >= 1) {
                assignmentsByContextIdByKeySequence.putAll(childAssignmentsByContextIdByKeySequence);
            }
            assignmentsByContextIdByKeySequence.put(keySequence, keySequenceBindingNode.assignmentsByContextId);
        }
        return assignmentsByContextIdByKeySequence;
    }

    static void getKeySequenceBindingDefinitions(Map keyStrokeNodeByKeyStrokeMap, KeySequence prefix, int rank, List keySequenceBindingDefinitions) {
        Iterator iterator = keyStrokeNodeByKeyStrokeMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            KeyStroke keyStroke = (KeyStroke)entry.getKey();
            KeySequenceBindingNode keySequenceBindingNode = (KeySequenceBindingNode)entry.getValue();
            ArrayList<KeyStroke> keyStrokes = new ArrayList<KeyStroke>(prefix.getKeyStrokes());
            keyStrokes.add(keyStroke);
            KeySequence keySequence = KeySequence.getInstance(keyStrokes);
            Map contextMap = keySequenceBindingNode.contextMap;
            Iterator iterator2 = contextMap.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry entry2 = iterator2.next();
                String contextId = (String)entry2.getKey();
                Map keyConfigurationMap = (Map)entry2.getValue();
                Iterator iterator3 = keyConfigurationMap.entrySet().iterator();
                while (iterator3.hasNext()) {
                    Map.Entry entry3 = iterator3.next();
                    String keyConfigurationId = (String)entry3.getKey();
                    Map rankMap = (Map)entry3.getValue();
                    Map platformMap = (Map)rankMap.get(new Integer(rank));
                    if (platformMap == null) continue;
                    Iterator iterator4 = platformMap.entrySet().iterator();
                    while (iterator4.hasNext()) {
                        Map.Entry entry4 = iterator4.next();
                        String platform = (String)entry4.getKey();
                        Map localeMap = (Map)entry4.getValue();
                        Iterator iterator5 = localeMap.entrySet().iterator();
                        while (iterator5.hasNext()) {
                            Map.Entry entry5 = iterator5.next();
                            String locale = (String)entry5.getKey();
                            Set commandIds = (Set)entry5.getValue();
                            Iterator iterator6 = commandIds.iterator();
                            while (iterator6.hasNext()) {
                                String commandId = (String)iterator6.next();
                                keySequenceBindingDefinitions.add(new KeySequenceBindingDefinition(contextId, commandId, keyConfigurationId, keySequence, locale, platform, null));
                            }
                        }
                    }
                }
            }
            KeySequenceBindingNode.getKeySequenceBindingDefinitions(keySequenceBindingNode.childKeyStrokeNodeByKeyStrokeMap, keySequence, rank, keySequenceBindingDefinitions);
        }
    }

    static Map getKeySequenceBindingsByCommandId(Map keySequenceMap) {
        HashMap<String, TreeSet<KeySequenceBinding>> commandMap = new HashMap<String, TreeSet<KeySequenceBinding>>();
        Iterator iterator = keySequenceMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            KeySequence keySequence = (KeySequence)entry.getKey();
            Match match = (Match)entry.getValue();
            String commandId = match.getCommandId();
            int value = match.getValue();
            TreeSet<KeySequenceBinding> keySequenceBindings = (TreeSet<KeySequenceBinding>)commandMap.get(commandId);
            if (keySequenceBindings == null) {
                keySequenceBindings = new TreeSet<KeySequenceBinding>();
                commandMap.put(commandId, keySequenceBindings);
            }
            keySequenceBindings.add(new KeySequenceBinding(keySequence, value));
        }
        return commandMap;
    }

    static Map getMatchesByKeySequence(Map keyStrokeNodeByKeyStrokeMap, KeySequence prefix) {
        HashMap<KeySequence, Match> keySequenceMap = new HashMap<KeySequence, Match>();
        Iterator iterator = keyStrokeNodeByKeyStrokeMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            KeyStroke keyStroke = (KeyStroke)entry.getKey();
            KeySequenceBindingNode keySequenceBindingNode = (KeySequenceBindingNode)entry.getValue();
            ArrayList<KeyStroke> keyStrokes = new ArrayList<KeyStroke>(prefix.getKeyStrokes());
            keyStrokes.add(keyStroke);
            KeySequence keySequence = KeySequence.getInstance(keyStrokes);
            Map childMatchesByKeySequence = KeySequenceBindingNode.getMatchesByKeySequence(keySequenceBindingNode.childKeyStrokeNodeByKeyStrokeMap, keySequence);
            if (childMatchesByKeySequence.size() >= 1) {
                keySequenceMap.putAll(childMatchesByKeySequence);
                continue;
            }
            if (keySequenceBindingNode.match == null || keySequenceBindingNode.match.getCommandId() == null) continue;
            keySequenceMap.put(keySequence, keySequenceBindingNode.match);
        }
        return keySequenceMap;
    }

    static void remove(Map keyStrokeNodeByKeyStrokeMap, KeySequence keySequence, String contextId, String keyConfigurationId, int rank, String platform, String locale) {
        Iterator iterator = keySequence.getKeyStrokes().iterator();
        KeySequenceBindingNode keySequenceBindingNode = null;
        while (iterator.hasNext()) {
            keySequenceBindingNode = (KeySequenceBindingNode)keyStrokeNodeByKeyStrokeMap.get(iterator.next());
            if (keySequenceBindingNode == null) {
                return;
            }
            keyStrokeNodeByKeyStrokeMap = keySequenceBindingNode.childKeyStrokeNodeByKeyStrokeMap;
        }
        keySequenceBindingNode.remove(contextId, keyConfigurationId, rank, platform, locale);
    }

    static void remove(Map keyStrokeNodeByKeyStrokeMap, KeySequence keySequence, String contextId, String keyConfigurationId, int rank, String platform, String locale, String commandId) {
        Iterator iterator = keySequence.getKeyStrokes().iterator();
        KeySequenceBindingNode keySequenceBindingNode = null;
        while (iterator.hasNext()) {
            keySequenceBindingNode = (KeySequenceBindingNode)keyStrokeNodeByKeyStrokeMap.get(iterator.next());
            if (keySequenceBindingNode == null) {
                return;
            }
            keyStrokeNodeByKeyStrokeMap = keySequenceBindingNode.childKeyStrokeNodeByKeyStrokeMap;
        }
        keySequenceBindingNode.remove(contextId, keyConfigurationId, rank, platform, locale, commandId);
    }

    static void solve(Map keyStrokeNodeByKeyStrokeMap, String[] keyConfigurationIds, String[] platforms, String[] locales) {
        Iterator iterator = keyStrokeNodeByKeyStrokeMap.values().iterator();
        while (iterator.hasNext()) {
            KeySequenceBindingNode keySequenceBindingNode = (KeySequenceBindingNode)iterator.next();
            keySequenceBindingNode.solveAssignmentsByContextId(keyConfigurationIds, platforms, locales);
            KeySequenceBindingNode.solve(keySequenceBindingNode.childKeyStrokeNodeByKeyStrokeMap, keyConfigurationIds, platforms, locales);
        }
    }

    static void solve(Map keyStrokeNodeByKeyStrokeMap, String[] contextIds, String[] keyConfigurationIds, String[] platforms, String[] locales) {
        Iterator iterator = keyStrokeNodeByKeyStrokeMap.values().iterator();
        while (iterator.hasNext()) {
            KeySequenceBindingNode keySequenceBindingNode = (KeySequenceBindingNode)iterator.next();
            keySequenceBindingNode.solveMatch(contextIds, keyConfigurationIds, platforms, locales);
            KeySequenceBindingNode.solve(keySequenceBindingNode.childKeyStrokeNodeByKeyStrokeMap, contextIds, keyConfigurationIds, platforms, locales);
        }
    }

    private KeySequenceBindingNode() {
    }

    private void add(String contextId, String keyConfigurationId, int rank, String platform, String locale, String commandId) {
        HashSet<String> commandIds;
        HashMap<String, HashSet<String>> localeMap;
        HashMap platformMap;
        HashMap rankMap;
        HashMap keyConfigurationMap = (HashMap)this.contextMap.get(contextId);
        if (keyConfigurationMap == null) {
            keyConfigurationMap = new HashMap();
            this.contextMap.put(contextId, keyConfigurationMap);
        }
        if ((rankMap = (HashMap)keyConfigurationMap.get(keyConfigurationId)) == null) {
            rankMap = new HashMap();
            keyConfigurationMap.put(keyConfigurationId, rankMap);
        }
        if ((platformMap = (HashMap)rankMap.get(new Integer(rank))) == null) {
            platformMap = new HashMap();
            rankMap.put(new Integer(rank), platformMap);
        }
        if ((localeMap = (HashMap<String, HashSet<String>>)platformMap.get(platform)) == null) {
            localeMap = new HashMap<String, HashSet<String>>();
            platformMap.put(platform, localeMap);
        }
        if ((commandIds = (HashSet<String>)localeMap.get(locale)) == null) {
            commandIds = new HashSet<String>();
            localeMap.put(locale, commandIds);
        }
        commandIds.add(commandId);
    }

    private void remove(String contextId, String keyConfigurationId, int rank, String platform, String locale) {
        Map localeMap;
        Map platformMap;
        Map rankMap;
        Map keyConfigurationMap = (Map)this.contextMap.get(contextId);
        if (keyConfigurationMap != null && (rankMap = (Map)keyConfigurationMap.get(keyConfigurationId)) != null && (platformMap = (Map)rankMap.get(new Integer(rank))) != null && (localeMap = (Map)platformMap.get(platform)) != null) {
            localeMap.remove(locale);
            if (localeMap.isEmpty()) {
                platformMap.remove(platform);
                if (platformMap.isEmpty()) {
                    rankMap.remove(new Integer(rank));
                    if (rankMap.isEmpty()) {
                        keyConfigurationMap.remove(keyConfigurationId);
                        if (keyConfigurationMap.isEmpty()) {
                            this.contextMap.remove(contextId);
                        }
                    }
                }
            }
        }
    }

    private void remove(String contextId, String keyConfigurationId, int rank, String platform, String locale, String commandId) {
        Set commandIds;
        Map localeMap;
        Map platformMap;
        Map rankMap;
        Map keyConfigurationMap = (Map)this.contextMap.get(contextId);
        if (keyConfigurationMap != null && (rankMap = (Map)keyConfigurationMap.get(keyConfigurationId)) != null && (platformMap = (Map)rankMap.get(new Integer(rank))) != null && (localeMap = (Map)platformMap.get(platform)) != null && (commandIds = (Set)localeMap.get(locale)) != null) {
            commandIds.remove(commandId);
            if (commandIds.isEmpty()) {
                localeMap.remove(locale);
                if (localeMap.isEmpty()) {
                    platformMap.remove(platform);
                    if (platformMap.isEmpty()) {
                        rankMap.remove(new Integer(rank));
                        if (rankMap.isEmpty()) {
                            keyConfigurationMap.remove(keyConfigurationId);
                            if (keyConfigurationMap.isEmpty()) {
                                this.contextMap.remove(contextId);
                            }
                        }
                    }
                }
            }
        }
    }

    private void solveAssignmentsByContextId(String[] keyConfigurationIds, String[] platforms, String[] locales) {
        this.assignmentsByContextId.clear();
        Iterator iterator = this.contextMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String contextId = (String)entry.getKey();
            Map keyConfigurationMap = (Map)entry.getValue();
            Assignment assignment = null;
            if (keyConfigurationMap != null) {
                int keyConfiguration = 0;
                while (keyConfiguration < keyConfigurationIds.length && keyConfiguration < 255) {
                    Map rankMap = (Map)keyConfigurationMap.get(keyConfigurationIds[keyConfiguration]);
                    if (rankMap != null) {
                        int rank = 0;
                        while (rank <= 1) {
                            Map platformMap = (Map)rankMap.get(new Integer(rank));
                            if (platformMap != null) {
                                int platform = 0;
                                while (platform < platforms.length && platform < 255) {
                                    Map localeMap = (Map)platformMap.get(platforms[platform]);
                                    if (localeMap != null) {
                                        int locale = 0;
                                        while (locale < locales.length && locale < 255) {
                                            Set commandIds = (Set)localeMap.get(locales[locale]);
                                            if (commandIds != null) {
                                                String commandId;
                                                String string = commandId = commandIds.size() == 1 ? (String)commandIds.iterator().next() : null;
                                                if (assignment == null) {
                                                    assignment = new Assignment();
                                                }
                                                switch (rank) {
                                                    case 0: {
                                                        if (keyConfiguration == 0 && !assignment.hasPreferenceCommandIdInFirstKeyConfiguration) {
                                                            assignment.hasPreferenceCommandIdInFirstKeyConfiguration = true;
                                                            assignment.preferenceCommandIdInFirstKeyConfiguration = commandId;
                                                            break;
                                                        }
                                                        if (assignment.hasPreferenceCommandIdInInheritedKeyConfiguration) break;
                                                        assignment.hasPreferenceCommandIdInInheritedKeyConfiguration = true;
                                                        assignment.preferenceCommandIdInInheritedKeyConfiguration = commandId;
                                                        break;
                                                    }
                                                    case 1: {
                                                        if (keyConfiguration == 0 && !assignment.hasPluginCommandIdInFirstKeyConfiguration) {
                                                            assignment.hasPluginCommandIdInFirstKeyConfiguration = true;
                                                            assignment.pluginCommandIdInFirstKeyConfiguration = commandId;
                                                            break;
                                                        }
                                                        if (assignment.hasPluginCommandIdInInheritedKeyConfiguration) break;
                                                        assignment.hasPluginCommandIdInInheritedKeyConfiguration = true;
                                                        assignment.pluginCommandIdInInheritedKeyConfiguration = commandId;
                                                    }
                                                }
                                            }
                                            ++locale;
                                        }
                                    }
                                    ++platform;
                                }
                            }
                            ++rank;
                        }
                    }
                    ++keyConfiguration;
                }
            }
            if (assignment == null) continue;
            this.assignmentsByContextId.put(contextId, assignment);
        }
    }

    private void solveMatch(String[] contextIds, String[] keyConfigurationIds, String[] platforms, String[] locales) {
        this.match = null;
        int context = 0;
        while (context < contextIds.length && context < 255 && this.match == null) {
            Map keyConfigurationMap = (Map)this.contextMap.get(contextIds[context]);
            if (keyConfigurationMap != null) {
                int keyConfiguration = 0;
                while (keyConfiguration < keyConfigurationIds.length && keyConfiguration < 255 && this.match == null) {
                    Map rankMap = (Map)keyConfigurationMap.get(keyConfigurationIds[keyConfiguration]);
                    if (rankMap != null) {
                        int rank = 0;
                        while (rank <= 1) {
                            Map platformMap = (Map)rankMap.get(new Integer(rank));
                            if (platformMap != null) {
                                int platform = 0;
                                while (platform < platforms.length && platform < 255 && this.match == null) {
                                    Map localeMap = (Map)platformMap.get(platforms[platform]);
                                    if (localeMap != null) {
                                        int locale = 0;
                                        while (locale < locales.length && locale < 255 && this.match == null) {
                                            Set commandIds = (Set)localeMap.get(locales[locale]);
                                            if (commandIds != null) {
                                                this.match = new Match(commandIds.size() == 1 ? (String)commandIds.iterator().next() : null, (context << 24) + (keyConfiguration << 16) + (platform << 8) + locale);
                                            }
                                            ++locale;
                                        }
                                    }
                                    ++platform;
                                }
                            }
                            ++rank;
                        }
                    }
                    ++keyConfiguration;
                }
            }
            ++context;
        }
    }

    static final class Assignment
    implements Comparable {
        boolean hasPluginCommandIdInFirstKeyConfiguration;
        boolean hasPluginCommandIdInInheritedKeyConfiguration;
        boolean hasPreferenceCommandIdInFirstKeyConfiguration;
        boolean hasPreferenceCommandIdInInheritedKeyConfiguration;
        String pluginCommandIdInFirstKeyConfiguration;
        String pluginCommandIdInInheritedKeyConfiguration;
        String preferenceCommandIdInFirstKeyConfiguration;
        String preferenceCommandIdInInheritedKeyConfiguration;

        Assignment() {
        }

        public int compareTo(Object object) {
            int compareTo;
            Assignment castedObject = (Assignment)object;
            int n = !this.hasPreferenceCommandIdInFirstKeyConfiguration ? (castedObject.hasPreferenceCommandIdInFirstKeyConfiguration ? -1 : 0) : (compareTo = 1);
            if (compareTo == 0) {
                int n2 = !this.hasPreferenceCommandIdInInheritedKeyConfiguration ? (castedObject.hasPreferenceCommandIdInInheritedKeyConfiguration ? -1 : 0) : (compareTo = 1);
                if (compareTo == 0) {
                    int n3 = !this.hasPluginCommandIdInFirstKeyConfiguration ? (castedObject.hasPluginCommandIdInFirstKeyConfiguration ? -1 : 0) : (compareTo = 1);
                    if (compareTo == 0) {
                        int n4 = !this.hasPluginCommandIdInInheritedKeyConfiguration ? (castedObject.hasPluginCommandIdInInheritedKeyConfiguration ? -1 : 0) : (compareTo = 1);
                        if (compareTo == 0 && (compareTo = Util.compare((Comparable)((Object)this.preferenceCommandIdInFirstKeyConfiguration), (Comparable)((Object)castedObject.preferenceCommandIdInFirstKeyConfiguration))) == 0 && (compareTo = Util.compare((Comparable)((Object)this.preferenceCommandIdInInheritedKeyConfiguration), (Comparable)((Object)castedObject.preferenceCommandIdInInheritedKeyConfiguration))) == 0 && (compareTo = Util.compare((Comparable)((Object)this.pluginCommandIdInFirstKeyConfiguration), (Comparable)((Object)castedObject.pluginCommandIdInFirstKeyConfiguration))) == 0) {
                            compareTo = Util.compare((Comparable)((Object)this.pluginCommandIdInInheritedKeyConfiguration), (Comparable)((Object)castedObject.pluginCommandIdInInheritedKeyConfiguration));
                        }
                    }
                }
            }
            return compareTo;
        }

        boolean contains(String commandId) {
            return Util.equals(commandId, this.preferenceCommandIdInFirstKeyConfiguration) || Util.equals(commandId, this.preferenceCommandIdInInheritedKeyConfiguration) || Util.equals(commandId, this.pluginCommandIdInFirstKeyConfiguration) || Util.equals(commandId, this.pluginCommandIdInInheritedKeyConfiguration);
        }

        public boolean equals(Object object) {
            if (!(object instanceof Assignment)) {
                return false;
            }
            Assignment castedObject = (Assignment)object;
            boolean equals = true;
            equals &= this.hasPreferenceCommandIdInFirstKeyConfiguration == castedObject.hasPreferenceCommandIdInFirstKeyConfiguration;
            equals &= this.hasPreferenceCommandIdInInheritedKeyConfiguration == castedObject.hasPreferenceCommandIdInInheritedKeyConfiguration;
            equals &= this.hasPluginCommandIdInFirstKeyConfiguration == castedObject.hasPluginCommandIdInFirstKeyConfiguration;
            equals &= this.hasPluginCommandIdInInheritedKeyConfiguration == castedObject.hasPluginCommandIdInInheritedKeyConfiguration;
            equals &= this.preferenceCommandIdInFirstKeyConfiguration == castedObject.preferenceCommandIdInFirstKeyConfiguration;
            equals &= this.preferenceCommandIdInInheritedKeyConfiguration == castedObject.preferenceCommandIdInInheritedKeyConfiguration;
            equals &= this.pluginCommandIdInFirstKeyConfiguration == castedObject.pluginCommandIdInFirstKeyConfiguration;
            return equals &= this.pluginCommandIdInInheritedKeyConfiguration == castedObject.pluginCommandIdInInheritedKeyConfiguration;
        }
    }
}

