/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.misc;

import java.util.HashMap;
import org.eclipse.ui.internal.misc.Policy;

public class UIStats {
    private static int SIZE = 20;
    private static boolean[] debug = new boolean[SIZE];
    private static String[] startStrings = new String[SIZE];
    private static String[] endStrings = new String[SIZE];
    private static HashMap operations = new HashMap();
    public static int CREATE_PART = 0;
    public static int CREATE_PART_CONTROL = 1;
    public static int INIT_PART = 2;
    public static int CREATE_PERSPECTIVE = 3;
    public static int RESTORE_WORKBENCH = 4;
    public static int START_WORKBENCH = 5;
    public static int CREATE_PART_INPUT = 6;
    public static int ACTIVATE_PART = 7;
    public static int BRING_PART_TO_TOP = 8;
    public static int NOTIFY_PART_LISTENERS = 9;
    public static int SWITCH_PERSPECTIVE = 10;

    static {
        UIStats.debug[UIStats.CREATE_PART] = Policy.DEBUG_PART_CREATE;
        UIStats.debug[UIStats.CREATE_PART_INPUT] = Policy.DEBUG_PART_CREATE;
        UIStats.debug[UIStats.CREATE_PART_CONTROL] = Policy.DEBUG_PART_CREATE;
        UIStats.debug[UIStats.INIT_PART] = Policy.DEBUG_PART_CREATE;
        UIStats.debug[UIStats.CREATE_PERSPECTIVE] = Policy.DEBUG_PERSPECTIVE;
        UIStats.debug[UIStats.SWITCH_PERSPECTIVE] = Policy.DEBUG_PERSPECTIVE;
        UIStats.debug[UIStats.RESTORE_WORKBENCH] = Policy.DEBUG_RESTORE_WORKBENCH;
        UIStats.debug[UIStats.START_WORKBENCH] = Policy.DEBUG_START_WORKBENCH;
        UIStats.debug[UIStats.ACTIVATE_PART] = Policy.DEBUG_PART_ACTIVATE;
        UIStats.debug[UIStats.BRING_PART_TO_TOP] = Policy.DEBUG_PART_ACTIVATE;
        UIStats.debug[UIStats.NOTIFY_PART_LISTENERS] = Policy.DEBUG_PART_LISTENERS;
        UIStats.startStrings[UIStats.CREATE_PART] = "Creating part: ";
        UIStats.endStrings[UIStats.CREATE_PART] = " ms to create: ";
        UIStats.startStrings[UIStats.CREATE_PART_INPUT] = "Creating part input: ";
        UIStats.endStrings[UIStats.CREATE_PART_INPUT] = " ms to create input: ";
        UIStats.startStrings[UIStats.CREATE_PART_CONTROL] = "Creating control: ";
        UIStats.endStrings[UIStats.CREATE_PART_CONTROL] = " ms to create control: ";
        UIStats.startStrings[UIStats.INIT_PART] = "Initializing part: ";
        UIStats.endStrings[UIStats.INIT_PART] = " ms to init part: ";
        UIStats.startStrings[UIStats.CREATE_PERSPECTIVE] = "Creating perspective: ";
        UIStats.endStrings[UIStats.CREATE_PERSPECTIVE] = " ms to create perspective: ";
        UIStats.startStrings[UIStats.RESTORE_WORKBENCH] = "Restoring: ";
        UIStats.endStrings[UIStats.RESTORE_WORKBENCH] = " ms to restore: ";
        UIStats.startStrings[UIStats.START_WORKBENCH] = "Starting: ";
        UIStats.endStrings[UIStats.START_WORKBENCH] = " ms to start: ";
        UIStats.startStrings[UIStats.ACTIVATE_PART] = "Activation part: ";
        UIStats.endStrings[UIStats.ACTIVATE_PART] = " ms to activate: ";
        UIStats.startStrings[UIStats.BRING_PART_TO_TOP] = "Bringing part to top: ";
        UIStats.endStrings[UIStats.BRING_PART_TO_TOP] = " ms to bring part to top: ";
        UIStats.startStrings[UIStats.NOTIFY_PART_LISTENERS] = "Notifying part listeners: ";
        UIStats.endStrings[UIStats.NOTIFY_PART_LISTENERS] = " ms to notify listeners: ";
        UIStats.startStrings[UIStats.SWITCH_PERSPECTIVE] = "Swtich perspective: ";
        UIStats.endStrings[UIStats.SWITCH_PERSPECTIVE] = " ms to switch perspective: ";
    }

    public static void start(int operation, String label) {
        if (debug[operation]) {
            System.out.println(String.valueOf(startStrings[operation]) + label);
            operations.put(String.valueOf(operation) + label, new Long(System.currentTimeMillis()));
        }
    }

    public static void end(int operation, String label) {
        if (debug[operation]) {
            Long startTime = (Long)operations.remove(String.valueOf(operation) + label);
            System.out.println("Time - " + (System.currentTimeMillis() - startTime) + endStrings[operation] + label);
        }
    }
}

