/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.progress;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IconAndMessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.internal.progress.JobTreeElement;
import org.eclipse.ui.internal.progress.ProgressLabelProvider;
import org.eclipse.ui.internal.progress.ProgressMessages;
import org.eclipse.ui.internal.progress.ProgressTreeContentProvider;
import org.eclipse.ui.internal.progress.ProgressTreeViewer;

public class BlockedJobsDialog
extends IconAndMessageDialog {
    private ProgressTreeViewer viewer;
    private Button cancelSelected;
    private Cursor arrowCursor;
    private Cursor waitCursor;
    private IProgressMonitor blockingMonitor;
    private JobTreeElement blockedElement = new BlockedUIElement();

    public BlockedJobsDialog(Shell parentShell, IProgressMonitor blocking, IStatus blockingStatus) {
        super(parentShell);
        this.blockingMonitor = blocking;
        this.setShellStyle(67616);
        this.setBlockOnOpen(false);
        this.setMessage(ProgressMessages.format("BlockedJobsDialog.BlockedMessage", new Object[]{blockingStatus.getMessage()}));
    }

    protected Control createDialogArea(Composite parent) {
        this.setMessage(this.message);
        this.createMessageArea(parent);
        this.showJobDetails(parent);
        return parent;
    }

    protected int getMessageLabelStyle() {
        return super.getMessageLabelStyle() | 0x1000000;
    }

    void showJobDetails(Composite parent) {
        int heightHint;
        this.viewer = new ProgressTreeViewer(parent, 2818){

            protected void updateColors(TreeItem treeItem, JobTreeElement element) {
                super.updateColors(treeItem, element);
                if (element == BlockedJobsDialog.this.blockedElement) {
                    this.setNotRunningColor(treeItem);
                }
            }
        };
        this.viewer.setUseHashlookup(true);
        this.viewer.setSorter(new ViewerSorter(){

            public int compare(Viewer testViewer, Object e1, Object e2) {
                return ((Comparable)e1).compareTo(e2);
            }
        });
        ProgressTreeContentProvider provider = this.getContentProvider();
        this.viewer.setContentProvider((IContentProvider)provider);
        this.viewer.setInput(provider);
        this.viewer.setLabelProvider((IBaseLabelProvider)new ProgressLabelProvider());
        GridData data = new GridData();
        data.horizontalSpan = 2;
        data.heightHint = heightHint = this.convertHeightInCharsToPixels(10);
        data.horizontalAlignment = 4;
        this.viewer.getControl().setLayoutData((Object)data);
    }

    private ProgressTreeContentProvider getContentProvider() {
        return new ProgressTreeContentProvider(this.viewer){

            public Object[] getElements(Object inputElement) {
                Object[] elements = super.getElements(inputElement);
                Object[] result = new Object[elements.length + 1];
                System.arraycopy(elements, 0, result, 1, elements.length);
                result[0] = BlockedJobsDialog.this.blockedElement;
                return result;
            }
        };
    }

    protected Control createButtonBar(Composite parent) {
        this.cancelSelected = this.createButton(parent, ProgressMessages.getString("CancelJobsButton.title"), new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                BlockedJobsDialog.this.viewer.cancelSelection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return parent;
    }

    private Button createButton(Composite parent, String text, SelectionListener listener) {
        Button button = new Button(parent, 8);
        button.setText(text);
        button.addSelectionListener(listener);
        if (this.arrowCursor == null) {
            this.arrowCursor = new Cursor((Device)button.getDisplay(), 0);
        }
        button.setCursor(this.arrowCursor);
        return button;
    }

    private void clearCursors() {
        this.clearCursor((Control)this.cancelSelected);
        this.clearCursor((Control)this.getShell());
        if (this.arrowCursor != null) {
            this.arrowCursor.dispose();
        }
        if (this.waitCursor != null) {
            this.waitCursor.dispose();
        }
        this.arrowCursor = null;
        this.waitCursor = null;
    }

    private void clearCursor(Control control) {
        if (control != null && !control.isDisposed()) {
            control.setCursor(null);
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(ProgressMessages.getString("BlockedJobsDialog.BlockedTitle"));
        if (this.waitCursor == null) {
            this.waitCursor = new Cursor((Device)shell.getDisplay(), 1);
        }
        shell.setCursor(this.waitCursor);
    }

    private void setMessage(String messageString) {
        String string = this.message = messageString == null ? "" : messageString;
        if (this.messageLabel == null || this.messageLabel.isDisposed()) {
            return;
        }
        this.messageLabel.setText(this.message);
    }

    protected Image getImage() {
        return JFaceResources.getImageRegistry().get("dialog_error_locked");
    }

    public boolean close() {
        this.clearCursors();
        return super.close();
    }

    private class BlockedUIElement
    extends JobTreeElement {
        BlockedUIElement() {
        }

        Object[] getChildren() {
            return null;
        }

        String getDisplayString() {
            return ProgressMessages.getString("BlockedJobsDialog.UserInterfaceTreeElement");
        }

        public Image getDisplayImage() {
            return JFaceResources.getImage((String)"WAITING_JOB");
        }

        Object getParent() {
            return null;
        }

        boolean hasChildren() {
            return false;
        }

        boolean isActive() {
            return true;
        }

        boolean isJobInfo() {
            return false;
        }

        public void cancel() {
            BlockedJobsDialog.this.blockingMonitor.setCanceled(true);
        }

        public boolean isCancellable() {
            return true;
        }
    }
}

