/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.progress;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.progress.ProgressLabelProvider;
import org.eclipse.ui.internal.progress.ProgressTreeViewer;

class ProgressManagerUtil {
    private static String PROGRESS_VIEW_ID = "org.eclipse.ui.views.ProgressView";

    ProgressManagerUtil() {
    }

    static Status exceptionStatus(Throwable exception) {
        return new Status(4, "org.eclipse.ui", 4, exception.getMessage(), exception);
    }

    static void logException(Throwable exception) {
        Platform.getPlugin((String)"org.eclipse.ui").getLog().log((IStatus)ProgressManagerUtil.exceptionStatus(exception));
    }

    static void initLabelProvider(ProgressTreeViewer viewer) {
        viewer.setLabelProvider((IBaseLabelProvider)new ProgressLabelProvider());
    }

    static ViewerSorter getProgressViewerSorter() {
        return new ViewerSorter(){

            public int compare(Viewer testViewer, Object e1, Object e2) {
                return ((Comparable)e1).compareTo(e2);
            }
        };
    }

    static void openProgressView(WorkbenchWindow window) {
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return;
        }
        try {
            page.showView(PROGRESS_VIEW_ID);
        }
        catch (PartInitException exception) {
            ProgressManagerUtil.logException((Throwable)((Object)exception));
        }
    }

    static boolean missingProgressView(WorkbenchWindow window) {
        return WorkbenchPlugin.getDefault().getViewRegistry().find(PROGRESS_VIEW_ID) == null;
    }
}

