/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.GraphicsSource;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.UpdateManager;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.widgets.Display;

public class DeferredUpdateManager
extends UpdateManager {
    private boolean updating;
    private GraphicsSource graphicsSource;
    private IFigure root;
    private boolean updateQueued = false;
    private List invalidFigures = new ArrayList();
    private Map dirtyRegions = new HashMap();
    private Rectangle damage;

    public DeferredUpdateManager(GraphicsSource gs) {
        this.setGraphicsSource(gs);
    }

    public DeferredUpdateManager() {
    }

    public synchronized void addDirtyRegion(IFigure figure, int x, int y, int w, int h) {
        if (!figure.isShowing()) {
            return;
        }
        if (w == 0 || h == 0) {
            return;
        }
        Rectangle rect = (Rectangle)this.dirtyRegions.get(figure);
        if (rect == null) {
            rect = new Rectangle(x, y, w, h);
            this.dirtyRegions.put(figure, rect);
        } else {
            rect.union(x, y, w, h);
        }
        this.queueWork();
    }

    public synchronized void addInvalidFigure(IFigure f) {
        if (this.invalidFigures.contains(f)) {
            return;
        }
        this.queueWork();
        this.invalidFigures.add(f);
    }

    protected Graphics getGraphics(Rectangle region) {
        if (this.graphicsSource == null) {
            return null;
        }
        return this.graphicsSource.getGraphics(region);
    }

    public synchronized void performUpdate(Rectangle exposed) {
        this.addDirtyRegion(this.root, exposed);
        this.performUpdate();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void performUpdate() {
        if (this.isDisposed()) return;
        if (this.updating) {
            return;
        }
        this.updating = true;
        try {
            this.validateFigures();
            this.updateQueued = false;
            this.repairDamage();
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.updating = false;
            throw throwable;
        }
        {
            Object var1_3 = null;
            this.updating = false;
            return;
        }
    }

    protected void queueWork() {
        if (!this.updateQueued) {
            Display.getCurrent().asyncExec((Runnable)new UpdateRequest());
            this.updateQueued = true;
        }
    }

    protected void releaseGraphics(Graphics graphics) {
        this.graphicsSource.flushGraphics(this.damage);
    }

    protected void repairDamage() {
        Graphics graphics;
        Iterator keys = this.dirtyRegions.keySet().iterator();
        while (keys.hasNext()) {
            IFigure figure = (IFigure)keys.next();
            IFigure walker = figure.getParent();
            Rectangle contribution = (Rectangle)this.dirtyRegions.get(figure);
            contribution.intersect(figure.getBounds());
            while (!contribution.isEmpty() && walker != null) {
                walker.translateToParent(contribution);
                contribution.intersect(walker.getBounds());
                walker = walker.getParent();
            }
            if (this.damage == null) {
                this.damage = new Rectangle(contribution);
                continue;
            }
            this.damage.union(contribution);
        }
        if (!this.dirtyRegions.isEmpty()) {
            this.firePainting(this.damage, this.dirtyRegions);
            this.dirtyRegions.clear();
        }
        if (this.damage != null && !this.damage.isEmpty() && (graphics = this.getGraphics(this.damage)) != null) {
            this.root.paint(graphics);
            this.releaseGraphics(graphics);
        }
        this.damage = null;
    }

    public void setGraphicsSource(GraphicsSource gs) {
        this.graphicsSource = gs;
    }

    public void setRoot(IFigure figure) {
        this.root = figure;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void validateFigures() {
        if (this.invalidFigures.isEmpty()) {
            return;
        }
        try {
            this.fireValidating();
            int i = 0;
            while (i < this.invalidFigures.size()) {
                IFigure fig = (IFigure)this.invalidFigures.get(i);
                this.invalidFigures.set(i, null);
                fig.validate();
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.invalidFigures.clear();
            throw throwable;
        }
        {
            Object var3_5 = null;
            this.invalidFigures.clear();
            return;
        }
    }

    protected class UpdateRequest
    implements Runnable {
        protected UpdateRequest() {
        }

        public void run() {
            DeferredUpdateManager.this.performUpdate();
        }
    }
}

