/*
 * Decompiled with CFR 0.152.
 */
package swingwtx.swing;

import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.widgets.Control;
import swingwt.awt.Component;
import swingwt.awt.Container;
import swingwt.awt.Frame;
import swingwt.awt.GraphicsConfiguration;
import swingwtx.swing.JLayeredPane;
import swingwtx.swing.JRootPane;
import swingwtx.swing.RootPaneContainer;
import swingwtx.swing.SwingUtilities;
import swingwtx.swing.SwingWTUtils;
import swingwtx.swing.WindowConstants;

public class JFrame
extends Frame
implements WindowConstants,
RootPaneContainer {
    public static final int NORMAL = 0;
    public static final int ICONIFIED = 1;
    public static final int MAXIMIZED_HORIZ = 2;
    public static final int MAXIMIZED_VERT = 3;
    public static final int MAXIMIZED_BOTH = 4;
    protected int closeOperation = 0;
    protected boolean isMax = false;
    protected int state = 0;
    private int intRetval;

    public JFrame() {
    }

    public JFrame(String title) {
        super(title);
    }

    public JFrame(GraphicsConfiguration gc) {
        super(gc);
    }

    public void setCachedProperties() {
        super.setCachedProperties();
        this.setExtendedState(this.state);
    }

    public int getExtendedState() {
        if (SwingWTUtils.isSWTControlAvailable((Control)this.peer)) {
            SwingUtilities.invokeSync(new Runnable(){

                public void run() {
                    if (JFrame.this.peer.getMaximized()) {
                        JFrame.this.intRetval = 4;
                    } else if (JFrame.this.peer.getMinimized()) {
                        JFrame.this.intRetval = 1;
                    } else {
                        JFrame.this.intRetval = 0;
                    }
                }
            });
        } else {
            this.intRetval = this.state;
        }
        return this.intRetval;
    }

    public void setExtendedState(final int state) {
        this.state = state;
        if (SwingWTUtils.isSWTControlAvailable((Control)this.peer)) {
            SwingUtilities.invokeSync(new Runnable(){

                public void run() {
                    if ((state & 4) > 0 || (state & 2) > 0 || (state & 3) > 0) {
                        JFrame.this.peer.setMaximized(true);
                        JFrame.this.isMax = true;
                    } else {
                        JFrame.this.peer.setMaximized(false);
                        JFrame.this.isMax = false;
                    }
                    if ((state & 1) > 0) {
                        JFrame.this.peer.setMinimized(true);
                        JFrame.this.isIcon = true;
                    } else {
                        JFrame.this.peer.setMinimized(false);
                        JFrame.this.isIcon = false;
                    }
                }
            });
        }
    }

    public void toggleWindowState() {
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                if (JFrame.this.isMax) {
                    JFrame.this.peer.setMaximized(false);
                    JFrame.this.peer.setMaximized(true);
                } else {
                    JFrame.this.peer.setMaximized(true);
                    JFrame.this.peer.setMaximized(false);
                }
            }
        });
    }

    public int getDefaultCloseOperation() {
        return this.closeOperation;
    }

    public void setDefaultCloseOperation(int operation) {
        this.closeOperation = operation;
    }

    public Container getContentPane() {
        return this.rootPane.getContentPane();
    }

    public Component getGlassPane() {
        return this.rootPane.getGlassPane();
    }

    public JLayeredPane getLayeredPane() {
        return this.rootPane.getLayeredPane();
    }

    public JRootPane getRootPane() {
        return this.rootPane;
    }

    public void setContentPane(Container contentPane) {
        this.rootPane.setContentPane(contentPane);
    }

    public void setGlassPane(Component glassPane) {
        this.rootPane.setGlassPane(glassPane);
    }

    public void setLayeredPane(JLayeredPane layeredPane) {
        this.rootPane.setLayeredPane(layeredPane);
    }

    public void registerWindowEvents() {
        this.peer.addShellListener(new ShellListener(){

            public void shellActivated(ShellEvent e) {
                JFrame.this.processWindowEvent(205);
            }

            public void shellClosed(ShellEvent e) {
                JFrame.this.isClosed = true;
                JFrame.this.processWindowEvent(201);
                JFrame.this.processWindowEvent(202);
                switch (JFrame.this.closeOperation) {
                    case 0: {
                        e.doit = true;
                        SwingWTUtils.decrementWindowReferences();
                        break;
                    }
                    case 1: {
                        e.doit = false;
                        break;
                    }
                    case 2: {
                        e.doit = true;
                        SwingWTUtils.decrementWindowReferences();
                        System.exit(0);
                        break;
                    }
                    case 3: {
                        e.doit = false;
                        JFrame.this.peer.setVisible(false);
                    }
                }
            }

            public void shellDeactivated(ShellEvent e) {
                JFrame.this.processWindowEvent(206);
            }

            public void shellDeiconified(ShellEvent e) {
                JFrame.this.processWindowEvent(204);
            }

            public void shellIconified(ShellEvent e) {
                JFrame.this.processWindowEvent(203);
            }
        });
    }
}

