/*
 * Decompiled with CFR 0.152.
 */
package swingwtx.swing;

import java.util.Vector;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Slider;
import swingwt.awt.Adjustable;
import swingwt.awt.Container;
import swingwt.awt.event.AdjustmentEvent;
import swingwt.awt.event.AdjustmentListener;
import swingwtx.swing.JComponent;
import swingwtx.swing.SwingUtilities;
import swingwtx.swing.SwingWTUtils;

public class JScrollBar
extends JComponent
implements Adjustable {
    protected Slider ppeer = null;
    public static final int VERTICAL = 0;
    public static final int HORIZONTAL = 1;
    protected int orientation = 0;
    protected int value = 0;
    protected int extent = 100;
    protected int blockIncrement = 10;
    protected int increment = 5;
    protected int min = 0;
    protected int max = 100;
    protected Vector adjustmentListeners = new Vector();
    private int retval = 0;

    public JScrollBar() {
        this(0);
    }

    public JScrollBar(int orientation) {
        this(orientation, 0, 5, 0, 100);
    }

    public JScrollBar(int orientation, int value, int extent, int min, int max) {
        this.orientation = orientation;
        this.value = value;
        this.extent = extent;
        this.min = min;
        this.max = max;
    }

    public void addAdjustmentListener(AdjustmentListener l) {
        this.adjustmentListeners.add(l);
    }

    public void removeAdjustmentListener(AdjustmentListener l) {
        this.adjustmentListeners.remove(l);
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
    }

    public int getUnitIncrement(int direction) {
        return this.increment;
    }

    public void setUnitIncrement(int unitIncrement) {
        this.increment = unitIncrement;
        this.updateBar();
    }

    public int getBlockIncrement(int direction) {
        return this.blockIncrement;
    }

    public void setBlockIncrement(int blockIncrement) {
        this.blockIncrement = blockIncrement;
        this.updateBar();
    }

    public int getUnitIncrement() {
        return this.increment;
    }

    public int getBlockIncrement() {
        return this.blockIncrement;
    }

    public int getValue() {
        if (!SwingWTUtils.isSWTControlAvailable((Control)this.ppeer)) {
            return this.value;
        }
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                JScrollBar.this.retval = JScrollBar.this.ppeer.getSelection();
            }
        });
        return this.retval;
    }

    public void setValue(int value) {
        this.value = value;
        this.updateBar();
    }

    public int getVisibleAmount() {
        return this.extent;
    }

    public void setVisibleAmount(int extent) {
        this.extent = extent;
        this.updateBar();
    }

    public int getMinimum() {
        return this.min;
    }

    public void setMinimum(int minimum) {
    }

    public int getMaximum() {
        return this.max;
    }

    public void setMaximum(int maximum) {
        this.max = maximum;
        this.updateBar();
    }

    public boolean getValueIsAdjusting() {
        return false;
    }

    public void setValueIsAdjusting(boolean b) {
    }

    public void setValues(int newValue, int newExtent, int newMin, int newMax) {
        this.extent = newExtent;
        this.value = newValue;
        this.min = newMin;
        this.max = newMax;
        this.updateBar();
    }

    protected void updateBar() {
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                if (SwingWTUtils.isSWTControlAvailable((Control)JScrollBar.this.ppeer)) {
                    JScrollBar.this.ppeer.setIncrement(JScrollBar.this.increment);
                    JScrollBar.this.ppeer.setPageIncrement(JScrollBar.this.blockIncrement);
                    JScrollBar.this.ppeer.setThumb(JScrollBar.this.increment);
                    JScrollBar.this.ppeer.setMaximum(JScrollBar.this.max);
                    JScrollBar.this.ppeer.setMinimum(JScrollBar.this.min);
                    JScrollBar.this.ppeer.setSelection(JScrollBar.this.value);
                }
            }
        });
    }

    public void setSwingWTParent(Container parent) throws Exception {
        this.descendantHasPeer = true;
        this.ppeer = new Slider(parent.getComposite(), this.orientation == 1 ? 256 : 512);
        this.peer = this.ppeer;
        this.parent = parent;
        this.updateBar();
        this.registerBarEvents();
    }

    protected void registerBarEvents() {
        final JScrollBar me = this;
        this.ppeer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AdjustmentEvent ev = new AdjustmentEvent(me, 0, 601, JScrollBar.this.ppeer.getSelection());
                JScrollBar.this.processAdjustmentEvent(ev);
            }
        });
    }

    protected void processAdjustmentEvent(AdjustmentEvent e) {
        for (int i = 0; i < this.adjustmentListeners.size(); ++i) {
            ((AdjustmentListener)this.adjustmentListeners.get(i)).adjustmentValueChanged(e);
        }
    }
}

