/*
 * Decompiled with CFR 0.152.
 */
package swingwtx.swing;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MenuItem;
import swingwt.awt.Component;
import swingwt.awt.SWTGraphics2DRenderer;
import swingwtx.swing.Icon;
import swingwtx.swing.ImageIcon;
import swingwtx.swing.SwingUtilities;

public abstract class SwingWTUtils {
    private static boolean isDebug = true;
    public static boolean showInternalSWTExceptions = false;
    private static final String VERSION = "0.85 (021104)";
    private static final String COPYRIGHT = "This is SwingWT (http://swingwt.sourceforge.net)\nVersion: 0.85 (021104)\nCopyright(c)2003-2004, R.Rawson-Tetley and other contributors.\n\nThis library is distributed in the hope that it will be useful,\nbut WITHOUT ANY WARRANTY; without even the implied warranty of\nMERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU\nLesser General Public Licence for more details.";
    private static Display display = null;
    private static boolean eventsDispatching = false;
    private static Object eventsDispatchOwner = null;
    private static boolean setDeleteTempOnShutdown = false;
    private static Vector tempFileList = new Vector();
    private static boolean retardEventDispatch = false;
    private static int retardationms = 2000;
    private static int windowReferenceCount = 0;
    private static boolean useSWTFastVirtualTables = !SwingWTUtils.isWindows();
    private static String tempDirectory = System.getProperty("user.home") + File.separator + "tmp" + File.separator + "swingwt";
    public static int MACOSX_MENUBAR_BOTTOM = 20;
    private static boolean checkedOS = false;
    private static boolean isWin = false;
    private static boolean isMacOS = false;
    private static int intretval = 0;

    public static String getVersion() {
        return VERSION;
    }

    public static synchronized void incrementWindowReferences() {
        ++windowReferenceCount;
    }

    public static synchronized void decrementWindowReferences() {
        --windowReferenceCount;
    }

    public static void setShowSwingWTInfoOnStartup(boolean b) {
        isDebug = b;
    }

    public static synchronized void setRetardDispatchThread(boolean b) {
        retardEventDispatch = b;
    }

    public static synchronized void setRetardDispatchThread(boolean b, int ms) {
        retardEventDispatch = b;
        retardationms = ms;
    }

    public static synchronized void setEclipsePlugin(boolean b) {
        if (b) {
            eventsDispatching = true;
            display = Display.getDefault();
        } else {
            eventsDispatching = false;
        }
    }

    public static boolean isUseSWTFastVirtualTables() {
        return useSWTFastVirtualTables;
    }

    public static void setUsesSWTFastVirtualTables(boolean b) {
        useSWTFastVirtualTables = b;
    }

    public static void initialiseMacOSX(Runnable run) {
        SwingWTUtils.getDisplay().asyncExec(run);
        SwingWTUtils.checkEventDispatcher();
    }

    public static synchronized void checkEventDispatcher() {
        if (!eventsDispatching) {
            eventsDispatching = true;
            SwingWTUtils.checkShutdownHook();
            Thread pump = new Thread(){

                public void run() {
                    display = Display.getDefault();
                    if (isDebug) {
                        System.out.println(SwingWTUtils.COPYRIGHT);
                    }
                    while (eventsDispatching) {
                        try {
                            if (!display.readAndDispatch()) {
                                display.sleep();
                            }
                            if (!SwingWTUtils.isRetardDispatchThread()) continue;
                            try {
                                Thread.sleep(SwingWTUtils.getRetardationInterval());
                            }
                            catch (InterruptedException e) {
                            }
                        }
                        catch (SWTException e) {
                            if (e.getMessage().startsWith("Device is disposed") && SwingWTUtils.isMacOSX()) {
                                SwingWTUtils.stopEventDispatchRunning();
                                return;
                            }
                            if (!showInternalSWTExceptions) continue;
                            e.printStackTrace();
                        }
                        catch (Error e) {
                            e.printStackTrace();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            };
            if (SwingWTUtils.isMacOSX()) {
                pump.run();
            } else {
                pump.start();
            }
        }
    }

    public static boolean isRetardDispatchThread() {
        return retardEventDispatch;
    }

    public static int getRetardationInterval() {
        return retardationms;
    }

    public static synchronized Display getDisplay() {
        if (SwingWTUtils.isMacOSX()) {
            display = Display.getDefault();
            return display;
        }
        SwingWTUtils.checkEventDispatcher();
        while (display == null) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return display;
    }

    private static void checkForTempDirectory() throws IOException {
        File f = new File(tempDirectory);
        if (!f.exists()) {
            f.mkdirs();
        }
    }

    public static boolean isSWTControlAvailable(Control c) {
        if (c == null) {
            return false;
        }
        return !c.isDisposed();
    }

    public static boolean isSWTMenuControlAvailable(MenuItem c) {
        if (c == null) {
            return false;
        }
        return !c.isDisposed();
    }

    public static synchronized boolean isEventDispatchRunning() {
        return eventsDispatching;
    }

    public static synchronized void stopEventDispatchRunning() {
        eventsDispatching = false;
    }

    public static boolean isUrlInJar(URL url) throws IOException {
        return url == null ? false : url.toString().startsWith("jar:");
    }

    public static URL stringToTempFile(byte[] contents, String type) throws IOException {
        SwingWTUtils.checkForTempDirectory();
        File f = null;
        String fName = null;
        while ((f = new File(fName = tempDirectory + File.separator + (int)(Math.random() * 1.0E7) + "." + type)).exists()) {
        }
        System.out.println("TEMP: Creating temp file " + fName);
        FileOutputStream out = new FileOutputStream(f);
        out.write(contents);
        out.close();
        tempFileList.add(fName);
        return new URL("file://" + fName);
    }

    public static void clearTempDirectory() {
        if (tempFileList.size() == 0) {
            return;
        }
        Iterator i = tempFileList.iterator();
        while (i.hasNext()) {
            try {
                File f = new File((String)i.next());
                f.delete();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void checkShutdownHook() {
        if (!setDeleteTempOnShutdown) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    SwingWTUtils.clearTempDirectory();
                    System.runFinalization();
                    System.gc();
                }
            });
            setDeleteTempOnShutdown = true;
        }
    }

    public static boolean isWindows() {
        if (!checkedOS) {
            isWin = SWT.getPlatform().equals("win32");
        }
        return isWin;
    }

    public static boolean isMacOSX() {
        if (!checkedOS) {
            isMacOS = SWT.getPlatform().equals("carbon");
        }
        return isMacOS;
    }

    public static void saveImageToJPG(swingwt.awt.Image image, OutputStream stream) {
        ImageLoader il = new ImageLoader();
        il.data = new ImageData[]{image.image.getImageData()};
        il.save(stream, 4);
        il = null;
    }

    public static void saveImageToGIF(swingwt.awt.Image image, OutputStream stream) {
        ImageLoader il = new ImageLoader();
        il.data = new ImageData[]{image.image.getImageData()};
        il.save(stream, 2);
        il = null;
    }

    public static void saveImageToPNG(swingwt.awt.Image image, OutputStream stream) {
        ImageLoader il = new ImageLoader();
        il.data = new ImageData[]{image.image.getImageData()};
        il.save(stream, 5);
        il = null;
    }

    public static int getRenderStringWidth(final String text) {
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                GC gc = null;
                Image im = null;
                if (SwingWTUtils.getDisplay().getActiveShell() == null) {
                    im = new Image((Device)SwingWTUtils.getDisplay(), SwingWTUtils.getDisplay().getBounds());
                    gc = new GC((Drawable)im);
                } else {
                    gc = new GC((Drawable)SwingWTUtils.getDisplay().getActiveShell());
                }
                Point p = null;
                p = SwingWTUtils.isWindows() ? gc.stringExtent(text + "WWW") : gc.stringExtent(text + "W");
                int width = p.x;
                gc.dispose();
                gc = null;
                if (im != null) {
                    im.dispose();
                }
                im = null;
                intretval = width;
            }
        });
        return intretval;
    }

    public static int getRenderStringHeight(final String text) {
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                GC gc = null;
                Image im = null;
                if (SwingWTUtils.getDisplay().getActiveShell() == null) {
                    im = new Image((Device)SwingWTUtils.getDisplay(), SwingWTUtils.getDisplay().getBounds());
                    gc = new GC((Drawable)im);
                } else {
                    gc = new GC((Drawable)SwingWTUtils.getDisplay().getActiveShell());
                }
                Point p = gc.stringExtent(text + "W");
                int height = p.y;
                gc.dispose();
                gc = null;
                if (im != null) {
                    im.dispose();
                }
                im = null;
                intretval = height;
            }
        });
        return intretval;
    }

    public static int getStringBufferIndexOf(StringBuffer buffer, String string) {
        return buffer.toString().indexOf(string);
    }

    public static int getStringBufferIndexOf(StringBuffer buffer, String string, int fromIndex) {
        return buffer.toString().indexOf(string, fromIndex);
    }

    public static Image getSWTImageFromSwingIcon(Component c, Icon icon) {
        if (icon == null) {
            return null;
        }
        if (icon instanceof ImageIcon) {
            return ((ImageIcon)icon).getImage().image;
        }
        Image img = new Image((Device)SwingWTUtils.getDisplay(), icon.getIconWidth(), icon.getIconHeight());
        GC gc = new GC((Drawable)img);
        SWTGraphics2DRenderer g = new SWTGraphics2DRenderer(gc, false);
        icon.paintIcon(c, g, 0, 0);
        g.dispose();
        return img;
    }

    public static int translateSwingAlignmentConstant(int constant) {
        int ret = 0;
        switch (constant) {
            case 0: {
                ret = 0x1000000;
                break;
            }
            case 1: {
                ret = 128;
                break;
            }
            case 2: {
                ret = 16384;
                break;
            }
            case 3: {
                ret = 1024;
                break;
            }
            case 4: {
                ret = 131072;
                break;
            }
            case 10: {
                ret = 16384;
                break;
            }
            case 11: {
                ret = 131072;
            }
        }
        return ret;
    }

    public static int translateSwingOrientationConstant(int constant) {
        int ret = 0;
        switch (constant) {
            case 0: {
                ret = 256;
                break;
            }
            case 1: {
                ret = 512;
            }
        }
        return ret;
    }

    public static String removeHTML(String s) {
        int opener = s.indexOf("<");
        int closer = s.indexOf(">");
        if (opener != -1 && closer == -1) {
            return s;
        }
        int i = s.indexOf("<");
        while (i != -1) {
            int e = s.indexOf(">", i);
            if (e == -1) {
                e = s.length();
            }
            s = s.substring(0, i) + (e < s.length() ? s.substring(e + 1, s.length()) : "");
            i = s.indexOf("<");
        }
        s = SwingWTUtils.replace(s, "&nbsp;", " ");
        s = SwingWTUtils.replace(s, "&nbsp", " ");
        s = SwingWTUtils.replace(s, "&amp;", " ");
        s = SwingWTUtils.replace(s, "&lt;", "<");
        s = SwingWTUtils.replace(s, "&gt;", ">");
        s = s.trim();
        StringBuffer o = new StringBuffer();
        boolean lastWasSpace = false;
        for (i = 0; i < s.length(); ++i) {
            if (s.substring(i, i + 1).equals(" ")) {
                if (lastWasSpace) continue;
                lastWasSpace = true;
                o.append(" ");
                continue;
            }
            o.append(s.substring(i, i + 1));
            lastWasSpace = false;
        }
        s = o.toString();
        return s;
    }

    public static String replace(String findin, String find, String replacewith) {
        StringBuffer sb = new StringBuffer(findin);
        try {
            for (int i = 0; i <= sb.length() - find.length(); ++i) {
                if (!sb.substring(i, i + find.length()).equalsIgnoreCase(find)) continue;
                sb.replace(i, i + find.length(), replacewith);
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            // empty catch block
        }
        return sb.toString();
    }
}

