/*
 * Decompiled with CFR 0.152.
 */
package swingwtx.swing.tree;

public class TreePath {
    private TreePath parentPath;
    private Object lastPathComponent;

    protected TreePath() {
    }

    public TreePath(Object singlePath) {
        this.lastPathComponent = singlePath;
        this.parentPath = null;
    }

    protected TreePath(TreePath parent, Object lastElement) {
        this.parentPath = parent;
        this.lastPathComponent = lastElement;
    }

    protected TreePath(Object[] path, int length) {
        this.lastPathComponent = path[path.length - length];
        if (length > 1) {
            this.parentPath = new TreePath(path, length - 1);
        }
    }

    public TreePath(Object[] path) {
        this.lastPathComponent = path[0];
        if (path.length > 1) {
            this.parentPath = new TreePath(path, path.length - 1);
        }
    }

    public Object[] getPath() {
        int i = this.getPathCount();
        Object[] result = new Object[i--];
        TreePath path = this;
        while (path != null) {
            result[i--] = path.lastPathComponent;
            path = path.parentPath;
        }
        return result;
    }

    public Object getLastPathComponent() {
        return this.lastPathComponent;
    }

    public int getPathCount() {
        int result = 0;
        TreePath path = this;
        while (path != null) {
            ++result;
            path = path.parentPath;
        }
        return result;
    }

    public Object getPathComponent(int element) {
        TreePath path = this;
        int pathLength = this.getPathCount();
        for (int i = pathLength - 1; i != element; --i) {
            path = path.parentPath;
        }
        return path.lastPathComponent;
    }

    public TreePath pathByAddingChild(Object child) {
        return new TreePath(this, child);
    }

    public TreePath getParentPath() {
        return this.parentPath;
    }

    public String toString() {
        StringBuffer s = new StringBuffer("[");
        int m = this.getPathCount();
        for (int c = 0; c < m; ++c) {
            if (c > 0) {
                s.append(", ");
            }
            s.append(this.getPathComponent(c));
        }
        s.append("]");
        return s.toString();
    }
}

