/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.preferences;

import org.eclipse.core.internal.preferences.EclipsePreferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IExportedPreferences;
import org.osgi.service.prefs.BackingStoreException;

public class ExportedPreferences
extends EclipsePreferences
implements IExportedPreferences {
    private boolean isExportRoot = false;

    ExportedPreferences(IEclipsePreferences parent, String name) {
        super(parent, name);
    }

    public boolean isExportRoot() {
        return this.isExportRoot;
    }

    public void setExportRoot() {
        this.isExportRoot = true;
    }

    public IEclipsePreferences create(IEclipsePreferences nodeParent, String nodeName) {
        return new ExportedPreferences(nodeParent, nodeName);
    }

    public void remove(String key) {
        super.remove(key);
        if (this.properties == null) {
            try {
                this.removeNode();
            }
            catch (BackingStoreException e) {
                String message = "Exception trying to remove node from exported prefs: " + this.absolutePath();
                Status status = new Status(4, "org.eclipse.core.runtime", 4, message, e);
                this.log(status);
            }
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.isExportRoot) {
            buffer.append("* ");
        }
        buffer.append(this.absolutePath());
        return buffer.toString();
    }
}

