/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.carbon.ControlButtonContentInfo;
import org.eclipse.swt.internal.carbon.ControlFontStyleRec;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Point;
import org.eclipse.swt.internal.carbon.Rect;
import org.eclipse.swt.internal.carbon.ThemeButtonDrawInfo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Button
extends Control {
    String text = "";
    Image image;
    int cIcon;
    boolean isImage;

    public Button(Composite parent, int style) {
        super(parent, Button.checkStyle(style));
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int style) {
        if (((style = Widget.checkBits(style, 8, 4, 32, 16, 2, 0)) & 0xA) != 0) {
            return Widget.checkBits(style, 0x1000000, 16384, 131072, 0, 0, 0);
        }
        if ((style & 0x30) != 0) {
            return Widget.checkBits(style, 16384, 131072, 0x1000000, 0, 0, 0);
        }
        if ((style & 4) != 0) {
            return Widget.checkBits(style |= 0x80000, 128, 1024, 16384, 131072, 0, 0);
        }
        return style;
    }

    void click() {
        this.postEvent(13);
    }

    public org.eclipse.swt.graphics.Point computeSize(int wHint, int hHint, boolean changed) {
        int border;
        int[] outMetric;
        this.checkWidget();
        if ((this.style & 4) != 0) {
            int[] outMetric2 = new int[1];
            OS.GetThemeMetric((int)25, (int[])outMetric2);
            int width = outMetric2[0];
            int height = outMetric2[0];
            if (wHint != -1) {
                width = wHint;
            }
            if (hHint != -1) {
                height = hHint;
            }
            return new org.eclipse.swt.graphics.Point(width, height);
        }
        int width = 0;
        int height = 0;
        if (this.isImage && this.image != null) {
            Rectangle bounds = this.image.getBounds();
            width = bounds.width;
            height = bounds.height;
        } else {
            int[] ptr = new int[1];
            OS.CopyControlTitleAsCFString((int)this.handle, (int[])ptr);
            if (ptr[0] != 0) {
                Point ioBounds = new Point();
                if (this.font == null) {
                    OS.GetThemeTextDimensions((int)ptr[0], (short)((short)this.defaultThemeFont()), (int)1, (boolean)false, (Point)ioBounds, null);
                } else {
                    int[] currentPort = new int[1];
                    OS.GetPort((int[])currentPort);
                    OS.SetPortWindowPort((int)OS.GetControlOwner((int)this.handle));
                    OS.TextFont((short)this.font.id);
                    OS.TextFace((short)this.font.style);
                    OS.TextSize((short)this.font.size);
                    OS.GetThemeTextDimensions((int)ptr[0], (short)200, (int)1, (boolean)false, (Point)ioBounds, null);
                    OS.SetPort((int)currentPort[0]);
                }
                width = ioBounds.h;
                height = ioBounds.v;
                OS.CFRelease((int)ptr[0]);
            } else {
                width = 64;
                height = 64;
            }
        }
        if ((this.style & 0x30) != 0) {
            outMetric = new int[1];
            int metric = (this.style & 0x20) != 0 ? 50 : 52;
            OS.GetThemeMetric((int)metric, (int[])outMetric);
            width += outMetric[0] + 3;
            height = Math.max(outMetric[0], height);
        } else if ((this.style & 0x800000) != 0 || (this.style & 2) != 0) {
            width += 10;
            height += 10;
        } else {
            width += 28;
            outMetric = new int[1];
            OS.GetThemeMetric((int)19, (int[])outMetric);
            height = Math.max(height, outMetric[0]);
        }
        Rect inset = this.getInset();
        width += inset.left + inset.right;
        height += inset.top + inset.bottom;
        width = Math.max(20, width);
        int n = border = (this.style & 8) != 0 ? 2 : 0;
        if (wHint != -1) {
            width = wHint + border * 2;
        }
        if (hHint != -1) {
            height = hHint + border * 2;
        }
        return new org.eclipse.swt.graphics.Point(width, height);
    }

    void createHandle() {
        int[] outControl = new int[1];
        int window = OS.GetControlOwner((int)this.parent.handle);
        if ((this.style & 4) != 0) {
            int orientation = 0;
            if ((this.style & 0x80) != 0) {
                orientation = 0;
            }
            if ((this.style & 0x400) != 0) {
                orientation = 1;
            }
            if ((this.style & 0x4000) != 0) {
                orientation = 2;
            }
            OS.CreateBevelButtonControl((int)window, null, (int)0, (short)0, (short)0, (int)0, (short)0, (short)0, (short)0, (int[])outControl);
            if (outControl[0] == 0) {
                this.error(2);
            }
            this.handle = outControl[0];
            OS.SetControlData((int)this.handle, (int)0, (int)1650811499, (int)2, (short[])new short[]{6});
            OS.SetControl32BitMaximum((int)this.handle, (int)2);
            OS.SetControl32BitValue((int)this.handle, (int)orientation);
        }
        if ((this.style & 0x20) != 0) {
            OS.CreateBevelButtonControl((int)window, null, (int)0, (short)0, (short)256, (int)0, (short)0, (short)0, (short)0, (int[])outControl);
            if (outControl[0] == 0) {
                this.error(2);
            }
            this.handle = outControl[0];
            OS.SetControlData((int)this.handle, (int)0, (int)1650811499, (int)2, (short[])new short[]{1});
        }
        if ((this.style & 0x10) != 0) {
            OS.CreateBevelButtonControl((int)window, null, (int)0, (short)0, (short)256, (int)0, (short)0, (short)0, (short)0, (int[])outControl);
            if (outControl[0] == 0) {
                this.error(2);
            }
            this.handle = outControl[0];
            OS.SetControlData((int)this.handle, (int)0, (int)1650811499, (int)2, (short[])new short[]{2});
        }
        if ((this.style & 2) != 0) {
            OS.CreateBevelButtonControl((int)window, null, (int)0, (short)1, (short)256, (int)0, (short)0, (short)0, (short)0, (int[])outControl);
            if (outControl[0] == 0) {
                this.error(2);
            }
            this.handle = outControl[0];
            if ((this.style & 0x800000) == 0) {
                OS.SetControlData((int)this.handle, (int)0, (int)1650811499, (int)2, (short[])new short[]{15});
            }
        }
        if ((this.style & 8) != 0) {
            if ((this.style & 0x800000) != 0) {
                OS.CreateBevelButtonControl((int)window, null, (int)0, (short)2, (short)0, (int)0, (short)0, (short)0, (short)0, (int[])outControl);
            } else {
                OS.CreatePushButtonControl((int)window, null, (int)0, (int[])outControl);
            }
            if (outControl[0] == 0) {
                this.error(2);
            }
            this.handle = outControl[0];
            if ((this.style & 0x800000) == 0) {
                OS.SetControlData((int)this.handle, (int)0, (int)1650811499, (int)2, (short[])new short[1]);
            }
        }
        ControlFontStyleRec fontRec = new ControlFontStyleRec();
        fontRec.flags = (short)128;
        fontRec.font = (short)this.defaultThemeFont();
        OS.SetControlFontStyle((int)this.handle, (ControlFontStyleRec)fontRec);
        if ((this.style & 0x1024000) != 0) {
            int textAlignment = 0;
            int graphicAlignment = 0;
            if ((this.style & 0x4000) != 0) {
                textAlignment = -2;
                graphicAlignment = 1;
            }
            if ((this.style & 0x1000000) != 0) {
                textAlignment = 1;
                graphicAlignment = 0;
            }
            if ((this.style & 0x20000) != 0) {
                textAlignment = -1;
                graphicAlignment = 2;
            }
            OS.SetControlData((int)this.handle, (int)0, (int)1952541801, (int)2, (short[])new short[]{(short)textAlignment});
            OS.SetControlData((int)this.handle, (int)0, (int)1734437993, (int)2, (short[])new short[]{(short)graphicAlignment});
        }
    }

    int defaultThemeFont() {
        if (this.display.smallFonts) {
            return 1;
        }
        return 105;
    }

    void drawWidget(int control, int damageRgn, int visibleRgn, int theEvent) {
        if (this.isImage && this.image != null && (this.style & 8) != 0 && (this.style & 0x800000) == 0) {
            Rect bounds = new Rect();
            Rect content = new Rect();
            OS.GetControlBounds((int)this.handle, (Rect)bounds);
            ThemeButtonDrawInfo drawInfo = new ThemeButtonDrawInfo();
            drawInfo.state = OS.IsControlActive((int)this.handle) ? 1 : 0;
            drawInfo.adornment = 1;
            OS.GetThemeButtonContentBounds((Rect)bounds, (int)0, (ThemeButtonDrawInfo)drawInfo, (Rect)content);
            int width = this.image == null ? 0 : OS.CGImageGetWidth((int)this.image.handle);
            int height = this.image == null ? 0 : OS.CGImageGetHeight((int)this.image.handle);
            int x = (bounds.right - bounds.left - width) / 2;
            int y = (content.bottom - content.top - height) / 2;
            GCData data = new GCData();
            data.paintEvent = theEvent;
            data.visibleRgn = visibleRgn;
            GC gc = GC.carbon_new(this, data);
            gc.drawImage(this.image, x, y);
            gc.dispose();
        }
        super.drawWidget(control, damageRgn, visibleRgn, theEvent);
    }

    public int getAlignment() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            if ((this.style & 0x80) != 0) {
                return 128;
            }
            if ((this.style & 0x400) != 0) {
                return 1024;
            }
            if ((this.style & 0x4000) != 0) {
                return 16384;
            }
            if ((this.style & 0x20000) != 0) {
                return 131072;
            }
            return 128;
        }
        if ((this.style & 0x4000) != 0) {
            return 16384;
        }
        if ((this.style & 0x1000000) != 0) {
            return 0x1000000;
        }
        if ((this.style & 0x20000) != 0) {
            return 131072;
        }
        return 16384;
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    String getNameText() {
        return this.getText();
    }

    public boolean getSelection() {
        this.checkWidget();
        if ((this.style & 0x32) == 0) {
            return false;
        }
        return OS.GetControl32BitValue((int)this.handle) != 0;
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    Rect getInset() {
        if ((this.style & 8) == 0) {
            return super.getInset();
        }
        return this.display.buttonInset;
    }

    int kEventControlHit(int nextHandler, int theEvent, int userData) {
        int result = super.kEventControlHit(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        if ((this.style & 0x10) != 0 && (this.parent.getStyle() & 0x400000) == 0) {
            this.selectRadio();
        }
        this.postEvent(13);
        return -9874;
    }

    int kEventControlSetFocusPart(int nextHandler, int theEvent, int userData) {
        int result = super.kEventControlSetFocusPart(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        if ((this.style & 8) != 0) {
            short[] part = new short[1];
            OS.GetEventParameter((int)theEvent, (int)1668313716, (int)1668313716, null, (int)2, null, (short[])part);
            this.menuShell().setDefaultButton(part[0] != 0 ? this : null, false);
        }
        return result;
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.cIcon != 0) {
            this.destroyCIcon(this.cIcon);
            this.cIcon = 0;
        }
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    void selectRadio() {
        Control[] children = this.parent._getChildren();
        int i = 0;
        while (i < children.length) {
            Control child = children[i];
            if (this != child) {
                child.setRadioSelection(false);
            }
            ++i;
        }
        this.setSelection(true);
    }

    public void setAlignment(int alignment) {
        if ((this.style & 4) != 0) {
            if ((this.style & 0x24480) == 0) {
                return;
            }
            this.style &= 0xFFFDBB7F;
            this.style |= alignment & 0x24480;
            int orientation = 0;
            if ((this.style & 0x80) != 0) {
                orientation = 0;
            }
            if ((this.style & 0x400) != 0) {
                orientation = 1;
            }
            if ((this.style & 0x4000) != 0) {
                orientation = 2;
            }
            OS.SetControl32BitValue((int)this.handle, (int)orientation);
            return;
        }
        if ((alignment & 0x1024000) == 0) {
            return;
        }
        this.style &= 0xFEFDBFFF;
        this.style |= alignment & 0x1024000;
        int textAlignment = 0;
        int graphicAlignment = 0;
        if ((this.style & 0x4000) != 0) {
            textAlignment = -2;
            graphicAlignment = 1;
        }
        if ((this.style & 0x1000000) != 0) {
            textAlignment = 1;
            graphicAlignment = 0;
        }
        if ((this.style & 0x20000) != 0) {
            textAlignment = -1;
            graphicAlignment = 2;
        }
        OS.SetControlData((int)this.handle, (int)0, (int)1952541801, (int)2, (short[])new short[]{(short)textAlignment});
        OS.SetControlData((int)this.handle, (int)0, (int)1734437993, (int)2, (short[])new short[]{(short)graphicAlignment});
        this.redraw();
    }

    public void setBounds(int x, int y, int width, int height) {
        this.checkWidget();
        if ((this.style & 4) == 0) {
            height = Math.max(20, height);
        }
        super.setBounds(x, y, width, height);
    }

    void setDefault(boolean value) {
        if ((this.style & 8) == 0) {
            return;
        }
        int window = OS.GetControlOwner((int)this.handle);
        OS.SetWindowDefaultButton((int)window, (int)(value ? this.handle : 0));
    }

    public void setImage(Image image) {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if (this.cIcon != 0) {
            this.destroyCIcon(this.cIcon);
            this.cIcon = 0;
        }
        this.image = image;
        this.isImage = true;
        if (image == null) {
            this.setText(this.text);
            return;
        }
        if (this.text.length() > 0) {
            int ptr = OS.CFStringCreateWithCharacters((int)0, null, (int)0);
            if (ptr == 0) {
                this.error(13);
            }
            OS.SetControlTitleWithCFString((int)this.handle, (int)ptr);
            OS.CFRelease((int)ptr);
        }
        this.cIcon = this.createCIcon(image);
        ControlButtonContentInfo inContent = new ControlButtonContentInfo();
        inContent.contentType = (short)130;
        inContent.iconRef = this.cIcon;
        OS.SetBevelButtonContentInfo((int)this.handle, (ControlButtonContentInfo)inContent);
        this.redraw();
    }

    boolean setRadioSelection(boolean value) {
        if ((this.style & 0x10) == 0) {
            return false;
        }
        if (this.getSelection() != value) {
            this.setSelection(value);
            this.postEvent(13);
        }
        return true;
    }

    public void setSelection(boolean selected) {
        this.checkWidget();
        if ((this.style & 0x32) == 0) {
            return;
        }
        OS.SetControl32BitValue((int)this.handle, (int)(selected ? 1 : 0));
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 4) != 0) {
            return;
        }
        this.text = string;
        if (this.isImage) {
            ControlButtonContentInfo inContent = new ControlButtonContentInfo();
            inContent.contentType = 0;
            OS.SetBevelButtonContentInfo((int)this.handle, (ControlButtonContentInfo)inContent);
        }
        this.isImage = false;
        char[] buffer = new char[this.text.length()];
        this.text.getChars(0, buffer.length, buffer, 0);
        int length = this.fixMnemonic(buffer);
        int ptr = OS.CFStringCreateWithCharacters((int)0, (char[])buffer, (int)length);
        if (ptr == 0) {
            this.error(13);
        }
        OS.SetControlTitleWithCFString((int)this.handle, (int)ptr);
        OS.CFRelease((int)ptr);
        this.redraw();
    }

    int traversalCode(int key, int theEvent) {
        int code = super.traversalCode(key, theEvent);
        if ((this.style & 0x10) != 0) {
            code |= 0x60;
        }
        return code;
    }
}

