/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.carbon.ColorPickerInfo;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Point;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Shell;

public class ColorDialog
extends Dialog {
    RGB rgb;

    public ColorDialog(Shell parent) {
        this(parent, 65536);
    }

    public ColorDialog(Shell parent, int style) {
        super(parent, style);
        this.checkSubclass();
    }

    public RGB getRGB() {
        return this.rgb;
    }

    public RGB open() {
        ColorPickerInfo info = new ColorPickerInfo();
        if (this.rgb != null) {
            info.red = (short)(this.rgb.red * 257);
            info.green = (short)(this.rgb.green * 257);
            info.blue = (short)(this.rgb.blue * 257);
        } else {
            info.red = (short)-1;
            info.green = (short)-1;
            info.blue = (short)-1;
        }
        info.flags = 3;
        info.placeWhere = 0;
        Point mp = new Point();
        OS.GetGlobalMouse((Point)mp);
        info.v = mp.v;
        info.h = mp.h;
        if (this.title != null) {
            info.prompt = new byte[256];
            int length = this.title.length();
            if (length > 255) {
                length = 255;
            }
            info.prompt[0] = (byte)length;
            int i = 0;
            while (i < length) {
                info.prompt[i + 1] = (byte)this.title.charAt(i);
                ++i;
            }
        }
        this.rgb = null;
        if (OS.PickColor((ColorPickerInfo)info) == 0 && info.newColorChosen) {
            int red = info.red >> 8 & 0xFF;
            int green = info.green >> 8 & 0xFF;
            int blue = info.blue >> 8 & 0xFF;
            this.rgb = new RGB(red, green, blue);
        }
        return this.rgb;
    }

    public void setRGB(RGB rgb) {
        this.rgb = rgb;
    }
}

