/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.carbon.CGPoint;
import org.eclipse.swt.internal.carbon.ControlFontStyleRec;
import org.eclipse.swt.internal.carbon.HMHelpContentRec;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Point;
import org.eclipse.swt.internal.carbon.RGBColor;
import org.eclipse.swt.internal.carbon.Rect;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public abstract class Control
extends Widget
implements Drawable {
    public int handle;
    Composite parent;
    String toolTipText;
    Object layoutData;
    int drawCount;
    int visibleRgn;
    Menu menu;
    float[] foreground;
    float[] background;
    Font font;
    Cursor cursor;
    GCData[] gcs;
    Accessible accessible;

    Control() {
    }

    public Control(Composite parent, int style) {
        super(parent, style);
        this.parent = parent;
        this.createWidget();
    }

    public void addControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(11, typedListener);
        this.addListener(10, typedListener);
    }

    public void addFocusListener(FocusListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(15, typedListener);
        this.addListener(16, typedListener);
    }

    public void addHelpListener(HelpListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(28, typedListener);
    }

    public void addKeyListener(KeyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(2, typedListener);
        this.addListener(1, typedListener);
    }

    public void addMouseListener(MouseListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(3, typedListener);
        this.addListener(4, typedListener);
        this.addListener(8, typedListener);
    }

    public void addMouseTrackListener(MouseTrackListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(6, typedListener);
        this.addListener(7, typedListener);
        this.addListener(32, typedListener);
    }

    public void addMouseMoveListener(MouseMoveListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(5, typedListener);
    }

    public void addPaintListener(PaintListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(9, typedListener);
    }

    public void addTraverseListener(TraverseListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(31, typedListener);
    }

    int colorProc(int inControl, int inMessage, int inDrawDepth, int inDrawInColor) {
        switch (inMessage) {
            case 30: {
                if (this.foreground != null) {
                    OS.RGBForeColor((RGBColor)this.toRGBColor(this.foreground));
                } else {
                    OS.SetThemeTextColor((short)1, (short)((short)inDrawDepth), (inDrawInColor != 0 ? 1 : 0) != 0);
                }
                return 0;
            }
            case 23: {
                float[] background;
                float[] fArray = background = this.background != null ? this.background : this.getParentBackground();
                if (background != null) {
                    OS.RGBBackColor((RGBColor)this.toRGBColor(background));
                } else {
                    OS.SetThemeBackground((short)1, (short)((short)inDrawDepth), (inDrawInColor != 0 ? 1 : 0) != 0);
                }
                return 0;
            }
        }
        return -9874;
    }

    public org.eclipse.swt.graphics.Point computeSize(int wHint, int hHint) {
        return this.computeSize(wHint, hHint, true);
    }

    public org.eclipse.swt.graphics.Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = 64;
        int height = 64;
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        int border = this.getBorderWidth();
        return new org.eclipse.swt.graphics.Point(width += border * 2, height += border * 2);
    }

    Control computeTabGroup() {
        if (this.isTabGroup()) {
            return this;
        }
        return this.parent.computeTabGroup();
    }

    Control[] computeTabList() {
        if (this.isTabGroup() && this.getVisible() && this.getEnabled()) {
            return new Control[]{this};
        }
        return new Control[0];
    }

    Control computeTabRoot() {
        Control[] tabList = this.parent._getTabList();
        if (tabList != null) {
            int index = 0;
            while (index < tabList.length) {
                if (tabList[index] == this) break;
                ++index;
            }
            if (index == tabList.length && this.isTabGroup()) {
                return this;
            }
        }
        return this.parent.computeTabRoot();
    }

    void createWidget() {
        this.checkOrientation(this.parent);
        super.createWidget();
        this.setDefaultFont();
        this.setZOrder();
    }

    Color defaultBackground() {
        return this.display.getSystemColor(22);
    }

    Font defaultFont() {
        byte[] family = new byte[256];
        short[] size = new short[1];
        byte[] style = new byte[1];
        OS.GetThemeFont((short)((short)this.defaultThemeFont()), (short)-1, (byte[])family, (short[])size, (byte[])style);
        short id = OS.FMGetFontFamilyFromName((byte[])family);
        int[] font = new int[1];
        OS.FMGetFontFromFontFamilyInstance((short)id, (short)style[0], (int[])font, null);
        return Font.carbon_new(this.display, font[0], id, style[0], size[0]);
    }

    Color defaultForeground() {
        return this.display.getSystemColor(21);
    }

    int defaultThemeFont() {
        if (this.display.smallFonts) {
            return 1;
        }
        return 0;
    }

    void deregister() {
        super.deregister();
        this.display.removeWidget(this.handle);
    }

    void destroyWidget() {
        int theControl = this.topHandle();
        this.releaseHandle();
        if (theControl != 0) {
            OS.DisposeControl((int)theControl);
        }
    }

    boolean drawFocusRing() {
        return !this.display.noFocusRing || this.getShell().parent != null;
    }

    boolean drawGripper(int x, int y, int width, int height) {
        return false;
    }

    void drawWidget(int control, int damageRgn, int visibleRgn, int theEvent) {
        if (control != this.handle) {
            return;
        }
        if (!this.hooks(9) && !this.filters(9)) {
            return;
        }
        Rect rect = new Rect();
        OS.GetRegionBounds((int)visibleRgn, (Rect)rect);
        Rect bounds = new Rect();
        OS.GetControlBounds((int)this.handle, (Rect)bounds);
        OS.OffsetRect((Rect)rect, (short)(-bounds.left), (short)(-bounds.top));
        int[] port = new int[1];
        OS.GetPort((int[])port);
        GCData data = new GCData();
        data.port = port[0];
        data.paintEvent = theEvent;
        data.visibleRgn = visibleRgn;
        GC gc = GC.carbon_new(this, data);
        Event event = new Event();
        event.gc = gc;
        event.x = rect.left;
        event.y = rect.top;
        event.width = rect.right - rect.left;
        event.height = rect.bottom - rect.top;
        this.sendEvent(9, event);
        event.gc = null;
        gc.dispose();
    }

    void enableWidget(boolean enabled) {
        int topHandle = this.topHandle();
        if (enabled) {
            OS.EnableControl((int)topHandle);
        } else {
            OS.DisableControl((int)topHandle);
        }
    }

    Cursor findCursor() {
        if (this.cursor != null) {
            return this.cursor;
        }
        return this.parent.findCursor();
    }

    void fixFocus(Control focusControl) {
        Shell shell = this.getShell();
        Control control = this;
        while ((control = control.parent) != null) {
            if (control.setFocus()) {
                return;
            }
            if (control == shell) break;
        }
        shell.setSavedFocus(focusControl);
        int window = OS.GetControlOwner((int)this.handle);
        OS.ClearKeyboardFocus((int)window);
    }

    public boolean forceFocus() {
        this.checkWidget();
        Decorations shell = this.menuShell();
        shell.setSavedFocus(this);
        if (!this.isEnabled() || !this.isVisible()) {
            return false;
        }
        if (this.isFocusControl()) {
            return true;
        }
        shell.setSavedFocus(null);
        shell.bringToTop(false);
        if (this.isDisposed()) {
            return false;
        }
        int window = OS.GetControlOwner((int)this.handle);
        OS.SetKeyboardFocus((int)window, (int)this.handle, (short)-1);
        if (this.isDisposed()) {
            return false;
        }
        shell.setSavedFocus(this);
        return this.hasFocus();
    }

    public Accessible getAccessible() {
        this.checkWidget();
        if (this.accessible == null) {
            this.accessible = Accessible.internal_new_Accessible(this);
        }
        return this.accessible;
    }

    public Color getBackground() {
        this.checkWidget();
        if (this.background == null) {
            return this.defaultBackground();
        }
        return Color.carbon_new(this.display, this.background);
    }

    public int getBorderWidth() {
        this.checkWidget();
        return 0;
    }

    public Rectangle getBounds() {
        this.checkWidget();
        Rect rect = this.getControlBounds(this.topHandle());
        return new Rectangle(rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top);
    }

    int getDrawCount(int control) {
        if (!this.isTrimHandle(control) && this.drawCount > 0) {
            return this.drawCount;
        }
        return this.parent.getDrawCount(control);
    }

    public boolean getEnabled() {
        this.checkWidget();
        return (this.state & 8) == 0;
    }

    public Font getFont() {
        this.checkWidget();
        return this.font != null ? this.font : this.defaultFont();
    }

    public Color getForeground() {
        this.checkWidget();
        if (this.foreground == null) {
            return this.defaultForeground();
        }
        return Color.carbon_new(this.display, this.foreground);
    }

    public Object getLayoutData() {
        this.checkWidget();
        return this.layoutData;
    }

    public org.eclipse.swt.graphics.Point getLocation() {
        this.checkWidget();
        Rect rect = this.getControlBounds(this.topHandle());
        return new org.eclipse.swt.graphics.Point(rect.left, rect.top);
    }

    public Menu getMenu() {
        this.checkWidget();
        return this.menu;
    }

    public Monitor getMonitor() {
        this.checkWidget();
        Monitor[] monitors = this.display.getMonitors();
        if (monitors.length == 1) {
            return monitors[0];
        }
        int index = -1;
        int value = -1;
        Rectangle bounds = this.getBounds();
        if (this != this.getShell()) {
            bounds = this.display.map((Control)this.parent, null, bounds);
        }
        int i = 0;
        while (i < monitors.length) {
            Rectangle rect = bounds.intersection(monitors[i].getBounds());
            int area = rect.width * rect.height;
            if (area > 0 && area > value) {
                index = i;
                value = area;
            }
            ++i;
        }
        if (index >= 0) {
            return monitors[index];
        }
        int centerX = bounds.x + bounds.width / 2;
        int centerY = bounds.y + bounds.height / 2;
        int i2 = 0;
        while (i2 < monitors.length) {
            int x;
            Rectangle rect = monitors[i2].getBounds();
            int n = centerX < rect.x ? rect.x - centerX : (x = centerX > rect.x + rect.width ? centerX - rect.x - rect.width : 0);
            int y = centerY < rect.y ? rect.y - centerY : (centerY > rect.y + rect.height ? centerY - rect.y - rect.height : 0);
            int distance = x * x + y * y;
            if (index == -1 || distance < value) {
                index = i2;
                value = distance;
            }
            ++i2;
        }
        return monitors[index];
    }

    public Composite getParent() {
        this.checkWidget();
        return this.parent;
    }

    float[] getParentBackground() {
        return this.parent.background;
    }

    Control[] getPath() {
        int count = 0;
        Shell shell = this.getShell();
        Control control = this;
        while (control != shell) {
            ++count;
            control = control.parent;
        }
        control = this;
        Control[] result = new Control[count];
        while (control != shell) {
            result[--count] = control;
            control = control.parent;
        }
        return result;
    }

    public Shell getShell() {
        this.checkWidget();
        return this.parent.getShell();
    }

    public org.eclipse.swt.graphics.Point getSize() {
        this.checkWidget();
        Rect rect = this.getControlSize(this.topHandle());
        return new org.eclipse.swt.graphics.Point(rect.right - rect.left, rect.bottom - rect.top);
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    public boolean getVisible() {
        this.checkWidget();
        return (this.state & 0x10) == 0;
    }

    int getVisibleRegion(int control, boolean clipChildren) {
        if (!clipChildren) {
            return super.getVisibleRegion(control, clipChildren);
        }
        if (this.visibleRgn == 0) {
            this.visibleRgn = OS.NewRgn();
            this.calculateVisibleRegion(control, this.visibleRgn, clipChildren);
        }
        int result = OS.NewRgn();
        OS.CopyRgn((int)this.visibleRgn, (int)result);
        return result;
    }

    boolean hasFocus() {
        return this == this.display.getFocusControl();
    }

    int helpProc(int inControl, int inGlobalMouse, int inRequest, int outContentProvided, int ioHelpContent) {
        switch (inRequest) {
            case 0: {
                int[] contentProvided = new int[]{-2};
                if (this.toolTipText != null && this.toolTipText.length() != 0) {
                    char[] buffer = new char[this.toolTipText.length()];
                    this.toolTipText.getChars(0, buffer.length, buffer, 0);
                    int length = this.fixMnemonic(buffer);
                    if (this.display.helpString != 0) {
                        OS.CFRelease((int)this.display.helpString);
                    }
                    this.display.helpString = OS.CFStringCreateWithCharacters((int)0, (char[])buffer, (int)length);
                    HMHelpContentRec helpContent = new HMHelpContentRec();
                    OS.memcpy((HMHelpContentRec)helpContent, (int)ioHelpContent, (int)534);
                    helpContent.version = 3;
                    int cursorHeight = 16;
                    helpContent.tagSide = (short)23;
                    int x = inGlobalMouse & 0xFFFF;
                    int y = inGlobalMouse >> 16;
                    if (this.display.helpControl != this) {
                        this.display.lastHelpX = x + cursorHeight / 2;
                        this.display.lastHelpY = y + cursorHeight + cursorHeight / 2;
                    }
                    int jitter = 4;
                    int deltaX = Math.abs(this.display.lastHelpX - x) + jitter;
                    int deltaY = Math.abs(this.display.lastHelpY - y) + jitter;
                    x = this.display.lastHelpX - deltaX;
                    y = this.display.lastHelpY - deltaY;
                    int width = deltaX * 2;
                    int height = deltaY * 2;
                    this.display.helpControl = this;
                    helpContent.absHotRect_left = (short)x;
                    helpContent.absHotRect_top = (short)y;
                    helpContent.absHotRect_right = (short)(x + width);
                    helpContent.absHotRect_bottom = (short)(y + height);
                    helpContent.content0_contentType = 1667658612;
                    helpContent.content0_tagCFString = this.display.helpString;
                    helpContent.content1_contentType = 1667658612;
                    helpContent.content1_tagCFString = this.display.helpString;
                    OS.memcpy((int)ioHelpContent, (HMHelpContentRec)helpContent, (int)534);
                    contentProvided[0] = 0;
                }
                OS.memcpy((int)outContentProvided, (int[])contentProvided, (int)4);
                break;
            }
            case 1: {
                if (this.display.helpString != 0) {
                    OS.CFRelease((int)this.display.helpString);
                }
                this.display.helpString = 0;
            }
        }
        return 0;
    }

    void hookEvents() {
        super.hookEvents();
        int controlProc = this.display.controlProc;
        int[] mask = new int[]{1668183148, 9, 1668183148, 5, 1668183148, 154, 1668183148, 13, 1668183148, 12, 1668183148, 10, 1668183148, 4, 1668183148, 1, 1668183148, 11, 1668183148, 7, 1668183148, 51};
        int controlTarget = OS.GetControlEventTarget((int)this.handle);
        OS.InstallEventHandler((int)controlTarget, (int)controlProc, (int)(mask.length / 2), (int[])mask, (int)this.handle, null);
        int helpProc = this.display.helpProc;
        OS.HMInstallControlContentCallback((int)this.handle, (int)helpProc);
        int colorProc = this.display.colorProc;
        OS.SetControlColorProc((int)this.handle, (int)colorProc);
    }

    public int internal_new_GC(GCData data) {
        int port;
        this.checkWidget();
        int n = port = data != null ? data.port : 0;
        if (port == 0) {
            int window = OS.GetControlOwner((int)this.handle);
            port = OS.GetWindowPort((int)window);
        }
        int[] buffer = new int[1];
        OS.CreateCGContextForPort((int)port, (int[])buffer);
        int context = buffer[0];
        if (context == 0) {
            SWT.error(2);
        }
        int visibleRgn = 0;
        visibleRgn = data != null && data.paintEvent != 0 ? data.visibleRgn : (this.getDrawCount(this.handle) > 0 ? OS.NewRgn() : this.getVisibleRegion(this.handle, true));
        Rect rect = new Rect();
        Rect portRect = new Rect();
        OS.GetControlBounds((int)this.handle, (Rect)rect);
        OS.GetPortBounds((int)port, (Rect)portRect);
        OS.ClipCGContextToRegion((int)context, (Rect)portRect, (int)visibleRgn);
        int portHeight = portRect.bottom - portRect.top;
        OS.CGContextScaleCTM((int)context, (float)1.0f, (float)-1.0f);
        OS.CGContextTranslateCTM((int)context, (float)rect.left, (float)(-portHeight + rect.top));
        if (data != null) {
            int mask = 0x6000000;
            if ((data.style & mask) == 0) {
                data.style |= this.style & (mask | 0x8000000);
            }
            data.device = this.display;
            data.thread = this.display.thread;
            data.background = this.background != null ? this.background : this.defaultBackground().handle;
            data.foreground = this.foreground != null ? this.foreground : this.defaultForeground().handle;
            data.font = this.font != null ? this.font : this.defaultFont();
            data.visibleRgn = visibleRgn;
            data.control = this.handle;
            data.portRect = portRect;
            data.controlRect = rect;
            if (data.paintEvent == 0) {
                if (this.gcs == null) {
                    this.gcs = new GCData[4];
                }
                int index = 0;
                while (index < this.gcs.length && this.gcs[index] != null) {
                    ++index;
                }
                if (index == this.gcs.length) {
                    GCData[] newGCs = new GCData[this.gcs.length + 4];
                    System.arraycopy(this.gcs, 0, newGCs, 0, this.gcs.length);
                    this.gcs = newGCs;
                }
                this.gcs[index] = data;
            }
        }
        return context;
    }

    public void internal_dispose_GC(int context, GCData data) {
        this.checkWidget();
        if (data != null && data.paintEvent == 0) {
            if (data.visibleRgn != 0) {
                OS.DisposeRgn((int)data.visibleRgn);
                data.visibleRgn = 0;
            }
            int index = 0;
            while (index < this.gcs.length && this.gcs[index] != data) {
                ++index;
            }
            if (index < this.gcs.length) {
                this.gcs[index] = null;
                index = 0;
                while (index < this.gcs.length && this.gcs[index] == null) {
                    ++index;
                }
                if (index == this.gcs.length) {
                    this.gcs = null;
                }
            }
        }
        OS.CGContextSynchronize((int)context);
        OS.CGContextRelease((int)context);
    }

    void invalidateChildrenVisibleRegion(int control) {
    }

    void invalidateVisibleRegion(int control) {
        int index = 0;
        Control[] siblings = this.parent._getChildren();
        while (index < siblings.length && siblings[index] != this) {
            ++index;
        }
        int i = index;
        while (i < siblings.length) {
            Control sibling = siblings[i];
            sibling.resetVisibleRegion(control);
            sibling.invalidateChildrenVisibleRegion(control);
            ++i;
        }
        this.parent.resetVisibleRegion(control);
    }

    void invalWindowRgn(int window, int rgn) {
        this.parent.invalWindowRgn(window, rgn);
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled() && this.parent.isEnabled();
    }

    boolean isEnabledCursor() {
        return this.isEnabled();
    }

    boolean isEnabledModal() {
        Shell[] shells = this.display.getShells();
        int i = 0;
        while (i < shells.length) {
            Shell modal = shells[i];
            if (modal != this && modal.isVisible()) {
                Shell shell;
                if ((modal.style & 0x8000) != 0 && modal.parent == (shell = this.getShell())) {
                    return false;
                }
                int bits = 196608;
                if ((modal.style & bits) != 0) {
                    Control control = this;
                    while (control != null) {
                        if (control == modal) break;
                        control = control.parent;
                    }
                    if (control != modal) {
                        return false;
                    }
                }
            }
            ++i;
        }
        return true;
    }

    boolean isFocusAncestor(Control control) {
        while (control != null && control != this) {
            control = control.parent;
        }
        return control == this;
    }

    public boolean isFocusControl() {
        this.checkWidget();
        return this.hasFocus();
    }

    public boolean isReparentable() {
        this.checkWidget();
        return false;
    }

    boolean isShowing() {
        if (!this.isVisible()) {
            return false;
        }
        Control control = this;
        while (control != null) {
            org.eclipse.swt.graphics.Point size = control.getSize();
            if (size.x == 0 || size.y == 0) {
                return false;
            }
            control = control.parent;
        }
        return true;
    }

    boolean isTabGroup() {
        int code;
        Control[] tabList = this.parent._getTabList();
        if (tabList != null) {
            int i = 0;
            while (i < tabList.length) {
                if (tabList[i] == this) {
                    return true;
                }
                ++i;
            }
        }
        if (((code = this.traversalCode(0, 0)) & 0x60) != 0) {
            return false;
        }
        return (code & 0x18) != 0;
    }

    boolean isTabItem() {
        int code;
        Control[] tabList = this.parent._getTabList();
        if (tabList != null) {
            int i = 0;
            while (i < tabList.length) {
                if (tabList[i] == this) {
                    return false;
                }
                ++i;
            }
        }
        return ((code = this.traversalCode(0, 0)) & 0x60) != 0;
    }

    public boolean isVisible() {
        this.checkWidget();
        return OS.IsControlVisible((int)this.topHandle());
    }

    Decorations menuShell() {
        return this.parent.menuShell();
    }

    int kEventControlContextualMenuClick(int nextHandler, int theEvent, int userData) {
        int sizeof = 4;
        Point pt = new Point();
        OS.GetEventParameter((int)theEvent, (int)1835822947, (int)1363439732, null, (int)sizeof, null, (Point)pt);
        Rect rect = new Rect();
        int window = OS.GetControlOwner((int)this.handle);
        OS.GetWindowBounds((int)window, (short)33, (Rect)rect);
        int x = pt.h + rect.left;
        int y = pt.v + rect.top;
        Event event = new Event();
        event.x = x;
        event.y = y;
        this.sendEvent(35, event);
        if (event.doit && this.menu != null && !this.menu.isDisposed()) {
            if (event.x != x || event.y != y) {
                this.menu.setLocation(event.x, event.y);
            }
            this.menu.setVisible(true);
        }
        return -9874;
    }

    int kEventControlSetCursor(int nextHandler, int theEvent, int userData) {
        if (!this.isEnabledCursor()) {
            return 0;
        }
        Cursor cursor = null;
        if (this.isEnabledModal() && (cursor = this.findCursor()) != null) {
            this.display.setCursor(cursor.handle);
        }
        return cursor != null ? 0 : -9874;
    }

    int kEventControlSetFocusPart(int nextHandler, int theEvent, int userData) {
        if (!this.display.ignoreFocus) {
            short[] part = new short[1];
            OS.GetEventParameter((int)theEvent, (int)1668313716, (int)1668313716, null, (int)2, null, (short[])part);
            Display display = this.display;
            if (part[0] != 0) {
                display.focusControl = this;
            }
            this.sendFocusEvent(part[0] != 0, false);
            if (part[0] != 0) {
                display.focusControl = null;
            }
            if (this.isDisposed()) {
                return 0;
            }
        }
        return -9874;
    }

    int kEventControlTrack(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventMouseDown(int nextHandler, int theEvent, int userData) {
        Shell shell = this.getShell();
        short[] button = new short[1];
        OS.GetEventParameter((int)theEvent, (int)1835168878, (int)1835168878, null, (int)2, null, (short[])button);
        int[] clickCount = new int[1];
        OS.GetEventParameter((int)theEvent, (int)1667460724, (int)1835100014, null, (int)4, null, (int[])clickCount);
        this.sendMouseEvent(3, button[0], theEvent);
        if (clickCount[0] == 2) {
            this.sendMouseEvent(8, button[0], theEvent);
        }
        if ((this.state & 0x20) != 0) {
            this.display.grabControl = this;
        }
        if (!shell.isDisposed()) {
            shell.setActiveControl(this);
        }
        if (this.hooks(29)) {
            Point pt = new Point();
            int sizeof = 4;
            OS.GetEventParameter((int)theEvent, (int)1835822947, (int)1363439732, null, (int)sizeof, null, (Point)pt);
            this.display.dragMouseStart = pt;
            this.display.dragging = false;
        }
        return -9874;
    }

    int kEventMouseDragged(int nextHandler, int theEvent, int userData) {
        if ((this.state & 2) == 0) {
            if (this.isEnabledModal()) {
                this.sendMouseEvent(5, (short)0, theEvent);
            }
            this.display.dragDetect(this);
        }
        return -9874;
    }

    int kEventMouseMoved(int nextHandler, int theEvent, int userData) {
        if (this.isEnabledModal()) {
            this.sendMouseEvent(5, (short)0, theEvent);
        }
        return -9874;
    }

    int kEventMouseUp(int nextHandler, int theEvent, int userData) {
        short[] button = new short[1];
        OS.GetEventParameter((int)theEvent, (int)1835168878, (int)1835168878, null, (int)2, null, (short[])button);
        this.sendMouseEvent(4, button[0], theEvent);
        return -9874;
    }

    int kEventRawKey(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventRawKeyDown(int nextHandler, int theEvent, int userData) {
        return this.kEventRawKey(nextHandler, theEvent, userData);
    }

    int kEventRawKeyModifiersChanged(int nextHandler, int theEvent, int userData) {
        Event event;
        Display display = this.display;
        int[] modifiers = new int[1];
        OS.GetEventParameter((int)theEvent, (int)1802334052, (int)1835100014, null, (int)(modifiers.length * 4), null, (int[])modifiers);
        int lastModifiers = display.lastModifiers;
        int chord = OS.GetCurrentEventButtonState();
        int type = 2;
        if ((modifiers[0] & 0x400) != 0 && (lastModifiers & 0x400) == 0) {
            type = 1;
        }
        if ((modifiers[0] & 0x200) != 0 && (lastModifiers & 0x200) == 0) {
            type = 1;
        }
        if ((modifiers[0] & 0x1000) != 0 && (lastModifiers & 0x1000) == 0) {
            type = 1;
        }
        if ((modifiers[0] & 0x100) != 0 && (lastModifiers & 0x100) == 0) {
            type = 1;
        }
        if ((modifiers[0] & 0x800) != 0 && (lastModifiers & 0x800) == 0) {
            type = 1;
        }
        if (type == 2 && (modifiers[0] & 0x400) == 0 && (lastModifiers & 0x400) != 0) {
            event = new Event();
            event.keyCode = 16777298;
            this.setInputState(event, 1, chord, modifiers[0]);
            this.sendKeyEvent(1, event);
        }
        event = new Event();
        this.setInputState(event, type, chord, modifiers[0]);
        if (event.keyCode == 0 && event.character == '\u0000') {
            return -9874;
        }
        boolean result = this.sendKeyEvent(type, event);
        if (type == 1 && (modifiers[0] & 0x400) != 0 && (lastModifiers & 0x400) == 0) {
            event = new Event();
            event.keyCode = 16777298;
            this.setInputState(event, 2, chord, modifiers[0]);
            this.sendKeyEvent(2, event);
        }
        display.lastModifiers = modifiers[0];
        return result ? -9874 : 0;
    }

    int kEventRawKeyRepeat(int nextHandler, int theEvent, int userData) {
        return this.kEventRawKey(nextHandler, theEvent, userData);
    }

    int kEventRawKeyUp(int nextHandler, int theEvent, int userData) {
        if (!this.sendKeyEvent(2, theEvent)) {
            return 0;
        }
        return -9874;
    }

    int kEventTextInputUnicodeForKeyEvent(int nextHandler, int theEvent, int userData) {
        int[] keyboardEvent = new int[1];
        OS.GetEventParameter((int)theEvent, (int)1953721189, (int)1702261350, null, (int)(keyboardEvent.length * 4), null, (int[])keyboardEvent);
        int[] keyCode = new int[1];
        OS.GetEventParameter((int)keyboardEvent[0], (int)1801678692, (int)1835100014, null, (int)(keyCode.length * 4), null, (int[])keyCode);
        if (this.translateTraversal(keyCode[0], keyboardEvent[0])) {
            return 0;
        }
        if (keyCode[0] == 114) {
            Control control = this;
            while (control != null) {
                if (control.hooks(28)) {
                    control.postEvent(28);
                    break;
                }
                control = control.parent;
            }
        }
        if (!this.sendKeyEvent(1, keyboardEvent[0])) {
            return 0;
        }
        return -9874;
    }

    public void moveAbove(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (this.parent != control.parent) {
                return;
            }
        }
        this.setZOrder(control, true);
    }

    public void moveBelow(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (this.parent != control.parent) {
                return;
            }
        }
        this.setZOrder(control, false);
    }

    public void pack() {
        this.checkWidget();
        this.pack(true);
    }

    public void pack(boolean changed) {
        this.checkWidget();
        this.setSize(this.computeSize(-1, -1, changed));
    }

    public void redraw() {
        this.checkWidget();
        this.redrawWidget(this.handle, false);
    }

    public void redraw(int x, int y, int width, int height, boolean all) {
        this.checkWidget();
        this.redrawWidget(this.handle, x, y, width, height, all);
    }

    void register() {
        super.register();
        this.display.addWidget(this.handle, this);
    }

    void releaseChild() {
        super.releaseChild();
        this.setVisible(this.topHandle(), false);
    }

    void releaseHandle() {
        super.releaseHandle();
        this.handle = 0;
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.menu != null && !this.menu.isDisposed()) {
            this.menu.dispose();
        }
        if (this.visibleRgn != 0) {
            OS.DisposeRgn((int)this.visibleRgn);
        }
        this.visibleRgn = 0;
        this.menu = null;
        this.parent = null;
        this.layoutData = null;
    }

    public void removeControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(10, listener);
        this.eventTable.unhook(11, listener);
    }

    public void removeFocusListener(FocusListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(15, listener);
        this.eventTable.unhook(16, listener);
    }

    public void removeHelpListener(HelpListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(28, listener);
    }

    public void removeKeyListener(KeyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(2, listener);
        this.eventTable.unhook(1, listener);
    }

    public void removeMouseListener(MouseListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(3, listener);
        this.eventTable.unhook(4, listener);
        this.eventTable.unhook(8, listener);
    }

    public void removeMouseMoveListener(MouseMoveListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(5, listener);
    }

    public void removeMouseTrackListener(MouseTrackListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(6, listener);
        this.eventTable.unhook(7, listener);
        this.eventTable.unhook(32, listener);
    }

    public void removePaintListener(PaintListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(9, listener);
    }

    public void removeTraverseListener(TraverseListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(31, listener);
    }

    void resetVisibleRegion(int control) {
        if (this.visibleRgn != 0) {
            OS.DisposeRgn((int)this.visibleRgn);
            this.visibleRgn = 0;
        }
        if (this.gcs != null) {
            int visibleRgn = this.getVisibleRegion(this.handle, true);
            int i = 0;
            while (i < this.gcs.length) {
                GCData data = this.gcs[i];
                if (data != null) {
                    data.updateClip = true;
                    OS.CopyRgn((int)visibleRgn, (int)data.visibleRgn);
                }
                ++i;
            }
            OS.DisposeRgn((int)visibleRgn);
        }
    }

    void sendFocusEvent(boolean focusIn, boolean post) {
        Shell shell = this.getShell();
        if (post) {
            this.postEvent(focusIn ? 15 : 16);
        } else {
            this.sendEvent(focusIn ? 15 : 16);
        }
        if (!shell.isDisposed()) {
            if (focusIn) {
                shell.setActiveControl(this);
            } else {
                Display display = shell.display;
                Control control = display.getFocusControl();
                if (control == null || shell != control.getShell()) {
                    shell.setActiveControl(null);
                }
            }
        }
    }

    boolean sendKeyEvent(int type, int theEvent) {
        int[] length = new int[1];
        int status = OS.GetEventParameter((int)theEvent, (int)1802858089, (int)1970567284, null, (int)4, (int[])length, null);
        if (status == 0 && length[0] > 2) {
            int count = 0;
            int[] chord = new int[1];
            OS.GetEventParameter((int)theEvent, (int)1667788658, (int)1835100014, null, (int)4, null, (int[])chord);
            int[] modifiers = new int[1];
            OS.GetEventParameter((int)theEvent, (int)1802334052, (int)1835100014, null, (int)4, null, (int[])modifiers);
            char[] chars = new char[length[0] / 2];
            OS.GetEventParameter((int)theEvent, (int)1802858089, (int)1970567284, null, (int)(chars.length * 2), null, (char[])chars);
            int i = 0;
            while (i < chars.length) {
                Event event = new Event();
                event.character = chars[i];
                this.setInputState(event, type, chord[0], modifiers[0]);
                if (this.sendKeyEvent(type, event)) {
                    chars[count++] = chars[i];
                }
                ++i;
            }
            if (count == 0) {
                return false;
            }
            if (count != chars.length - 1) {
                OS.SetEventParameter((int)theEvent, (int)1802858089, (int)1970567284, (int)(count * 2), (char[])chars);
            }
            return true;
        }
        Event event = new Event();
        if (!this.setKeyState(event, type, theEvent)) {
            return true;
        }
        return this.sendKeyEvent(type, event);
    }

    boolean sendKeyEvent(int type, Event event) {
        this.sendEvent(type, event);
        if (this.isDisposed()) {
            return false;
        }
        return event.doit;
    }

    boolean sendMouseEvent(int type, short button, int theEvent) {
        int sizeof = 4;
        Point pt = new Point();
        OS.GetEventParameter((int)theEvent, (int)1835822947, (int)1363439732, null, (int)sizeof, null, (Point)pt);
        Rect rect = new Rect();
        int window = OS.GetControlOwner((int)this.handle);
        OS.GetWindowBounds((int)window, (short)33, (Rect)rect);
        int x = pt.h - rect.left;
        int y = pt.v - rect.top;
        OS.GetControlBounds((int)this.handle, (Rect)rect);
        x -= rect.left;
        y -= rect.top;
        int[] chord = new int[1];
        OS.GetEventParameter((int)theEvent, (int)1667788658, (int)1835100014, null, (int)4, null, (int[])chord);
        int[] modifiers = new int[1];
        OS.GetEventParameter((int)theEvent, (int)1802334052, (int)1835100014, null, (int)4, null, (int[])modifiers);
        return this.sendMouseEvent(type, button, chord[0], (short)x, (short)y, modifiers[0], false);
    }

    boolean sendMouseEvent(int type, short button, int chord, short x, short y, int modifiers, boolean send) {
        Event event = new Event();
        switch (button) {
            case 1: {
                event.button = 1;
                break;
            }
            case 2: {
                event.button = 3;
                break;
            }
            case 3: {
                event.button = 2;
            }
        }
        event.x = x;
        event.y = y;
        this.setInputState(event, type, chord, modifiers);
        this.sendEvent(type, event, send);
        return true;
    }

    public void setBackground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        this.background = color != null ? color.handle : null;
        this.setBackground(this.background);
        this.redrawWidget(this.handle, false);
    }

    void setBackground(float[] color) {
        ControlFontStyleRec fontStyle = new ControlFontStyleRec();
        OS.GetControlData((int)this.handle, (short)0, (int)1718578804, (int)24, (ControlFontStyleRec)fontStyle, null);
        if (color != null) {
            fontStyle.backColor_red = (short)(color[0] * 65535.0f);
            fontStyle.backColor_green = (short)(color[1] * 65535.0f);
            fontStyle.backColor_blue = (short)(color[2] * 65535.0f);
            fontStyle.flags = (short)(fontStyle.flags | 0x10);
        } else {
            fontStyle.flags = (short)(fontStyle.flags & 0xFFFFFFEF);
        }
        OS.SetControlFontStyle((int)this.handle, (ControlFontStyleRec)fontStyle);
    }

    public void setBounds(int x, int y, int width, int height) {
        this.checkWidget();
        this.setBounds(this.topHandle(), x, y, width, height, true, true, true);
    }

    public void setBounds(Rectangle rect) {
        if (rect == null) {
            this.error(4);
        }
        this.setBounds(rect.x, rect.y, rect.width, rect.height);
    }

    public void setCapture(boolean capture) {
        this.checkWidget();
    }

    public void setCursor(Cursor cursor) {
        this.checkWidget();
        if (cursor != null && cursor.isDisposed()) {
            this.error(5);
        }
        this.cursor = cursor;
        if (!this.isEnabled()) {
            return;
        }
        Point where = new Point();
        OS.GetGlobalMouse((Point)where);
        int[] theWindow = new int[1];
        if (this.display.grabControl == this) {
            theWindow[0] = OS.GetControlOwner((int)this.handle);
        } else {
            if (OS.FindWindow((Point)where, (int[])theWindow) != 3) {
                return;
            }
            if (theWindow[0] == 0) {
                return;
            }
        }
        Rect rect = new Rect();
        OS.GetWindowBounds((int)theWindow[0], (short)33, (Rect)rect);
        int[] theControl = new int[1];
        if (this.display.grabControl == this) {
            theControl[0] = this.handle;
        } else {
            Control control;
            Widget widget;
            CGPoint inPoint = new CGPoint();
            inPoint.x = where.h - rect.left;
            inPoint.y = where.v - rect.top;
            int[] theRoot = new int[1];
            OS.GetRootControl((int)theWindow[0], (int[])theRoot);
            OS.HIViewGetSubviewHit((int)theRoot[0], (CGPoint)inPoint, (boolean)true, (int[])theControl);
            int cursorControl = theControl[0];
            while (theControl[0] != 0 && theControl[0] != this.handle) {
                OS.GetSuperControl((int)theControl[0], (int[])theControl);
            }
            if (theControl[0] == 0) {
                return;
            }
            theControl[0] = cursorControl;
            while ((widget = this.display.getWidget(theControl[0])) == null || !(widget instanceof Control) || !(control = (Control)widget).isEnabled()) {
                OS.GetSuperControl((int)theControl[0], (int[])theControl);
                if (theControl[0] != 0) continue;
            }
            if (theControl[0] == 0) {
                theControl[0] = theRoot[0];
                widget = this.display.getWidget(theControl[0]);
                if (widget != null && widget instanceof Control) {
                    control = (Control)widget;
                    theControl[0] = control.handle;
                }
            }
        }
        where.h = (short)(where.h - rect.left);
        where.v = (short)(where.v - rect.top);
        int modifiers = OS.GetCurrentEventKeyModifiers();
        boolean[] cursorWasSet = new boolean[1];
        OS.HandleControlSetCursor((int)theControl[0], (Point)where, (int)((short)modifiers), (boolean[])cursorWasSet);
        if (!cursorWasSet[0]) {
            OS.SetThemeCursor((int)0);
        }
    }

    void setDefaultFont() {
        if (this.display.smallFonts) {
            this.setFontStyle(this.defaultFont());
        }
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        if ((this.state & 8) == 0 == enabled) {
            return;
        }
        Control control = null;
        boolean fixFocus = false;
        if (!enabled) {
            control = this.display.getFocusControl();
            fixFocus = this.isFocusAncestor(control);
        }
        this.state = enabled ? (this.state &= 0xFFFFFFF7) : (this.state |= 8);
        this.enableWidget(enabled);
        if (fixFocus) {
            this.fixFocus(control);
        }
    }

    public boolean setFocus() {
        this.checkWidget();
        if ((this.style & 0x80000) != 0) {
            return false;
        }
        return this.forceFocus();
    }

    public void setFont(Font font) {
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        this.font = font;
        this.setFontStyle(font);
        this.redrawWidget(this.handle, false);
    }

    void setFontStyle(Font font) {
        ControlFontStyleRec fontStyle = new ControlFontStyleRec();
        OS.GetControlData((int)this.handle, (short)0, (int)1718578804, (int)24, (ControlFontStyleRec)fontStyle, null);
        if (font != null) {
            fontStyle.flags = (short)(fontStyle.flags | 7);
            fontStyle.font = font.id;
            fontStyle.style = font.style;
            fontStyle.size = font.size;
        } else {
            fontStyle.flags = (short)(fontStyle.flags | 0x80);
            fontStyle.font = (short)this.defaultThemeFont();
        }
        OS.SetControlFontStyle((int)this.handle, (ControlFontStyleRec)fontStyle);
    }

    public void setForeground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        this.foreground = color != null ? color.handle : null;
        this.setForeground(this.foreground);
        this.redrawWidget(this.handle, false);
    }

    void setForeground(float[] color) {
        ControlFontStyleRec fontStyle = new ControlFontStyleRec();
        OS.GetControlData((int)this.handle, (short)0, (int)1718578804, (int)24, (ControlFontStyleRec)fontStyle, null);
        if (color != null) {
            fontStyle.foreColor_red = (short)(color[0] * 65535.0f);
            fontStyle.foreColor_green = (short)(color[1] * 65535.0f);
            fontStyle.foreColor_blue = (short)(color[2] * 65535.0f);
            fontStyle.flags = (short)(fontStyle.flags | 8);
        } else {
            fontStyle.flags = (short)(fontStyle.flags & 0xFFFFFFF7);
        }
        OS.SetControlFontStyle((int)this.handle, (ControlFontStyleRec)fontStyle);
    }

    public void setLayoutData(Object layoutData) {
        this.checkWidget();
        this.layoutData = layoutData;
    }

    public void setLocation(int x, int y) {
        this.checkWidget();
        this.setBounds(this.topHandle(), x, y, 0, 0, true, false, true);
    }

    public void setLocation(org.eclipse.swt.graphics.Point location) {
        if (location == null) {
            this.error(4);
        }
        this.setLocation(location.x, location.y);
    }

    public void setMenu(Menu menu) {
        this.checkWidget();
        if (menu != null) {
            if (menu.isDisposed()) {
                SWT.error(5);
            }
            if ((menu.style & 8) == 0) {
                this.error(37);
            }
            if (menu.parent != this.menuShell()) {
                this.error(32);
            }
        }
        this.menu = menu;
    }

    public boolean setParent(Composite parent) {
        this.checkWidget();
        if (parent.isDisposed()) {
            SWT.error(5);
        }
        return false;
    }

    public void setRedraw(boolean redraw) {
        this.checkWidget();
        if (redraw) {
            if (--this.drawCount == 0) {
                this.invalidateVisibleRegion(this.handle);
                this.redrawWidget(this.handle, true);
            }
        } else {
            if (this.drawCount == 0) {
                this.invalidateVisibleRegion(this.handle);
            }
            ++this.drawCount;
        }
    }

    boolean setRadioSelection(boolean value) {
        return false;
    }

    public void setSize(int width, int height) {
        this.checkWidget();
        this.setBounds(this.topHandle(), 0, 0, width, height, false, true, true);
    }

    public void setSize(org.eclipse.swt.graphics.Point size) {
        if (size == null) {
            this.error(4);
        }
        this.setSize(size.x, size.y);
    }

    boolean setTabGroupFocus() {
        return this.setTabItemFocus();
    }

    boolean setTabItemFocus() {
        if (!this.isShowing()) {
            return false;
        }
        return this.forceFocus();
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        this.toolTipText = string;
    }

    public void setVisible(boolean visible) {
        this.checkWidget();
        if (visible) {
            if ((this.state & 0x10) == 0) {
                return;
            }
            this.state &= 0xFFFFFFEF;
        } else {
            if ((this.state & 0x10) != 0) {
                return;
            }
            this.state |= 0x10;
        }
        if (visible) {
            this.sendEvent(22);
            if (this.isDisposed()) {
                return;
            }
        }
        Control control = null;
        boolean fixFocus = false;
        if (!visible) {
            control = this.display.getFocusControl();
            fixFocus = this.isFocusAncestor(control);
        }
        this.setVisible(this.topHandle(), visible);
        if (!visible) {
            this.sendEvent(23);
            if (this.isDisposed()) {
                return;
            }
        }
        if (fixFocus) {
            this.fixFocus(control);
        }
    }

    void setZOrder() {
        int topHandle = this.topHandle();
        int parentHandle = this.parent.handle;
        OS.HIViewAddSubview((int)parentHandle, (int)topHandle);
        Rect parentRect = new Rect();
        OS.GetControlBounds((int)parentHandle, (Rect)parentRect);
        Rect inset = this.getInset();
        Rect newBounds = new Rect();
        newBounds.left = (short)(parentRect.left + inset.left);
        newBounds.top = (short)(parentRect.top + inset.top);
        newBounds.right = (short)(newBounds.left - inset.right - inset.left);
        newBounds.bottom = (short)(newBounds.top - inset.bottom - inset.top);
        if (newBounds.bottom < newBounds.top) {
            newBounds.bottom = newBounds.top;
        }
        if (newBounds.right < newBounds.left) {
            newBounds.right = newBounds.left;
        }
        OS.SetControlBounds((int)topHandle, (Rect)newBounds);
    }

    void setZOrder(Control control, boolean above) {
        int otherControl = control == null ? 0 : control.topHandle();
        this.setZOrder(this.topHandle(), otherControl, above);
    }

    void sort(int[] items) {
        int length = items.length;
        int gap = length / 2;
        while (gap > 0) {
            int i = gap;
            while (i < length) {
                int j = i - gap;
                while (j >= 0) {
                    if (items[j] <= items[j + gap]) {
                        int swap = items[j];
                        items[j] = items[j + gap];
                        items[j + gap] = swap;
                    }
                    j -= gap;
                }
                ++i;
            }
            gap /= 2;
        }
    }

    public org.eclipse.swt.graphics.Point toControl(int x, int y) {
        this.checkWidget();
        Rect rect = new Rect();
        int window = OS.GetControlOwner((int)this.handle);
        OS.GetWindowBounds((int)window, (short)33, (Rect)rect);
        OS.GetControlBounds((int)this.handle, (Rect)rect);
        return new org.eclipse.swt.graphics.Point((x -= rect.left) - rect.left, (y -= rect.top) - rect.top);
    }

    public org.eclipse.swt.graphics.Point toControl(org.eclipse.swt.graphics.Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        return this.toControl(point.x, point.y);
    }

    public org.eclipse.swt.graphics.Point toDisplay(int x, int y) {
        this.checkWidget();
        Rect rect = new Rect();
        OS.GetControlBounds((int)this.handle, (Rect)rect);
        int window = OS.GetControlOwner((int)this.handle);
        OS.GetWindowBounds((int)window, (short)33, (Rect)rect);
        return new org.eclipse.swt.graphics.Point((x += rect.left) + rect.left, (y += rect.top) + rect.top);
    }

    public org.eclipse.swt.graphics.Point toDisplay(org.eclipse.swt.graphics.Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        return this.toDisplay(point.x, point.y);
    }

    int topHandle() {
        return this.handle;
    }

    boolean translateTraversal(int key, int theEvent) {
        int detail = 0;
        int code = this.traversalCode(key, theEvent);
        boolean all = false;
        switch (key) {
            case 53: {
                all = true;
                detail = 2;
                break;
            }
            case 36: {
                all = true;
                detail = 4;
                break;
            }
            case 48: {
                int[] modifiers = new int[1];
                OS.GetEventParameter((int)theEvent, (int)1802334052, (int)1835100014, null, (int)4, null, (int[])modifiers);
                boolean next = (modifiers[0] & 0x200) == 0;
                detail = next ? 16 : 8;
                break;
            }
            case 123: 
            case 124: 
            case 125: 
            case 126: {
                boolean next = key == 125 || key == 124;
                detail = next ? 64 : 32;
                break;
            }
            case 116: 
            case 121: {
                all = true;
                int[] modifiers = new int[1];
                OS.GetEventParameter((int)theEvent, (int)1802334052, (int)1835100014, null, (int)4, null, (int[])modifiers);
                if ((modifiers[0] & 0x1000) == 0) {
                    return false;
                }
                detail = key == 121 ? 512 : 256;
                break;
            }
            default: {
                return false;
            }
        }
        Event event = new Event();
        event.doit = (code & detail) != 0;
        event.detail = detail;
        if (!this.setKeyState(event, 31, theEvent)) {
            return false;
        }
        Shell shell = this.getShell();
        Control control = this;
        do {
            if (control.traverse(event)) {
                return true;
            }
            if (!event.doit && control.hooks(31)) {
                return false;
            }
            if (control == shell) {
                return false;
            }
            control = control.parent;
        } while (all && control != null);
        return false;
    }

    int traversalCode(int key, int theEvent) {
        int code = 28;
        Shell shell = this.getShell();
        if (shell.parent != null) {
            code |= 2;
        }
        return code;
    }

    boolean traverseMnemonic(char key) {
        return false;
    }

    public boolean traverse(int traversal) {
        this.checkWidget();
        Event event = new Event();
        event.doit = true;
        event.detail = traversal;
        return this.traverse(event);
    }

    boolean traverse(Event event) {
        this.sendEvent(31, event);
        if (this.isDisposed()) {
            return true;
        }
        if (!event.doit) {
            return false;
        }
        switch (event.detail) {
            case 0: {
                return true;
            }
            case 2: {
                return this.traverseEscape();
            }
            case 4: {
                return this.traverseReturn();
            }
            case 16: {
                return this.traverseGroup(true);
            }
            case 8: {
                return this.traverseGroup(false);
            }
            case 64: {
                return this.traverseItem(true);
            }
            case 32: {
                return this.traverseItem(false);
            }
            case 128: {
                return this.traverseMnemonic(event);
            }
            case 512: {
                return this.traversePage(true);
            }
            case 256: {
                return this.traversePage(false);
            }
        }
        return false;
    }

    boolean traverseEscape() {
        return false;
    }

    boolean traverseGroup(boolean next) {
        Control root = this.computeTabRoot();
        Control group = this.computeTabGroup();
        Control[] list = root.computeTabList();
        int length = list.length;
        int index = 0;
        while (index < length) {
            if (list[index] == group) break;
            ++index;
        }
        if (index == length) {
            return false;
        }
        int start = index;
        int offset = next ? 1 : -1;
        while ((index = (index + offset + length) % length) != start) {
            Control control = list[index];
            if (control.isDisposed() || !control.setTabGroupFocus()) continue;
            return true;
        }
        if (group.isDisposed()) {
            return false;
        }
        return group.setTabGroupFocus();
    }

    boolean traverseItem(boolean next) {
        Control[] children = this.parent._getChildren();
        int length = children.length;
        int index = 0;
        while (index < length) {
            if (children[index] == this) break;
            ++index;
        }
        if (index == length) {
            return false;
        }
        int start = index;
        int offset = next ? 1 : -1;
        while ((index = (index + offset + length) % length) != start) {
            Control child = children[index];
            if (child.isDisposed() || !child.isTabItem() || !child.setTabItemFocus()) continue;
            return true;
        }
        return false;
    }

    boolean traverseReturn() {
        return false;
    }

    boolean traversePage(boolean next) {
        return false;
    }

    boolean traverseMnemonic(Event event) {
        return false;
    }

    public void update() {
        this.checkWidget();
        this.update(false);
    }

    void update(boolean all) {
        if (!this.isDrawing(this.handle)) {
            return;
        }
        int window = OS.GetControlOwner((int)this.handle);
        int port = OS.GetWindowPort((int)window);
        int portRgn = OS.NewRgn();
        OS.GetPortVisibleRegion((int)port, (int)portRgn);
        if (!OS.EmptyRgn((int)portRgn)) {
            int updateRgn = OS.NewRgn();
            OS.GetWindowRegion((int)window, (short)34, (int)updateRgn);
            if (!OS.EmptyRgn((int)updateRgn)) {
                Rect rect = new Rect();
                OS.GetWindowBounds((int)window, (short)33, (Rect)rect);
                OS.OffsetRgn((int)updateRgn, (short)(-rect.left), (short)(-rect.top));
                OS.SectRgn((int)portRgn, (int)updateRgn, (int)updateRgn);
                if (!OS.EmptyRgn((int)updateRgn)) {
                    int visibleRgn = this.getVisibleRegion(this.handle, !all);
                    if (!OS.EmptyRgn((int)visibleRgn)) {
                        OS.SectRgn((int)updateRgn, (int)visibleRgn, (int)visibleRgn);
                        if (!OS.EmptyRgn((int)visibleRgn)) {
                            int[] currentPort = new int[1];
                            OS.GetPort((int[])currentPort);
                            OS.SetPort((int)port);
                            OS.BeginUpdate((int)window);
                            OS.DiffRgn((int)updateRgn, (int)visibleRgn, (int)updateRgn);
                            this.invalWindowRgn(window, updateRgn);
                            OS.UpdateControls((int)window, (int)visibleRgn);
                            OS.EndUpdate((int)window);
                            OS.SetPort((int)currentPort[0]);
                        }
                    }
                    OS.DisposeRgn((int)visibleRgn);
                }
            }
            OS.DisposeRgn((int)updateRgn);
        }
        OS.DisposeRgn((int)portRgn);
    }
}

