/*
   SwingWT
   Copyright(c)2003-2004, R. Rawson-Tetley

   For more information on distributing and using this program, please
   see the accompanying "COPYING" file.
 
   Contact me by electronic mail: bobintetley@users.sourceforge.net

   $Log: Dimension.java,v $
   Revision 1.6  2004/01/15 15:20:29  bobintetley
   Java2D work

   Revision 1.5  2003/12/14 09:13:38  bobintetley
   Added CVS log to source headers

*/


package swingwt.awt;

import swingwt.awt.geom.*;

public class Dimension extends Dimension2D {
    
    public int width;
    public int height;
    public Dimension() {
	this(0, 0);
    }
    public Dimension(Dimension d) {
	this(d.width, d.height);
    }
    public Dimension(int width, int height) {
	this.width = width;
	this.height = height;
    }
    public double getWidth() {
	return width;
    }
    public double getHeight() {
	return height;
    }
    public void setSize(double width, double height) {
	this.width = (int) Math.ceil(width);
	this.height = (int) Math.ceil(height);
    }
    public Dimension getSize() {
	return new Dimension(width, height);
    }	
    public void setSize(Dimension d) {
	setSize(d.width, d.height);
    }	
    public void setSize(int width, int height) {
    	this.width = width;
    	this.height = height;
    }
    public boolean equals(Object obj) {
	if (obj instanceof Dimension) {
	    Dimension d = (Dimension)obj;
	    return (width == d.width) && (height == d.height);
	}
	return false;
    }
    public String toString() {
	return getClass().getName() + "[width=" + width + ",height=" + height + "]";
    }
}
