/*
   SwingWT
   Copyright(c)2003-2004, R. Rawson-Tetley

   For more information on distributing and using this program, please
   see the accompanying "COPYING" file.

   Contact me by electronic mail: bobintetley@users.sourceforge.net

   $Log: Image.java,v $
   Revision 1.14  2004/06/11 03:29:26  dannaab
   AWT improvements: implement Button over JButton; Menu fixes; add missing geom me
   thods; add some missing awt event methods/features

   Revision 1.13  2004/06/10 07:57:57  dannaab
   Added AWTSwingWrapper to map AWT components to the corresponding Swing version.  Implemted using it: TextComponent, TextArea, TextField; used similar technique for Menu components

   Revision 1.12  2004/05/06 12:35:21  bobintetley
   Parity with Swing constants for Binary Compatibility + fixes to JDesktopPane

   Revision 1.11  2004/04/23 00:52:31  dannaab
   Handle borders in a Swing-like way. Implement EmptyBorder & TitledBorder

   Revision 1.10  2004/03/01 12:25:46  bobintetley
   Better HTML conversion, custom JFileChooser support, JLabel, Window and
   Image fixes to improve compatibility

   Revision 1.9  2004/01/15 15:20:29  bobintetley
   Java2D work

   Revision 1.8  2003/12/22 13:58:50  bobintetley
   Image scaling support

   Revision 1.7  2003/12/15 17:44:22  bobintetley
   Image getHeight/Width support

   Revision 1.6  2003/12/14 09:13:38  bobintetley
   Added CVS log to source headers

*/


package swingwt.awt;

import swingwt.awt.image.ImageObserver;
import swingwt.awt.image.ImageProducer;

import org.eclipse.swt.graphics.*;

public class Image {
    
    public final static int SCALE_DEFAULT = 1; 
    public final static int SCALE_FAST = 2;
    public final static int SCALE_SMOOTH = 4;
    public final static int SCALE_REPLICATE = 8;
    public final static int SCALE_AREA_AVERAGING = 16;
    
    public org.eclipse.swt.graphics.Image image = null;
    protected swingwt.awt.Graphics2D gc = null;
    
    public Image() {
        //image = new org.eclipse.swt.graphics.Image();
    }

    public int getHeight() { return getHeight(null); }
    public int getHeight(ImageObserver img) {
        if (image != null)
            return image.getBounds().height;
        else
            return 0;
    }

    public int getWidth() { return getWidth(null); }
    public int getWidth(ImageObserver img) {
        if (image != null)
            return image.getBounds().width;
        else
            return 0;
    }
    
    public Image getScaledInstance(int width, int height, int hints) {
        
        if (image == null) return null;
        if (width < 0 && height < 0) throw new IllegalArgumentException("You must supply width or height");
        
        // If width or height is negative, we need to maintain the
        // aspect ratio for the one that's missing
        if (height < 0) {
            double aspectRatio = ((double) image.getBounds().width) / ((double) image.getBounds().height);
            height = (int) ((double) width * (double) aspectRatio);
        }
        if (width < 0) {
            double aspectRatio = ((double) image.getBounds().width) / ((double) image.getBounds().height);
            width = (int) ((double) height * (double) aspectRatio);
        }
        
        // Create our new output image
        org.eclipse.swt.graphics.Image destImage = 
            new org.eclipse.swt.graphics.Image(swingwtx.swing.SwingWTUtils.getDisplay(), width, height);
        
        // Paint our image on it
        GC gc = new GC(destImage);
        gc.drawImage(image, 0, 0, image.getBounds().width, image.getBounds().height, 0, 0, width, height);
        
        // Construct our return image
        Image retImage = new Image();
        retImage.image = destImage;
        
        // Dispose of the GC
        gc.dispose();
        
        return retImage;
        
    }
    
    public Graphics getGraphics() { return createGraphics(); }
    public Graphics2D createGraphics() { 
        if (gc != null)
            return gc;
        // We have an image and no GC now - create it
        else if (image != null) {
            gc = new SWTGraphics2DRenderer( new GC(image), true);
            return gc;
        }
        else 
            return null;
    }
    
    public ImageProducer getSource() {
        // TODO: Implement
        return null;
    }
}
