/*******************************************************************************
 * Copyright (c) 2000, 2004 IBM Corporation and others. All rights reserved.
 * The contents of this file are made available under the terms
 * of the GNU Lesser General Public License (LGPL) Version 2.1 that
 * accompanies this distribution (lgpl-v21.txt).  The LGPL is also
 * available at http://www.gnu.org/licenses/lgpl.html.  If the version
 * of the LGPL at http://www.gnu.org is different to the version of
 * the LGPL accompanying this distribution and there is any conflict
 * between the two license versions, the terms of the LGPL accompanying
 * this distribution shall govern.
 *******************************************************************************/
package org.eclipse.swt.internal.gtk;

 
import org.eclipse.swt.internal.Library;

public class OS {
	static {
		Library.loadLibrary("swt-pi");
	}
	
	/** Constants */
	public static final int G_SIGNAL_MATCH_DATA = 1 << 4;
	public static final int G_SIGNAL_MATCH_ID = 1 << 0;
	public static final int GDK_2BUTTON_PRESS = 0x5;
	public static final int GDK_3BUTTON_PRESS = 0x6;
	public static final int GDK_ACTION_COPY = 1 << 1;
	public static final int GDK_ACTION_MOVE = 1 << 2;
	public static final int GDK_ACTION_LINK = 1 << 3;
	public static final int GDK_Alt_L = 0xffe9;
	public static final int GDK_Alt_R = 0xffea;
	public static final int GDK_AND = 4;
	public static final int GDK_BackSpace = 0xff08;
	public static final int GDK_BOTTOM_LEFT_CORNER = 0xc;
	public static final int GDK_BOTTOM_RIGHT_CORNER = 0xe;
	public static final int GDK_BOTTOM_SIDE = 0x10;
	public static final int GDK_BUTTON1_MASK = 0x100;
	public static final int GDK_BUTTON2_MASK = 0x200;
	public static final int GDK_BUTTON3_MASK = 0x400;
	public static final int GDK_BUTTON_MOTION_MASK	= 1 << 4;
	public static final int GDK_BUTTON1_MOTION_MASK	= 1 << 5;
	public static final int GDK_BUTTON2_MOTION_MASK	= 1 << 6;
	public static final int GDK_BUTTON3_MOTION_MASK	= 1 << 7;
	public static final int GDK_BUTTON_PRESS = 0x4;
	public static final int GDK_BUTTON_PRESS_MASK = 0x100;
	public static final int GDK_BUTTON_RELEASE = 0x7;
	public static final int GDK_BUTTON_RELEASE_MASK = 0x200;
	public static final int GDK_CAP_BUTT = 0x1;
	public static final int GDK_CAP_ROUND = 0x2;
	public static final int GDK_COLORSPACE_RGB = 0;
	public static final int GDK_CONFIGURE = 13;
	public static final int GDK_CONTROL_MASK = 0x4;
	public static final int GDK_COPY = 0x0;
	public static final int GDK_CROSS = 0x1e;
	public static final int GDK_CROSSING_NORMAL = 0;
	public static final int GDK_Break = 0xff6b;
	public static final int GDK_Cancel = 0xff69;
	public static final int GDK_Caps_Lock = 0xffE5;
	public static final int GDK_Clear = 0xff0B;
	public static final int GDK_Control_L = 0xffe3;
	public static final int GDK_Control_R = 0xffe4;
	public static final int GDK_CURRENT_TIME = 0x0;
	public static final int GDK_DECOR_BORDER = 0x2;
	public static final int GDK_DECOR_MAXIMIZE = 0x40;
	public static final int GDK_DECOR_MENU = 0x10;
	public static final int GDK_DECOR_MINIMIZE = 0x20;
	public static final int GDK_DECOR_RESIZEH = 0x4;
	public static final int GDK_DECOR_TITLE = 0x8;
	public static final int GDK_DOUBLE_ARROW = 0x2a;
	public static final int GDK_Delete = 0xffff;
	public static final int GDK_Down = 0xff54;
	public static final int GDK_ENTER_NOTIFY_MASK = 0x1000;
	public static final int GDK_ENTER_NOTIFY = 10;
	public static final int GDK_EVEN_ODD_RULE = 0;
	public static final int GDK_EXPOSE = 2;
	public static final int GDK_EXPOSURE_MASK = 0x2;
	public static final int GDK_End = 0xff57;
	public static final int GDK_Escape = 0xff1b;
	public static final int GDK_F1 = 0xffbe;
	public static final int GDK_F10 = 0xffc7;
	public static final int GDK_F11 = 0xffc8;
	public static final int GDK_F12 = 0xffc9;
	public static final int GDK_F13 = 0xffca;
	public static final int GDK_F14 = 0xffcb;
	public static final int GDK_F15 = 0xffcc;
	public static final int GDK_F2 = 0xffbf;
	public static final int GDK_F3 = 0xffc0;
	public static final int GDK_F4 = 0xffc1;
	public static final int GDK_F5 = 0xffc2;
	public static final int GDK_F6 = 0xffc3;
	public static final int GDK_F7 = 0xffc4;
	public static final int GDK_F8 = 0xffc5;
	public static final int GDK_F9 = 0xffc6;
	public static final int GDK_FLEUR = 0x34;
	public static final int GDK_FOCUS_CHANGE = 0xc;
	public static final int GDK_FOCUS_CHANGE_MASK = 0x4000;
	public static final int GDK_GC_CLIP_MASK = 0x80;
	public static final int GDK_GC_CLIP_X_ORIGIN = 0x800;
	public static final int GDK_GC_CLIP_Y_ORIGIN = 0x1000;
	public static final int GDK_GRAB_SUCCESS = 0x0;
	public static final int GDK_HAND1 = 0x3a;
	public static final int GDK_Help = 0xFF6A;
	public static final int GDK_Home = 0xff50;
	public static final int GDK_INCLUDE_INFERIORS = 0x1;
	public static final int GDK_INPUT_ONLY = 1;
	public static final int GDK_INTERP_BILINEAR = 0x2;
	public static final int GDK_Insert = 0xff63;
	public static final int GDK_ISO_Left_Tab = 0xfe20;
	public static final int GDK_JOIN_MITER = 0x0;
	public static final int GDK_KEY_PRESS = 0x8;
	public static final int GDK_KEY_PRESS_MASK = 0x400;
	public static final int GDK_KEY_RELEASE = 0x9;
	public static final int GDK_KEY_RELEASE_MASK = 0x800;
	public static final int GDK_KP_0 = 0xffb0;
	public static final int GDK_KP_1 = 0xffb1;
	public static final int GDK_KP_2 = 0xffb2;
	public static final int GDK_KP_3 = 0xffb3;
	public static final int GDK_KP_4 = 0xffb4;
	public static final int GDK_KP_5 = 0xffb5;
	public static final int GDK_KP_6 = 0xffb6;
	public static final int GDK_KP_7 = 0xffb7;
	public static final int GDK_KP_8 = 0xffb8;
	public static final int GDK_KP_9 = 0xffb9;
	public static final int GDK_KP_Add = 0xffab;
	public static final int GDK_KP_Decimal = 0xffae;
	public static final int GDK_KP_Delete = 0xFF9F;
	public static final int GDK_KP_Divide = 0xffaf;
	public static final int GDK_KP_Down = 0xFF99;
	public static final int GDK_KP_End = 0xFF9C;
	public static final int GDK_KP_Enter = 0xff8d;
	public static final int GDK_KP_Equal = 0xffbd;
	public static final int GDK_KP_Home = 0xFF95;
	public static final int GDK_KP_Insert = 0xFF9E;
	public static final int GDK_KP_Left = 0xFF96;
	public static final int GDK_KP_Multiply = 0xffaa;
	public static final int GDK_KP_Page_Down = 0xFF9B;
	public static final int GDK_KP_Page_Up = 0xFF9A;
	public static final int GDK_KP_Right = 0xFF98;
	public static final int GDK_KP_Subtract = 0xffad;
	public static final int GDK_KP_Up = 0xFF97;
	public static final int GDK_LEAVE_NOTIFY = 11;
	public static final int GDK_LEAVE_NOTIFY_MASK = 0x2000;
	public static final int GDK_LEFT_PTR = 0x44;
	public static final int GDK_LEFT_SIDE = 0x46;
	public static final int GDK_LINE_ON_OFF_DASH = 0x1;
	public static final int GDK_LINE_SOLID = 0x0;
	public static final int GDK_Linefeed = 0xff0A;
	public static final int GDK_LSB_FIRST = 0x0;
	public static final int GDK_Left = 0xff51;
	public static final int GDK_Meta_L = 0xFFE7;
	public static final int GDK_Meta_R = 0xFFE8;
	public static final int GDK_MAP = 14;
	public static final int GDK_MOD1_MASK = 0x8;
	public static final int GDK_MOTION_NOTIFY = 0x3;
	public static final int GDK_NO_EXPOSE = 30;
	public static final int GDK_NONE = 0;
	public static final int GDK_NOTIFY_INFERIOR = 2;
	public static final int PANGO_ALIGN_LEFT = 0;
	public static final int PANGO_ALIGN_CENTER = 1;
	public static final int PANGO_ALIGN_RIGHT = 2;
	public static final int PANGO_DIRECTION_LTR = 0;
	public static final int PANGO_DIRECTION_RTL = 1;	
	public static final int GDK_Num_Lock = 0xFF7F;
	public static final int GDK_OVERLAP_RECTANGLE_OUT = 0x1;
	public static final int GDK_PIXBUF_ALPHA_BILEVEL = 0x0;
	public static final int GDK_POINTER_MOTION_HINT_MASK = 0x8;
	public static final int GDK_POINTER_MOTION_MASK = 0x4;
	public static final int GDK_PROPERTY_NOTIFY = 16;
	public static final int GDK_Page_Down = 0xff56;
	public static final int GDK_Page_Up = 0xff55;
	public static final int GDK_Pause = 0xff13;
	public static final int GDK_Print = 0xff61;
	public static final int GDK_QUESTION_ARROW = 0x5c;
	public static final int GDK_RGB_DITHER_NORMAL = 0x1;
	public static final int GDK_RIGHT_SIDE = 0x60;
	public static final int GDK_Return = 0xff0d;
	public static final int GDK_Right = 0xff53;
	public static final int GDK_space = 0x20;
	public static final int GDK_SB_H_DOUBLE_ARROW = 0x6c;
	public static final int GDK_SB_UP_ARROW = 0x72;
	public static final int GDK_SB_V_DOUBLE_ARROW = 0x74;
	public static final int GDK_SELECTION_CLEAR = 17;
	public static final int GDK_SELECTION_NOTIFY = 19;
	public static final int GDK_SELECTION_REQUEST = 18;
	public static final int GDK_SHIFT_MASK = 0x1;
	public static final int GDK_SIZING = 0x78;
	public static final int GDK_STIPPLED = 0x2;
	public static final int GDK_Shift_L = 0xffe1;
	public static final int GDK_Shift_R = 0xffe2;
	public static final int GDK_Scroll_Lock = 0xff14;
	public static final int GDK_TOP_LEFT_CORNER = 0x86;
	public static final int GDK_TOP_RIGHT_CORNER = 0x88;
	public static final int GDK_TOP_SIDE = 0x8a;
	public static final int GDK_Tab = 0xff09;
	public static final int GDK_Up = 0xff52;
	public static final int GDK_WATCH = 0x96;
	public static final int GDK_XOR = 0x2;
	public static final int GDK_XTERM = 0x98;
	public static final int GDK_X_CURSOR = 0x0;
	public static final int GDK_VISIBILITY_FULLY_OBSCURED = 2;
	public static final int GDK_VISIBILITY_NOTIFY_MASK = 1 << 17;
	public static final int GDK_WINDOW_CHILD = 2;
	public static final int GDK_WINDOW_STATE_ICONIFIED  = 1 << 1;
	public static final int GDK_WINDOW_STATE_MAXIMIZED  = 1 << 2;
	public static final int GTK_ACCEL_VISIBLE = 0x1;
	public static final int GTK_ARROW_DOWN = 0x1;
	public static final int GTK_ARROW_LEFT = 0x2;
	public static final int GTK_ARROW_RIGHT = 0x3;
	public static final int GTK_ARROW_UP = 0x0;
	public static final int GTK_CAN_DEFAULT = 0x2000;
	public static final int GTK_CAN_FOCUS = 0x800;
	public static final int GTK_CELL_RENDERER_MODE_ACTIVATABLE = 1;
	public static final int GTK_CLIST_SHOW_TITLES = 0x4;
	public static final int GTK_CORNER_TOP_LEFT = 0x0;
	public static final int GTK_CORNER_TOP_RIGHT = 0x2;
	public static final int GTK_DIALOG_DESTROY_WITH_PARENT = 1 << 1;
	public static final int GTK_DIALOG_MODAL = 1 << 0;
	public static final int GTK_DIR_TAB_FORWARD = 0;
	public static final int GTK_DIR_TAB_BACKWARD = 1;
	public static final int GTK_HAS_FOCUS = 1 << 12;
	public static final int GTK_JUSTIFY_CENTER = 0x2;
	public static final int GTK_JUSTIFY_LEFT = 0x0;
	public static final int GTK_JUSTIFY_RIGHT = 0x1;
	public static final int GTK_MESSAGE_INFO = 0;
	public static final int GTK_MESSAGE_WARNING = 1;
	public static final int GTK_MESSAGE_QUESTION = 2;
	public static final int GTK_MESSAGE_ERROR = 3;
	public static final int GTK_NO_WINDOW = 1 << 5;
	public static final int GTK_ORIENTATION_HORIZONTAL = 0x0;
	public static final int GTK_ORIENTATION_VERTICAL = 0x1;
	public static final int GTK_POLICY_ALWAYS = 0x0;
	public static final int GTK_POLICY_AUTOMATIC = 0x1;
	public static final int GTK_POLICY_NEVER = 0x2;
	public static final int GTK_POS_BOTTOM = 0x3;
	public static final int GTK_PROGRESS_CONTINUOUS = 0x0;
	public static final int GTK_PROGRESS_DISCRETE = 0x1;
	public static final int GTK_PROGRESS_LEFT_TO_RIGHT = 0x0;
	public static final int GTK_PROGRESS_BOTTOM_TO_TOP = 0x2;
	public static final int GTK_REALIZED  = 1 << 6;
	public static final int GTK_RELIEF_NONE = 0x2;
	public static final int GTK_RC_BG = 1 << 1;
	public static final int GTK_RC_FG = 1 << 0;
	public static final int GTK_RESPONSE_OK = 0xfffffffb;
	public static final int GTK_SELECTION_BROWSE = 0x2;
	public static final int GTK_SELECTION_MULTIPLE = 0x3;
	public static final int GTK_SENSITIVE = 0x200;
	public static final int GTK_SHADOW_ETCHED_IN = 0x3;
	public static final int GTK_SHADOW_ETCHED_OUT = 0x4;
	public static final int GTK_SHADOW_IN = 0x1;
	public static final int GTK_SHADOW_NONE = 0x0;
	public static final int GTK_SHADOW_OUT = 0x2;
	public static final int GTK_STATE_ACTIVE = 0x1;
	public static final int GTK_STATE_INSENSITIVE = 0x4;
	public static final int GTK_STATE_NORMAL = 0x0;
	public static final int GTK_STATE_PRELIGHT = 0x2;
	public static final int GTK_STATE_SELECTED = 0x3;
	public static final int GTK_TEXT_DIR_LTR = 1;
	public static final int GTK_TEXT_DIR_NONE = 0 ;
	public static final int GTK_TEXT_DIR_RTL = 2;
	public static final int GTK_TEXT_WINDOW_TEXT = 2;
	public static final int GTK_TOOLBAR_CHILD_BUTTON = 0x1;
	public static final int GTK_TOOLBAR_CHILD_RADIOBUTTON = 0x3;
	public static final int GTK_TOOLBAR_CHILD_TOGGLEBUTTON = 0x2;
	public static final int GTK_TREE_VIEW_COLUMN_GROW_ONLY = 0;
	public static final int GTK_TREE_VIEW_COLUMN_AUTOSIZE = 1;
	public static final int GTK_TREE_VIEW_COLUMN_FIXED = 2;
	public static final int GTK_TREE_VIEW_DROP_BEFORE = 0;
	public static final int GTK_TREE_VIEW_DROP_AFTER = 1;
	public static final int GTK_TREE_VIEW_DROP_INTO_OR_BEFORE = 2;
	public static final int GTK_TREE_VIEW_DROP_INTO_OR_AFTER = 3;
	public static final int GDK_UNMAP = 15;
	public static final int GTK_VISIBILITY_FULL = 0x2;
	public static final int GTK_VISIBILITY_NONE = 0x0;
	public static final int GTK_VISIBLE = 0x100;
	public static final int GDK_WA_X = 1 << 2;
	public static final int GDK_WA_Y = 1 << 3;
	public static final int GTK_WINDOW_POPUP = 0x1;
	public static final int GTK_WINDOW_TOPLEVEL = 0x0;
	public static final int GDK_WINDOW_TYPE_HINT_DIALOG = 1;
	public static final int GTK_WRAP_NONE = 0;
	public static final int GTK_WRAP_WORD = 2;
	public static final int G_LOG_FLAG_FATAL = 0x2;
	public static final int G_LOG_FLAG_RECURSION = 0x1;
	public static final int G_LOG_LEVEL_MASK = 0xfffffffc;
	public static final int None = 0;
	public static final int PANGO_SCALE = 1024;
	public static final int PANGO_STRETCH_NORMAL = 0x4;
	public static final int PANGO_STYLE_ITALIC = 0x2;
	public static final int PANGO_STYLE_NORMAL = 0x0;
	public static final int PANGO_STYLE_OBLIQUE = 0x1;
	public static final int PANGO_TAB_LEFT = 0;
	public static final int PANGO_UNDERLINE_LOW = 3;
	public static final int PANGO_UNDERLINE_SINGLE = 1;
	public static final int PANGO_WEIGHT_BOLD = 0x2bc;
	public static final int PANGO_WEIGHT_NORMAL = 0x190;
	public static final int PANGO_WRAP_WORD = 0;
	public static final int PANGO_WRAP_WORD_CHAR = 2;
	public static final int XA_CARDINAL = 0x6;
	
	/** Signals */
	public static final byte[] activate = signal("activate");
	public static final byte[] button_press_event = signal("button_press_event");
	public static final byte[] button_release_event = signal("button_release_event");
	public static final byte[] changed = signal("changed");
	public static final byte[] change_current_page = signal("change_current_page");
	public static final byte[] clicked = signal("clicked");
	public static final byte[] commit = signal("commit");
	public static final byte[] configure_event = signal("configure_event");
	public static final byte[] delete_event = signal("delete_event");
	public static final byte[] delete_range = signal("delete_range");
	public static final byte[] delete_text = signal("delete_text");
	public static final byte[] enter_notify_event = signal("enter_notify_event");
	public static final byte[] event = signal("event");
	public static final byte[] event_after = signal("event_after");
	public static final byte[] expose_event = signal("expose_event");
	public static final byte[] focus = signal("focus");
	public static final byte[] focus_in_event = signal("focus_in_event");
	public static final byte[] focus_out_event = signal("focus_out_event");
	public static final byte[] hide = signal("hide");
	public static final byte[] insert_text = signal("insert_text");
	public static final byte[] key_press_event = signal("key_press_event");
	public static final byte[] key_release_event = signal("key_release_event");
	public static final byte[] leave_notify_event = signal("leave_notify_event");
	public static final byte[] map_event = signal("map_event");
	public static final byte[] mnemonic_activate = signal("mnemonic_activate");
	public static final byte[] motion_notify_event = signal("motion_notify_event");
	public static final byte[] popup_menu = signal("popup_menu");
	public static final byte[] preedit_changed = signal("preedit_changed");
	public static final byte[] realize = signal("realize");
	public static final byte[] row_activated = signal("row_activated");
	public static final byte[] row_changed = signal("row_changed");
	public static final byte[] scroll_child = signal("scroll_child");
	public static final byte[] select = signal("select");
	public static final byte[] show = signal("show");
	public static final byte[] show_help = signal("show_help");
	public static final byte[] size_allocate = signal("size_allocate");
	public static final byte[] style_set = signal("style_set");
	public static final byte[] switch_page = signal("switch_page");
	public static final byte[] test_collapse_row = signal("test_collapse_row");
	public static final byte[] test_expand_row = signal("test_expand_row");
	public static final byte[] toggled = signal("toggled");
	public static final byte[] unmap_event = signal("unmap_event");
	public static final byte[] unrealize = signal("unrealize");
	public static final byte[] value_changed = signal("value_changed");
	public static final byte[] visibility_notify_event = signal("visibility_notify_event");
	public static final byte[] window_state_event = signal("window_state_event");
	
	/** Properties */
	public static final byte[] background_gdk = signal("background-gdk");
	public static final byte[] button_relief = signal("button_relief");
	public static final byte[] cell_background_gdk = signal("cell-background-gdk");
	public static final byte[] expander_size = signal("expander-size");
	public static final byte[] fixed_height_mode = signal("fixed-height-mode");
	public static final byte[] focus_line_width = signal("focus_line_width");
	public static final byte[] font_desc = signal("font-desc");
	public static final byte[] foreground_gdk = signal("foreground-gdk");
	public static final byte[] horizontal_separator = signal("horizontal_separator");
	public static final byte[] interior_focus = signal("interior_focus");
	public static final byte[] mode = signal("mode");
	public static final byte[] pixbuf = signal("pixbuf");
	public static final byte[] text = signal("text");
	public static final byte[] xalign = signal("xalign");
	
protected static byte [] signal (String name) {
	int length = name.length ();
	char [] chars = new char [length];
	name.getChars (0, length, chars, 0);
	byte [] buffer = new byte [length + 1];
	for (int i=0; i<length; i++) {
		buffer [i] = (byte) chars [i];
	}
	return buffer;
}

/** 64 bit */
public static final int PTR_SIZEOF = PTR_sizeof();
public static final synchronized native int PTR_sizeof();
public static final synchronized native int GdkColor_sizeof();
public static final synchronized native int GdkDragContext_sizeof();
public static final synchronized native int GdkEvent_sizeof();
public static final synchronized native int GdkEventButton_sizeof();
public static final synchronized native int GdkEventCrossing_sizeof();
public static final synchronized native int GdkEventExpose_sizeof();
public static final synchronized native int GdkEventFocus_sizeof();
public static final synchronized native int GdkEventKey_sizeof();
public static final synchronized native int GdkEventMotion_sizeof();
public static final synchronized native int GdkEventVisibility_sizeof();
public static final synchronized native int GdkEventWindowState_sizeof();
public static final synchronized native int GdkGCValues_sizeof();
public static final synchronized native int GdkImage_sizeof();
public static final synchronized native int GdkRectangle_sizeof();
public static final synchronized native int GdkVisual_sizeof();
public static final synchronized native int GdkWindowAttr_sizeof();
public static final synchronized native int GtkAdjustment_sizeof();
public static final synchronized native int GtkAllocation_sizeof();
public static final synchronized native int GtkColorSelectionDialog_sizeof();
public static final synchronized native int GtkCombo_sizeof();
public static final synchronized native int GtkFileSelection_sizeof();
public static final synchronized native int GtkFixed_sizeof();
public static final synchronized native int GtkRequisition_sizeof();
public static final synchronized native int GtkSelectionData_sizeof();
public static final synchronized native int GtkTargetEntry_sizeof();
public static final synchronized native int GtkTargetPair_sizeof();
public static final synchronized native int GtkTextIter_sizeof();
public static final synchronized native int GtkTreeIter_sizeof();
public static final synchronized native int PangoAttribute_sizeof();
public static final synchronized native int PangoItem_sizeof();
public static final synchronized native int PangoLayoutLine_sizeof();
public static final synchronized native int PangoLayoutRun_sizeof();
public static final synchronized native int PangoLogAttr_sizeof();
public static final synchronized native int PangoRectangle_sizeof();
public static final synchronized native int XAnyEvent_sizeof();
public static final synchronized native int XClientMessageEvent_sizeof();
public static final synchronized native int XEvent_sizeof();
public static final synchronized native int XCrossingEvent_sizeof();
public static final synchronized native int XExposeEvent_sizeof();
public static final synchronized native int XFocusChangeEvent_sizeof();
public static final synchronized native int XVisibilityEvent_sizeof();
public static final synchronized native int XWindowChanges_sizeof();
public static final native int strlen(int /*long*/ str);

/** Object private fields accessors */
public static final synchronized native int GTK_WIDGET_HEIGHT(int /*long*/ widget);
public static final synchronized native int GTK_WIDGET_WIDTH(int /*long*/ widget);
public static final synchronized native int /*long*/ GTK_WIDGET_WINDOW(int /*long*/ widget);
public static final synchronized native int GTK_WIDGET_X(int /*long*/ widget);
public static final synchronized native int GTK_WIDGET_Y(int /*long*/ widget);
public static final synchronized native int /*long*/ GTK_SCROLLED_WINDOW_HSCROLLBAR(int /*long*/ widget);
public static final synchronized native int /*long*/ GTK_SCROLLED_WINDOW_VSCROLLBAR(int /*long*/ widget);
public static final synchronized native int GTK_SCROLLED_WINDOW_SCROLLBAR_SPACING(int /*long*/ widget);
public static final synchronized native void GTK_ACCEL_LABEL_SET_ACCEL_STRING(int /*long*/ acce_label, int /*long*/ string);
public static final synchronized native int /*long*/ GTK_ACCEL_LABEL_GET_ACCEL_STRING(int /*long*/ acce_label);
public static final synchronized native int /*long*/ GTK_ENTRY_IM_CONTEXT(int /*long*/ widget);
public static final synchronized native int /*long*/ GTK_TEXTVIEW_IM_CONTEXT(int /*long*/ widget);

/** X11 Native methods and constants */
public static final int Above = 0;
public static final int Below = 1;
public static final int ClientMessage = 33;
public static final int CWSibling = 0x20;
public static final int CWStackMode = 0x40;
public static final int EnterNotify = 7;
public static final int Expose = 12;
public static final int FocusChangeMask = 1 << 21;
public static final int FocusIn = 9;
public static final int FocusOut = 10;
public static final int GraphicsExpose = 13;
public static final int NoExpose = 14;
public static final int ExposureMask = 1 << 15;
public static final int NotifyNonlinear = 3;
public static final int NotifyPointer = 5;
public static final int VisibilityChangeMask = 1 << 16;
public static final int VisibilityFullyObscured = 2;
public static final int VisibilityNotify = 15;
public static final native boolean GDK_WINDOWING_X11();
public static final int /*long*/ NoEventMask = 0;
public static final int RevertToParent = 2;
public static final int SYSTEM_TRAY_REQUEST_DOCK = 0;
public static final synchronized native boolean XCheckMaskEvent(int /*long*/ display, int /*long*/ event_mask, int /*long*/ event_return);
public static final synchronized native boolean XCheckWindowEvent(int /*long*/ display, int /*long*/ window, int /*long*/ event_mask, int /*long*/ event_return);
public static final synchronized native boolean XCheckIfEvent(int /*long*/ display, int /*long*/ event_return, int /*long*/ predicate, int /*long*/ arg);
public static final synchronized native int XDefaultScreen(int /*long*/ display);
public static final synchronized native int /*long*/ XGetSelectionOwner(int /*long*/ display, int /*long*/ selection);
public static final synchronized native int XQueryTree(int /*long*/ display, int /*long*/ w, int /*long*/[] root_return, int /*long*/[] parent_return, int /*long*/[] children_return, int[] nchildren_return);
public static final synchronized native int XKeysymToKeycode(int /*long*/ display, int /*long*/ keysym);
public static final synchronized native int XReconfigureWMWindow(int /*long*/ display, int /*long*/ window, int screen, int valueMask, XWindowChanges values);
public static final synchronized native int XSendEvent(int /*long*/ display, int /*long*/ w, boolean propogate, int /*long*/ event_mask, int /*long*/ event_send);
public static final synchronized native int XSetInputFocus(int /*long*/ display, int /*long*/ window, int revert, int time);
public static final synchronized native int /*long*/ XSynchronize(int /*long*/ display, boolean onoff);
public static final synchronized native void XTestFakeButtonEvent(int /*long*/ display, int button, boolean is_press, int /*long*/ delay);
public static final synchronized native void XTestFakeKeyEvent(int /*long*/ display, int keycode, boolean is_press, int /*long*/ delay);
public static final synchronized native void XTestFakeMotionEvent(int /*long*/ display, int screen_number, int x, int y, int /*long*/ delay);
public static final synchronized native int /*long*/gdk_x11_atom_to_xatom(int /*long*/ atom);
public static final synchronized native int /*long*/ gdk_x11_drawable_get_xdisplay(int /*long*/ drawable);
public static final synchronized native int /*long*/ gdk_x11_drawable_get_xid(int /*long*/ drawable);
public static final synchronized native int /*long*/ gdk_window_lookup(int /*long*/ xid);
public static final synchronized native void gdk_window_add_filter(int /*long*/ window, int /*long*/ function, int /*long*/ data);
public static final native void memmove(int /*long*/ dest, XClientMessageEvent src, int /*long*/ size);
public static final native void memmove(int /*long*/ dest, XCrossingEvent src, int /*long*/ size);
public static final native void memmove(int /*long*/ dest, XExposeEvent src, int /*long*/ size);
public static final native void memmove(int /*long*/ dest, XFocusChangeEvent src, int /*long*/ size);
public static final native void memmove(XCrossingEvent dest, int /*long*/ src, int /*long*/ size);
public static final native void memmove(XExposeEvent dest, int /*long*/ src, int /*long*/ size);
public static final native void memmove(XFocusChangeEvent dest, int /*long*/ src, int /*long*/ size);
public static final native void memmove(XVisibilityEvent dest, int /*long*/ src, int /*long*/ size);

/** Native methods */
public static final synchronized native int /*long*/ GDK_DISPLAY();
public static final synchronized native int /*long*/ GDK_ROOT_PARENT();
public static final synchronized native int /*long*/ GDK_TYPE_COLOR();
public static final synchronized native int /*long*/ GDK_TYPE_PIXBUF();
public static final synchronized native boolean GTK_IS_BUTTON(int /*long*/ obj);
public static final synchronized native boolean GTK_IS_CELL_RENDERER_PIXBUF(int /*long*/ obj);
public static final synchronized native boolean GTK_IS_IMAGE_MENU_ITEM(int /*long*/ obj);
public static final synchronized native int GTK_WIDGET_FLAGS(int /*long*/ wid);
public static final synchronized native boolean GTK_WIDGET_HAS_DEFAULT(int /*long*/ wid);
public static final synchronized native boolean GTK_WIDGET_HAS_FOCUS(int /*long*/ wid);
public static final synchronized native boolean GTK_WIDGET_IS_SENSITIVE(int /*long*/ wid);
public static final synchronized native boolean GTK_WIDGET_MAPPED(int /*long*/ wid);
public static final synchronized native boolean GTK_WIDGET_SENSITIVE(int /*long*/ wid);
public static final synchronized native void GTK_WIDGET_SET_FLAGS(int /*long*/ wid, int flag);
public static final synchronized native void GTK_WIDGET_UNSET_FLAGS(int /*long*/ wid, int flag);
public static final synchronized native boolean GTK_WIDGET_VISIBLE(int /*long*/ wid);
public static final synchronized native int /*long*/ G_TYPE_BOOLEAN();
public static final synchronized native int /*long*/ G_TYPE_INT();
public static final synchronized native int /*long*/ G_TYPE_STRING();
public static final synchronized native int PANGO_PIXELS(int dimension);
public static final synchronized native int /*long*/ PANGO_TYPE_FONT_DESCRIPTION();
public static final synchronized native int /*long*/ g_filename_to_utf8(int /*long*/ opsysstring, int /*long*/ len, int /*long*/[] bytes_read, int /*long*/[] bytes_written, int /*long*/[] error);
public static final synchronized native int /*long*/ g_filename_to_uri(int /*long*/ filename, int /*long*/ hostname, int /*long*/[] error);
public static final synchronized native int /*long*/ g_filename_from_utf8(int /*long*/ opsysstring, int /*long*/ len,  int /*long*/[] bytes_read, int /*long*/[] bytes_written, int /*long*/[] error);
public static final synchronized native int /*long*/ g_filename_from_uri(int /*long*/ uri, int /*long*/[] hostname, int /*long*/[] error);
public static final synchronized native void g_free(int /*long*/ mem);
public static final synchronized native int /*long*/ g_list_append(int /*long*/ list, int /*long*/ data);
public static final synchronized native int /*long*/ g_list_data(int /*long*/ list);
public static final synchronized native void g_list_free(int /*long*/ list);
public static final synchronized native void g_list_free_1(int /*long*/ list);
public static final synchronized native int g_list_length(int /*long*/ list);
public static final synchronized native void g_list_set_next(int /*long*/ list, int /*long*/ llist);
public static final synchronized native int /*long*/ g_list_next(int /*long*/ list);
public static final synchronized native int /*long*/ g_list_nth(int /*long*/ list, int n);
public static final synchronized native int /*long*/ g_list_nth_data(int /*long*/ list, int n);
public static final synchronized native int /*long*/ g_list_prepend(int /*long*/ list, int /*long*/ data);
public static final synchronized native void g_list_set_previous(int /*long*/ list, int /*long*/ llist);
public static final synchronized native int /*long*/ g_list_previous(int /*long*/ list);
public static final synchronized native int /*long*/ g_list_remove_link(int /*long*/ list, int /*long*/ link);
public static final synchronized native int /*long*/ g_list_reverse(int /*long*/ list);
public static final synchronized native int /*long*/ g_locale_from_utf8(int /*long*/ utf8string, int /*long*/ len, int /*long*/[] bytes_read, int /*long*/[] bytes_written, int /*long*/[] error);
public static final synchronized native int /*long*/ g_locale_to_utf8(int /*long*/ opsysstring, int /*long*/ len, int /*long*/[] bytes_read, int /*long*/[] bytes_written, int /*long*/[] error);
public static final synchronized native void g_log_default_handler(int /*long*/ log_domain, int log_levels, int /*long*/ message, int /*long*/ unused_data);
public static final synchronized native void g_log_remove_handler(byte[] log_domain, int handler_id);
public static final synchronized native int g_log_set_handler(byte[] log_domain, int log_levels, int /*long*/ log_func, int /*long*/ user_data);
public static final synchronized native int /*long*/ g_malloc(int /*long*/ size);
public static final synchronized native int /*long*/ g_object_get_qdata(int /*long*/ object, int quark);
public static final synchronized native int /*long*/ g_object_ref(int /*long*/ object);
public static final synchronized native void g_object_set(int /*long*/ object, byte[] first_property_name, boolean data, int terminator);
public static final synchronized native void g_object_set(int /*long*/ object, byte[] first_property_name, int data, int terminator);
public static final synchronized native void g_object_set(int /*long*/ object, byte[] first_property_name, float data, int terminator);
public static final synchronized native void g_object_set_qdata(int /*long*/ object, int quark, int /*long*/ data);
public static final synchronized native void g_object_unref(int /*long*/ object);
public static final synchronized native int g_quark_from_string(byte[] string);
public static final synchronized native int g_signal_connect(int /*long*/ instance, byte[] detailed_signal, int /*long*/ proc, int /*long*/ data);
public static final synchronized native int g_signal_connect_after(int /*long*/ instance, byte[] detailed_signal, int /*long*/ proc, int /*long*/ data);
public static final synchronized native void g_signal_emit_by_name(int /*long*/ instance, byte[] detailed_signal);
public static final synchronized native void g_signal_emit_by_name(int /*long*/ instance, byte[] detailed_signal, int /*long*/ data);
public static final synchronized native void g_signal_emit_by_name(int /*long*/ instance, byte[] detailed_signal, int /*long*/ data1, int /*long*/ data2);
public static final synchronized native void g_signal_emit_by_name(int /*long*/ instance, byte[] detailed_signal, byte [] data);
public static final synchronized native void g_signal_handler_disconnect(int /*long*/ instance, int handler_id);
public static final synchronized native int g_signal_handlers_block_matched(int /*long*/ instance, int mask, int signal_id, int detail, int /*long*/ closure, int /*long*/ func, int /*long*/ data);
public static final synchronized native int g_signal_handlers_disconnect_matched(int /*long*/ instance, int mask, int signal_id, int detail, int /*long*/ closure, int /*long*/ func, int /*long*/ data);
public static final synchronized native int g_signal_handlers_unblock_matched(int /*long*/ instance, int mask, int signal_id, int detail, int /*long*/ closure, int /*long*/ func, int /*long*/ data);
public static final synchronized native int g_signal_lookup (byte[] name, int /*long*/ itype);
public static final synchronized native void g_signal_stop_emission_by_name(int /*long*/ instance, byte[] detailed_signal);
public static final synchronized native int /*long*/ g_slist_next(int /*long*/ list);
public static final synchronized native int /*long*/ g_slist_data(int /*long*/ list);
public static final synchronized native void g_strfreev(int /*long*/ string_array);
public static final synchronized native void g_thread_init(int /*long*/ vtable);
public static final synchronized native boolean g_thread_supported();
public static final synchronized native int /*long*/ g_utf16_to_utf8(char[] str, int /*long*/ len, int /*long*/[] items_read, int /*long*/[] items_written, int /*long*/[] error);
public static final synchronized native int /*long*/ g_utf8_offset_to_pointer(int /*long*/ str, int /*long*/ offset);
public static final synchronized native int /*long*/ g_utf8_pointer_to_offset(int /*long*/ str, int /*long*/ pos);
public static final synchronized native int /*long*/ g_utf8_strlen(int /*long*/ str, int /*long*/ max);
public static final synchronized native int /*long*/ g_utf8_to_utf16(byte[] str, int /*long*/ len, int /*long*/[] items_read, int /*long*/[] items_written, int /*long*/[] error);
public static final synchronized native int /*long*/ g_utf8_to_utf16(int /*long*/ str, int /*long*/ len, int /*long*/[] items_read, int /*long*/[] items_written, int /*long*/[] error);
public static final synchronized native int /*long*/ gdk_atom_intern(byte[] atom_name, boolean only_if_exists);
public static final synchronized native int /*long*/ gdk_atom_name(int /*long*/ atom);
public static final synchronized native void gdk_beep();
public static final synchronized native int /*long*/ gdk_bitmap_create_from_data(int /*long*/ window, byte[] data, int width, int height);
public static final synchronized native boolean gdk_color_white(int /*long*/ colormap, GdkColor color);
public static final synchronized native boolean gdk_colormap_alloc_color(int /*long*/ colormap, GdkColor color, boolean writeable, boolean best_match);
public static final synchronized native void gdk_colormap_free_colors(int /*long*/ colormap, GdkColor colors, int ncolors);
public static final synchronized native int /*long*/ gdk_colormap_get_system();
public static final synchronized native void gdk_colormap_query_color(int /*long*/ colormap, int /*long*/ pixel, GdkColor result);
public static final synchronized native void gdk_cursor_destroy(int /*long*/ cursor);
public static final synchronized native int /*long*/ gdk_cursor_new(int /*long*/ cursor_type);
public static final synchronized native int /*long*/ gdk_cursor_new_from_pixmap(int /*long*/ source, int /*long*/ mask, GdkColor fg, GdkColor bg, int x, int y);
public static final synchronized native void gdk_drag_status(int /*long*/ context, int action, int time);
public static final synchronized native void gdk_draw_arc(int /*long*/ drawable, int /*long*/ gc, int filled, int x, int y, int width, int height, int angle1, int angle2);
public static final synchronized native void gdk_draw_drawable(int /*long*/ drawable, int /*long*/ gc, int /*long*/ src, int xsrc, int ysrc, int xdest, int ydest, int width, int height);
public static final synchronized native void gdk_draw_layout(int /*long*/ drawable, int /*long*/ gc, int x, int y, int /*long*/ layout);
public static final synchronized native void gdk_draw_layout_with_colors(int /*long*/ drawable, int /*long*/ gc, int x, int y, int /*long*/ layout, GdkColor foreground, GdkColor background);
public static final synchronized native void gdk_draw_line(int /*long*/ drawable, int /*long*/ gc, int x1, int y1, int x2, int y2);
public static final synchronized native void gdk_draw_lines(int /*long*/ drawable, int /*long*/ gc, int[] points, int npoints);
public static final synchronized native void gdk_draw_point(int /*long*/ drawable, int /*long*/ gc, int x, int y);
public static final synchronized native void gdk_draw_polygon(int /*long*/ drawable, int /*long*/ gc, int filled, int[] points, int npoints);
public static final synchronized native void gdk_draw_rectangle(int /*long*/ drawable, int /*long*/ gc, int filled, int x, int y, int width, int height);
public static final synchronized native int /*long*/ gdk_drawable_get_image(int /*long*/ drawable, int x, int y, int width, int height);
public static final synchronized native void gdk_drawable_get_size(int /*long*/ drawable, int[] width, int[] height);
public static final synchronized native int /*long*/ gdk_drawable_get_visible_region(int /*long*/ drawable);
public static final synchronized native int /*long*/ gdk_event_copy(int /*long*/ event);
public static final synchronized native void gdk_event_free(int /*long*/ event);
public static final synchronized native int /*long*/ gdk_event_get();
public static final synchronized native boolean gdk_event_get_root_coords(int /*long*/ event, double[] px, double[] py);
public static final synchronized native boolean gdk_event_get_coords(int /*long*/ event, double[] px, double[] py);
public static final synchronized native int /*long*/ gdk_event_get_graphics_expose(int /*long*/ window);
public static final synchronized native boolean gdk_event_get_state(int /*long*/ event, int[] pmod);
public static final synchronized native int gdk_event_get_time(int /*long*/ event);
public static final synchronized native void gdk_event_handler_set(int /*long*/ func, int /*long*/ data, int /*long*/ notify);
public static final synchronized native void gdk_event_put(int /*long*/ event);
public static final synchronized native void gdk_error_trap_push();
public static final synchronized native int gdk_error_trap_pop();
public static final synchronized native void gdk_flush();
public static final synchronized native void gdk_free_text_list(int /*long*/ list);
public static final synchronized native void gdk_gc_get_values(int /*long*/ gc, GdkGCValues values);
public static final synchronized native int /*long*/ gdk_gc_new(int /*long*/ window);
public static final synchronized native void gdk_gc_set_background(int /*long*/ gc, GdkColor color);
public static final synchronized native void gdk_gc_set_clip_mask(int /*long*/ gc, int /*long*/ mask);
public static final synchronized native void gdk_gc_set_clip_origin(int /*long*/ gc, int x, int y);
public static final synchronized native void gdk_gc_set_clip_rectangle(int /*long*/ gc, GdkRectangle rectangle);
public static final synchronized native void gdk_gc_set_clip_region(int /*long*/ gc, int /*long*/ region);
public static final synchronized native void gdk_gc_set_dashes(int /*long*/ gc, int dash_offset, byte[] dash_list, int n);
public static final synchronized native void gdk_gc_set_exposures(int /*long*/ gc, boolean exposures);
public static final synchronized native void gdk_gc_set_fill(int /*long*/ gc, int fill);
public static final synchronized native void gdk_gc_set_foreground(int /*long*/ gc, GdkColor color);
public static final synchronized native void gdk_gc_set_function(int /*long*/ gc, int /*long*/ function);
public static final synchronized native void gdk_gc_set_line_attributes(int /*long*/ gc, int line_width, int line_style, int cap_style, int join_style);
public static final synchronized native void gdk_gc_set_stipple(int /*long*/ gc, int /*long*/ stipple);
public static final synchronized native void gdk_gc_set_subwindow(int /*long*/ gc, int /*long*/ mode);
public static final synchronized native void gdk_gc_set_values(int /*long*/ gc, GdkGCValues values, int values_mask);
public static final synchronized native int /*long*/ gdk_image_get(int /*long*/ window, int x, int y, int width, int height);
public static final synchronized native int /*long*/ gdk_image_get_pixel(int /*long*/ image, int x, int y);
public static final synchronized native void gdk_keyboard_ungrab(int time);
public static final synchronized native int /*long*/ gdk_keymap_get_default();
public static final synchronized native boolean gdk_keymap_translate_keyboard_state (int /*long*/ keymap, int hardware_keycode, int state, int group, int[] keyval, int[] effective_group, int[] level,  int[] consumed_modifiers);
public static final synchronized native int gdk_keyval_to_lower(int keyval);
public static final synchronized native int gdk_keyval_to_unicode(int keyval);
public static final synchronized native int /*long*/ gdk_pango_context_get();
public static final synchronized native void gdk_pango_context_set_colormap(int /*long*/ context, int /*long*/ colormap);
public static final synchronized native int /*long*/ gdk_pango_layout_get_clip_region(int /*long*/ layout, int x_origin, int y_origin, int[] index_ranges, int n_ranges);
public static final synchronized native int /*long*/ gdk_pixbuf_get_from_drawable(int /*long*/ dest, int /*long*/ src, int /*long*/ cmap, int src_x, int src_y, int dest_x, int dest_y, int width, int height);
public static final synchronized native int /*long*/ gdk_pixbuf_get_pixels(int /*long*/ pixbuf);
public static final synchronized native int gdk_pixbuf_get_rowstride(int /*long*/ pixbuf);
public static final synchronized native int /*long*/ gdk_pixbuf_new(int colorspace, boolean has_alpha, int bits_per_sample, int width, int height);
public static final synchronized native void gdk_pixbuf_render_to_drawable(int /*long*/ pixbuf, int /*long*/ drawable, int /*long*/ gc, int src_x, int src_y, int dest_x, int dest_y, int width, int height, int dither, int x_dither, int y_dither);
public static final synchronized native void gdk_pixbuf_render_to_drawable_alpha(int /*long*/ pixbuf, int /*long*/ drawable, int src_x, int src_y, int dest_x, int dest_y, int width, int height, int alpha_mode, int alpha_threshold, int dither, int x_dither, int y_dither);
public static final synchronized native void gdk_pixbuf_render_pixmap_and_mask(int /*long*/ pixbuf, int /*long*/[] pixmap_return, int /*long*/[] mask_return, int alpha_threshold);
public static final synchronized native void gdk_pixbuf_scale(int /*long*/ src, int /*long*/ dest, int dest_x, int dest_y, int dest_width, int dest_height, double offset_x, double offset_y, double scale_x, double scale_y, int interp_type);
public static final synchronized native int /*long*/ gdk_pixbuf_scale_simple(int /*long*/ src, int dest_width, int dest_height, int interp_type);
public static final synchronized native int /*long*/ gdk_pixmap_new(int /*long*/ window, int width, int height, int depth);
public static final synchronized native int gdk_pointer_grab(int /*long*/ window, boolean owner_events, int event_mask, int /*long*/ confine_to, int /*long*/ cursor, int time);
public static final synchronized native boolean gdk_pointer_is_grabbed();
public static final synchronized native void gdk_pointer_ungrab(int time);
public static final synchronized native boolean gdk_property_get(int /*long*/ window, int /*long*/ property, int /*long*/ type, int /*long*/ offset, int /*long*/ length, int pdelete, int /*long*/[] actual_property_type, int[] actual_format, int[] actual_length, int /*long*/[] data);
public static final synchronized native void gdk_region_destroy(int /*long*/ region);
public static final synchronized native boolean gdk_region_empty(int /*long*/ region);
public static final synchronized native void gdk_region_get_clipbox(int /*long*/ region, GdkRectangle rectangle);
public static final synchronized native void gdk_region_get_rectangles(int /*long*/ region, int /*long*/[] rectangles, int[] n_rectangles);
public static final synchronized native void gdk_region_intersect(int /*long*/ source1, int /*long*/ source2);
public static final synchronized native int /*long*/ gdk_region_new();
public static final synchronized native void gdk_region_offset(int /*long*/ region, int dx, int dy);
public static final synchronized native boolean gdk_region_point_in(int /*long*/ region, int x, int y);
public static final synchronized native int /*long*/ gdk_region_polygon(int[] points, int npoints, int fill_rule);
public static final synchronized native int /*long*/ gdk_region_rectangle(GdkRectangle rectangle);
public static final synchronized native int /*long*/ gdk_region_rect_in(int /*long*/ region, GdkRectangle rect);
public static final synchronized native void gdk_region_subtract(int /*long*/ source1, int /*long*/ source2);
public static final synchronized native void gdk_region_union(int /*long*/ source1, int /*long*/ source2);
public static final synchronized native void gdk_region_union_with_rect(int /*long*/ region, GdkRectangle rect);
public static final synchronized native void gdk_rgb_init();
public static final synchronized native int /*long*/ gdk_screen_get_default();
public static final synchronized native int gdk_screen_get_monitor_at_window(int /*long*/ screen, int /*long*/ window);
public static final synchronized native void gdk_screen_get_monitor_geometry (int /*long*/ screen, int monitor_num, GdkRectangle dest);
public static final synchronized native int gdk_screen_get_n_monitors(int /*long*/ screen);
public static final synchronized native int gdk_screen_get_number(int /*long*/ screen);
public static final synchronized native int gdk_screen_height();
public static final synchronized native int gdk_screen_width();
public static final synchronized native int gdk_screen_width_mm();
public static final synchronized native void gdk_set_program_class(byte[] program_class);
public static final synchronized native boolean gdk_utf8_to_compound_text(byte[] str, int /*long*/[] encoding, int[] format, int /*long*/[] ctext, int[] length);
public static final synchronized native int gdk_text_property_to_utf8_list  (int /*long*/ encoding, int format, int /*long*/ text, int length,  int /*long*/[] list);
public static final synchronized native void gdk_threads_enter();
public static final synchronized native void gdk_threads_init();
public static final synchronized native void gdk_threads_leave();
public static final synchronized native  int gdk_unicode_to_keyval(int wc);
public static final synchronized native int /*long*/ gdk_visual_get_system();
public static final synchronized native int /*long*/ gdk_window_at_pointer(int[] win_x, int[] win_y);
public static final synchronized native void gdk_window_begin_paint_rect(int /*long*/ window, GdkRectangle rectangle);
public static final synchronized native void gdk_window_destroy(int /*long*/ window);
public static final synchronized native void gdk_window_end_paint(int /*long*/ window);
public static final synchronized native int /*long*/ gdk_window_get_children(int /*long*/ window);
public static final synchronized native int gdk_window_get_events(int /*long*/ window);
public static final synchronized native void gdk_window_focus(int /*long*/ window, int timestamp);
public static final synchronized native void gdk_window_freeze_updates(int /*long*/ window);
public static final synchronized native void gdk_window_get_frame_extents(int /*long*/ window, GdkRectangle rect);
public static final synchronized native int gdk_window_get_origin(int /*long*/ window, int[] x, int[] y);
public static final synchronized native int /*long*/ gdk_window_get_parent(int /*long*/ window);
public static final synchronized native int /*long*/ gdk_window_get_pointer(int /*long*/ window, int[] x, int[] y, int[] mask);
public static final synchronized native void gdk_window_get_user_data(int /*long*/ window, int /*long*/[] data);
public static final synchronized native void gdk_window_hide(int /*long*/ window);
public static final synchronized native void gdk_window_invalidate_rect(int /*long*/ window, GdkRectangle rectangle, boolean invalidate_children);
public static final synchronized native void gdk_window_invalidate_region(int /*long*/ window, int /*long*/ region, boolean invalidate_children);
public static final synchronized native void gdk_window_move(int /*long*/ window, int x, int y);
public static final synchronized native int /*long*/ gdk_window_new(int /*long*/ parent, GdkWindowAttr attributes, int attributes_mask);
public static final synchronized native void gdk_window_lower(int /*long*/ window);
public static final synchronized native void gdk_window_process_all_updates();
public static final synchronized native void gdk_window_process_updates(int /*long*/ window, boolean update_children);
public static final synchronized native void gdk_window_raise(int /*long*/ window);
public static final synchronized native void gdk_window_resize(int /*long*/ window, int width, int height);
public static final synchronized native void gdk_window_scroll(int /*long*/ window, int dx, int dy);
public static final synchronized native void gdk_window_set_accept_focus(int /*long*/ window, boolean accept_focus);
public static final synchronized native void gdk_window_set_back_pixmap(int /*long*/ window, int /*long*/ pixmap, boolean parent_relative);
public static final synchronized native void gdk_window_set_cursor(int /*long*/ window, int /*long*/ cursor);
public static final synchronized native void gdk_window_set_decorations(int /*long*/ window, int decorations);
public static final synchronized native void gdk_window_set_events(int /*long*/ window, int event_mask);
public static final synchronized native void gdk_window_set_icon(int /*long*/ window, int /*long*/ icon_window, int /*long*/ pixmap, int /*long*/ mask);
public static final synchronized native void gdk_window_set_icon_list(int /*long*/ window, int /*long*/ pixbufs);
public static final synchronized native void gdk_window_set_keep_above(int /*long*/ window, boolean setting);
public static final synchronized native void gdk_window_set_override_redirect(int /*long*/ window, boolean override_redirect);
public static final synchronized native void gdk_window_set_user_data(int /*long*/ window, int /*long*/ user_data);
public static final synchronized native void gdk_window_shape_combine_region (int /*long*/ window, int /*long*/  shape_region, int offset_x,  int offset_y);
public static final synchronized native void gdk_window_show(int /*long*/ window);
public static final synchronized native void gdk_window_thaw_updates(int /*long*/ window);
public static final synchronized native int /*long*/ gtk_accel_group_new();
public static final synchronized native boolean gtk_accel_groups_activate(int /*long*/ accelGroup, int accelKey, int accelMods);
public static final synchronized native void gtk_accel_label_set_accel_widget(int /*long*/ accel_label, int /*long*/ accel_widget);
public static final synchronized native void gtk_adjustment_changed(int /*long*/ adjustment);
public static final synchronized native int /*long*/ gtk_adjustment_new(double value, double lower, double upper, double step_increment, double page_increment, double page_size);
public static final synchronized native void gtk_adjustment_set_value(int /*long*/ adjustment, double value);
public static final synchronized native void gtk_adjustment_value_changed(int /*long*/ adjustment);
public static final synchronized native int /*long*/ gtk_arrow_new(int arrow_type, int shadow_type);
public static final synchronized native void gtk_arrow_set(int /*long*/ arrow, int arrow_type, int shadow_type);
public static final synchronized native int /*long*/ gtk_bin_get_child(int /*long*/ bin);
public static final synchronized native int /*long*/ gtk_button_new();
public static final synchronized native void gtk_button_set_relief(int /*long*/ button, int newstyle);
public static final synchronized native void gtk_cell_renderer_get_size(int /*long*/ cell, int /*long*/ widget, GdkRectangle area, int[] x_offset, int[] y_offset, int[] width, int[] height);
public static final synchronized native int /*long*/ gtk_cell_renderer_pixbuf_new();
public static final synchronized native int /*long*/ gtk_cell_renderer_text_new();
public static final synchronized native int /*long*/ gtk_cell_renderer_toggle_new();
public static final synchronized native int /*long*/ gtk_check_button_new();
public static final synchronized native boolean gtk_check_menu_item_get_active(int /*long*/ wid);
public static final synchronized native int /*long*/ gtk_check_menu_item_new_with_label(byte[] label);
public static final synchronized native void gtk_check_menu_item_set_active(int /*long*/ wid, boolean active);
public static final synchronized native int /*long*/ gtk_check_version(int required_major, int required_minor, int required_micro);
public static final synchronized native void gtk_clipboard_clear(int /*long*/ clipboard);
public static final synchronized native int /*long*/ gtk_clipboard_get(int /*long*/ selection);
public static final synchronized native boolean gtk_clipboard_set_with_data(int /*long*/ clipboard, int /*long*/ target, int n_targets, int /*long*/ get_func, int /*long*/ clear_func, int /*long*/ user_data);
public static final synchronized native int /*long*/ gtk_clipboard_wait_for_contents(int /*long*/ clipboard, int /*long*/ target);
public static final synchronized native int /*long*/ gtk_color_selection_dialog_new(byte[] title);
public static final synchronized native void gtk_color_selection_get_current_color(int /*long*/ colorsel, GdkColor color);
public static final synchronized native void gtk_color_selection_set_current_color(int /*long*/ colorsel, GdkColor color);
public static final synchronized native void gtk_combo_disable_activate(int /*long*/ combo);
public static final synchronized native int /*long*/ gtk_combo_new();
public static final synchronized native void gtk_combo_set_case_sensitive(int /*long*/ combo, boolean val);
public static final synchronized native void gtk_combo_set_popdown_strings(int /*long*/ combo, int /*long*/ strings);
public static final synchronized native void gtk_container_add(int /*long*/ container, int /*long*/ widget);
public static final synchronized native int gtk_container_get_border_width(int /*long*/ container);
public static final synchronized native int /*long*/ gtk_container_get_children(int /*long*/ container);
public static final synchronized native void gtk_container_remove(int /*long*/ container, int /*long*/ widget);
public static final synchronized native void gtk_container_resize_children(int /*long*/ container);
public static final synchronized native void gtk_container_set_border_width(int /*long*/ container, int border_width);
public static final synchronized native int /*long*/ gtk_dialog_add_button(int /*long*/ dialog, String button_text, int response_id);
public static final synchronized native int gtk_dialog_run(int /*long*/ dialog);
public static final synchronized native int /*long*/ gtk_drag_begin(int /*long*/ widget, int /*long*/ targets, int actions, int button, int /*long*/ event);
public static final synchronized native boolean gtk_drag_check_threshold(int /*long*/ widget, int start_x, int start_y, int current_x, int current_y);
public static final synchronized native int /*long*/ gtk_drag_dest_find_target(int /*long*/ widget, int /*long*/ context, int /*long*/ target_list);
public static final synchronized native void gtk_drag_dest_set(int /*long*/ widget, int flags, int /*long*/ targets, int n_targets, int actions);
public static final synchronized native void gtk_drag_dest_unset(int /*long*/ widget);
public static final synchronized native void gtk_drag_finish(int /*long*/ context, boolean success, boolean delete, int time);
public static final synchronized native void gtk_drag_get_data(int /*long*/ widget, int /*long*/ context, int /*long*/ target, int time);
public static final synchronized native int /*long*/ gtk_drawing_area_new();
public static final synchronized native void gtk_editable_copy_clipboard(int /*long*/ editable);
public static final synchronized native void gtk_editable_cut_clipboard(int /*long*/ editable);
public static final synchronized native void gtk_editable_delete_selection(int /*long*/ editable);
public static final synchronized native void gtk_editable_delete_text(int /*long*/ editable, int start_pos, int end_pos);
public static final synchronized native int /*long*/ gtk_editable_get_chars(int /*long*/ editable, int start_pos, int end_pos);
public static final synchronized native boolean gtk_editable_get_editable(int /*long*/ editable);
public static final synchronized native int gtk_editable_get_position(int /*long*/ editable);
public static final synchronized native boolean gtk_editable_get_selection_bounds(int /*long*/ editable, int[] start, int[] end);
public static final synchronized native void gtk_editable_insert_text(int /*long*/ editable, byte[] new_text, int new_text_length, int[] position);
public static final synchronized native void gtk_editable_paste_clipboard(int /*long*/ editable);
public static final synchronized native void gtk_editable_select_region(int /*long*/ editable, int start, int end);
public static final synchronized native void gtk_editable_set_editable(int /*long*/ entry, boolean editable);
public static final synchronized native void gtk_editable_set_position(int /*long*/ editable, int position);
public static final synchronized native char gtk_entry_get_invisible_char(int /*long*/ entry);
public static final synchronized native int /*long*/ gtk_entry_get_layout (int /*long*/ entry);
public static final synchronized native int gtk_entry_get_max_length(int /*long*/ entry);
public static final synchronized native int /*long*/ gtk_entry_get_text(int /*long*/ entry);
public static final synchronized native boolean gtk_entry_get_visibility(int /*long*/ entry);
public static final synchronized native int /*long*/ gtk_entry_new();
public static final synchronized native void gtk_entry_set_activates_default(int /*long*/ entry, boolean setting);
public static final synchronized native void gtk_entry_set_alignment(int /*long*/ entry, float xalign);
public static final synchronized native void gtk_entry_set_has_frame(int /*long*/ entry, boolean setting);
public static final synchronized native void gtk_entry_set_invisible_char(int /*long*/ entry, char ch);
public static final synchronized native void gtk_entry_set_max_length(int /*long*/ entry, int max);
public static final synchronized native void gtk_entry_set_text(int /*long*/ entry, byte[] text);
public static final synchronized native void gtk_entry_set_visibility(int /*long*/ entry, boolean visible);
public static final synchronized native int gtk_events_pending();
public static final synchronized native void gtk_file_selection_complete(int /*long*/ filesel, byte[] pattern);
public static final synchronized native int /*long*/ gtk_file_selection_get_filename(int /*long*/ filesel);
public static final synchronized native int /*long*/ gtk_file_selection_get_selections(int /*long*/ filesel);
public static final synchronized native void gtk_file_selection_hide_fileop_buttons(int /*long*/ filesel);
public static final synchronized native int /*long*/ gtk_file_selection_new(byte[] title);
public static final synchronized native void gtk_file_selection_set_filename(int /*long*/ filesel, int /*long*/ filename);
public static final synchronized native void gtk_file_selection_set_select_multiple(int /*long*/ filesel, boolean select_multiple);
public static final synchronized native void gtk_fixed_move(int /*long*/ fixed, int /*long*/ widget, int x, int y);
public static final synchronized native int /*long*/ gtk_fixed_new();
public static final synchronized native void gtk_fixed_set_has_window(int /*long*/ fixed, boolean has_window);
public static final synchronized native int /*long*/ gtk_font_selection_dialog_get_font_name(int /*long*/ fsd);
public static final synchronized native int /*long*/ gtk_font_selection_dialog_new(byte[] title);
public static final synchronized native boolean gtk_font_selection_dialog_set_font_name(int /*long*/ fsd, byte[] fontname);
public static final synchronized native int /*long*/ gtk_frame_new(byte[] label);
public static final synchronized native int /*long*/ gtk_frame_get_label_widget(int /*long*/ frame);
public static final synchronized native void gtk_frame_set_label(int /*long*/ frame, byte[] label);
public static final synchronized native void gtk_frame_set_label_widget(int /*long*/ frame, int /*long*/ label_widget);
public static final synchronized native void gtk_frame_set_shadow_type(int /*long*/ frame, int type);
public static final synchronized native int /*long*/ gtk_get_current_event();
public static final synchronized native boolean gtk_get_current_event_state (int[] state);
public static final synchronized native int gtk_get_current_event_time();
public static final synchronized native int /*long*/ gtk_get_default_language();
public static final synchronized native int /*long*/ gtk_get_event_widget(int /*long*/ event);
public static final synchronized native void gtk_grab_add(int /*long*/ widget);
public static final synchronized native int /*long*/ gtk_grab_get_current();
public static final synchronized native void gtk_grab_remove(int /*long*/ widget);
public static final synchronized native int /*long*/ gtk_hbox_new(boolean homogeneous, int spacing);
public static final synchronized native int /*long*/ gtk_hscale_new(int /*long*/ adjustment);
public static final synchronized native int /*long*/ gtk_hscrollbar_new(int /*long*/ adjustment);
public static final synchronized native int /*long*/ gtk_hseparator_new();
public static final synchronized native int /*long*/ gtk_icon_factory_lookup_default(byte[] stock_id);
public static final synchronized native int /*long*/ gtk_icon_set_render_icon(int /*long*/ icon_set, int /*long*/ style, int direction, int state, int size, int /*long*/ widget, int /*long*/ detail);
public static final synchronized native boolean gtk_im_context_filter_keypress(int /*long*/ context, int /*long*/ event);
public static final synchronized native void gtk_im_context_focus_in(int /*long*/ context);
public static final synchronized native void gtk_im_context_focus_out(int /*long*/ context);
public static final synchronized native void gtk_im_context_get_preedit_string(int /*long*/ context, int /*long*/[] str, int /*long*/[] attrs, int[] cursor_pos);
public static final synchronized native int /*long*/ gtk_im_context_get_type();
public static final synchronized native void gtk_im_context_reset(int /*long*/ context);
public static final synchronized native void gtk_im_context_set_client_window(int /*long*/ context, int /*long*/ window);
public static final synchronized native void gtk_im_context_set_cursor_location(int /*long*/ context, GdkRectangle area);
public static final synchronized native void gtk_im_multicontext_append_menuitems (int /*long*/ context, int /*long*/ menushell);
public static final synchronized native int /*long*/ gtk_im_multicontext_new();
public static final synchronized native int /*long*/ gtk_image_menu_item_new_with_label(byte[] label);
public static final synchronized native void gtk_image_menu_item_set_image(int /*long*/ menu_item, int /*long*/ image);
public static final synchronized native int /*long*/ gtk_image_new();
public static final synchronized native int /*long*/ gtk_image_new_from_pixmap(int /*long*/ pixmap, int /*long*/ mask);
public static final synchronized native void gtk_image_set_from_pixmap(int /*long*/ image, int /*long*/ pixmap, int /*long*/ mask);
public static final synchronized native boolean gtk_init_check(int /*long*/[] argc, int /*long*/[] argv);
public static final synchronized native int gtk_label_get_mnemonic_keyval(int /*long*/ label);
public static final synchronized native int /*long*/ gtk_label_new(byte[] label);
public static final synchronized native int /*long*/ gtk_label_new_with_mnemonic(byte[] str);
public static final synchronized native void gtk_label_set_attributes(int /*long*/ label, int /*long*/ attrs);
public static final synchronized native void gtk_label_set_justify(int /*long*/ label, int jtype);
public static final synchronized native void gtk_label_set_line_wrap(int /*long*/ label, boolean wrap);
public static final synchronized native void gtk_label_set_text(int /*long*/ label, int /*long*/ str);
public static final synchronized native void gtk_label_set_text_with_mnemonic(int /*long*/ label, byte[] str);
public static final synchronized native void gtk_list_store_append(int /*long*/ list_store, int /*long*/ iter);
public static final synchronized native void gtk_list_store_clear(int /*long*/ store);
public static final synchronized native void gtk_list_store_insert(int /*long*/ list_store, int /*long*/ iter, int position);
public static final synchronized native int /*long*/ gtk_list_store_newv(int numColumns, int /*long*/[] types);
public static final synchronized native void gtk_list_store_remove(int /*long*/ list_store, int /*long*/ iter);
public static final synchronized native void gtk_list_store_set(int /*long*/ store, int /*long*/ iter, int column, byte[] value, int terminator);
public static final synchronized native void gtk_list_store_set(int /*long*/ store, int /*long*/ iter, int column, int value, int terminator);
public static final synchronized native void gtk_list_store_set(int /*long*/ store, int /*long*/ iter, int column, long value, int terminator);
public static final synchronized native void gtk_list_store_set(int /*long*/ store, int /*long*/ iter, int column, GdkColor value, int terminator);
public static final synchronized native void gtk_list_store_set(int /*long*/ store, int /*long*/ iter, int column, boolean value, int terminator);
public static final synchronized native int gtk_major_version();
public static final synchronized native int gtk_minor_version();
public static final synchronized native int gtk_micro_version();
public static final synchronized native void gtk_main();
public static final synchronized native int gtk_main_iteration();
public static final synchronized native void gtk_main_do_event(int /*long*/ event);
public static final synchronized native int /*long*/ gtk_menu_bar_new();
public static final synchronized native void gtk_menu_item_remove_submenu(int /*long*/ menu_item);
public static final synchronized native void gtk_menu_item_set_submenu(int /*long*/ menu_item, int /*long*/ submenu);
public static final synchronized native int /*long*/ gtk_menu_new();
public static final synchronized native void gtk_menu_popdown(int /*long*/ menu);
public static final synchronized native void gtk_menu_popup(int /*long*/ menu, int /*long*/ parent_menu_shell, int /*long*/ parent_menu_item, int /*long*/ func, int /*long*/ data, int button, int activate_time);
public static final synchronized native void gtk_menu_shell_deactivate(int /*long*/ menu_shell);
public static final synchronized native void gtk_menu_shell_insert(int /*long*/ menu_shell, int /*long*/ child, int position);
public static final synchronized native void gtk_menu_shell_select_item(int /*long*/ menu_shell, int /*long*/ menu_item);
public static final synchronized native int /*long*/ gtk_message_dialog_new(int /*long*/ parent, int flags, int type, int buttons, String message_format);
public static final synchronized native void gtk_misc_set_alignment(int /*long*/ misc, float xalign, float yalign);
public static final synchronized native int gtk_notebook_get_current_page(int /*long*/ notebook);
public static final synchronized native boolean gtk_notebook_get_scrollable(int /*long*/ notebook);
public static final synchronized native void gtk_notebook_insert_page(int /*long*/ notebook, int /*long*/ child, int /*long*/ tab_label, int position);
public static final synchronized native int /*long*/ gtk_notebook_new();
public static final synchronized native void gtk_notebook_remove_page(int /*long*/ notebook, int page_num);
public static final synchronized native void gtk_notebook_set_current_page(int /*long*/ notebook, int page_num);
public static final synchronized native void gtk_notebook_set_scrollable(int /*long*/ notebook, boolean scrollable);
public static final synchronized native void gtk_notebook_set_show_tabs(int /*long*/ notebook, boolean show_tabs);
public static final synchronized native void gtk_notebook_set_tab_pos(int /*long*/ notebook, int pos);
public static final synchronized native void gtk_object_sink(int /*long*/ object);
public static final synchronized native void gtk_paint_handle(int /*long*/ style, int /*long*/ window, int state_type, int shadow_type, GdkRectangle area, int /*long*/ widget, byte[] detail, int x , int y, int width, int height, int orientation);
public static final synchronized native int /*long*/ gtk_plug_get_id(int /*long*/ plug);
public static final synchronized native int /*long*/ gtk_plug_new(int /*long*/ socket_id);
public static final synchronized native int /*long*/ gtk_progress_bar_new();
public static final synchronized native void gtk_progress_bar_pulse(int /*long*/ pbar);
public static final synchronized native void gtk_progress_bar_set_fraction(int /*long*/ pbar, double fraction);
public static final synchronized native void gtk_progress_bar_set_orientation(int /*long*/ pbar, int orientation);
public static final synchronized native int /*long*/ gtk_radio_button_get_group(int /*long*/ radio_button);
public static final synchronized native int /*long*/ gtk_radio_button_new(int /*long*/ group);
public static final synchronized native int /*long*/ gtk_radio_menu_item_new_with_label(int /*long*/ group, byte[] label);
public static final synchronized native int /*long*/ gtk_range_get_adjustment(int /*long*/ range);
public static final synchronized native void gtk_range_set_increments(int /*long*/ range, double step, double page);
public static final synchronized native void gtk_range_set_range(int /*long*/ range, double min, double max);
public static final synchronized native void gtk_range_set_value(int /*long*/ range, double value);
public static final synchronized native void gtk_rc_parse_string(byte[] rc_string);
public static final synchronized native int /*long*/ gtk_rc_style_get_bg_pixmap_name(int /*long*/ style, int index);
public static final synchronized native int gtk_rc_style_get_color_flags(int /*long*/ style, int index);
public static final synchronized native void gtk_rc_style_set_bg(int /*long*/ style, int index, GdkColor color);
public static final synchronized native void gtk_rc_style_set_bg_pixmap_name(int /*long*/ style, int index, int /*long*/ name);
public static final synchronized native void gtk_rc_style_set_color_flags(int /*long*/ style, int index, int flag);
public static final synchronized native void gtk_scale_set_digits(int /*long*/ scale, int digits);
public static final synchronized native void gtk_scale_set_draw_value(int /*long*/ scale, boolean draw_value);
public static final synchronized native int /*long*/ gtk_scrolled_window_get_hadjustment(int /*long*/ scrolled_window);
public static final synchronized native void gtk_scrolled_window_get_policy(int /*long*/ scrolled_window, int[] hscrollbar_policy, int[] vscrollbar_policy);
public static final synchronized native int gtk_scrolled_window_get_shadow_type(int /*long*/ scrolled_window);
public static final synchronized native int /*long*/ gtk_scrolled_window_get_vadjustment(int /*long*/ scrolled_window);
public static final synchronized native int /*long*/ gtk_scrolled_window_new(int /*long*/ hadjustment, int /*long*/ vadjustment);
public static final synchronized native void gtk_scrolled_window_set_placement(int /*long*/ scrolled_window, int placement);
public static final synchronized native void gtk_scrolled_window_set_policy(int /*long*/ scrolled_window, int hscrollbar_policy, int vscrollbar_policy);
public static final synchronized native void gtk_scrolled_window_set_shadow_type(int /*long*/ scrolled_window, int type);
public static final synchronized native void gtk_selection_data_free(int /*long*/ selection_data);
public static final synchronized native void gtk_selection_data_set(int /*long*/ selection_data, int /*long*/ type, int format, int /*long*/ data, int length);
public static final synchronized native int /*long*/ gtk_separator_menu_item_new();
public static final synchronized native int /*long*/ gtk_set_locale();
public static final synchronized native int /*long*/ gtk_socket_get_id(int /*long*/ socket);
public static final synchronized native int /*long*/ gtk_socket_new();
public static final synchronized native void gtk_style_get_base(int /*long*/ style, int index, GdkColor color);
public static final synchronized native void gtk_style_get_black(int /*long*/ style, GdkColor color);
public static final synchronized native void gtk_style_get_bg(int /*long*/ style, int index, GdkColor color);
public static final synchronized native void gtk_style_get_dark(int /*long*/ style, int index, GdkColor color);
public static final synchronized native void gtk_style_get_fg(int /*long*/ style, int index, GdkColor color);
public static final synchronized native int /*long*/ gtk_style_get_font_desc(int /*long*/ style);
public static final synchronized native void gtk_style_get_light(int /*long*/ style, int index, GdkColor color);
public static final synchronized native void gtk_style_get_text(int /*long*/ style, int index, GdkColor color);
public static final synchronized native int gtk_style_get_xthickness(int /*long*/ style);
public static final synchronized native int gtk_style_get_ythickness(int /*long*/ style);
public static final synchronized native int /*long*/ gtk_target_list_new(int /*long*/ targets, int ntargets);
public static final synchronized native void gtk_target_list_unref(int /*long*/ list);
public static final synchronized native void gtk_text_buffer_copy_clipboard(int /*long*/ buffer, int /*long*/ clipboard);
public static final synchronized native void gtk_text_buffer_cut_clipboard(int /*long*/ buffer, int /*long*/ clipboard, boolean default_editable);
public static final synchronized native void gtk_text_buffer_delete(int /*long*/ buffer, byte[] start, byte[] end);
public static final synchronized native void gtk_text_buffer_get_bounds(int /*long*/ buffer, byte[] start, byte[] end);
public static final synchronized native int gtk_text_buffer_get_char_count(int /*long*/ buffer);
public static final synchronized native void gtk_text_buffer_get_end_iter(int /*long*/ buffer, byte[] iter);
public static final synchronized native int /*long*/ gtk_text_buffer_get_insert(int /*long*/ buffer);
public static final synchronized native void gtk_text_buffer_get_iter_at_line(int /*long*/ buffer, byte[] iter, int line_number);
public static final synchronized native void gtk_text_buffer_get_iter_at_mark(int /*long*/ buffer, byte[] iter, int /*long*/ mark);
public static final synchronized native void gtk_text_buffer_get_iter_at_offset(int /*long*/ buffer, byte[] iter, int char_offset);
public static final synchronized native int gtk_text_buffer_get_line_count(int /*long*/ buffer);
public static final synchronized native int /*long*/ gtk_text_buffer_get_selection_bound(int /*long*/ buffer);
public static final synchronized native boolean gtk_text_buffer_get_selection_bounds(int /*long*/ buffer, byte[] start, byte[] end);
public static final synchronized native int /*long*/ gtk_text_buffer_get_text(int /*long*/ buffer, byte[] start, byte[] end, boolean include_hidden_chars);
public static final synchronized native void gtk_text_buffer_insert(int /*long*/ buffer, byte[] iter, byte[] text, int len);
public static final synchronized native void gtk_text_buffer_insert(int /*long*/ buffer, int /*long*/ iter, byte[] text, int len);
public static final synchronized native void gtk_text_buffer_move_mark(int /*long*/ buffer, int /*long*/ mark, byte[] where);
public static final synchronized native void gtk_text_buffer_paste_clipboard(int /*long*/ buffer, int /*long*/ clipboard, byte[] override_location, boolean default_editable);
public static final synchronized native void gtk_text_buffer_place_cursor(int /*long*/ buffer, byte[] where);
public static final synchronized native void gtk_text_buffer_set_text(int /*long*/ buffer, byte[] text, int len);
public static final synchronized native int gtk_text_iter_get_line(byte[] iter);
public static final synchronized native int gtk_text_iter_get_offset(byte[] iter);
public static final synchronized native void gtk_text_view_buffer_to_window_coords(int /*long*/ text_view, int win, int buffer_x, int buffer_y, int[] window_x, int[] window_y);
public static final synchronized native int /*long*/ gtk_text_view_get_buffer(int /*long*/ text_view);
public static final synchronized native boolean gtk_text_view_get_editable(int /*long*/ text_view);
public static final synchronized native void gtk_text_view_get_iter_location(int /*long*/ text_view, byte[] iter, GdkRectangle location);
public static final synchronized native void gtk_text_view_get_line_at_y(int /*long*/ text_view, byte[] target_iter, int y, int[] line_top);
public static final synchronized native void gtk_text_view_get_visible_rect(int /*long*/ text_view, GdkRectangle visible_rect);
public static final synchronized native int /*long*/ gtk_text_view_get_window(int /*long*/ text_view, int win);
public static final synchronized native int /*long*/ gtk_text_view_new();
public static final synchronized native void gtk_text_view_scroll_mark_onscreen(int /*long*/ text_view, int /*long*/ mark);
public static final synchronized native boolean gtk_text_view_scroll_to_iter(int /*long*/ text_view, byte[] iter, double within_margin, boolean use_align, double xalign, double yalign);
public static final synchronized native void gtk_text_view_set_editable(int /*long*/ text_view, boolean setting);
public static final synchronized native void gtk_text_view_set_justification(int /*long*/ text_view, int justification);
public static final synchronized native void gtk_text_view_set_tabs(int /*long*/ text_view, int /*long*/ tabs);
public static final synchronized native void gtk_text_view_set_wrap_mode(int /*long*/ text_view, int wrap_mode);
public static final synchronized native int gtk_timeout_add(int interval, int /*long*/ function, int /*long*/ data);
public static final synchronized native void gtk_timeout_remove(int timeout_handler_id);
public static final synchronized native boolean gtk_toggle_button_get_active(int /*long*/ toggle_button);
public static final synchronized native int /*long*/ gtk_toggle_button_new();
public static final synchronized native void gtk_toggle_button_set_active(int /*long*/ toggle_button, boolean is_active);
public static final synchronized native void gtk_toggle_button_set_mode(int /*long*/ toggle_button, boolean draw_indicator);
public static final synchronized native void gtk_toolbar_insert_widget(int /*long*/ toolbar, int /*long*/ widget, byte[] tooltip_text, byte[] tooltip_private_text, int position);
public static final synchronized native int /*long*/ gtk_toolbar_new();
public static final synchronized native void gtk_toolbar_set_orientation(int /*long*/ toolbar, int orientation);
public static final synchronized native void gtk_tooltips_disable(int /*long*/ tooltips);
public static final synchronized native void gtk_tooltips_enable(int /*long*/ tooltips);
public static final synchronized native int /*long*/ gtk_tooltips_new();
public static final synchronized native void gtk_tooltips_set_tip(int /*long*/ tooltips, int /*long*/ widget, byte[] tip_text, byte[] tip_private);
public static final synchronized native void gtk_tree_model_get(int /*long*/ tree_model, int /*long*/ iter, int column, int[] value, int terminator);
public static final synchronized native void gtk_tree_model_get(int /*long*/ tree_model, int /*long*/ iter, int column, long[] value, int terminator);
public static final synchronized native boolean gtk_tree_model_get_iter(int /*long*/ tree_model, int /*long*/ iter, int /*long*/ path);
public static final synchronized native boolean gtk_tree_model_get_iter_first(int /*long*/ tree_model, int /*long*/ iter);
public static final synchronized native int gtk_tree_model_get_n_columns(int /*long*/ tree_model);
public static final synchronized native int /*long*/ gtk_tree_model_get_path(int /*long*/ tree_model, int /*long*/ iter);
public static final synchronized native int /*long*/ gtk_tree_model_get_type();
public static final synchronized native boolean gtk_tree_model_iter_children(int /*long*/ model, int /*long*/ iter, int /*long*/ parent);
public static final synchronized native int gtk_tree_model_iter_n_children(int /*long*/ model, int /*long*/ iter);
public static final synchronized native boolean gtk_tree_model_iter_next(int /*long*/ model, int /*long*/ iter);
public static final synchronized native boolean gtk_tree_model_iter_nth_child(int /*long*/ tree_model, int /*long*/ iter, int /*long*/ parent, int n);
public static final synchronized native void gtk_tree_path_append_index(int /*long*/ path, int index);
public static final synchronized native void gtk_tree_path_free(int /*long*/ path);
public static final synchronized native int gtk_tree_path_get_depth(int /*long*/ path);
public static final synchronized native int /*long*/ gtk_tree_path_get_indices(int /*long*/ path);
public static final synchronized native int /*long*/ gtk_tree_path_new();
public static final synchronized native int /*long*/ gtk_tree_path_new_first();
public static final synchronized native int /*long*/ gtk_tree_path_new_from_string(byte[] path);
public static final synchronized native int /*long*/ gtk_tree_path_new_from_string(int /*long*/ path);
public static final synchronized native boolean gtk_tree_path_up(int /*long*/ path);
public static final synchronized native boolean gtk_tree_selection_get_selected(int /*long*/ selection, int /*long*/[] model, int /*long*/ iter);
public static final synchronized native int /*long*/ gtk_tree_selection_get_selected_rows(int /*long*/ selection, int /*long*/[] model);
public static final synchronized native boolean gtk_tree_selection_path_is_selected(int /*long*/ selection, int /*long*/ path);
public static final synchronized native void gtk_tree_selection_select_all(int /*long*/ selection);
public static final synchronized native void gtk_tree_selection_select_iter(int /*long*/ selection, int /*long*/ iter);
public static final synchronized native void gtk_tree_selection_selected_foreach(int /*long*/ selection, int /*long*/ func, int /*long*/ data);
public static final synchronized native void gtk_tree_selection_set_mode(int /*long*/ selection, int mode);
public static final synchronized native void gtk_tree_selection_unselect_all(int /*long*/ selection);
public static final synchronized native void gtk_tree_selection_unselect_iter(int /*long*/ selection, int /*long*/ iter);
public static final synchronized native void gtk_tree_store_append(int /*long*/ store, int /*long*/ iter, int /*long*/ parent);
public static final synchronized native void gtk_tree_store_clear(int /*long*/ store);
public static final synchronized native void gtk_tree_store_insert(int /*long*/ store, int /*long*/ iter, int /*long*/ parent, int position);
public static final synchronized native int /*long*/ gtk_tree_store_newv(int numColumns, int /*long*/[] types);
public static final synchronized native void gtk_tree_store_remove(int /*long*/ store, int /*long*/ iter);
public static final synchronized native void gtk_tree_store_set(int /*long*/ store, int /*long*/ iter, int column, byte[] value, int terminator);
public static final synchronized native void gtk_tree_store_set(int /*long*/ store, int /*long*/ iter, int column, int value, int terminator);
public static final synchronized native void gtk_tree_store_set(int /*long*/ store, int /*long*/ iter, int column, long value, int terminator);
public static final synchronized native void gtk_tree_store_set(int /*long*/ store, int /*long*/ iter, int column, GdkColor value, int terminator);
public static final synchronized native void gtk_tree_store_set(int /*long*/ store, int /*long*/ iter, int column, boolean value, int terminator);
public static final synchronized native boolean gtk_tree_view_collapse_row(int /*long*/ view, int /*long*/ path);
public static final synchronized native void gtk_tree_view_column_add_attribute(int /*long*/ treeColumn, int /*long*/ cellRenderer, String attribute, int column);
public static final synchronized native boolean gtk_tree_view_column_cell_get_position(int /*long*/ tree_column, int /*long*/ cell_renderer, int[] start_pos, int[] width);
public static final synchronized native void gtk_tree_view_column_cell_get_size(int /*long*/ tree_column, GdkRectangle cell_area, int[] x_offset, int[] y_offset, int[] width, int[] height);
public static final synchronized native void gtk_tree_view_column_cell_set_cell_data(int /*long*/ tree_column, int /*long*/ tree_model, int /*long*/ iter, boolean is_expander, boolean is_expanded);
public static final synchronized native void gtk_tree_view_column_clear(int /*long*/ tree_column);
public static final synchronized native int /*long*/ gtk_tree_view_column_get_cell_renderers(int /*long*/ tree_column);
public static final synchronized native boolean gtk_tree_view_column_get_resizable(int /*long*/ column);
public static final synchronized native int gtk_tree_view_column_get_spacing(int /*long*/ tree_column);
public static final synchronized native boolean gtk_tree_view_column_get_visible(int /*long*/ column);
public static final synchronized native int gtk_tree_view_column_get_width(int /*long*/ column);
public static final synchronized native int /*long*/ gtk_tree_view_column_new();
public static final synchronized native void gtk_tree_view_column_pack_start(int /*long*/ tree_column, int /*long*/ cell_renderer, boolean expand);
public static final synchronized native void gtk_tree_view_column_pack_end(int /*long*/ tree_column, int /*long*/ cell_renderer, boolean expand);
public static final synchronized native void gtk_tree_view_column_set_alignment(int /*long*/ tree_column, float xalign);
public static final synchronized native void gtk_tree_view_column_set_cell_data_func(int /*long*/ tree_column, int /*long*/ cell_renderer, int /*long*/ func, int /*long*/ func_data, int /*long*/ destroy);
public static final synchronized native void gtk_tree_view_column_set_clickable(int /*long*/ column, boolean clickable);
public static final synchronized native void gtk_tree_view_column_set_fixed_width(int /*long*/ column, int fixed_width);
public static final synchronized native void gtk_tree_view_column_set_resizable(int /*long*/ column, boolean resizable);
public static final synchronized native void gtk_tree_view_column_set_sizing(int /*long*/ column, int type);
public static final synchronized native void gtk_tree_view_column_set_title(int /*long*/ tree_column, byte[] title);
public static final synchronized native void gtk_tree_view_column_set_visible (int /*long*/ tree_column, boolean visible);
public static final synchronized native void gtk_tree_view_column_set_widget(int /*long*/ tree_column, int /*long*/ widget);
public static final synchronized native void gtk_tree_view_set_drag_dest_row(int /*long*/ view, int /*long*/ path, int pos);
public static final synchronized native boolean gtk_tree_view_expand_row(int /*long*/ view, int /*long*/ path, boolean open_all);
public static final synchronized native int /*long*/ gtk_tree_view_get_bin_window(int /*long*/ tree_view);
public static final synchronized native void gtk_tree_view_get_cell_area(int /*long*/ tree_view, int /*long*/ path, int /*long*/ column, GdkRectangle rect);
public static final synchronized native int /*long*/gtk_tree_view_get_expander_column(int /*long*/ tree_view);
public static final synchronized native int /*long*/ gtk_tree_view_get_column(int /*long*/ tree_view, int n);
public static final synchronized native void gtk_tree_view_get_cursor(int /*long*/ tree_view, int /*long*/[] path, int /*long*/[] focus_column);
public static final synchronized native boolean gtk_tree_view_get_headers_visible(int /*long*/ tree_view);
public static final synchronized native boolean gtk_tree_view_get_path_at_pos(int /*long*/ tree_view, int x, int y, int /*long*/[] path, int /*long*/[] column, int[] cell_x, int[] cell_y);
public static final synchronized native boolean gtk_tree_view_get_rules_hint(int /*long*/ tree_view);
public static final synchronized native int /*long*/ gtk_tree_view_get_selection(int /*long*/ tree_view);
public static final synchronized native void gtk_tree_view_get_visible_rect(int /*long*/ tree_view, GdkRectangle visible_rect);
public static final synchronized native int gtk_tree_view_insert_column(int /*long*/ tree_view, int /*long*/ column, int position);
public static final synchronized native int /*long*/ gtk_tree_view_new_with_model(int /*long*/ model);
public static final synchronized native void gtk_tree_view_remove_column(int /*long*/ tree_view, int /*long*/ column);
public static final synchronized native boolean gtk_tree_view_row_expanded(int /*long*/ view, int /*long*/ path);
public static final synchronized native void gtk_tree_view_scroll_to_cell(int /*long*/ tree_view, int /*long*/ path, int /*long*/ column, boolean use_align, float row_aligh, float column_align);
public static final synchronized native void gtk_tree_view_scroll_to_point (int /*long*/ tree_view, int tree_x, int tree_y);
public static final synchronized native void gtk_tree_view_set_cursor(int /*long*/ tree_view, int /*long*/ path, int /*long*/ focus_column, boolean start_editing); 
public static final synchronized native void gtk_tree_view_set_headers_visible(int /*long*/ tree_view, boolean visible);
public static final synchronized native void gtk_tree_view_set_model(int /*long*/ tree_view, int /*long*/ model);
public static final synchronized native void gtk_tree_view_set_rules_hint(int /*long*/ tree_view, boolean setting);
public static final synchronized native void gtk_tree_view_tree_to_widget_coords(int /*long*/ tree_view, int tx, int ty, int[] wx, int[] wy);
public static final synchronized native void gtk_tree_view_unset_rows_drag_dest(int /*long*/ tree_view);
public static final synchronized native void gtk_tree_view_widget_to_tree_coords(int /*long*/ tree_view, int wx, int wy, int[] tx, int[] ty);
public static final synchronized native int /*long*/ gtk_vbox_new(boolean homogeneous, int spacing);
public static final synchronized native int /*long*/ gtk_vscale_new(int /*long*/ adjustment);
public static final synchronized native int /*long*/ gtk_vscrollbar_new(int /*long*/ adjustment);
public static final synchronized native int /*long*/ gtk_vseparator_new();
public static final synchronized native void gtk_widget_add_accelerator(int /*long*/ widget, byte[] accel_signal, int /*long*/ accel_group, int accel_key, int accel_mods, int accel_flags);
public static final synchronized native void gtk_widget_add_events(int /*long*/ widget, int events);
public static final synchronized native boolean gtk_widget_child_focus(int /*long*/ widget, int direction);
public static final synchronized native int /*long*/ gtk_widget_create_pango_layout(int /*long*/ widget, byte[] text);
public static final synchronized native int /*long*/ gtk_widget_create_pango_layout(int /*long*/ widget, int /*long*/ text);
public static final synchronized native void gtk_widget_destroy(int /*long*/ widget);
public static final synchronized native boolean gtk_widget_event(int /*long*/ widget, int /*long*/ event);
public static final synchronized native int gtk_widget_get_default_direction();
public static final synchronized native int /*long*/ gtk_widget_get_default_style();
public static final synchronized native int gtk_widget_get_direction(int /*long*/ widget);
public static final synchronized native int gtk_widget_get_events(int /*long*/ widget);
public static final synchronized native int /*long*/ gtk_widget_get_modifier_style(int /*long*/ widget);
public static final synchronized native int /*long*/ gtk_widget_get_pango_context(int /*long*/ widget);
public static final synchronized native int /*long*/ gtk_widget_get_parent(int /*long*/ widget);
public static final synchronized native int /*long*/ gtk_widget_get_style(int /*long*/ widget);
public static final synchronized native void gtk_widget_grab_focus(int /*long*/ widget);
public static final synchronized native void gtk_widget_hide(int /*long*/ widget);
public static final synchronized native boolean gtk_widget_is_focus(int /*long*/ widget);
public static final synchronized native boolean gtk_widget_mnemonic_activate(int /*long*/ widget, boolean group_cycling);
public static final synchronized native void gtk_widget_modify_base(int /*long*/ widget, int state, GdkColor color);
public static final synchronized native void gtk_widget_modify_bg(int /*long*/ widget, int state, GdkColor color);
public static final synchronized native void gtk_widget_modify_fg(int /*long*/ widget, int state, GdkColor color);
public static final synchronized native void gtk_widget_modify_font(int /*long*/ widget, int /*long*/ pango_font_descr);
public static final synchronized native void gtk_widget_modify_style(int /*long*/ widget, int /*long*/ style);
public static final synchronized native void gtk_widget_modify_text(int /*long*/ widget, int state, GdkColor color);
public static final synchronized native void gtk_widget_realize(int /*long*/ widget);
public static final synchronized native void gtk_widget_remove_accelerator(int /*long*/ widget, int /*long*/ accel_group, int accel_key, int accel_mods);
public static final synchronized native void gtk_widget_reparent(int /*long*/ widget, int /*long*/ new_parent);
public static final synchronized native void gtk_widget_set_default_direction(int dir); 
public static final synchronized native void gtk_widget_set_direction(int /*long*/ widget, int dir);
public static final synchronized native void gtk_widget_set_double_buffered(int /*long*/ widget, boolean double_buffered);
public static final synchronized native void gtk_widget_set_name(int /*long*/ widget, byte[] name);
public static final synchronized native void gtk_widget_set_redraw_on_allocate(int /*long*/ widget, boolean redraw);
public static final synchronized native void gtk_widget_set_sensitive(int /*long*/ widget, boolean sensitive);
public static final synchronized native void gtk_widget_set_size_request(int /*long*/ widget, int width, int height);
public static final synchronized native void gtk_widget_set_state(int /*long*/ widget, int state);
public static final synchronized native void gtk_widget_shape_combine_mask(int /*long*/ widget, int /*long*/ shape_mask, int offset_x, int offset_y);
public static final synchronized native void gtk_widget_show(int /*long*/ widget);
public static final synchronized native void gtk_widget_show_now(int /*long*/ widget);
public static final synchronized native void gtk_widget_size_allocate(int /*long*/ widget, GtkAllocation allocation);
public static final synchronized native void gtk_widget_size_request(int /*long*/ widget, GtkRequisition requisition);
public static final synchronized native void gtk_widget_style_get(int /*long*/ widget, byte[] property_name, int[] value, int null_terminator);
public static final synchronized native void gtk_widget_unrealize(int /*long*/ widget);
public static final synchronized native boolean gtk_window_activate_default(int /*long*/ window);
public static final synchronized native void gtk_window_add_accel_group(int /*long*/ window, int /*long*/ accel_group);
public static final synchronized native void gtk_window_deiconify(int /*long*/ handle);
public static final synchronized native int /*long*/ gtk_window_get_focus(int /*long*/ window);
public static final synchronized native int gtk_window_get_mnemonic_modifier(int /*long*/ window);
public static final synchronized native void gtk_window_get_position(int /*long*/ handle, int[] x, int[] y);
public static final synchronized native void gtk_window_get_size(int /*long*/ handle, int[] x, int[] y);
public static final synchronized native void gtk_window_iconify(int /*long*/ handle);
public static final synchronized native void gtk_window_maximize(int /*long*/ handle);
public static final synchronized native void gtk_window_move(int /*long*/ handle, int x, int y);
public static final synchronized native int /*long*/ gtk_window_new(int type);
public static final synchronized native void gtk_window_present(int /*long*/ window);
public static final synchronized native void gtk_window_remove_accel_group(int /*long*/ window, int /*long*/ accel_group);
public static final synchronized native void gtk_window_resize(int /*long*/ handle, int x, int y);
public static final synchronized native void gtk_window_set_default(int /*long*/ window, int /*long*/ widget);
public static final synchronized native void gtk_window_set_destroy_with_parent(int /*long*/ window, boolean setting);
public static final synchronized native void gtk_window_set_modal(int /*long*/ window, boolean modal);
public static final synchronized native void gtk_window_set_resizable(int /*long*/ window, boolean resizable);
public static final synchronized native void gtk_window_set_title(int /*long*/ window, byte[] title);
public static final synchronized native void gtk_window_set_type_hint(int /*long*/ window, int hint);
public static final synchronized native void gtk_window_set_transient_for(int /*long*/ window, int /*long*/ parent);
public static final synchronized native void gtk_window_unmaximize(int /*long*/ handle);
public static final native void memmove(int /*long*/ dest, GtkTargetEntry src, int /*long*/ size);
public static final native void memmove(int /*long*/ dest, GtkAdjustment src);
public static final native void memmove(int /*long*/ dest, GdkEventButton src, int /*long*/ size);
public static final native void memmove(int /*long*/ dest, PangoAttribute src, int /*long*/ size);
public static final native void memmove(GtkColorSelectionDialog dest, int /*long*/ src);
public static final native void memmove(GtkFileSelection dest, int /*long*/ src);
public static final native void memmove(GdkDragContext dest, int /*long*/ src, int /*long*/ size);
public static final native void memmove(GtkSelectionData dest, int /*long*/ src, int /*long*/ size);
public static final native void memmove(GtkTargetPair dest, int /*long*/ src, int /*long*/ size);
public static final native void memmove(GtkCombo dest, int /*long*/ src);
public static final native void memmove(GtkAdjustment dest, int /*long*/ src);
public static final native void memmove(GdkColor dest, int /*long*/ src, int /*long*/ size);
public static final native void memmove(GdkEvent dest, int /*long*/ src, int /*long*/ size);
public static final native void memmove(GdkEventButton dest, int /*long*/ src, int /*long*/ size);
public static final native void memmove(GdkEventCrossing dest, int /*long*/ src, int /*long*/ size);
public static final native void memmove(GdkEventExpose dest, int /*long*/ src, int /*long*/ size);
public static final native void memmove(GdkEventFocus dest, int /*long*/ src, int /*long*/ size);
public static final native void memmove(GdkEventKey dest, int /*long*/ src, int /*long*/ size);
public static final native void memmove(GdkEventMotion dest, int /*long*/ src, int /*long*/ size);
public static final native void memmove(GdkEventVisibility dest, int /*long*/ src, int /*long*/ size);
public static final native void memmove(GdkEventWindowState dest, int /*long*/ src, int /*long*/ size);
public static final native void memmove(GtkFixed dest, int /*long*/ src);
public static final native void memmove(int /*long*/ dest, GtkFixed src);
public static final native void memmove(GdkVisual dest, int /*long*/ src);
public static final native void memmove(GdkImage dest, int /*long*/ src);
public static final native void memmove(GdkRectangle dest, int /*long*/ src, int /*long*/ size);
public static final native void memmove(PangoAttribute dest, int /*long*/ src, int /*long*/ size);
public static final native void memmove(PangoItem dest, int /*long*/ src, int /*long*/ size);
public static final native void memmove(PangoLayoutLine dest, int /*long*/ src, int /*long*/ size);
public static final native void memmove(PangoLayoutRun dest, int /*long*/ src, int /*long*/ size);
public static final native void memmove(PangoLogAttr dest, int /*long*/ src, int /*long*/ size);
public static final native void memmove(int /*long*/ dest, int[] src, int /*long*/ size);
public static final native void memmove(int /*long*/ dest, byte[] src, int /*long*/ size);
public static final native void memmove(int[] dest, byte[] src, int /*long*/ size);
public static final native void memmove(byte[] dest, int /*long*/ src, int /*long*/ size);
public static final native void memmove(char[] dest, int /*long*/ src, int /*long*/ size);
public static final native void memmove(int[] dest, int /*long*/ src, int /*long*/ size);
public static final native void memmove(long[] dest, int /*long*/ src, int /*long*/ size);
public static final native void memset(int /*long*/ buffer, char c, int /*long*/ num);
public static final synchronized native int /*long*/ pango_attr_background_new (short red, short green, short blue);
public static final synchronized native int /*long*/ pango_attr_font_desc_new(int /*long*/ desc);
public static final synchronized native int /*long*/ pango_attr_foreground_new (short red, short green, short blue);
public static final synchronized native int /*long*/ pango_attr_shape_new(PangoRectangle ink_rect, PangoRectangle logical_rect);
public static final synchronized native void pango_attr_list_insert(int /*long*/ list, int /*long*/ attr);
public static final synchronized native void pango_attr_list_change(int /*long*/ list, int /*long*/ attr);
public static final synchronized native int /*long*/ pango_attr_list_new();
public static final synchronized native void pango_attr_list_unref(int /*long*/ list);
public static final synchronized native int /*long*/ pango_attr_strikethrough_new(boolean strikethrough);
public static final synchronized native int /*long*/ pango_attr_underline_new(int underline);
public static final synchronized native int /*long*/ pango_attr_weight_new(int weight);
public static final synchronized native int pango_context_get_base_dir(int /*long*/ context);
public static final synchronized native int /*long*/ pango_context_get_language(int /*long*/ context);
public static final synchronized native int /*long*/ pango_context_get_metrics(int /*long*/ context, int /*long*/ desc, int /*long*/ language);
public static final synchronized native void pango_context_list_families(int /*long*/ context, int /*long*/[] families, int[] n_families);
public static final synchronized native void pango_context_set_base_dir(int /*long*/ context, int direction);
public static final synchronized native void pango_context_set_language(int /*long*/ context, int /*long*/ language);
public static final synchronized native int /*long*/ pango_font_description_copy(int /*long*/ desc);
public static final synchronized native void pango_font_description_free(int /*long*/ desc);
public static final synchronized native int /*long*/ pango_font_description_from_string(byte[] str);
public static final synchronized native int /*long*/ pango_font_description_get_family(int /*long*/ desc);
public static final synchronized native int pango_font_description_get_size(int /*long*/ desc);
public static final synchronized native int pango_font_description_get_style(int /*long*/ desc);
public static final synchronized native int pango_font_description_get_weight(int /*long*/ desc);
public static final synchronized native int /*long*/ pango_font_description_new();
public static final synchronized native void pango_font_description_set_family(int /*long*/ desc, byte[] family);
public static final synchronized native void pango_font_description_set_size(int /*long*/ desc, int size);
public static final synchronized native void pango_font_description_set_stretch(int /*long*/ desc, int stretch);
public static final synchronized native void pango_font_description_set_style(int /*long*/ desc, int weight);
public static final synchronized native void pango_font_description_set_weight(int /*long*/ desc, int weight);
public static final synchronized native int /*long*/ pango_font_description_to_string(int /*long*/ desc);
public static final synchronized native int /*long*/ pango_font_face_describe(int /*long*/ face);
public static final synchronized native int /*long*/ pango_font_family_get_name (int /*long*/ family);
public static final synchronized native void pango_font_family_list_faces(int /*long*/ family, int /*long*/[] faces, int[] n_faces);
public static final synchronized native int /*long*/ pango_font_get_metrics(int /*long*/ font, int /*long*/ language);
public static final synchronized native int pango_font_metrics_get_approximate_char_width(int /*long*/ metrics);
public static final synchronized native int pango_font_metrics_get_ascent(int /*long*/ metrics);
public static final synchronized native int pango_font_metrics_get_descent(int /*long*/ metrics);
public static final synchronized native void pango_font_metrics_unref(int /*long*/ metrics);
public static final synchronized native int /*long*/ pango_language_from_string(byte[] language);
public static final synchronized native void pango_layout_context_changed (int /*long*/ layout);
public static final synchronized native int pango_layout_get_alignment(int /*long*/ layout);
public static final synchronized native int /*long*/ pango_layout_get_attributes(int /*long*/ layout);
public static final synchronized native int /*long*/ pango_layout_get_iter(int /*long*/ layout);
public static final synchronized native int /*long*/ pango_layout_get_line(int /*long*/ layout, int line);
public static final synchronized native int pango_layout_get_line_count(int /*long*/ layout);
public static final synchronized native void pango_layout_get_log_attrs(int /*long*/ layout, int /*long*/[] attrs, int[] n_attrs);
public static final synchronized native void pango_layout_get_size(int /*long*/ layout, int[] width, int[] height);
public static final synchronized native int pango_layout_get_spacing(int /*long*/ layout);
public static final synchronized native int /*long*/ pango_layout_get_tabs(int /*long*/ layout);
public static final synchronized native int /*long*/ pango_layout_get_text(int /*long*/ layout);
public static final synchronized native int pango_layout_get_width(int /*long*/ layout);
public static final synchronized native void pango_layout_index_to_pos(int /*long*/ layout, int index, PangoRectangle pos);
public static final synchronized native void pango_layout_iter_free(int /*long*/ iter);
public static final synchronized native void pango_layout_iter_get_line_extents(int /*long*/ iter, PangoRectangle ink_rect, PangoRectangle logical_rect);
public static final synchronized native int pango_layout_iter_get_index(int /*long*/ iter);
public static final synchronized native int /*long*/ pango_layout_iter_get_run(int /*long*/ iter);
public static final synchronized native boolean pango_layout_iter_next_line(int /*long*/ iter);
public static final synchronized native boolean pango_layout_iter_next_run(int /*long*/ iter);
public static final synchronized native void pango_layout_line_get_extents(int /*long*/ line, PangoRectangle ink_rect, PangoRectangle logical_rect);
public static final synchronized native boolean pango_layout_line_x_to_index(int /*long*/ line, int x_pos, int[] index_, int[] trailing);
public static final synchronized native int /*long*/ pango_layout_new(int /*long*/ context);
public static final synchronized native void pango_layout_set_alignment (int /*long*/ layout, int alignment);
public static final synchronized native void pango_layout_set_attributes(int /*long*/ layout, int /*long*/ attrs);
public static final synchronized native void pango_layout_set_font_description(int /*long*/ context, int /*long*/ descr);
public static final synchronized native void pango_layout_set_single_paragraph_mode(int /*long*/ context, boolean setting);
public static final synchronized native void pango_layout_set_spacing(int /*long*/ layout, int spacing);
public static final synchronized native void pango_layout_set_tabs(int /*long*/ layout, int /*long*/ tabs);
public static final synchronized native void pango_layout_set_text(int /*long*/ layout, byte[] text, int length);
public static final synchronized native void pango_layout_set_width(int /*long*/ layout, int width);
public static final synchronized native void pango_layout_set_wrap (int /*long*/ layout, int wrap);
public static final synchronized native boolean pango_layout_xy_to_index(int /*long*/ layout, int x, int y, int[] index, int[] trailing);
public static final synchronized native int pango_tab_array_get_size(int /*long*/ tab_array);
public static final synchronized native void pango_tab_array_get_tabs(int /*long*/ tab_array, int /*long*/[] alignments, int /*long*/[] locations);
public static final synchronized native void pango_tab_array_free(int /*long*/ tab_array);
public static final synchronized native int /*long*/ pango_tab_array_new(int initial_size, boolean positions_in_pixels);
public static final synchronized native void pango_tab_array_set_tab(int /*long*/ tab_array, int tab_index, int /*long*/ alignment, int location);
}
