//
// C++ Interface: mainwindow
//
// Description: 
//
//
// Author: Ivn Forcada Atienza <ivan@swscanner.org>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//

/**
@author Ivn Forcada Atienza
*/

#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include "swscanneriface.h"
#include "iwlib.h"
#include "gpslog.h"
#include "frmconfig.h"
#include "aplist.h"
#include "apentry.h"
#include "scanning.h"
#include "myevents.h"
#include "interface.h"
#include "gpserial.h"
#include "aplist.h"
#include "shapehandler.h"
#include "gpslog.h"
#include "frmutils.h"
#include "frmconfigini.h"
#include "swsconfig.h"
#include "scanthread.h"
#include "frmsignalchart.h"
#include "treefilterlistview.h"
#include "accesspointlistview.h"
#include "swsystemtray.h"
#include "configpopupmenu.h"
#include "swsglobals.h"
#include "filehandler.h"

#include <iostream>
#include <linux/if.h>
#include <arpa/inet.h>
#include <unistd.h>
#include <dcopclient.h>

#include <kmainwindow.h>
#include <kaudioplayer.h>
#include <kapp.h>
#include <kmenubar.h>
#include <klocale.h>
#include <kpopupmenu.h>
#include <kaction.h>
#include <kstdaccel.h>
#include <kshortcut.h>
#include <kled.h>
#include <kiconloader.h>
#include <kcmdlineargs.h>
#include <kaboutdialog.h>
#include <kfiledialog.h>
#include <kstandarddirs.h>
#include <kprogress.h>
#include <krecentdocument.h>
#include <kmessagebox.h>

#include <qlistview.h>
#include <qpushbutton.h>
#include <qlabel.h>
#include <qcheckbox.h>
#include <qcombobox.h>
#include <qspinbox.h>
#include <qgroupbox.h>
#include <qlayout.h>
#include <qheader.h>
#include <qtooltip.h>
#include <qtimer.h>
#include <qprocess.h>
#include <qtable.h>
#include <qdom.h>

void delay (int sec);
QPixmap getPix2(int signal);

typedef struct nodes_statistics
{
	int wepon;
	int wepoff;
	int chans[13];
}nstats;

class MainWindow : public KMainWindow, public SWScannerIface
{
Q_OBJECT

private:

	QLabel* 	textLabel1;
	QLabel* 	textLabel2;
	QLabel* 	textLabel3;	
	QLabel* 	textLabel4;
	QLabel* 	textLabel5;
	QLabel* 	textLabel6;
	QLabel* 	textLabel7;
	QLabel* 	textLabel8;
	QLabel* 	textLabel9;
	QLabel* 	textLabel10;
	QLabel* 	textLabel11;	
	QLabel* 	textLabel12;
	QLabel* 	textLabel13;
	QLabel* 	textLabel14;
	QLabel* 	textLabel15;	
	QLabel* 	textLabel16;
	QLabel* 	textLabel17;
	QLabel* 	textLabel18;	
	QLabel* 	textLabel19;
	
	QLabel* 	lblIP;
	QLabel* 	lblMask;
	QLabel* 	lblBcast;
	QLabel* 	lblMode;
	QLabel* 	lblEssid;
	QLabel* 	lblChan;
	QLabel* 	lblWEP;
	QLabel* 	lblKLen;
	QLabel* 	lblSignal;
	QLabel* 	pixSignal;
	QLabel* 	lblNoise;
	QLabel* 	lblSNR;
	QLabel* 	lblAP;
	QLabel* 	lblAPs;
	QLabel* 	lblLat;
	QLabel* 	lblSpeed;
	QLabel* 	lblLong;
	QLabel* 	lblAPnum;
	QLabel* 	lblSpeedUnits;
	QLineEdit* 	lblStats;

	QTable* 	tblStatsWEP;
	QTable* 	tblStatsChan;
		
	TreeFilterListView* 	lstFilter;
	AccessPointListView* 	tblScan;

	KToggleAction * 	viewStatsAction;
	KToggleAction * 	viewStatusAction;
	KToggleAction * 	viewGPSAction;
	KToggleAction * 	viewFilterAction;
	KRecentFilesAction *	recentsAction;

	configPopupMenu *	apConfigActions;

	QPushButton* 	buttonCancel;
	QPushButton* 	buttonOk;
	QPushButton* 	btnStop;
	QPushButton* 	btnClear;
	QPushButton* 	btnRefresh;
	QPushButton* 	btnGPS;
	QPushButton* 	btnShowStats;
	QPushButton* 	btnShowFilter;
	QPushButton* 	btnShowStatus;
	QPushButton* 	btnShowGPS;

	KPopupMenu* 	fileMenu;
	KPopupMenu* 	editMenu;
	KPopupMenu* 	viewMenu;
	KPopupMenu* 	actionsMenu;
	KPopupMenu* 	toolsMenu;
	int 		actionsPosition;

	QGroupBox* 	grpGPS;
	QGroupBox* 	grpStatus;
	
	QCheckBox* 	chkPreserve;
	QCheckBox* 	chkSound;	
	QComboBox* 	cmbIface;
	
	QSpinBox* 	spInterval;

	KLed* 		GPSLed;
	
	SWSystemTray*	SWSTray;

	QTimer*		scanTimer;
	QTimer*		statusTimer;
	
	APList* 	nodes;			// continuously regenerated ap list (in each scan)
	GPSerial* 	gps;			// thread reading GPS data
	ScanThread* 	sct;			// thread for scanning
	gpslog* 	log;			// gps log, log gps, gps log ;-)
	ShapeHandler* 	shapefile;

	nstats		nodeStats;
	
public slots:
	
	virtual void fileOpen();
	virtual void fileSave();
	virtual void editCut();
	virtual void editCopy();
	virtual void editPaste();
	virtual void start();
	virtual void stopScan();
	virtual void timerScanDone();	
	virtual void timerStatusDone();
	virtual void changeInterface();
	virtual void fileAdd();
	virtual void showPopupMenu(QListViewItem * it, const QPoint & pos, int col);
	virtual void clearAll();
	virtual void GPSstart();
	virtual void GPSstop();
	virtual void changeInterval();
	virtual void toolsUtilities();
	virtual void toolsSettings();
	virtual void applyFilter(QListViewItem *);
	virtual void chkPreserveClick();
	virtual void chkSoundClick();
	virtual void refreshCombo();
	virtual void customEvent(QCustomEvent *);
	virtual void asociate();
	virtual void removeConfig();
	virtual void showChart();
	virtual void keyReleaseEvent(QKeyEvent *);
	virtual void showConfig();
	virtual void showStats();
	virtual void showStatus();
	virtual void showGPS();
	virtual void showFilter();
	virtual void apItemChanged(QListViewItem *);
	virtual void apItemChanged();
	virtual void fileRecents(const KURL& url);
	virtual bool queryClose();

protected:

	QHBoxLayout* layout1;
	QHBoxLayout* layout2;
	QHBoxLayout* layout3;	
	QHBoxLayout* layout4;
	QHBoxLayout* layout5;	
	QHBoxLayout* layout6;
	QHBoxLayout* layout7;
	QHBoxLayout* layout8;
	QHBoxLayout* layout9;
	QHBoxLayout* layout12;
	
	QGridLayout* grpStatusLayout;
	QGridLayout* frmPrincipalLayout;
	QGridLayout* grpGPSLayout;
	QGridLayout* layout10;

	QVBoxLayout* layout11;	

	QSpacerItem* spacer1;
	QSpacerItem* spacer2;
	QSpacerItem* spacer3;
	QSpacerItem* spacer4;
	QSpacerItem* spacer5;
	QSpacerItem* spacer6;
	QSpacerItem* spacer7;
	QSpacerItem* spacer8;
	QSpacerItem* spacer9;
	QSpacerItem* spacer10;
	QSpacerItem* spacer11;
	QSpacerItem* spacer12;
	QSpacerItem* spacer13;
	QSpacerItem* spacer14;
	QSpacerItem* spacer15;
	QSpacerItem* spacer16;
	QSpacerItem* spacer17;

  public:
	
	MainWindow ( const char * name, WFlags f = Qt::WType_TopLevel|Qt::WDestructiveClose );
	~MainWindow();

	void		getStatus(QString iface);
        void		fileOpen(char * name);
	void		fileAdd(char * name);
	void		updateRow(APEntry* ap);
	void		flushOldNodes();
	bool		passTheFilter(QListViewItem * it);
	void		startDhcp(QString client);
	void		executeScript(QString script);
	void		updateNumLabel();
	void		updateStatistics();
	void		repaintTable();
	KPopupMenu * 	getActionsMenu();
	
	// Dcop functions
	void startScanning() { start(); };
	void stopScanning() { stopScan(); };
	void clearList() { clearAll(); };
	void changeInterface( QString ifc );

};

#endif
