// Copyright (C) 2006-2009 Kent-Andre Mardal and Simula Research Laboratory.
// Licensed under the GNU GPL Version 2, or (at your option) any later version.

#ifndef DISCONTINUOUSLAGRANGEFE_IS_INCLUDED
#define DISCONTINUOUSLAGRANGEFE_IS_INCLUDED

#include "Lagrange.h"
#include <ginac/ginac.h>

namespace SyFi
{

	class DiscontinuousLagrange : public Lagrange
	{
		GiNaC::ex element;
		public:
			DiscontinuousLagrange();
			DiscontinuousLagrange(Polygon& p, unsigned int order = 1);
			virtual ~DiscontinuousLagrange() {}

			virtual void set_element_number(unsigned int element);
			virtual void compute_basis_functions();
	};

	class VectorDiscontinuousLagrange : public VectorLagrange
	{
		GiNaC::ex element;
		public:
			VectorDiscontinuousLagrange();
			VectorDiscontinuousLagrange(Polygon& p, unsigned int order = 1);
			virtual ~VectorDiscontinuousLagrange() {}

			virtual void set_element_number(unsigned int element);
			virtual void set_size(unsigned int size_);
			virtual void compute_basis_functions();
	};

}								 // namespace SyFi
#endif
