#!/usr/bin/python

from swiginac import *
from SyFi import *

initSyFi(3)

x = cvar.x; y = cvar.y; z = cvar.z # fetch some global variables 


class CrouzeixRaviart: 
  """ 
    Python implementation of the Crouzeix-Raviart element. 
    The corresponding C++ implementation is in the 
    file CrouzeixRaviart.cpp.
  """ 

  def __init__(self, polygon):  
    """ Constructor """
    self.Ns = []
    self.dofs = []
    self.polygon = polygon 
    self.compute_basis_functions()

  def compute_basis_functions(self): 
    """ 
    Compute the basis functions and degrees of freedom  
    and put them in Ns and dofs, respectively. 
    """
    polspace = bernstein(1,triangle,"a")
    N = polspace[0]
    variables = polspace[1]

    for i in range(0,3): 
      line = triangle.line(i)
      dofi = line.integrate(N) 
      self.dofs.append(dofi)

    for i in range(0,3): 
      equations = []
      for j in range(0,3): 
        equations.append(relational(self.dofs[j], dirac(i,j)))
      sub = lsolve(equations, variables) 
      Ni = N.subs(sub) 
      self.Ns.append(Ni); 

  def N(self,i): return self.Ns[i]
  def dof(self,i): return self.dofs[i]
  def nbf(self): return len(self.Ns)


p0 = [0,0,0]; p1 = [1,0,0]; p2 = [0,1,0]; 

triangle = Triangle(p0, p1, p2) 

fe = CrouzeixRaviart(triangle)
fe.compute_basis_functions()
print fe.nbf()

for i in range(0,fe.nbf()): 
  print "N(%d)       = "%i,   fe.N(i).eval().printc()
  print "grad(N(%d)) = "%i,   grad(fe.N(i)).eval().printc()
  print "dof(%d)     = "%i,   fe.dof(i).eval().printc()






