// Copyright (C) 2009 Martin Sandve Alnes
//
// This file is part of SyFi.
//
// SyFi is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 2 of the License, or
// (at your option) any later version.
//
// SyFi is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with SyFi. If not, see <http://www.gnu.org/licenses/>.
//
// First added:  2009-01-01
// Last changed: 2009-04-01
//
// This demo program computes a projection of a function
// between two vector finite element spaces.

#include <dolfin.h>
#include "generated_code/ProjectionVector.h"

using namespace dolfin;
using namespace ProjectionVector;

class Weight: public Expression 
{
public:
  void eval(Array<double>& values, const Array<double>& x) const
  {
    values[0] = 1.0;
  }
};

class Source: public Expression 
{
public:
  Source() : Expression(2) {}
  void eval(Array<double>& values, const Array<double>& x) const
  {
    double dx = x[0] - 0.5;
    double dy = x[1] - 0.5;
    //values[0] = cos(2*DOLFIN_PI*dx*dx);
    //values[1] = cos(2*DOLFIN_PI*dy*dy);
    values[0] = x[0] + x[1];
    values[1] = x[0] + x[1];
  }
};

int main(int argc, char ** argv)
{
  UnitSquare mesh(10, 10);

  BilinearForm::TrialSpace V(mesh);
  CoefficientSpace_c C(mesh);
  CoefficientSpace_f F(mesh);

  Weight c;
  Source f;
  Function u(V);

  BilinearForm a(V, V);
  LinearForm L(V);

  a.c = c;
  L.f = f;

  solve(a == L, u); 

  
  // Interpolate f onto the discrete space V
  Source f2;
  Function fi(V);
  fi.interpolate(f2); 
  
  File u_file("u.pvd");
  u_file << u;
  File f_file("f.pvd");
  f_file << fi;
  
  //plot(u);
  
  return 0;
}

