<?php
	/**
	 * $Id: BuildLogger.php 3076 2006-12-18 08:52:12Z fabien $
	 *
	 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
	 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
	 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
	 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
	 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
	 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
	 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
	 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
	 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
	 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
	 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
	 *
	 * This software consists of voluntary contributions made by many individuals
	 * and is licensed under the LGPL. For more information please see
	 * <http://phing.info>.
	 */
	
	require_once 'phing/BuildListener.php';
	/**
	 * Interface used by Phing Ant to log the build output.
	 *
	 * @author Michiel Rook <michiel.rook@gmail.com>
	 * @version $Id: BuildLogger.php 3076 2006-12-18 08:52:12Z fabien $
	 * @package phing.listener
	 */
	interface BuildLogger extends BuildListener
	{
		/**
		 * Sets the highest level of message this logger should respond to.
		 *
		 * Only messages with a message level lower than or equal to the
		 * given level should be written to the log.
		 *
		 * @param int the logging level for the logger.
		 */
		function setMessageOutputLevel($level);
	};
?>