

#include <apt-pkg/acquire.h>

#include <vector>

#include "rwwindow.h"

#include <WINGs/wtableview.h>


class RWFetchProgress : public pkgAcquireStatus, public RWWindow
{
   struct Item {
       string uri;
       string size;
       int status;
   };
   
   vector<Item> _items;

   WMTableView *_table;
   WMLabel *_statusL;
   
   bool _cancelled;

   void updateStatus(pkgAcquire::ItemDesc &Itm, int status);
   
   static void stopDownload(WMWidget *self, void *data);

   static int numberOfRows(WMTableViewDelegate *self, WMTableView *table);

   static void *valueForCell(WMTableViewDelegate *self, 
			     WMTableColumn *column, int row);
public:
   
   virtual bool MediaChange(string Media,string Drive);
   virtual void IMSHit(pkgAcquire::ItemDesc &Itm);
   virtual void Fetch(pkgAcquire::ItemDesc &Itm);
   virtual void Done(pkgAcquire::ItemDesc &Itm);
   virtual void Fail(pkgAcquire::ItemDesc &Itm);
   virtual void Start();
   virtual void Stop();

   bool Pulse(pkgAcquire *Owner);

   RWFetchProgress(RWWindow *win);
};
