C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C                       *****************
                        SUBROUTINE BILFLV
C                       *****************
C
C      ----------------------------------------------------------
     * (NREFE,NELEMS,NBFLVS,NPFEL,NFLUVS,VFLUVS,VOLUME,
     *  NPOINS,NDIM,COORDS,NDMATS,NODES)
C      ----------------------------------------------------------
C
C***********************************************************************
C* SYRTHES 3.4.2                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C FONCTION :                                                           *
C ----------                                                           *
C            BILANS DE FLUX VOLUMIQUES                                 *
C-----------------------------------------------------------------------
C                             ARGUMENTS
C .___________.____.____.______________________________________________.
C !    NOM    !TYPE!MODE!                   ROLE                       !
C !___________!____!____!______________________________________________!
C !  NBFLVS   !  E ! D  ! NOMBRE DE NOEUDS AVEC FLUX VOL               !
C !  NFLUVS   ! TE ! D  ! NUMEROS GLOBAUX DES NOEUDS AVEC FLUX VOL     !
C !  VFLUVS   ! TR ! R  ! VALEUR DU FLUX VOLUMIQUE EN CES NOEUDS       !
C !___________!____!____!______________________________________________!
C ! COMMONS                                                            !
C !____________________________________________________________________!
C ! /OPTCT/   !    ! D  !                                              !
C ! /TEMPS/   !    ! D  !                                              !
C !___________!____!____!______________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : ---
C
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) : 
C
C***********************************************************************
C
      IMPLICIT NONE
C
C***********************************************************************
C     DONNEES EN COMMON  
C **********************************************************************
C
#include "optct.h"
#include "divct.h"
#include "bilan.h"
#include "nlofes.h"
C
C***********************************************************************
C
C.. Variables externes
      INTEGER NBFLVS,NPFEL,NELEMS,NDIM,NPOINS,NDMATS
      INTEGER NREFE(NELEMS),NFLUVS(NBFLVS),NODES(NELEMS,NDMATS)
      DOUBLE PRECISION  VFLUVS(NBFLVS,NPFEL),COORDS(NPOINS,NDIM)
      DOUBLE PRECISION  VOLUME(NELEMS)
C
C.. Variables internes
      INTEGER I,NUMREF,NCA,NB,N1,N2,N3,NI
      LOGICAL OK
      DOUBLE PRECISION PHI,S12,S160,S480
      DOUBLE PRECISION R1,R2,R3,F1,F2,F3,F4,F5,F6,F7,F8,F9,F10
C
C***********************************************************************
      IF (IAXISY.EQ.1) THEN
         NCA=2
      ELSE
         NCA=1
      ENDIF
C
      S12 = 1.D0 / 12.D0
      S160 = 1.D0 / 160.D0
      S480 = 1.D0 / 480.D0
C
      DO NB=1,NBISMX
        BFLUVO(NB)=0.
      ENDDO
C
      DO NB=1,NBILAV
        DO I=1,NBFLVS
          NUMREF=NREFE(NFLUVS(I))
          OK=.FALSE.
          DO N1=1,NRFMA2
            IF (IRBILV(N1,NB).NE.0 .AND. NUMREF.EQ.N1) OK=.TRUE.
          ENDDO
          IF (OK) THEN
            IF (NDFLUV.EQ.2) THEN
              BFLUVO(NB)=BFLUVO(NB)+VFLUVS(I,1)*VOLUME(NFLUVS(I))
            ELSEIF (NDFLUV.EQ.3) THEN
              IF (NDIM.EQ.2 .AND. IAXISY.EQ.0) THEN
                 F1  = VFLUVS(I,1)
                 F2  = VFLUVS(I,2)
                 F3  = VFLUVS(I,3)
                 F4  = VFLUVS(I,4)
                 F5  = VFLUVS(I,5)
                 F6  = VFLUVS(I,6)
                 PHI=F1+F2+F3+3*F4+3*F5+3*F6     
                 BFLUVO(NB)=BFLUVO(NB)+PHI*VOLUME(NFLUVS(I))*S12
              ELSEIF (NDIM.EQ.2 .AND. IAXISY.NE.0) THEN
                 NI=NFLUVS(I)
                 N1 = NODES(NI,1)
                 N2 = NODES(NI,2)
                 N3 = NODES(NI,3)
                 R1 = ABS( COORDS(N1,NCA) )
                 R2 = ABS( COORDS(N2,NCA) )
                 R3 = ABS( COORDS(N3,NCA) )
                 F1  = VFLUVS(I,1)
                 F2  = VFLUVS(I,2)
                 F3  = VFLUVS(I,3)
                 F4  = VFLUVS(I,4)
                 F5  = VFLUVS(I,5)
                 F6  = VFLUVS(I,6)
                 PHI=  F1*(30*R1+4*R2+4*R3) + F2*(4*R1+30*R2+4*R3) 
     *               + F3*(4*R1+4*R2+30*R3) + F4*(50*R1+50*R2+20*R3)
     *               + F5*(20*R1+50*R2+50*R3)+F6*(50*R1+20*R2+50*R3)
                 BFLUVO(NB)=BFLUVO(NB)+PHI*VOLUME(NI)*S480
              ELSE
                 NI=NFLUVS(I)
                 F1  = VFLUVS(I,1)
                 F2  = VFLUVS(I,2)
                 F3  = VFLUVS(I,3)
                 F4  = VFLUVS(I,4)
                 F5  = VFLUVS(I,5)
                 F6  = VFLUVS(I,6)
                 F7  = VFLUVS(I,7)
                 F8  = VFLUVS(I,8)
                 F9  = VFLUVS(I,9)
                 F10 = VFLUVS(I,10)
                 PHI=5*F1+5*F2+5*F3+5*F4+20*F5+30*F6+20*F7+30*F8+20*F9
     *                +20*F10
                 BFLUVO(NB)=BFLUVO(NB)+PHI*VOLUME(NI)*S160
              ENDIF
            ENDIF
          ENDIF
        ENDDO
      ENDDO
C
C
C
C     IMPRESSIONS
C     -----------
C
      WRITE(NFECRA,1000)
      DO NB=1,NBILAV
         WRITE(NFECRA,1010) NB,BFLUVO(NB)
      ENDDO
C
C--------
C FORMATS
C--------
 1000 FORMAT(/,'Bilans de Flux volumiques :')
 1010 FORMAT(  ' * Bilan ',I2,' * flux volumique = ',E12.5)
C                             
      END

