C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C/MEMBR ADD NAME=RAYFLU,SSI=0
                        SUBROUTINE RAYFLU
C                       *****************
C
C      -------------------------------------------------------
     * (MODE,
     *  NDIM,NFIXLT,NFXLP2,NPOINF,NBCOUF,NCOUPF,VCOUPF,
     *  TFLUID,TEMPAR,LNUMP2,UTAUP,TPLUS)
C      -------------------------------------------------------
C
C***********************************************************************
C* SYRTHES 3.4.2                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C FONCTION :                                                           *
C ----------                                                           *
C            PASSAGE DES DONNES VOL DU FLUIDE AU TABLEAU VCOUPF        *
C                                                                      * 
C----------------------------------------------------------------------
C                             ARGUMENTS
C .___________.____.____.______________________________________________.
C !    NOM    !TYPE!MODE!                   ROLE                       !
C !___________!____!____!______________________________________________!
C !  MODE     !  E ! D  ! SENS DE L'INTERPOLATION                      !
C !           !    !    !   = 1 PASSAGE SOLIDE --> FLUIDE              !
C !           !    !    !   = 2 PASSAGE FLUIDE --> SOLIDE              !
C !  NDIM     !  E ! D  ! DIMENSION DU PROBLEME                        !
C !  NBCOUF   !  E ! D  ! NOMBRE DE NOEUDS FLUIDES COUPLES             !
C !  NCOUPF   ! TE ! D  ! NUMERO DES NOEUDS FLUIDES COUPLES            !
C !  VCOUPF   ! TR !D M ! VALEUR AUX NOEUDS FLUIDES COUPLES            !
C !___________!____!____!______________________________________________!
C ! COMMONS                                                            !
C !____________________________________________________________________!
C ! /NLOFES/  !    ! D  !                                              !
C !___________!____!____!______________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : ---
C
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) : 
C
C***********************************************************************
C
      IMPLICIT NONE
C
C***********************************************************************
C     DONNEES EN COMMON  
C **********************************************************************
C
#include "nlofes.h"
#include "optct.h"
C
C **********************************************************************
C Attention common issu de N3S
      DOUBLE PRECISION PI,DEGRAD,ZERO,UN,EPZERO
      INTEGER          IZERO,IUN
      COMMON /CONST/   PI,DEGRAD,ZERO,UN,EPZERO,IZERO,IUN   
      DOUBLE PRECISION DEN,VISC,SPHT,CONDUC,BETA,REY,PRNDLA  
      COMMON /FLUID/   DEN,VISC,SPHT,CONDUC,BETA,REY,PRNDLA   
      DOUBLE PRECISION VREF,RAYHYD,PREF,TREF,DX0,Y5PRND,ALMAX,GRAVIT          
      COMMON /VALREF/  VREF,RAYHYD,PREF,TREF,DX0,Y5PRND,ALMAX,GRAVIT(3)
C
C***********************************************************************
C
C..Variables externes
      INTEGER MODE,NDIM,NBCOUF,NFIXLT,NFXLP2,NPOINF
      INTEGER NCOUPF(NBCOUF,2),LNUMP2(NPOINF)
      DOUBLE PRECISION VCOUPF(NBCOUF,2)
      DOUBLE PRECISION TFLUID(NPOINF),TEMPAR(NFIXLT)
      DOUBLE PRECISION UTAUP(NFXLP2),TPLUS(NFIXLT)
C
C..Variables internes
      INTEGER NF,NTP,NGF,IP,N
      DOUBLE PRECISION XXH,UTEMPP
C
C***********************************************************************
C
C     0- INITIALISATIONS
C     ==================
C
C
      IF (MODE.EQ.1) THEN
C
C      1- PASSAGE DU SOLIDE VERS LE FLUIDE
C      ===================================
C
       DO 100 NF=1,NBCOUF
C
        NTP = NCOUPF(NF,2)
C
        TEMPAR(NTP) = VCOUPF(NF,1)
C
  100  CONTINUE
C
C       IMPRESSIONS POUR CONTROLE
C       -------------------------
        IF (NBLBLR.GE.10) THEN
          WRITE(NFECRA,1010)
          DO 110 N=1,NFIXLT
             WRITE(NFECRA,1020) N,TEMPAR(N)
 110      CONTINUE
        ENDIF
C
C
      ELSEIF (MODE.EQ.2) THEN
C
C     2- PASSAGE DU FLUIDE VERS LE SOLIDE
C     ===================================
C
       DO 200 NF=1,NBCOUF
C
        NGF = NCOUPF(NF,1)
C
        NTP = NCOUPF(NF,2)
C
        IF (TPLUS(NTP).LE.EPZERO) THEN                                  
          XXH = CONDUC / (DX0/10.D0)                  
        ELSE                                                           
          IP = LNUMP2(NGF)                                             
          UTEMPP = UTAUP(IP)                                             
          XXH =  DEN*SPHT*UTEMPP/TPLUS(NTP)                             
        ENDIF                                                          
C
        VCOUPF(NF,1) =  TFLUID(NGF)
        VCOUPF(NF,2) =  XXH
C
C
  200 CONTINUE
C
C       IMPRESSIONS POUR CONTROLE
C       -------------------------
        IF (NBLBLR.GE.10) THEN
         IF (MODE.EQ.1) THEN
          WRITE(NFECRA,*) '>solflu>>>>TEMPAR>>>>>>',TEMPAR
         ELSE
          WRITE(NFECRA,*) '>solflu>>>>TFLUID>>>>>>',TFLUID
          WRITE(NFECRA,*) '>solflu>>>>TEMPAR>>>>>>',TEMPAR
          WRITE(NFECRA,*) '>solflu>>>>>UTAUP>>>>>>',UTAUP
          WRITE(NFECRA,*) '>solflu>>>>>TPLUS>>>>>',TPLUS
         ENDIF
        ENDIF
C
        IF (NBLBLR.GE.10) THEN
          WRITE(NFECRA,2010)
          DO 210 N=1,NBCOUF
             WRITE(NFECRA,2020) N,VCOUPF(N,1),VCOUPF(N,2)
 210      CONTINUE
        ENDIF
C

C     3- SORTIE EN ERREUR
C     ===================
      ELSE
C
        WRITE(NFECRA,3000)
        STOP
C
      ENDIF
C
C
C
C-------
C FORMAT
C-------
C
 1010 FORMAT(/,' *** RAYFLU : PASSAGE DES DONNEES DU SOLIDE',
     &         ' VERS LE FLUIDE',/,
     &          5X,' N fluide      TEMPAR ')
 1020 FORMAT(5X,3X,I4,6X,G13.7)
 2010 FORMAT(/,' *** RAYFLU : PASSAGE DES DONNEES DU FLUIDE',
     &         ' VERS LE SOLIDE  (tempar --> vcoupf)',/,
     &          5X,' N fluide      T              h')
 2020 FORMAT(5X,3X,I4,6X,G13.7,3X,G13.7)
 3000 FORMAT(/,'  %% ERREUR RAYFLU : OPTION INCORRECTE ')
C
C----
C FIN
C----
      END
          
