#-----------------------------------------------------------------------
#
#                        SYRTHES version 3.4
#                        -------------------
#
#     This file is part of the SYRTHES Kernel, element of the
#     thermal code SYRTHES.
#
#     Copyright (C) 1988-2008 EDF S.A., France
#
#     contact: syrthes-support@edf.fr
#
#
#     The SYRTHES Kernel is free software; you can redistribute it
#     and/or modify it under the terms of the GNU General Public License
#     as published by the Free Software Foundation; either version 2 of
#     the License, or (at your option) any later version.
#
#     The SYRTHES Kernel is distributed in the hope that it will be
#     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
#     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#     GNU General Public License for more details.
#
#
#     You should have received a copy of the GNU General Public License
#     along with the Code_Saturne Kernel; if not, write to the
#     Free Software Foundation, Inc.,
#     51 Franklin St, Fifth Floor,
#     Boston, MA  02110-1301  USA
#
#-----------------------------------------------------------------------

# Architecture name and location of the directory for installation
# ================================================================
  NOM_ARCH=`uname -s`
  PATHSYR=/home/syrthes

#------------------------------------------------------------------------
# Only in case of installation on multiple architectures

# Architecture
  NOM_ARCH=`uname -s`
  if [ "$NOM_ARCH" = "Linux" ] ; then
    if [ "`hostname | cut -c1-7`" = "platine" ] ; then
      NOM_ARCH=Linux_IA64
    elif [ "`domainname 2>/dev/null`" = "cluster-chatou" ] ; then
      NOM_ARCH=Linux_Ch
    elif [ -d /bgl/BlueLight/ppcfloor ] ; then
      NOM_ARCH=Blue_Gene_L
    elif [ -d /bgsys/drivers/ppcfloor ] ; then
      NOM_ARCH=Blue_Gene_P
    else
      MACHINE=`uname -m`
      case "$MACHINE" in
        *86)    NOM_ARCH=Linux ;;
        x86_64) NOM_ARCH=Linux_x86_64 ;;
        ia64)   NOM_ARCH=Linux_IA64 ;;
        *)      NOM_ARCH=Linux_$MACHINE ;;
      esac
    fi
  fi

#-----------------------------------------------------------
#
  SYRTHES_HOME=${PATHSYR}/syrthes3.4.2  
#
# Path 
  PATH=${SYRTHES_HOME}/bin:${SYRTHES_HOME}/bin/${NOM_ARCH}:$PATH
  export PATH

# Export des variables
  export NOM_ARCH NOM_USER SYRTHES_HOME 


