C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C/MEMBR ADD NAME=GRCONJ,SSI=0
C
                     SUBROUTINE GRCONJ
C                    *****************
C
C     ----------------------------------------------------
     *( X,DMAT,XMAT,B,DIAG,NODES,RES,GD,DD,Z,WCT,
     *  NPOINS,NELEMS,NDIELE,NDMATS,NCOEMA,
     *  NODEPR,NELEPR,NPRIOS,NBPRIO,NBCOPR )
C      ---------------------------------------------------
C***********************************************************************
C* SYRTHES 3.4.2                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C                                                                      *
C      FONCTION :                                                      *
C      ---------     SOLVEUR D'UN SYSTEME   A X = B                    *
C                                                                      *
C      Ce sous-programme determine la solution de:                     *
C                                                                      *
C                         A X = B                                      *
C                                                                      *
C      A est une matrice symetrique.                                   *
C      On utilise la methode du gradient conjuge, et le                *
C      preconditionnement par la diagonale.                            *
C                                                                      *
C      Soit X la variable d'iteration:                                 *
C                                                                      *
C      Etape d'initialisation:                                         *
C      -----------------------                                         *
C                                                                      *
C                              RES0  = A X0 - B                        *
C                                                                      *
C                              GD0   = DIAG * RES0                     *
C                                                                      *
C                              DD0   = GD0                             *
C                                                                      *
C      Iterations N :                                                  *
C      --------------                                                  *
C                                                                      *
C                              GD    = DIAG * RES                      *
C                                N               N                     *
C                                                                      *
C                                              RES  .  GD              *
C                                                 N      N             *
C                              DD    = GD   *  -------------  * DD     *
C                                N       N    RES   .  GD         N-1  *
C                                                N-1     N-1           *
C                                                                      *
C                              Z     = A * DD                          *
C                               N            N                         *
C                                                                      *
C                                       RES  .  DD                     *
C                                          N      N                    *
C                              RO    = - ------------                  *
C                                N      DD   .   Z                     *
C                                         N       N                    *
C                                                                      *
C                              X     =   X  +  RO  *  DD               *
C                               N+1       N      N      N              *
C                                                                      *
C                              RES   =   RES + RO  *  Z                *
C                                 N+1       N    N     N               *
C                                                                      *
C      Test de convergence:                                            *
C      --------------------                                            *
C                              || RES   ||  <  EPSI                    *
C                                    N+1                               *
C      On choisi de faire une precision relative qui s'appuit sur      *
C      la norme du vecteur initial                                     *
C      epsi = epsgcs * || X0 ||                                        *
C      c'est a dire que si la solution conduit a un grand vecteur X    *
C      le residu || X  -  X  || sera compare a un nombre plus grand.   *
C                    N+1   N                                           *
C      epsgcs est fourni par l'utilisateur (0.001 A 0.000001)          *
C                                                                      *
C-----------------------------------------------------------------------
C		    (*)    (*)			ARGUMENTS
C   .___________.______._______________________________________________.
C   !    NOM    ! TYPE !MODE!                    ROLE                  !
C   !___________!______!____!__________________________________________!
C   !   X       !  TR  ! M  ! VECTEUR RESULTAT                         !
C   !   DMAT    !  TR  ! D  ! DIAGONALE DE LA MATRICE DU SYSTEME       !
C   !   MAT     !  TR  ! D  ! TERMES EXTRA DIAGOMAUX DE LA MATRICE     !
C   !   B       !  TR  ! D  ! SECOND MEMBRE DE L'EQUATION              !
C   !   DIAG    !  TR  ! D  ! DIAGONALE DE PRECONDITIONNEMENT          !
C   !   RES     !  TR  ! M  ! RESIDU                                   !
C   !   GD      !  TR  ! M  ! GRADIENT DE DESCENTE                     !
C   !   DD      !  TR  ! M  ! DIRECTION DE DESCENTE                    !
C   !   Z       !  TR  ! M  ! VECTEUR CONTENANT 'M' MULTIPLIEE PAR DD  !
C   !   WCT     !  TR  ! M  ! TABLEAU DE TRAVAIL ( NELEMS*NDMATS)      !
C   !___________!______!____!__________________________________________!
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C    SOUS PROGRAMME(S) APPELE(S)    : IINFO,OV,OMV,PROSCA
C-----------------------------------------------------------------------
C    SOUS PROGRAMME(S) APPELANT(S)  : ????
C
C***********************************************************************
C
      IMPLICIT NONE
C
C***********************************************************************
C     DONNEES EN COMMON
C***********************************************************************
C
#include "optct.h"
#include "nlofes.h"
C
C***********************************************************************
C
C..Variables externes
      INTEGER NPOINS,NELEMS,NDMATS,NELEPR,NBPRIO,NBCOPR,NCOEMA,NDIELE
C
      INTEGER NODES(NELEMS,NDMATS)
      INTEGER NODEPR(NELEPR,NDMATS+1),NPRIOS(NBPRIO,1+NBCOPR)
C
      DOUBLE PRECISION X(NPOINS),B(NPOINS),DD(NPOINS),GD(NPOINS)
      DOUBLE PRECISION RES(NPOINS),Z(NPOINS)
      DOUBLE PRECISION DIAG(NPOINS),DMAT(NPOINS),XMAT(NELEMS,NCOEMA)
      DOUBLE PRECISION WCT(NELEMS,NDMATS)
C
C..Variables locales
      INTEGER N
      DOUBLE PRECISION C,X0,RESNOR,SL,RGRG,RO,PRSCA1,PRSCA2
      DOUBLE PRECISION ALP,EPSIS,ZERO
      LOGICAL LVERIF
C      
C***********************************************************************
C    
C     1- INITIALISATION
C     =================
C
      LVERIF = .TRUE.
      ZERO   = 0.D0
C  
      N = 0
C 
      CALL PROSCA ( NPOINS,X,X,PRSCA1 )
      X0 = SQRT ( PRSCA1 )
C  
      IF ( X0 .LT. 1.D-20 ) X0 = 1.D-4
      EPSIS = 1.D-4 * X0
C
C
      CALL OV ( 'X=C     ',RES,RES,RES,ZERO,NPOINS )
      CALL OMV ( 'X=MY    ',RES,DMAT,XMAT,X,C,NODES,WCT, 
     &            NPOINS,NDMATS,NCOEMA,NDIELE,NELEMS,
     &            NODEPR,NELEPR,NPRIOS,NBPRIO,NBCOPR)
      CALL OV ( 'X=X-Y   ',RES,B,RES,ZERO,NPOINS )
C
C
      CALL PROSCA ( NPOINS,RES,RES,PRSCA1 )
      RESNOR = SQRT ( PRSCA1 )
C
      IF ( RESNOR.LE.EPSIS .AND.  RESNOR.LE.EPSGCS*SQRT(DBLE(NPOINS)))
     & THEN
C
C
          IF (NBLBLA.GE.2) THEN
            WRITE(NFECRA,1000)
            WRITE(NFECRA,1010) N,RESNOR/X0,RESNOR/SQRT(DBLE(NPOINS))
          ELSEIF (NBLBLA.GT.0) THEN
            WRITE(NFECRA,2010) N,RESNOR/X0,RESNOR/SQRT(DBLE(NPOINS))
          ENDIF
          RETURN
C
      ENDIF
C
C     2. PROCESSUS ITERATIF
C     =====================
      IF (NBLBLA.GE.2) WRITE(NFECRA,1000)
      CALL FLUSHF(NFECRA)

C
    1 N = N + 1
C
C
      CALL OV ( 'X=YZ    ',GD ,RES,DIAG,ZERO,NPOINS )
C
C
      CALL PROSCA ( NPOINS,RES,GD,SL )
C
      IF ( N . EQ . 1 ) THEN
          CALL OV ( 'X=Y     ',DD,GD,RES,ZERO,NPOINS )
      ELSE 
          ALP = SL / RGRG
          CALL OV ( 'X=Y+CZ  ',DD,GD,DD,ALP,NPOINS )
      ENDIF
C
      RGRG = SL
C
C     Calcul de Z
C     -----------
C 
      CALL OV ( 'X=C     ',Z,RES,RES,ZERO,NPOINS )
      CALL OMV ( 'X=MY    ',Z,DMAT,XMAT,DD,C,NODES,WCT,
     &            NPOINS,NDMATS,NCOEMA,NDIELE,NELEMS,
     &            NODEPR,NELEPR,NPRIOS,NBPRIO,NBCOPR )
C
C
      CALL PROSCA ( NPOINS,RES,DD,PRSCA1 )
      CALL PROSCA ( NPOINS,DD,Z,PRSCA2 )  
      RO = - PRSCA1 / PRSCA2
C
C      
      CALL OV ( 'X=X+CY  ',X,DD,RES,RO,NPOINS )
      CALL OV ( 'X=X+CY  ',RES,Z,RES,RO,NPOINS )
C
C
      CALL PROSCA ( NPOINS,RES,RES,PRSCA1 ) 
      RESNOR = SQRT ( PRSCA1 )
C
      IF (NBLBLA.GE.2 .AND. MOD(N,25).EQ.0)
     &    WRITE(NFECRA,1010) N,RESNOR/X0,RESNOR/SQRT(DBLE(NPOINS))

      IF ( .NOT. ( (RESNOR.LE.EPSIS .AND.  
     &              RESNOR.LE.EPSGCS*SQRT(DBLE(NPOINS)))
     &                  .OR.  N.GE.NITMXS ) )  
     &    GOTO 1
C
      IF (NBLBLA.GT.0)
     &  WRITE (NFECRA,2010) N,RESNOR/X0,RESNOR/SQRT(DBLE(NPOINS))
C
C--------
C FORMATS
C--------
C 
 1000 FORMAT (/,' *** GRCONJ: RESOLUTION PAR GRADIENT CONJUGUE'
     &       ,/,10X,' ITERATIONS   PRECISION RELATIVE',  
     &       '   PRECISION ABSOLUE')
 1010 FORMAT (13X,I4,11X,E12.5,6X,E12.5)  
 2010 FORMAT (' GRCONJ',I4,' ITERATIONS    PRECISION RELATIVE = ',E12.5,
     &          ' PRECISION ABSOLUE = ', E12.5 )
C
      END    





