C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C
                        SUBROUTINE LECME1
C                       *****************
C
C     ----------------------------------------------------------------
     *(NPOINS,NELEMS,NBNO)
C     ----------------------------------------------------------------
C
C***********************************************************************
C* SYRTHES 3.4.2                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C FONCTION :                                                           *
C ----------                                                           *
C             1ere LECTURE DU MAILLAGE ELEMENTS FINIS                  *
C             --> STRUCTURE DE DONNEE ISSUEDE MED                      *
C             (Necessaire pour les dimensionnements de tableaux)       *
C                                                                      *
C-----------------------------------------------------------------------
C                             ARGUMENTS
C .___________.____.____.______________________________________________.
C !    NOM    !TYPE!MODE!                   ROLE                       !
C !___________!____!____!______________________________________________!
C !___________!____!____!______________________________________________!
C ! COMMONS                                                            !
C !____________________________________________________________________!
C ! /XREFER/  !    ! D  !                                              !
C ! /NLOFES/  !    ! D  !                                              !
C ! /NLOFCT/  !    ! D  !                                              !
C !___________!____!____!______________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : CMPTNO,CMPTEL,CMPTFA,INREFA
C
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) :
C
C***********************************************************************
C
      IMPLICIT NONE
C
C***********************************************************************
C     DONNEES EN COMMON  
C **********************************************************************
C
#include "nlofes.h"
#include "nlofct.h"
#ifdef MED
#include "med.hf"
#endif
C***********************************************************************
C 
C.. Variables externes
      INTEGER NPOINS,NELEMS,NBNO
C
#ifdef MED
C.. Variables internes
      CHARACTER*32 NOM
      INTEGER IRET,IDIM,NN
C
C***********************************************************************
C
C     lire le nom du maillage
      CALL EFMAAI(NFSGCT,1,NOM,IDIM,IRET)
C
C     nombre de noeuds
      CALL EFNEMA(NFSGCT,NOM,MED_COOR,MED_NOEUD,0,0,NPOINS,IRET)
C
C     nombre d'elements
      IF (NBNO.EQ.2) THEN
        CALL EFNEMA(NFSGCT,NOM,MED_CONN,
     *              MED_MAILLE,MED_SEG2,MED_NOD,NN,IRET)
      ELSEIF (NBNO.EQ.3) THEN
        CALL EFNEMA(NFSGCT,NOM,MED_CONN,
     *              MED_MAILLE,MED_TRIA3,MED_NOD,NN,IRET)
      ELSEIF (NBNO.EQ.6) THEN
        CALL EFNEMA(NFSGCT,NOM,MED_CONN,
     *              MED_MAILLE,MED_TRIA6,MED_NOD,NN,IRET)
      ELSEIF (NBNO.EQ.10) THEN
        CALL EFNEMA(NFSGCT,NOM,MED_CONN,
     *              MED_MAILLE,MED_TETRA10,MED_NOD,NN,IRET)
      ELSE
        WRITE(NFECRA,2000)
        STOP
      ENDIF
C
      NELEMS=NN
C
C--------
C FORMATS
C--------
C 
C
 2000 FORMAT(/,'  %% ERREUR LECME1 : TYPE D''ELEMENT INCONNU')      
C 
#endif
      END
