%define name            systemconfigurator
%define version         2.0.10
%define release         1
%define prefix          /usr

Summary: System Configurator
Name: %name
Version: %version
Release: %release
Copyright: GPL
URL: http://systemconfig.sourceforge.net
Group: Applications/System
Source: %{name}-%{version}.tar.gz
Requires: perl perl-AppConfig
Vendor: IBM
Distribution: System Installation Suite
Packager: Sean Dague <sean@dague.net>
Prefix: %prefix
Buildroot: /var/tmp/%{name}-%{version}-root
BuildArchitectures: noarch
AutoReqProv: no

%description
Unified Configuration API for Linux Installation

Provides an API for various installation and configuration processes that are
otherwise inconsistent between the many Linux distributions, and the many
architectures they run on.  For example, you can configure the bootloader
on a system in a general way - you don't need to know anything about the
particular boot loader on the system.  You can update the network settings
of a system, without knowing the distribution or the format of its network
configuration files.

%prep
%setup -c -n %{name}-%{version}

# No configure, no make, just copy files to the output dir.
%build
cd $RPM_BUILD_DIR/%{name}-%{version}/%{name}-%{version}/
mkdir -p /var/tmp/%{name}-%{version}-root/usr/share/man/man5
perl Makefile.PL PREFIX=/var/tmp/%{name}-%{version}-root%{prefix} INSTALLSITELIB=/var/tmp/%{name}-%{version}-root/usr/lib/systemconfig INSTALLMAN1DIR=/var/tmp/%{name}-%{version}-root/usr/share/man/man1 INSTALLMAN3DIR=/var/tmp/%{name}-%{version}-root/usr/share/man/man3 INSTALLSITEMAN1DIR=/var/tmp/%{name}-%{version}-root/usr/share/man/man1 INSTALLSITEMAN3DIR=/var/tmp/%{name}-%{version}-root/usr/share/man/man3 INSTALLSITEBIN=/var/tmp/%{name}-%{version}-root/usr/bin INSTALLSITESCRIPT=/var/tmp/%{name}-%{version}-root/usr/bin
make
make test
make install
gzip /var/tmp/%{name}-%{version}-root/usr/share/man/*/*
rm -rf /var/tmp/%{name}-%{version}-root/usr/lib/systemconfig/auto*

%clean
rm -fr $RPM_BUILD_DIR/*
rm -rf /var/tmp/%{name}-%{version}-root

%files
%defattr(-,root,root)
%doc %{name}-%{version}/TODO 
%doc %{name}-%{version}/CREDITS 
%doc %{name}-%{version}/CHANGELOG 
%doc %{name}-%{version}/README
%doc %{name}-%{version}/INSTALL 
%doc %{name}-%{version}/README.yaboot
%doc %{name}-%{version}/COPYING
%doc %{name}-%{version}/sample.cfg
%doc %{name}-%{version}/docs/design.pod 
%{prefix}/bin/*
%{prefix}/share/man/man1/*
%{prefix}/share/man/man5/*
/usr/lib/systemconfig/*
%dir /usr/lib/systemconfig

%changelog
* Sun Sep 19 2004 dann frazier <dannf@dannf.org> 2.0.10-1
- New release

* Tue Aug 21 2001 Sean Dague <japh@us.ibm.com>
- Added %doc sections for devel docs

* Tue Aug 14 2001 Sean Dague <japh@us.ibm.com>
- Added prebuild for man 5 directory

* Mon Jul 16 2001 Sean Dague <japh@us.ibm.com>
- Initial spec file.
