/*
 * Copyright (C) 2003  Stefan Kleine Stegemann
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#ifndef _H_PDF_CONTENT_VIEW
#define _H_PDF_CONTENT_VIEW

#include <Foundation/NSString.h>
#include <AppKit/NSView.h>
#include <AppKit/NSTextField.h>

#include <PDFKit/PDFDocument.h>
#include <PDFKit/PDFImageRep.h>

#include "ExtendedScrollView.h"


@interface PDFContentView : NSView
{
   ExtendedScrollView*      scrollView;
   id                       imageView;
   NSTextField*             messageView;
   BOOL                     messageDisplayed;
   int                      pageNum;
   PDFDocument*             pdfDoc;

   // for use with PDFImageRep
   PDFImageRep*             imageRep;
}

- (id) initWithFrame: (NSRect)frameRect;
- (void) dealloc;

- (id) imageView;

- (void) updateView;

- (void) setDocument: (PDFDocument*)_pdfDoc;
- (void) setPage: (int)_pageNum scaledBy: (float)factor;

- (void) sizeToFitPage;
- (void) setPageSize: (NSSize)size;
- (void) displayMessage: (NSString*)message;
- (void) removeMessage;

- (ExtendedScrollView*) scrollView;

- (void) resizeWithOldSuperviewSize: (NSSize)oldBoundsSize;

@end

#endif
