/*=========================================================================

  Program:   Visualization Toolkit
  Module:    $RCSfile: vtkMultiBlockDataSet.cxx,v $
  Language:  C++
  Date:      $Date: 2003/12/11 15:47:37 $
  Version:   $Revision: 1.1 $

  Copyright (c) 1993-2002 Ken Martin, Will Schroeder, Bill Lorensen 
  All rights reserved.
  See Copyright.txt or http://www.kitware.com/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even 
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
#include "vtkMultiBlockDataSet.h"

#include "vtkMultiBlockDataIterator.h"
#include "vtkMultiBlockDataSetInternal.h"
#include "vtkMultiBlockDataVisitor.h"

#include "vtkObjectFactory.h"

vtkCxxRevisionMacro(vtkMultiBlockDataSet, "$Revision: 1.1 $");
vtkStandardNewMacro(vtkMultiBlockDataSet);

//----------------------------------------------------------------------------
vtkMultiBlockDataSet::vtkMultiBlockDataSet()
{
  this->Internal = new vtkMultiBlockDataSetInternal;
}

//----------------------------------------------------------------------------
vtkMultiBlockDataSet::~vtkMultiBlockDataSet()
{
  delete this->Internal;
}

//----------------------------------------------------------------------------
void vtkMultiBlockDataSet::AddDataSet(vtkDataObject* data)
{
  if (data)
    {
    this->Internal->DataSets.push_back(data);
    this->Modified();
    }
}

//----------------------------------------------------------------------------
vtkCompositeDataIterator* vtkMultiBlockDataSet::NewIterator()
{
  vtkMultiBlockDataIterator* iter = vtkMultiBlockDataIterator::New();
  iter->SetDataSet(this);
  return iter;
}

//----------------------------------------------------------------------------
vtkCompositeDataVisitor* vtkMultiBlockDataSet::NewVisitor()
{
  vtkMultiBlockDataVisitor* vis = vtkMultiBlockDataVisitor::New();
  vtkMultiBlockDataIterator* it = 
    vtkMultiBlockDataIterator::SafeDownCast(this->NewIterator());
  vis->SetDataIterator(it);
  it->Delete();
  return vis;
}

//----------------------------------------------------------------------------
void vtkMultiBlockDataSet::Initialize()
{
  this->Superclass::Initialize();
  this->Internal->DataSets.clear();
}

//----------------------------------------------------------------------------
void vtkMultiBlockDataSet::PrintSelf(ostream& os, vtkIndent indent)
{
  this->Superclass::PrintSelf(os,indent);
}

