/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.TextArea;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

public class ImageCanvas
extends Canvas {
    static final int CONNECTED = 0;
    static final int DISCONNECTED = 1;
    static final int STOPPED = 2;
    private final String connectingImageFilename = "init.jpg";
    private final String cannotConnectImageFilename = "error.jpg";
    private Applet applet;
    private String host;
    private int port;
    private double fps;
    private int connected = 2;
    private boolean first_image = true;
    private Dimension preferredSize;
    private Graphics offGraphics;
    private Image currentImage;
    private Image offImage;
    private PopupMenu popup;
    private MenuItem startStop;
    private Frame mainWindow;
    private ImageDownloader downloader;
    private ImageCanvas thisImageCanvas;
    private Frame about;
    private Frame chat;
    private TextArea output;
    private TextField input;
    private TextField name = new TextField("name", 10);

    public ImageCanvas(Applet applet, String string, int n, int n2, int n3, int n4) {
        this.applet = applet;
        this.host = string;
        this.port = n;
        this.fps = n2;
        this.preferredSize = new Dimension(n3, n4);
        if (applet == null) {
            File file = new File("init.jpg");
            if (file.exists()) {
                this.setImage(Toolkit.getDefaultToolkit().getImage("init.jpg"));
            } else {
                System.out.println("init.jpg not found");
            }
        } else {
            try {
                this.setImage(applet.getImage(new URL(String.valueOf(applet.getCodeBase().toString()) + "init.jpg")));
            }
            catch (MalformedURLException malformedURLException) {}
        }
        this.about = this.createAbout();
        this.add(this.createMenu());
        this.thisImageCanvas = this;
        this.addMouseListener(this.createMouseListener());
        this.downloader = new ImageDownloader(string, n, n2, this);
        this.downloader.start();
    }

    public Dimension getPreferredSize() {
        return this.preferredSize;
    }

    public double getFPS() {
        return this.fps;
    }

    public int getPort() {
        return this.port;
    }

    public String getHost() {
        return this.host;
    }

    public void setMainWindow(Frame frame) {
        this.mainWindow = frame;
    }

    public void setImageSize(Dimension dimension) {
        this.preferredSize = dimension;
        this.setSize(dimension);
    }

    public void setStartStopText(String string) {
        this.startStop.setLabel(string);
    }

    public int setImage(Image image) {
        int n;
        int n2;
        if (this.first_image && this.mainWindow != null) {
            while ((n2 = image.getWidth(null)) < 0 || (n = image.getHeight(null)) < 0) {
            }
            System.out.println("w = " + n2 + ", h = " + n);
            ((Component)this.mainWindow).setBounds(100, 100, n2, n);
            this.first_image = false;
        }
        n2 = 0;
        n = 5;
        while (!this.prepareImage(image, this)) {
            this.wait(n);
            if (++n2 * n > 5000) break;
        }
        this.currentImage = image;
        this.repaint();
        return n2 * n;
    }

    public void couldNotConnect() {
        this.setStartStopText("Start");
        if (this.applet == null) {
            File file = new File("error.jpg");
            if (file.exists()) {
                this.setImage(Toolkit.getDefaultToolkit().getImage("error.jpg"));
                return;
            }
            System.out.println("error.jpg not found");
            return;
        }
        try {
            this.setImage(this.applet.getImage(new URL(String.valueOf(this.applet.getCodeBase().toString()) + "error.jpg")));
            return;
        }
        catch (MalformedURLException malformedURLException) {
            return;
        }
    }

    public void setConnected(int n) {
        this.connected = n;
        if (n != 0 && this.chat != null) {
            this.chat.dispose();
            this.chat = null;
        }
        this.repaint();
    }

    public void wait(int n) {
        try {
            Thread.sleep(n);
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    public void disconnect() {
        this.downloader.disconnect();
        if (this.chat != null) {
            this.chat.dispose();
            this.chat = null;
        }
    }

    public MouseListener createMouseListener() {
        return new 1();
    }

    public Frame createChat() {
        if (this.connected != 0) {
            return null;
        }
        Frame frame = new Frame("WebCam Chat");
        Panel panel = new Panel();
        this.input = new TextField();
        this.output = new TextArea("please type your name in the 'name' field\n");
        panel.setLayout(new BorderLayout());
        frame.setLayout(new BorderLayout());
        panel.add((Component)this.input, "Center");
        panel.add((Component)this.name, "West");
        frame.add((Component)panel, "South");
        frame.add((Component)this.output, "Center");
        this.output.setEditable(false);
        this.input.addKeyListener(new 2());
        frame.addWindowListener(new 3());
        ((Component)frame).setBounds(200, 200, 300, 150);
        frame.show();
        return frame;
    }

    public Frame createAbout() {
        Frame frame = new Frame("About");
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(0, 1));
        panel.add(new Label(" "));
        panel.add(new Label("Copyright (C) 2002"));
        panel.add(new Label("Applet by Mike Morrison"));
        panel.add(new Label("Server by Donn Morrison"));
        panel.add(new Label(" "));
        Button button = new Button("Ok");
        button.addActionListener(new 4());
        frame.add((Component)panel, "North");
        panel = new Panel();
        panel.setLayout(new FlowLayout());
        panel.add(button);
        frame.add((Component)panel, "Center");
        frame.pack();
        ((Component)frame).setBackground(Color.lightGray);
        frame.setResizable(false);
        return frame;
    }

    public PopupMenu createMenu() {
        this.popup = new PopupMenu("WebCam Options");
        this.startStop = new MenuItem("Stop");
        this.startStop.addActionListener(new 5());
        this.popup.add(this.startStop);
        Menu menu = new Menu("Max FPS");
        MenuItem menuItem = new MenuItem("0.1");
        menuItem.addActionListener(new 6());
        menu.add(menuItem);
        menuItem = new MenuItem("0.2");
        menuItem.addActionListener(new 7());
        menu.add(menuItem);
        menuItem = new MenuItem("0.5");
        menuItem.addActionListener(new 8());
        menu.add(menuItem);
        menuItem = new MenuItem("1");
        menuItem.addActionListener(new 9());
        menu.add(menuItem);
        menuItem = new MenuItem("2");
        menuItem.addActionListener(new 10());
        menu.add(menuItem);
        menuItem = new MenuItem("5");
        menuItem.addActionListener(new 11());
        menu.add(menuItem);
        menuItem = new MenuItem("10");
        menuItem.addActionListener(new 12());
        menu.add(menuItem);
        menuItem = new MenuItem("Unlimited");
        menuItem.addActionListener(new 13());
        menu.add(menuItem);
        this.popup.add(menu);
        this.popup.addSeparator();
        menuItem = new MenuItem("About");
        menuItem.addActionListener(new 14());
        this.popup.add(menuItem);
        return this.popup;
    }

    public void paint(Graphics graphics) {
        this.update(graphics);
    }

    public void update(Graphics graphics) {
        Color color = Color.black;
        if (this.currentImage != null) {
            this.offImage = this.createImage(this.preferredSize.width, this.preferredSize.height);
            this.offGraphics = this.offImage.getGraphics();
            this.offGraphics.drawImage(this.currentImage, 0, 0, this.preferredSize.width, this.preferredSize.height, this);
            graphics.drawImage(this.offImage, 0, 0, this);
            switch (this.connected) {
                case 0: {
                    color = new Color(30, 175, 30);
                    break;
                }
                case 1: {
                    color = new Color(175, 30, 30);
                    break;
                }
                case 2: {
                    color = new Color(175, 30, 30);
                    break;
                }
            }
            graphics.setColor(Color.black);
            graphics.fillOval(this.preferredSize.width - 11, this.preferredSize.height - 11, 7, 7);
            graphics.setColor(color);
            graphics.fillOval(this.preferredSize.width - 12, this.preferredSize.height - 12, 7, 7);
        }
    }

    private final class 1
    implements MouseListener {
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            switch (mouseEvent.getModifiers()) {
                case 4: {
                    if (ImageCanvas.this.connected != 0) {
                        ImageCanvas.this.thisImageCanvas.startStop.setLabel("Start");
                    } else {
                        ImageCanvas.this.thisImageCanvas.startStop.setLabel("Stop");
                    }
                    ImageCanvas.this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                    return;
                }
            }
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    implements KeyListener {
        public void keyTyped(KeyEvent keyEvent) {
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10 && !ImageCanvas.this.input.getText().equals("")) {
                String string = String.valueOf(ImageCanvas.this.name.getText()) + ": " + ImageCanvas.this.input.getText() + "\n";
                ImageCanvas.this.output.append(string);
                ((TextComponent)ImageCanvas.this.input).setText("");
                ImageCanvas.this.downloader.queueChatText(string);
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        /* synthetic */ 2() {
        }
    }

    private final class 3
    implements WindowListener {
        public void windowActivated(WindowEvent windowEvent) {
        }

        public void windowClosed(WindowEvent windowEvent) {
        }

        public void windowClosing(WindowEvent windowEvent) {
            ImageCanvas.this.chat.dispose();
            ImageCanvas.this.chat = null;
        }

        public void windowDeactivated(WindowEvent windowEvent) {
        }

        public void windowDeiconified(WindowEvent windowEvent) {
        }

        public void windowIconified(WindowEvent windowEvent) {
        }

        public void windowOpened(WindowEvent windowEvent) {
        }

        /* synthetic */ 3() {
        }
    }

    private final class 4
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            ((Component)ImageCanvas.this.about).hide();
        }

        /* synthetic */ 4() {
        }
    }

    private final class 5
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            if (ImageCanvas.this.downloader == null || !ImageCanvas.this.downloader.isConnected()) {
                ImageCanvas.this.downloader = new ImageDownloader(ImageCanvas.this.thisImageCanvas.getHost(), ImageCanvas.this.thisImageCanvas.getPort(), ImageCanvas.this.thisImageCanvas.getFPS(), ImageCanvas.this.thisImageCanvas);
                ImageCanvas.this.downloader.start();
                ImageCanvas.this.downloader.setMaxFPS(ImageCanvas.this.thisImageCanvas.fps);
                return;
            }
            ImageCanvas.this.thisImageCanvas.fps = ImageCanvas.this.downloader.getMaxFPS();
            ImageCanvas.this.downloader.disconnect();
            ImageCanvas.this.downloader = null;
        }

        /* synthetic */ 5() {
        }
    }

    private final class 6
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            if (ImageCanvas.this.downloader != null) {
                ImageCanvas.this.downloader.setMaxFPS(0.1);
                ImageCanvas.this.thisImageCanvas.fps = 0.1;
            }
        }

        /* synthetic */ 6() {
        }
    }

    private final class 7
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            if (ImageCanvas.this.downloader != null) {
                ImageCanvas.this.downloader.setMaxFPS(0.2);
                ImageCanvas.this.thisImageCanvas.fps = 0.2;
            }
        }

        /* synthetic */ 7() {
        }
    }

    private final class 8
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            if (ImageCanvas.this.downloader != null) {
                ImageCanvas.this.downloader.setMaxFPS(0.5);
                ImageCanvas.this.thisImageCanvas.fps = 0.5;
            }
        }

        /* synthetic */ 8() {
        }
    }

    private final class 9
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            if (ImageCanvas.this.downloader != null) {
                ImageCanvas.this.downloader.setMaxFPS(1.0);
                ImageCanvas.this.thisImageCanvas.fps = 1.0;
            }
        }

        /* synthetic */ 9() {
        }
    }

    private final class 10
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            if (ImageCanvas.this.downloader != null) {
                ImageCanvas.this.downloader.setMaxFPS(2.0);
                ImageCanvas.this.thisImageCanvas.fps = 2.0;
            }
        }

        /* synthetic */ 10() {
        }
    }

    private final class 11
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            if (ImageCanvas.this.downloader != null) {
                ImageCanvas.this.downloader.setMaxFPS(5.0);
                ImageCanvas.this.thisImageCanvas.fps = 5.0;
            }
        }

        /* synthetic */ 11() {
        }
    }

    private final class 12
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            if (ImageCanvas.this.downloader != null) {
                ImageCanvas.this.downloader.setMaxFPS(10.0);
                ImageCanvas.this.thisImageCanvas.fps = 10.0;
            }
        }

        /* synthetic */ 12() {
        }
    }

    private final class 13
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            if (ImageCanvas.this.downloader != null) {
                ImageCanvas.this.downloader.setMaxFPS(30.0);
                ImageCanvas.this.thisImageCanvas.fps = 30.0;
            }
        }

        /* synthetic */ 13() {
        }
    }

    private final class 14
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            ImageCanvas.this.about.show();
        }

        /* synthetic */ 14() {
        }
    }
}

