/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Image;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.Vector;

public class ImageDownloader
extends Thread {
    private Socket socket;
    private ImageCanvas imageCanvas;
    private String host;
    private int port;
    private boolean done;
    private String len_hdr = "content-length: ";
    private final String request = "GET / WCS/0.50";
    private double maxFPS = 1.0;
    private int timeToWait;
    private Vector chatQueue = new Vector();

    public ImageDownloader(String string, int n, double d, ImageCanvas imageCanvas) {
        this.host = string;
        this.port = n;
        this.imageCanvas = imageCanvas;
        this.setMaxFPS(d);
    }

    public void queueChatText(String string) {
        this.chatQueue.addElement(string);
    }

    public void setMaxFPS(double d) {
        if (d > 0.0) {
            this.maxFPS = d;
            this.timeToWait = (int)(1000.0 / d);
        }
    }

    public double getMaxFPS() {
        return this.maxFPS;
    }

    public boolean connect() {
        try {
            this.socket = new Socket(this.host, this.port);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean disconnect() {
        this.done = true;
        return true;
    }

    public boolean isConnected() {
        return !this.done;
    }

    public void run() {
        Object object2;
        this.done = false;
        if (!this.connect()) {
            this.imageCanvas.couldNotConnect();
            this.imageCanvas.setConnected(1);
            this.imageCanvas.setStartStopText("Start");
            return;
        }
        this.imageCanvas.setConnected(0);
        try {
            try {
                long l;
                object2 = new PrintWriter(this.socket.getOutputStream());
                InputStream inputStream = this.socket.getInputStream();
                BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
                byte[] byArray = new byte[1024];
                long l2 = l = System.currentTimeMillis();
                while (!this.done) {
                    l = System.currentTimeMillis();
                    ((PrintWriter)object2).println("GET / WCS/0.50");
                    if (this.chatQueue.size() > 0) {
                        System.out.println((String)this.chatQueue.elementAt(0));
                        ((PrintWriter)object2).println((String)this.chatQueue.elementAt(0));
                        this.chatQueue.removeElementAt(0);
                    }
                    ((PrintWriter)object2).flush();
                    int n = 0;
                    while ((byArray[n] = (byte)bufferedInputStream.read()) != -1) {
                        if (n > 0 && byArray[n] == 10 && byArray[n - 1] == 10) break;
                        ++n;
                    }
                    String string = new String(byArray).toLowerCase();
                    int n2 = string.indexOf(this.len_hdr) + this.len_hdr.length();
                    int n3 = string.indexOf("\n", n2);
                    string = string.substring(n2, n3);
                    int n4 = Integer.parseInt(string);
                    if (n4 < 0) break;
                    byte[] byArray2 = new byte[n4];
                    int n5 = 0;
                    int n6 = 0;
                    while ((n5 = bufferedInputStream.read(byArray2, n6, n4 - n6)) != -1) {
                        if ((n6 += n5) == n4) break;
                        this.wait(10);
                    }
                    if (n6 != n4) {
                        System.out.println("Did not read everything!");
                        break;
                    }
                    Image image = Toolkit.getDefaultToolkit().createImage(byArray2);
                    if (this.imageCanvas != null) {
                        this.imageCanvas.setImage(image);
                    }
                    if ((long)this.timeToWait - ((l2 = System.currentTimeMillis()) - l) <= 0L) continue;
                    this.wait((int)((long)this.timeToWait - (l2 - l)));
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                this.imageCanvas.setConnected(1);
                this.imageCanvas.setStartStopText("Start");
            }
            Object var2_18 = null;
            this.disconnect();
        }
        catch (Throwable throwable) {
            Object var2_19 = null;
            this.disconnect();
            this.imageCanvas.setConnected(2);
            this.imageCanvas.setStartStopText("Start");
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            throw throwable;
        }
        this.imageCanvas.setConnected(2);
        this.imageCanvas.setStartStopText("Start");
        try {
            this.socket.close();
        }
        catch (IOException object2) {
            ((Throwable)object2).printStackTrace();
        }
    }

    public int FourBytesToInt(byte[] byArray) {
        int n = 0;
        int n2 = 0;
        n += ImageDownloader.unsignedByteToInt(byArray[n2++]);
        n += ImageDownloader.unsignedByteToInt(byArray[n2++]) << 8;
        n += ImageDownloader.unsignedByteToInt(byArray[n2++]) << 16;
        return n += ImageDownloader.unsignedByteToInt(byArray[n2++]) << 24;
    }

    public static int unsignedByteToInt(byte by) {
        return by & 0xFF;
    }

    public void wait(int n) {
        try {
            Thread.sleep(n);
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    public static void main(String[] stringArray) {
        ImageDownloader imageDownloader = new ImageDownloader(stringArray[1], Integer.parseInt(stringArray[2]), 30.0, null);
        imageDownloader.start();
    }
}

