// wmmixer - A mixer designed for WindowMaker
// 05/09/98  Release 1.0 Beta1
// Copyright (C) 1998  Sam Hawker <shawkie@geocities.com>
// This software comes with ABSOLUTELY NO WARRANTY
// This software is free software, and you are welcome to redistribute it
// under certain conditions
// See the README file for a more complete notice.

// 02/04/02 Gordon Fraser <gordon@debian.org>
//   * GNU getopt
//   * Mousewheel support
//   * X handling rewrite


// Defines, includes and global variables
// --------------------------------------

// User defines - standard
#define WINDOWMAKER false
#define USESHAPE    false
#define AFTERSTEP   false
#define NORMSIZE    64
#define ASTEPSIZE   56
#define NAME        "wmmixer"
#define CLASS       "WMMixer"

// User defines - custom
#define MIXERDEV    "/dev/mixer"
#define BACKCOLOR   "#282828"
#define LEDCOLOR    "green"

// Includes - standard
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include <getopt.h>

// Includes - custom
#include "mixctl.h"

// X-Windows includes - standard
#include <X11/X.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xproto.h>
#include <X11/xpm.h>
#include <X11/extensions/shape.h>

// Pixmaps - standard
Pixmap pm_main;
Pixmap pm_tile;
Pixmap pm_disp;
Pixmap pm_mask;

// Pixmaps - custom
Pixmap pm_icon;
Pixmap pm_nrec;

// Xpm images - standard
#include "XPM/wmmixer.xpm"
#include "XPM/tile.xpm"

// Xpm images - custom
#include "XPM/icons.xpm"
#include "XPM/norec.xpm"

// Variables for command-line arguments - standard
bool wmaker=WINDOWMAKER;
bool ushape=USESHAPE;
bool astep=AFTERSTEP;
char display[256]="";
char position[256]="";
int winsize;

// Variables for command-line arguments - custom
char mixdev[256]=MIXERDEV;
char backcolor[256]=BACKCOLOR;
char ledcolor[256]=LEDCOLOR;

// X-Windows basics - standard
Atom _XA_GNUSTEP_WM_FUNC;
Atom deleteWin;
Display *d_display;
Window w_icon;
Window w_main;
Window w_root;

// X-Windows basics - custom
GC gc_gc;
unsigned long color[4];


// Misc custom global variables 
// ----------------------------

// Current state information
int curchannel=0;
bool curshowrec;
bool currec;
int curleft;
int curright;

// For buttons
int btnstate=0;
#define BTNNEXT  1
#define BTNPREV  2
#define BTNREC   4

// For repeating next and prev buttons
#define RPTINTERVAL   5
int rpttimer=0;

// For draggable volume control
bool dragging=false;

int channels=0;
int *channel;
int *icon;

MixCtl *mixctl;

Pixel back_pix;
Pixel fore_pix;

// Default scroll amount
int wheel_scroll = 2;


// Procedures and functions
// ------------------------

// Procedures and functions - standard
void initXWin(int argc, char **argv);
void freeXWin();
void createWin(Window *win, int x, int y);
unsigned long getColor(char *colorname);
unsigned long mixColor(char *colorname1, int prop1, char *colorname2, int prop2);

// Procedures and functions - custom
void scanArgs(int argc, char **argv);
void readFile();
void checkVol(bool forced=true);
void pressEvent(XButtonEvent *xev);
void releaseEvent(XButtonEvent *xev);
void motionEvent(XMotionEvent *xev);
void repaint();
void update();
void drawLeft();
void drawRight();
void drawBtns(int btns);
void drawBtn(int x, int y, int w, int h, bool down);
void initialize_icon(int num);
static int flush_expose(Window w);
void version(void);
void usage(const char *);

