/* util.h
 * This file belongs to Worker, a file manager for UN*X/X11.
 * Copyright (C) 2001-2008,2010 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef UTIL_H
#define UTIL_H

#include "aguixdefs.h"
#include <string>

int createLines(const char*,char ***);

namespace AGUIXUtils
{
    std::string bytes_to_human_readable( loff_t number,
                                         int threshold = 1);

    std::string tolower( const std::string &str );
    
    bool stringIsShorter( const char *str, int len );

    std::string formatStringToString( const char *format, ... );

    loff_t convertHumanStringToNumber( const std::string &str );

    typedef enum {
        BM_TRADITIONAL,
        BM_SI,
        BM_IEC,
        BM_SYSTEM_SETTING
    } byte_multiplier_t;

    std::string bytes_to_human_readable_f( loff_t number,
                                           int threshold = 1,
                                           int precision = 1,
                                           byte_multiplier_t suffix_format = BM_IEC );
    std::string bytes_to_human_readable_f( double number,
                                           int threshold = 1,
                                           int precision = 1,
                                           byte_multiplier_t suffix_format = BM_IEC );
}

#endif

/* Local Variables: */
/* mode:c++ */
/* End: */
