// $Id: CommandStack.h,v 1.3 2001/10/14 22:24:47 zongo_fr Exp $
#ifndef WE_COMMANDSTACK_H
#define WE_COMMANDSTACK_H


#include <list>

// forward declarations
class Command;


class CommandStack
{
      /// Typedef for the stack container
      typedef std::list<Command*> CommandList;
      typedef CommandList::iterator CLIterator;

      /// Stack contains the list of commands.
      CommandList m_Stack;

      /// Current contains the current command.
      CLIterator m_Current;

      /// Max size of the stack
      const unsigned int m_MaxSize;

   protected:
      /**
       * Clears part of the stack.
       */
      void Clear(const CLIterator& iterator);


      /**
       * Removes the oldest undoable command.
       */
      void Forget();


   public:
      CommandStack(unsigned size);
      ~CommandStack();

      /**
       * Try to merge this command with the one on the top of the stack, and
       * if it's not possible, push it to the top of the command stack.
       */
      void Push(Command* command);

      /**
       * Clear the stack.
       */
      inline void Clear()
      {
	 Clear( m_Stack.begin() );
      }

      /**
       * Return false if a command can be undone.
       */
      inline bool CannotUndo()
      {
	 return (m_Stack.empty() || (m_Current == m_Stack.begin()));
      }

      /**
       * Return false if a command can be redone.
       */
      inline bool CannotRedo()
      {
	 return (m_Stack.empty() || (m_Current == m_Stack.end()));
      }

      /// Undo the last command.
      void Undo();

      /// Redo the last undone command.
      void Redo();
};

#endif // WE_COMMANDSTACK_H
